/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.MariadbDataSegment;
import org.mariadb.r2dbc.MariadbOutSegment;
import org.mariadb.r2dbc.MariadbRowSegment;
import org.mariadb.r2dbc.codec.BinaryRowDecoder;
import org.mariadb.r2dbc.codec.RowDecoder;
import org.mariadb.r2dbc.codec.TextRowDecoder;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.server.ColumnCountPacket;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.message.server.CompletePrepareResult;
import org.mariadb.r2dbc.message.server.EofPacket;
import org.mariadb.r2dbc.message.server.ErrorPacket;
import org.mariadb.r2dbc.message.server.OkPacket;
import org.mariadb.r2dbc.message.server.RowPacket;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.ServerPrepareResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SynchronousSink;

final class MariadbResult
implements org.mariadb.r2dbc.api.MariadbResult {
    private final Flux<ServerMessage> dataRows;
    private final ExceptionFactory factory;
    private final String[] generatedColumns;
    private final boolean supportReturning;
    private final boolean text;
    private final MariadbConnectionConfiguration conf;
    private AtomicReference<ServerPrepareResult> prepareResult;
    private Predicate<Result.Segment> filter;
    private volatile MariadbDataSegment segment;

    MariadbResult(boolean text, AtomicReference<ServerPrepareResult> prepareResult, Flux<ServerMessage> dataRows, ExceptionFactory factory, String[] generatedColumns, boolean supportReturning, MariadbConnectionConfiguration conf) {
        this.text = text;
        this.dataRows = dataRows;
        this.factory = factory;
        this.generatedColumns = generatedColumns;
        this.supportReturning = supportReturning;
        this.conf = conf;
        this.prepareResult = prepareResult;
        this.filter = null;
    }

    @Override
    public Flux<Integer> getRowsUpdated() {
        AtomicInteger rowCount = new AtomicInteger(0);
        return this.dataRows.takeUntil(ServerMessage::resultSetEnd).handle((serverMessage, sink) -> {
            if (serverMessage instanceof ErrorPacket) {
                sink.error((Throwable)this.factory.from((ErrorPacket)serverMessage));
                return;
            }
            if (serverMessage instanceof OkPacket) {
                OkPacket okPacket = (OkPacket)serverMessage;
                sink.next((Object)((int)okPacket.value()));
                sink.complete();
                return;
            }
            if (serverMessage instanceof EofPacket) {
                EofPacket eofPacket = (EofPacket)serverMessage;
                if (eofPacket.resultSetEnd()) {
                    sink.next((Object)rowCount.get());
                    rowCount.set(0);
                    sink.complete();
                }
                return;
            }
            if (serverMessage instanceof RowPacket) {
                rowCount.incrementAndGet();
                ((RowPacket)serverMessage).release();
                return;
            }
        });
    }

    @Override
    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
        Flux flux = this.dataRows.takeUntil(ServerMessage::resultSetEnd).handle(this.handler(true)).filter(MariadbRowSegment.class::isInstance);
        if (this.filter != null) {
            flux = flux.filter(this.filter);
        }
        return flux.cast(MariadbRowSegment.class).map(it -> {
            try {
                return mappingFunction.apply(it.row(), it.getMetadata());
            }
            catch (IllegalArgumentException i) {
                throw this.factory.createException(i.getMessage(), "HY000", -1);
            }
        });
    }

    @Override
    public <T> Flux<T> map(Function<? super Readable, ? extends T> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
        Flux flux = this.dataRows.takeUntil(ServerMessage::resultSetEnd).handle(this.handler(true));
        if (this.filter != null) {
            flux = flux.filter(this.filter);
        }
        return flux.cast(MariadbRowSegment.class).map(it -> mappingFunction.apply((Readable)it.row()));
    }

    @Override
    public Result filter(Predicate<Result.Segment> filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public <T> Flux<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
        Flux flux = this.dataRows.takeUntil(ServerMessage::resultSetEnd).handle(this.handler(true));
        if (this.filter != null) {
            flux = flux.filter(this.filter);
        }
        return flux.flatMap(it -> (Publisher)mappingFunction.apply((Result.Segment)it));
    }

    private BiConsumer<? super ServerMessage, SynchronousSink<Result.Segment>> handler(boolean throwError) {
        ArrayList columns = new ArrayList();
        return (serverMessage, sink) -> {
            if (serverMessage instanceof ErrorPacket) {
                if (throwError) {
                    sink.error((Throwable)this.factory.from((ErrorPacket)serverMessage));
                } else {
                    sink.next((Object)((ErrorPacket)serverMessage));
                    sink.complete();
                }
                return;
            }
            if (serverMessage instanceof CompletePrepareResult) {
                this.prepareResult.set(((CompletePrepareResult)serverMessage).getPrepare());
                return;
            }
            if (serverMessage instanceof ColumnCountPacket) {
                if (!((ColumnCountPacket)serverMessage).isMetaFollows()) {
                    columns.addAll(Arrays.asList(this.prepareResult.get().getColumns()));
                }
                return;
            }
            if (serverMessage instanceof ColumnDefinitionPacket) {
                columns.add((ColumnDefinitionPacket)serverMessage);
                return;
            }
            if (serverMessage instanceof OkPacket) {
                OkPacket okPacket = (OkPacket)serverMessage;
                if (this.generatedColumns != null && !this.supportReturning && serverMessage instanceof OkPacket) {
                    String colName = this.generatedColumns.length > 0 ? this.generatedColumns[0] : "ID";
                    List<ColumnDefinitionPacket> tmpCol = Collections.singletonList(ColumnDefinitionPacket.fromGeneratedId(colName, this.conf));
                    if (okPacket.value() > 1L) {
                        sink.error((Throwable)this.factory.createException("Connector cannot get generated ID (using returnGeneratedValues) multiple rows before MariaDB 10.5.1", "HY000", -1));
                        return;
                    }
                    ByteBuf buf = this.getLongTextEncoded(okPacket.getLastInsertId());
                    this.segment = new MariadbRowSegment(new TextRowDecoder(tmpCol, this.conf), tmpCol);
                    this.segment.updateRaw(buf);
                    sink.next((Object)this.segment);
                } else {
                    sink.next((Object)okPacket);
                }
                return;
            }
            if (serverMessage instanceof EofPacket) {
                RowDecoder decoder = this.text ? new TextRowDecoder(columns, this.conf) : new BinaryRowDecoder(columns, this.conf);
                boolean outputParameter = (((EofPacket)serverMessage).getServerStatus() & 0x1000) > 0;
                this.segment = outputParameter ? new MariadbOutSegment(decoder, columns) : new MariadbRowSegment(decoder, columns);
                return;
            }
            if (serverMessage instanceof RowPacket) {
                RowPacket row = (RowPacket)serverMessage;
                try {
                    this.segment.updateRaw(row.getRaw());
                    sink.next((Object)this.segment);
                }
                catch (IllegalArgumentException i) {
                    sink.error((Throwable)this.factory.createException(i.getMessage(), "HY000", -1));
                }
                catch (R2dbcException i) {
                    sink.error((Throwable)i);
                }
                finally {
                    row.release();
                }
                return;
            }
        };
    }

    private ByteBuf getLongTextEncoded(long value) {
        byte[] byteValue = Long.toString(value).getBytes(StandardCharsets.US_ASCII);
        int length = byteValue.length;
        byte[] encodedLength = new byte[]{(byte)length};
        return Unpooled.copiedBuffer((byte[][])new byte[][]{encodedLength, byteValue});
    }
}

