/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.authentication.standard;

import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.authentication.AuthenticationPlugin;
import org.mariadb.r2dbc.message.AuthMoreData;
import org.mariadb.r2dbc.message.AuthSwitch;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.client.ClearPasswordPacket;

public final class PamPluginFlow
implements AuthenticationPlugin {
    public static final String TYPE = "dialog";
    private int counter = -1;

    @Override
    public PamPluginFlow create() {
        return new PamPluginFlow();
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public ClientMessage next(MariadbConnectionConfiguration configuration, AuthSwitch authSwitch, AuthMoreData authMoreData) {
        ++this.counter;
        if (this.counter == 0) {
            return new ClearPasswordPacket(authSwitch.getSequencer(), configuration.getPassword());
        }
        if (configuration.getPamOtherPwd() == null) {
            throw new IllegalArgumentException("PAM authentication is set with multiple password, but pamOtherPwd option wasn't set");
        }
        if (configuration.getPamOtherPwd().length < this.counter) {
            throw new IllegalArgumentException(String.format("PAM authentication required at least %s passwords, but pamOtherPwd has only %s", this.counter, configuration.getPamOtherPwd().length));
        }
        return new ClearPasswordPacket(authSwitch.getSequencer(), configuration.getPamOtherPwd()[this.counter - 1]);
    }
}

