/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import org.mariadb.r2dbc.client.CmdElement;
import org.mariadb.r2dbc.client.DecoderStateInterface;
import org.mariadb.r2dbc.client.MariadbPacketDecoder;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.server.AuthMoreDataPacket;
import org.mariadb.r2dbc.message.server.AuthSwitchPacket;
import org.mariadb.r2dbc.message.server.ColumnCountPacket;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.message.server.CompletePrepareResult;
import org.mariadb.r2dbc.message.server.EofPacket;
import org.mariadb.r2dbc.message.server.ErrorPacket;
import org.mariadb.r2dbc.message.server.InitialHandshakePacket;
import org.mariadb.r2dbc.message.server.OkPacket;
import org.mariadb.r2dbc.message.server.PrepareResultPacket;
import org.mariadb.r2dbc.message.server.RowPacket;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.message.server.SkipPacket;
import org.mariadb.r2dbc.util.ServerPrepareResult;

public enum DecoderState implements DecoderStateInterface
{
    INIT_HANDSHAKE{

        @Override
        public DecoderState decoder(short val, int len) {
            switch (val) {
                case 255: {
                    return ERROR;
                }
            }
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return InitialHandshakePacket.decode(sequencer, body);
        }
    }
    ,
    OK_PACKET{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return OkPacket.decode(sequencer, body, decoder.getContext());
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return QUERY_RESPONSE;
        }
    }
    ,
    AUTHENTICATION_SWITCH{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return AuthSwitchPacket.decode(sequencer, body, decoder.getContext());
        }
    }
    ,
    AUTHENTICATION_SWITCH_RESPONSE{

        @Override
        public DecoderState decoder(short val, int len) {
            switch (val) {
                case 1: {
                    return AUTHENTICATION_MORE_DATA;
                }
                case 254: {
                    return AUTHENTICATION_SWITCH;
                }
                case 255: {
                    return ERROR;
                }
            }
            return OK_PACKET;
        }
    }
    ,
    AUTHENTICATION_MORE_DATA{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return AuthMoreDataPacket.decode(sequencer, body, decoder.getContext());
        }
    }
    ,
    QUERY_RESPONSE{

        @Override
        public DecoderState decoder(short val, int len) {
            switch (val) {
                case 0: {
                    return OK_PACKET;
                }
                case 255: {
                    return ERROR;
                }
            }
            return COLUMN_COUNT;
        }
    }
    ,
    COLUMN_COUNT{
        ColumnCountPacket columnCountPacket;

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            this.columnCountPacket = ColumnCountPacket.decode(sequencer, body, decoder.getContext());
            decoder.setStateCounter(this.columnCountPacket.getColumnCount());
            return this.columnCountPacket;
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            if (this.columnCountPacket.isMetaFollows()) {
                return COLUMN_DEFINITION;
            }
            if ((decoder.getClientCapabilities() & 0x1000000L) > 0L) {
                return ROW_RESPONSE;
            }
            return EOF_INTERMEDIATE_RESPONSE;
        }
    }
    ,
    COLUMN_DEFINITION{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            decoder.decrementStateCounter();
            return ColumnDefinitionPacket.decode(sequencer, body, decoder.getContext(), false, decoder.getConf());
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            if (decoder.getStateCounter() <= 0) {
                return EOF_INTERMEDIATE_RESPONSE;
            }
            return this;
        }
    }
    ,
    EOF_INTERMEDIATE_RESPONSE{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            EofPacket eof = EofPacket.decode(sequencer, body, decoder.getContext(), false);
            decoder.setStateCounter((eof.getServerStatus() & 0x1000) > 0 ? 1 : 0);
            return eof;
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            if (decoder.getStateCounter() > 0) {
                decoder.setStateCounter(0);
                return ROW_RESPONSE_OUT_PARAM;
            }
            return ROW_RESPONSE;
        }
    }
    ,
    EOF_END{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return EofPacket.decode(sequencer, body, decoder.getContext(), true);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return QUERY_RESPONSE;
        }
    }
    ,
    EOF_END_OUT_PARAM{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return EofPacket.decodeOutputParam(sequencer, body, decoder.getContext());
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return QUERY_RESPONSE;
        }
    }
    ,
    ROW_RESPONSE{

        @Override
        public DecoderState decoder(short val, int len) {
            switch (val) {
                case 254: {
                    if (len < 0xFFFFFF) {
                        return EOF_END;
                    }
                    return ROW;
                }
                case 255: {
                    return ERROR;
                }
            }
            return ROW;
        }
    }
    ,
    ROW_RESPONSE_OUT_PARAM{

        @Override
        public DecoderState decoder(short val, int len) {
            switch (val) {
                case 254: {
                    if (len < 0xFFFFFF) {
                        return EOF_END_OUT_PARAM;
                    }
                    return ROW_OUTPUT_PARAM;
                }
                case 255: {
                    return ERROR;
                }
            }
            return ROW_OUTPUT_PARAM;
        }
    }
    ,
    ROW{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return new RowPacket(body);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return ROW_RESPONSE;
        }
    }
    ,
    ROW_OUTPUT_PARAM{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return new RowPacket(body);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return ROW_RESPONSE_OUT_PARAM;
        }
    }
    ,
    PREPARE_RESPONSE{

        @Override
        public DecoderState decoder(short val, int len) {
            switch (val) {
                case 255: {
                    return ERROR;
                }
            }
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            PrepareResultPacket packet = PrepareResultPacket.decode(sequencer, body, decoder.getContext(), false);
            decoder.setPrepare(packet);
            if (packet.getNumParams() == 0 && packet.getNumColumns() == 0) {
                ServerPrepareResult serverPrepareResult = decoder.endPrepare();
                return new CompletePrepareResult(serverPrepareResult, false);
            }
            return new SkipPacket(false);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            if (decoder.getPrepare().getNumParams() == 0) {
                decoder.setStateCounter(decoder.getPrepare().getNumColumns());
                return PREPARE_COLUMN;
            }
            decoder.setStateCounter(decoder.getPrepare().getNumParams() + 1);
            return PREPARE_PARAMETER;
        }
    }
    ,
    PREPARE_AND_EXECUTE_RESPONSE{

        @Override
        public DecoderState decoder(short val, int len) {
            switch (val) {
                case 255: {
                    return ERROR_AND_EXECUTE_RESPONSE;
                }
            }
            return this;
        }

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            decoder.setPrepare(PrepareResultPacket.decode(sequencer, body, decoder.getContext(), true));
            if (decoder.getPrepare().getNumParams() == 0 && decoder.getPrepare().getNumColumns() == 0) {
                ServerPrepareResult serverPrepareResult = decoder.endPrepare();
                return new CompletePrepareResult(serverPrepareResult, true);
            }
            return new SkipPacket(false);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            if (decoder.getPrepare().getNumParams() == 0) {
                if (decoder.getPrepare().getNumColumns() == 0) {
                    decoder.setPrepare(null);
                    return QUERY_RESPONSE;
                }
                decoder.setStateCounter(decoder.getPrepare().getNumColumns());
                return PREPARE_COLUMN;
            }
            decoder.setStateCounter(decoder.getPrepare().getNumParams() + 1);
            return PREPARE_PARAMETER;
        }
    }
    ,
    PREPARE_PARAMETER{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            decoder.decrementStateCounter();
            if (decoder.getStateCounter() == 0 && decoder.getPrepare().getNumColumns() == 0) {
                boolean ending = !decoder.getPrepare().isContinueOnEnd();
                ServerPrepareResult serverPrepareResult = decoder.endPrepare();
                return new CompletePrepareResult(serverPrepareResult, ending);
            }
            return SkipPacket.decode(false);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            if (decoder.getStateCounter() <= 0) {
                if (decoder.getPrepare() == null) {
                    return QUERY_RESPONSE;
                }
                decoder.setStateCounter(decoder.getPrepare().getNumColumns());
                return PREPARE_COLUMN;
            }
            return PREPARE_PARAMETER;
        }
    }
    ,
    PREPARE_COLUMN{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            ColumnDefinitionPacket columnDefinitionPacket;
            decoder.getPrepareColumns()[decoder.getPrepare().getNumColumns() - decoder.getStateCounter()] = columnDefinitionPacket = ColumnDefinitionPacket.decode(sequencer, body, decoder.getContext(), false, decoder.getConf());
            decoder.decrementStateCounter();
            return SkipPacket.decode(false);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            if (decoder.getStateCounter() <= 0) {
                return PREPARE_COLUMN_EOF;
            }
            return this;
        }
    }
    ,
    PREPARE_COLUMN_EOF{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            boolean ending = !decoder.getPrepare().isContinueOnEnd();
            ServerPrepareResult prepareResult = decoder.endPrepare();
            return new CompletePrepareResult(prepareResult, ending);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return QUERY_RESPONSE;
        }
    }
    ,
    ERROR{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return ErrorPacket.decode(sequencer, body, true);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            throw new IllegalArgumentException("unexpected state");
        }
    }
    ,
    ERROR_AND_EXECUTE_RESPONSE{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            return ErrorPacket.decode(sequencer, body, false);
        }

        @Override
        public DecoderState next(MariadbPacketDecoder decoder) {
            return SKIP_EXECUTE;
        }
    }
    ,
    SKIP_EXECUTE{

        @Override
        public ServerMessage decode(ByteBuf body, Sequencer sequencer, MariadbPacketDecoder decoder, CmdElement element) {
            decoder.decrementStateCounter();
            return SkipPacket.decode(true);
        }
    };

}

