/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;

public abstract class RowDecoder {
    protected static final int NULL_LENGTH = -1;
    public ByteBuf buf;
    protected int length;
    protected int index;
    protected MariadbConnectionConfiguration conf;

    public RowDecoder(MariadbConnectionConfiguration conf) {
        this.conf = conf;
    }

    public void resetRow(ByteBuf buf) {
        this.buf = buf;
        this.buf.markReaderIndex();
        this.index = -1;
    }

    protected IllegalArgumentException noDecoderException(ColumnDefinitionPacket column, Class<?> type) {
        if (type.isArray()) {
            if (EnumSet.of(DataType.TINYINT, DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT).contains((Object)column.getDataType())) {
                throw new IllegalArgumentException(String.format("No decoder for type %s[] and column type %s(%s)", type.getComponentType().getName(), column.getDataType().toString(), column.isSigned() ? "signed" : "unsigned"));
            }
            throw new IllegalArgumentException(String.format("No decoder for type %s[] and column type %s", type.getComponentType().getName(), column.getDataType().toString()));
        }
        if (EnumSet.of(DataType.TINYINT, DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT).contains((Object)column.getDataType())) {
            throw new IllegalArgumentException(String.format("No decoder for type %s and column type %s(%s)", type.getName(), column.getDataType().toString(), column.isSigned() ? "signed" : "unsigned"));
        }
        throw new IllegalArgumentException(String.format("No decoder for type %s and column type %s", type.getName(), column.getDataType().toString()));
    }

    public abstract void setPosition(int var1);

    public abstract <T> T get(int var1, ColumnDefinitionPacket var2, Class<T> var3) throws IllegalArgumentException;
}

