/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.Blob;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BufferUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BlobCodec
implements Codec<Blob> {
    public static final BlobCodec INSTANCE = new BlobCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.BIT, new DataType[]{DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB, DataType.STRING, DataType.VARSTRING, DataType.TEXT});

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getDataType()) && type.isAssignableFrom(Blob.class);
    }

    @Override
    public Blob decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Blob> type) {
        switch (column.getDataType()) {
            case STRING: 
            case TEXT: 
            case VARSTRING: {
                if (!column.isBinary()) {
                    buf.skipBytes(length);
                    throw new R2dbcNonTransientResourceException(String.format("Data type %s (not binary) cannot be decoded as Blob", new Object[]{column.getDataType()}));
                }
                return new MariaDbBlob(buf.readRetainedSlice(length));
            }
        }
        return new MariaDbBlob(buf.readRetainedSlice(length));
    }

    @Override
    public Blob decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Blob> type) {
        switch (column.getDataType()) {
            case BIT: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case BLOB: 
            case GEOMETRY: {
                return new MariaDbBlob(buf.readRetainedSlice(length));
            }
        }
        if (!column.isBinary()) {
            buf.skipBytes(length);
            throw new R2dbcNonTransientResourceException(String.format("Data type %s (not binary) cannot be decoded as Blob", new Object[]{column.getDataType()}));
        }
        return new MariaDbBlob(buf.readRetainedSlice(length));
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return Blob.class.isAssignableFrom(value);
    }

    @Override
    public void encodeText(ByteBuf buf, Context context, Object value) {
        buf.writeBytes("_binary '".getBytes(StandardCharsets.US_ASCII));
        Flux.from((Publisher)((Blob)value).stream()).handle((tempVal, sync) -> {
            if (tempVal.hasArray()) {
                BufferUtils.writeEscaped(buf, tempVal.array(), tempVal.arrayOffset(), tempVal.remaining(), context);
            } else {
                byte[] intermediaryBuf = new byte[tempVal.remaining()];
                tempVal.get(intermediaryBuf);
                BufferUtils.writeEscaped(buf, intermediaryBuf, 0, intermediaryBuf.length, context);
            }
            sync.next((Object)buf);
        }).doOnComplete(() -> buf.writeByte(39)).subscribe();
    }

    @Override
    public void encodeBinary(ByteBuf buf, Context context, Object value) {
        Blob b = (Blob)value;
        buf.writeByte(254);
        int initialPos = buf.writerIndex();
        buf.writerIndex(buf.writerIndex() + 8);
        Flux.from((Publisher)b.stream()).handle((tempVal, sync) -> {
            buf.writeBytes(tempVal);
            sync.next((Object)buf);
        }).doOnComplete(() -> {
            int endPos = buf.writerIndex();
            buf.writerIndex(initialPos);
            buf.writeLongLE((long)(endPos - (initialPos + 8)));
            buf.writerIndex(endPos);
        }).subscribe();
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.BLOB;
    }

    private class MariaDbBlob
    implements Blob {
        private ByteBuf data;

        public MariaDbBlob(ByteBuf data) {
            this.data = data;
        }

        public Publisher<ByteBuffer> stream() {
            return Mono.just((Object)this.data.nioBuffer()).doAfterTerminate(this::discard);
        }

        public Publisher<Void> discard() {
            if (this.data != null) {
                this.data.release();
                this.data = null;
            }
            return Mono.empty();
        }
    }
}

