/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.EnumSet;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.codec.list.LocalDateTimeCodec;
import org.mariadb.r2dbc.codec.list.LocalTimeCodec;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;

public class DurationCodec
implements Codec<Duration> {
    public static final DurationCodec INSTANCE = new DurationCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TIME, new DataType[]{DataType.DATETIME, DataType.TIMESTAMP, DataType.VARSTRING, DataType.TEXT, DataType.STRING});

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getDataType()) && type.isAssignableFrom(Duration.class);
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return Duration.class.isAssignableFrom(value);
    }

    @Override
    public Duration decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Duration> type) {
        switch (column.getDataType()) {
            case TIMESTAMP: 
            case DATETIME: {
                int[] parts = LocalDateTimeCodec.parseTimestamp(buf.readCharSequence(length, StandardCharsets.US_ASCII).toString());
                if (parts == null) {
                    return null;
                }
                return Duration.ZERO.plusDays(parts[2] - 1).plusHours(parts[3]).plusMinutes(parts[4]).plusSeconds(parts[5]).plusNanos(parts[6]);
            }
        }
        int[] parts = LocalTimeCodec.parseTime(buf, length, column);
        Duration d = Duration.ZERO.plusHours(parts[1]).plusMinutes(parts[2]).plusSeconds(parts[3]).plusNanos(parts[4]);
        if (parts[0] == 1) {
            return d.negated();
        }
        return d;
    }

    @Override
    public Duration decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Duration> type) {
        long days = 0L;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        long microseconds = 0L;
        switch (column.getDataType()) {
            case TIME: {
                boolean negate = false;
                if (length > 0) {
                    negate = buf.readUnsignedByte() == 1;
                    days = buf.readUnsignedIntLE();
                    hours = buf.readByte();
                    minutes = buf.readByte();
                    seconds = buf.readByte();
                    if (length > 8) {
                        microseconds = buf.readIntLE();
                    }
                }
                Duration duration = Duration.ZERO.plusDays(days).plusHours(hours).plusMinutes(minutes).plusSeconds(seconds).plusNanos(microseconds * 1000L);
                if (negate) {
                    return duration.negated();
                }
                return duration;
            }
            case TIMESTAMP: 
            case DATETIME: {
                if (length > 0) {
                    buf.readUnsignedShortLE();
                    buf.readByte();
                    days = buf.readByte();
                    if (length > 4) {
                        hours = buf.readByte();
                        minutes = buf.readByte();
                        seconds = buf.readByte();
                        if (length > 7) {
                            microseconds = buf.readUnsignedIntLE();
                        }
                    }
                }
                return Duration.ZERO.plusDays(days - 1L).plusHours(hours).plusMinutes(minutes).plusSeconds(seconds).plusNanos(microseconds * 1000L);
            }
        }
        int[] parts = LocalTimeCodec.parseTime(buf, length, column);
        Duration d = Duration.ZERO.plusHours(parts[1]).plusMinutes(parts[2]).plusSeconds(parts[3]).plusNanos(parts[4]);
        if (parts[0] == 1) {
            return d.negated();
        }
        return d;
    }

    @Override
    public void encodeText(ByteBuf buf, Context context, Object value) {
        Duration val = (Duration)value;
        long s = val.getSeconds();
        boolean negate = false;
        if (s < 0L) {
            negate = true;
            s = -s;
        }
        long microSecond = val.getNano() / 1000;
        buf.writeByte(39);
        if (microSecond != 0L) {
            if (negate) {
                buf.writeCharSequence((CharSequence)String.format("-%d:%02d:%02d.%06d", --s / 3600L, s % 3600L / 60L, s % 60L, 1000000L - microSecond), StandardCharsets.US_ASCII);
            } else {
                buf.writeCharSequence((CharSequence)String.format("%d:%02d:%02d.%06d", s / 3600L, s % 3600L / 60L, s % 60L, microSecond), StandardCharsets.US_ASCII);
            }
        } else {
            String format = negate ? "-%d:%02d:%02d" : "%d:%02d:%02d";
            buf.writeCharSequence((CharSequence)String.format(format, s / 3600L, s % 3600L / 60L, s % 60L), StandardCharsets.US_ASCII);
        }
        buf.writeByte(39);
    }

    @Override
    public void encodeBinary(ByteBuf buf, Context context, Object val) {
        Duration value = (Duration)val;
        long microSecond = value.getNano() / 1000;
        long s = Math.abs(value.getSeconds());
        if (microSecond > 0L) {
            if (value.isNegative()) {
                buf.writeByte(12);
                buf.writeByte((int)((byte)(value.isNegative() ? 1 : 0)));
                buf.writeIntLE((int)(--s / 86400L));
                buf.writeByte((int)(s % 86400L) / 3600);
                buf.writeByte((int)(s % 3600L) / 60);
                buf.writeByte((int)(s % 60L));
                buf.writeIntLE((int)(1000000L - microSecond));
            } else {
                buf.writeByte(12);
                buf.writeByte((int)((byte)(value.isNegative() ? 1 : 0)));
                buf.writeIntLE((int)(s / 86400L));
                buf.writeByte((int)(s % 86400L) / 3600);
                buf.writeByte((int)(s % 3600L) / 60);
                buf.writeByte((int)(s % 60L));
                buf.writeIntLE((int)microSecond);
            }
        } else {
            buf.writeByte(8);
            buf.writeByte((int)((byte)(value.isNegative() ? 1 : 0)));
            buf.writeIntLE((int)(s / 86400L));
            buf.writeByte((int)(s % 86400L) / 3600);
            buf.writeByte((int)(s % 3600L) / 60);
            buf.writeByte((int)(s % 60L));
        }
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.TIME;
    }
}

