/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.spi.Parameter;
import java.util.Map;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.Codecs;
import org.mariadb.r2dbc.codec.list.StringCodec;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.MessageSequence;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.ServerPrepareResult;

public final class ExecutePacket
implements ClientMessage {
    private final Parameter[] parameters;
    private final Codec<?>[] codecs;
    private final int statementId;
    private final int parameterCount;
    private final MessageSequence sequencer = new Sequencer(-1);

    public ExecutePacket(ServerPrepareResult prepareResult, Map<Integer, Parameter> parameters) {
        if (prepareResult != null) {
            this.statementId = prepareResult.getStatementId();
            this.parameterCount = prepareResult.getNumParams();
        } else {
            this.statementId = -1;
            int parameterCount = 0;
            if (parameters != null) {
                Integer[] keys;
                for (Integer i : keys = parameters.keySet().toArray(new Integer[0])) {
                    if (i + 1 <= parameterCount) continue;
                    parameterCount = i + 1;
                }
            }
            this.parameterCount = parameterCount;
        }
        this.codecs = new Codec[this.parameterCount];
        this.parameters = new Parameter[this.parameterCount];
        for (int i = 0; i < this.parameterCount; ++i) {
            Parameter p = parameters.get(i);
            if (p == null) {
                throw new IllegalArgumentException(String.format("Parameter at position %s is not set", i));
            }
            this.parameters[i] = p;
            if (p instanceof Parameter.In) {
                if (p.getValue() == null) {
                    if (p.getType() != null) {
                        try {
                            this.codecs[i] = Codecs.codecByClass(p.getType().getJavaType(), i);
                        }
                        catch (IllegalArgumentException e) {
                            this.codecs[i] = StringCodec.INSTANCE;
                        }
                        continue;
                    }
                    this.codecs[i] = StringCodec.INSTANCE;
                    continue;
                }
                this.codecs[i] = Codecs.codecByClass(p.getValue().getClass(), i);
                continue;
            }
            if (p.getType() != null) {
                try {
                    this.codecs[i] = Codecs.codecByClass(p.getType().getJavaType(), i);
                }
                catch (IllegalArgumentException e) {
                    this.codecs[i] = StringCodec.INSTANCE;
                }
                continue;
            }
            this.codecs[i] = StringCodec.INSTANCE;
        }
    }

    @Override
    public MessageSequence getSequencer() {
        return this.sequencer;
    }

    @Override
    public ByteBuf encode(Context context, ByteBufAllocator allocator) {
        ByteBuf buf = allocator.ioBuffer();
        buf.writeByte(23);
        buf.writeIntLE(this.statementId);
        buf.writeByte(0);
        buf.writeIntLE(1);
        if (this.parameterCount > 0) {
            int i;
            int nullCount = (this.parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            for (i = 0; i < this.parameterCount; ++i) {
                if (this.parameters[i].getValue() != null) continue;
                int n = i / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i % 8);
            }
            buf.writeBytes(nullBitsBuffer);
            buf.writeByte(1);
            for (i = 0; i < this.parameterCount; ++i) {
                buf.writeShortLE((int)this.codecs[i].getBinaryEncodeType().get());
            }
        }
        for (int i = 0; i < this.parameterCount; ++i) {
            Parameter p = this.parameters[i];
            if (p.getValue() == null) continue;
            this.codecs[i].encodeBinary(buf, context, p.getValue());
        }
        return buf;
    }
}

