/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.spi.Parameter;
import java.nio.charset.StandardCharsets;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.Codecs;
import org.mariadb.r2dbc.codec.list.StringCodec;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.MessageSequence;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.ClientPrepareResult;

public final class QueryWithParametersPacket
implements ClientMessage {
    private final ClientPrepareResult prepareResult;
    private final Parameter[] parameters;
    private final Codec<?>[] codecs;
    private final String[] generatedColumns;
    private final MessageSequence sequencer = new Sequencer(-1);

    public QueryWithParametersPacket(ClientPrepareResult prepareResult, Parameter[] parameters, String[] generatedColumns) {
        this.prepareResult = prepareResult;
        this.parameters = parameters;
        this.codecs = new Codec[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter p = parameters[i];
            if (!(p instanceof Parameter.In)) continue;
            this.codecs[i] = p.getValue() == null ? StringCodec.INSTANCE : Codecs.codecByClass(p.getValue().getClass(), i);
        }
        this.generatedColumns = generatedColumns;
    }

    @Override
    public ByteBuf encode(Context context, ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        String additionalReturningPart = null;
        if (this.generatedColumns != null) {
            additionalReturningPart = this.generatedColumns.length == 0 ? " RETURNING *" : " RETURNING " + String.join((CharSequence)", ", this.generatedColumns);
        }
        ByteBuf out = byteBufAllocator.ioBuffer();
        out.writeByte(3);
        if (this.prepareResult.getParamCount() == 0) {
            out.writeBytes(this.prepareResult.getQueryParts().get(0));
            if (additionalReturningPart != null) {
                out.writeCharSequence((CharSequence)additionalReturningPart, StandardCharsets.UTF_8);
            }
        } else {
            out.writeBytes(this.prepareResult.getQueryParts().get(0));
            for (int i = 0; i < this.prepareResult.getParamCount(); ++i) {
                if (this.parameters[i].getValue() == null) {
                    out.writeBytes("null".getBytes(StandardCharsets.US_ASCII));
                } else {
                    this.codecs[i].encodeText(out, context, this.parameters[i].getValue());
                }
                out.writeBytes(this.prepareResult.getQueryParts().get(i + 1));
            }
            if (additionalReturningPart != null) {
                out.writeCharSequence((CharSequence)additionalReturningPart, StandardCharsets.UTF_8);
            }
        }
        return out;
    }

    @Override
    public MessageSequence getSequencer() {
        return this.sequencer;
    }
}

