/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.flow;

import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import java.util.Arrays;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.SslMode;
import org.mariadb.r2dbc.authentication.AuthenticationFlowPluginLoader;
import org.mariadb.r2dbc.authentication.AuthenticationPlugin;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.client.DecoderState;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.client.HandshakeResponse;
import org.mariadb.r2dbc.message.client.SslRequestPacket;
import org.mariadb.r2dbc.message.server.AuthMoreDataPacket;
import org.mariadb.r2dbc.message.server.AuthSwitchPacket;
import org.mariadb.r2dbc.message.server.ErrorPacket;
import org.mariadb.r2dbc.message.server.InitialHandshakePacket;
import org.mariadb.r2dbc.message.server.OkPacket;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.HostAddress;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class AuthenticationFlow {
    private static final Logger logger = Loggers.getLogger(AuthenticationFlow.class);
    private MariadbConnectionConfiguration configuration;
    private InitialHandshakePacket initialHandshakePacket;
    private AuthenticationPlugin pluginHandler;
    private AuthSwitchPacket authSwitchPacket;
    private AuthMoreDataPacket authMoreDataPacket;
    private Client client;
    private FluxSink<State> sink;
    private HostAddress hostAddress;
    private long clientCapabilities;

    private AuthenticationFlow(Client client, MariadbConnectionConfiguration configuration, HostAddress hostAddress) {
        this.client = client;
        this.configuration = configuration;
        this.hostAddress = hostAddress;
    }

    public static Mono<Client> exchange(Client client, MariadbConnectionConfiguration configuration, HostAddress hostAddress) {
        AuthenticationFlow flow = new AuthenticationFlow(client, configuration, hostAddress);
        Assert.requireNonNull(client, "client must not be null");
        return Flux.create(sink -> {
            flow.sink = sink;
            State.INIT.handle(flow).subscribe(arg_0 -> ((FluxSink)sink).next(arg_0), arg_0 -> ((FluxSink)sink).error(arg_0));
        }).doOnNext(state -> {
            if (State.COMPLETED == state) {
                if (flow.authMoreDataPacket != null) {
                    flow.authMoreDataPacket.deallocate();
                }
                flow.sink.complete();
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("authentication state {}", new Object[]{state});
                }
                state.handle(flow).subscribe(arg_0 -> flow.sink.next(arg_0), arg_0 -> flow.sink.error(arg_0));
            }
        }).doOnComplete(() -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Authentication success");
            }
        }).doOnError(e -> {
            logger.error("Authentication failed", e);
            flow.client.close().subscribe();
        }).then(Mono.just((Object)client));
    }

    private static long initializeClientCapabilities(long serverCapabilities, MariadbConnectionConfiguration configuration) {
        long capabilities = 68731970306L;
        if (configuration.allowMultiQueries()) {
            capabilities |= 0x10000L;
        }
        if (configuration.getDatabase() != null) {
            capabilities |= 8L;
        }
        return capabilities;
    }

    private HandshakeResponse createHandshakeResponse(long clientCapabilities) {
        return new HandshakeResponse(this.initialHandshakePacket, this.configuration.getUsername(), this.configuration.getPassword(), this.configuration.getDatabase(), this.configuration.getConnectionAttributes(), this.hostAddress, clientCapabilities);
    }

    private SslRequestPacket createSslRequest(long clientCapabilities) {
        return new SslRequestPacket(this.initialHandshakePacket, clientCapabilities);
    }

    public static enum State {
        INIT{

            @Override
            Mono<State> handle(AuthenticationFlow flow) {
                return flow.client.receive(DecoderState.INIT_HANDSHAKE).handle((message, sink) -> {
                    if (message instanceof ErrorPacket) {
                        sink.error((Throwable)ExceptionFactory.INSTANCE.from((ErrorPacket)message));
                    } else if (message instanceof InitialHandshakePacket) {
                        InitialHandshakePacket packet = (InitialHandshakePacket)message;
                        flow.initialHandshakePacket = packet;
                        flow.clientCapabilities = AuthenticationFlow.initializeClientCapabilities(flow.initialHandshakePacket.getCapabilities(), flow.configuration);
                        flow.client.setContext(packet, flow.clientCapabilities);
                        if (flow.configuration.getSslConfig().getSslMode() != SslMode.DISABLE) {
                            if ((packet.getCapabilities() & 0x800L) == 0L) {
                                sink.error((Throwable)new R2dbcNonTransientResourceException("Trying to connect with ssl, but ssl not enabled in the server", "08000"));
                            } else {
                                sink.next((Object)SSL_REQUEST);
                            }
                        } else {
                            sink.next((Object)HANDSHAKE);
                        }
                    } else {
                        sink.error((Throwable)new IllegalStateException(String.format("Unexpected message type '%s' in handshake init phase", message.getClass().getSimpleName())));
                    }
                }).next();
            }
        }
        ,
        SSL_REQUEST{

            @Override
            Mono<State> handle(AuthenticationFlow flow) {
                flow.clientCapabilities |= 2048L;
                SslRequestPacket sslRequest = flow.createSslRequest(flow.clientCapabilities);
                return flow.client.sendSslRequest(sslRequest, flow.configuration).then(Mono.just((Object)((Object)HANDSHAKE)));
            }
        }
        ,
        HANDSHAKE{

            @Override
            Mono<State> handle(AuthenticationFlow flow) {
                return flow.client.sendCommand(flow.createHandshakeResponse(flow.clientCapabilities), DecoderState.AUTHENTICATION_SWITCH_RESPONSE).handle((message, sink) -> {
                    if (message instanceof ErrorPacket) {
                        R2dbcException exception = ExceptionFactory.createException((ErrorPacket)message, null);
                        sink.error((Throwable)new R2dbcNonTransientResourceException(exception.getMessage(), (Throwable)exception));
                    } else if (message instanceof OkPacket) {
                        sink.next((Object)COMPLETED);
                    } else if (message instanceof AuthSwitchPacket) {
                        flow.authSwitchPacket = (AuthSwitchPacket)message;
                        String plugin = flow.authSwitchPacket.getPlugin();
                        if (flow.configuration.getRestrictedAuth() != null && !Arrays.stream(flow.configuration.getRestrictedAuth()).anyMatch(s -> plugin.equals(s))) {
                            sink.error((Throwable)new R2dbcPermissionDeniedException(String.format("Unsupported authentication plugin %s. Authorized plugin: %s", plugin, Arrays.toString(flow.configuration.getRestrictedAuth()))));
                        } else {
                            AuthenticationPlugin authPlugin = AuthenticationFlowPluginLoader.get(plugin);
                            flow.authMoreDataPacket = null;
                            flow.pluginHandler = authPlugin;
                            sink.next((Object)AUTH_SWITCH);
                        }
                    } else {
                        sink.error((Throwable)new IllegalStateException(String.format("Unexpected message type '%s' in handshake response phase", message.getClass().getSimpleName())));
                    }
                }).next();
            }
        }
        ,
        AUTH_SWITCH{

            @Override
            Mono<State> handle(AuthenticationFlow flow) {
                ClientMessage clientMessage;
                try {
                    clientMessage = flow.pluginHandler.next(flow.configuration, flow.authSwitchPacket, flow.authMoreDataPacket);
                }
                catch (R2dbcException ex) {
                    return Mono.error((Throwable)ex);
                }
                Flux<ServerMessage> flux = clientMessage != null ? flow.client.sendCommand(clientMessage, DecoderState.AUTHENTICATION_SWITCH_RESPONSE) : flow.client.receive(DecoderState.AUTHENTICATION_SWITCH_RESPONSE);
                return flux.handle((message, sink) -> {
                    if (message instanceof ErrorPacket) {
                        sink.error((Throwable)new R2dbcNonTransientResourceException(((ErrorPacket)message).message()));
                    } else if (message instanceof OkPacket) {
                        sink.next((Object)COMPLETED);
                    } else if (message instanceof AuthSwitchPacket) {
                        flow.authSwitchPacket = (AuthSwitchPacket)message;
                        String plugin = flow.authSwitchPacket.getPlugin();
                        if (flow.configuration.getRestrictedAuth() != null && !Arrays.stream(flow.configuration.getRestrictedAuth()).anyMatch(s -> plugin.equals(s))) {
                            sink.error((Throwable)new R2dbcPermissionDeniedException(String.format("Unsupported authentication plugin %s. Authorized plugin: %s", plugin, Arrays.toString(flow.configuration.getRestrictedAuth()))));
                        } else {
                            AuthenticationPlugin authPlugin = AuthenticationFlowPluginLoader.get(plugin);
                            flow.authMoreDataPacket = null;
                            flow.pluginHandler = authPlugin;
                            sink.next((Object)AUTH_SWITCH);
                        }
                    } else if (message instanceof AuthMoreDataPacket) {
                        flow.authMoreDataPacket = (AuthMoreDataPacket)message;
                        sink.next((Object)AUTH_SWITCH);
                    } else {
                        sink.error((Throwable)new IllegalStateException(String.format("Unexpected message type '%s' in handshake response phase", message.getClass().getSimpleName())));
                    }
                }).next();
            }
        }
        ,
        COMPLETED{

            @Override
            Mono<State> handle(AuthenticationFlow flow) {
                return Mono.just((Object)((Object)COMPLETED));
            }
        };


        abstract Mono<State> handle(AuthenticationFlow var1);
    }
}

