/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.server;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.Result;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.BufferUtils;
import reactor.util.Logger;
import reactor.util.Loggers;

public class OkPacket
implements ServerMessage,
Result.UpdateCount {
    public static final byte TYPE = 0;
    private static final Logger logger = Loggers.getLogger(OkPacket.class);
    private final Sequencer sequencer;
    private final long affectedRows;
    private final long lastInsertId;
    private final short serverStatus;
    private final short warningCount;
    private final boolean ending;

    public OkPacket(Sequencer sequencer, long affectedRows, long lastInsertId, short serverStatus, short warningCount, boolean ending) {
        this.sequencer = sequencer;
        this.affectedRows = affectedRows;
        this.lastInsertId = lastInsertId;
        this.serverStatus = serverStatus;
        this.warningCount = warningCount;
        this.ending = ending;
    }

    public static OkPacket decode(Sequencer sequencer, ByteBuf buf, Context context) {
        buf.skipBytes(1);
        long affectedRows = BufferUtils.readLengthEncodedInt(buf);
        long lastInsertId = BufferUtils.readLengthEncodedInt(buf);
        short serverStatus = buf.readShortLE();
        short warningCount = buf.readShortLE();
        if ((context.getServerCapabilities() & 0x800000L) != 0L && buf.isReadable()) {
            BufferUtils.skipLengthEncode(buf);
            while (buf.isReadable()) {
                ByteBuf stateInfo = BufferUtils.readLengthEncodedBuffer(buf);
                if (!stateInfo.isReadable()) continue;
                switch (stateInfo.readByte()) {
                    case 0: {
                        ByteBuf sessionVariableBuf = BufferUtils.readLengthEncodedBuffer(stateInfo);
                        String variable = BufferUtils.readLengthEncodedString(sessionVariableBuf);
                        String value = BufferUtils.readLengthEncodedString(sessionVariableBuf);
                        logger.debug("System variable change :  {} = {}", new Object[]{variable, value});
                        break;
                    }
                    case 1: {
                        ByteBuf sessionSchemaBuf = BufferUtils.readLengthEncodedBuffer(stateInfo);
                        String database = BufferUtils.readLengthEncodedString(sessionSchemaBuf);
                        logger.debug("Database change : now is '{}'", new Object[]{database});
                    }
                }
            }
        }
        context.setServerStatus(serverStatus);
        return new OkPacket(sequencer, affectedRows, lastInsertId, serverStatus, warningCount, (serverStatus & 8) == 0);
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }

    public short getServerStatus() {
        return this.serverStatus;
    }

    public short getWarningCount() {
        return this.warningCount;
    }

    @Override
    public boolean ending() {
        return this.ending;
    }

    @Override
    public boolean resultSetEnd() {
        return true;
    }

    public long value() {
        return this.affectedRows;
    }

    public String toString() {
        return "OkPacket{affectedRows=" + this.affectedRows + ", lastInsertId=" + this.lastInsertId + ", serverStatus=" + this.serverStatus + ", warningCount=" + this.warningCount + ", ending=" + this.ending + '}';
    }
}

