/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import org.mariadb.r2dbc.message.Context;

public final class BufferUtils {
    private static final byte QUOTE = 39;
    private static final byte DBL_QUOTE = 34;
    private static final byte ZERO_BYTE = 0;
    private static final byte BACKSLASH = 92;
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
    private static final DateTimeFormatter TIMESTAMP_FORMAT_NO_FRACTIONAL = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static void skipLengthEncode(ByteBuf buf) {
        short type = buf.readUnsignedByte();
        switch (type) {
            case 252: {
                buf.skipBytes(buf.readUnsignedShortLE());
                return;
            }
            case 253: {
                buf.skipBytes(buf.readUnsignedMediumLE());
                return;
            }
            case 254: {
                buf.skipBytes((int)buf.readLongLE());
                return;
            }
        }
        buf.skipBytes((int)type);
    }

    public static long readLengthEncodedInt(ByteBuf buf) {
        short type = buf.readUnsignedByte();
        switch (type) {
            case 251: {
                return -1L;
            }
            case 252: {
                return buf.readUnsignedShortLE();
            }
            case 253: {
                return buf.readUnsignedMediumLE();
            }
            case 254: {
                return buf.readLongLE();
            }
        }
        return type;
    }

    public static String readLengthEncodedString(ByteBuf buf) {
        int length = (int)BufferUtils.readLengthEncodedInt(buf);
        if (length == -1) {
            return null;
        }
        return buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
    }

    public static ByteBuf readLengthEncodedBuffer(ByteBuf buf) {
        int length = (int)BufferUtils.readLengthEncodedInt(buf);
        if (length == -1) {
            return null;
        }
        buf.skipBytes(length);
        return buf.slice(buf.readerIndex() - length, length);
    }

    public static void writeLengthEncode(int length, ByteBuf buf) {
        if (length < 251) {
            buf.writeByte((int)((byte)length));
            return;
        }
        if (length < 65536) {
            buf.writeByte(-4);
            buf.writeByte((int)((byte)length));
            buf.writeByte((int)((byte)(length >>> 8)));
            return;
        }
        if (length < 0x1000000) {
            buf.writeByte(-3);
            buf.writeByte((int)((byte)length));
            buf.writeByte((int)((byte)(length >>> 8)));
            buf.writeByte((int)((byte)(length >>> 16)));
            return;
        }
        buf.writeByte(-2);
        buf.writeByte((int)((byte)length));
        buf.writeByte((int)((byte)(length >>> 8)));
        buf.writeByte((int)((byte)(length >>> 16)));
        buf.writeByte((int)((byte)(length >>> 24)));
        buf.writeByte((int)((byte)(length >>> 32)));
        buf.writeByte((int)((byte)(length >>> 40)));
        buf.writeByte((int)((byte)(length >>> 48)));
        buf.writeByte((int)((byte)(length >>> 54)));
    }

    public static void writeLengthEncode(String val, ByteBuf buf) {
        byte[] bytes = val.getBytes(StandardCharsets.UTF_8);
        BufferUtils.writeLengthEncode(bytes.length, buf);
        buf.writeBytes(bytes);
    }

    public static void writeAscii(ByteBuf buf, String str) {
        buf.writeCharSequence((CharSequence)str, StandardCharsets.US_ASCII);
    }

    public static void writeEscaped(ByteBuf buf, byte[] bytes, int offset, int len, Context context) {
        boolean noBackslashEscapes;
        buf.ensureWritable(len * 2);
        boolean bl = noBackslashEscapes = (context.getServerStatus() & 0x200) > 0;
        if (noBackslashEscapes) {
            for (int i = offset; i < len + offset; ++i) {
                if (39 == bytes[i]) {
                    buf.writeByte(39);
                }
                buf.writeByte((int)bytes[i]);
            }
        } else {
            for (int i = offset; i < len + offset; ++i) {
                if (bytes[i] == 39 || bytes[i] == 92 || bytes[i] == 34 || bytes[i] == 0) {
                    buf.writeByte(92);
                }
                buf.writeByte((int)bytes[i]);
            }
        }
    }

    public static ByteBuf write(ByteBuf buf, String str, boolean quote, Context context) {
        char currChar;
        boolean noBackslashEscapes;
        int charsLength = str.length();
        buf.ensureWritable(charsLength * 3 + 2);
        int charsOffset = 0;
        boolean bl = noBackslashEscapes = (context.getServerStatus() & 0x200) > 0;
        if (quote) {
            buf.writeByte(39);
        }
        if (noBackslashEscapes) {
            while (charsOffset < charsLength && (currChar = str.charAt(charsOffset)) < '\u0080') {
                if (currChar == '\'') {
                    buf.writeByte(39);
                }
                buf.writeByte((int)((byte)currChar));
                ++charsOffset;
            }
        } else {
            while (charsOffset < charsLength && (currChar = str.charAt(charsOffset)) < '\u0080') {
                if (currChar == '\\' || currChar == '\'' || currChar == '\u0000' || currChar == '\"') {
                    buf.writeByte(92);
                }
                buf.writeByte((int)((byte)currChar));
                ++charsOffset;
            }
        }
        while (charsOffset < charsLength) {
            if ((currChar = str.charAt(charsOffset++)) < '\u0080') {
                if (noBackslashEscapes) {
                    if (currChar == '\'') {
                        buf.writeByte(39);
                    }
                } else if (currChar == '\\' || currChar == '\'' || currChar == '\u0000' || currChar == '\"') {
                    buf.writeByte(92);
                }
                buf.writeByte((int)((byte)currChar));
                continue;
            }
            if (currChar < '\u0800') {
                buf.writeByte((int)((byte)(0xC0 | currChar >> 6)));
                buf.writeByte((int)((byte)(0x80 | currChar & 0x3F)));
                continue;
            }
            if (currChar >= '\ud800' && currChar < '\ue000') {
                if (currChar < '\udc00') {
                    if (charsOffset + 1 > charsLength) {
                        buf.writeByte(99);
                        continue;
                    }
                    char nextChar = str.charAt(charsOffset);
                    if (nextChar >= '\udc00' && nextChar < '\ue000') {
                        int surrogatePairs = (currChar << 10) + nextChar + -56613888;
                        buf.writeByte((int)((byte)(0xF0 | surrogatePairs >> 18)));
                        buf.writeByte((int)((byte)(0x80 | surrogatePairs >> 12 & 0x3F)));
                        buf.writeByte((int)((byte)(0x80 | surrogatePairs >> 6 & 0x3F)));
                        buf.writeByte((int)((byte)(0x80 | surrogatePairs & 0x3F)));
                        ++charsOffset;
                        continue;
                    }
                    buf.writeByte(63);
                    continue;
                }
                buf.writeByte(63);
                continue;
            }
            buf.writeByte((int)((byte)(0xE0 | currChar >> 12)));
            buf.writeByte((int)((byte)(0x80 | currChar >> 6 & 0x3F)));
            buf.writeByte((int)((byte)(0x80 | currChar & 0x3F)));
        }
        if (quote) {
            buf.writeByte(39);
        }
        return buf;
    }

    public static String toString(ByteBuf packet) {
        char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[packet.readableBytes() * 2];
        int j = 0;
        while (packet.readableBytes() > 0) {
            int v = packet.readByte() & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }
}

