/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.mariadb.r2dbc.util.PrepareResult;

public class ClientPrepareResult
implements PrepareResult {
    private final List<byte[]> queryParts;
    private final List<String> paramNameList;
    private final int paramCount;
    private boolean isQueryMultipleRewritable;
    private boolean isReturning;
    private boolean supportAddingReturning;

    private ClientPrepareResult(List<byte[]> queryParts, List<String> paramNameList, boolean isQueryMultipleRewritable, boolean isReturning, boolean supportAddingReturning) {
        this.queryParts = queryParts;
        this.paramNameList = paramNameList;
        this.isQueryMultipleRewritable = isQueryMultipleRewritable;
        this.paramCount = queryParts.size() - 1;
        this.isReturning = isReturning;
        this.supportAddingReturning = supportAddingReturning;
    }

    public static ClientPrepareResult parameterParts(String queryString, boolean noBackslashEscapes) {
        boolean multipleQueriesPrepare = true;
        ArrayList<byte[]> partList = new ArrayList<byte[]>();
        ArrayList<String> paramNameList = new ArrayList<String>();
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        boolean endingSemicolon = false;
        boolean returning = false;
        boolean supportAddingReturning = false;
        boolean singleQuotes = false;
        int lastParameterPosition = 0;
        char[] query = queryString.toCharArray();
        int queryLength = query.length;
        for (int i = 0; i < queryLength; ++i) {
            char car = query[i];
            if (state == LexState.Escape) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state == LexState.SlashStarComment && lastChar == '*') {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != '-') break;
                    state = LexState.EOLComment;
                    multipleQueriesPrepare = false;
                    break;
                }
                case '\n': {
                    if (state != LexState.EOLComment) break;
                    multipleQueriesPrepare = true;
                    state = LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != LexState.String || singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != LexState.String || !singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case ';': {
                    if (state != LexState.Normal) break;
                    endingSemicolon = true;
                    multipleQueriesPrepare = false;
                    break;
                }
                case '?': {
                    if (state != LexState.Normal) break;
                    partList.add(queryString.substring(lastParameterPosition, i).getBytes(StandardCharsets.UTF_8));
                    lastParameterPosition = i + 1;
                    paramNameList.add(null);
                    break;
                }
                case ':': {
                    if (state != LexState.Normal) break;
                    partList.add(queryString.substring(lastParameterPosition, i).getBytes(StandardCharsets.UTF_8));
                    String placeholderName = "";
                    while (++i < queryLength && (car = query[i]) != ' ' && (car >= '0' && car <= '9' || car >= 'A' && car <= 'Z' || car >= 'a' && car <= 'z' || car == '-' || car == '_')) {
                        placeholderName = placeholderName + car;
                    }
                    lastParameterPosition = i;
                    paramNameList.add(placeholderName);
                    break;
                }
                case 'R': 
                case 'r': {
                    if (state != LexState.Normal || returning || queryLength <= i + 8 || query[i + 1] != 'e' && query[i + 1] != 'E' || query[i + 2] != 't' && query[i + 2] != 'T' || query[i + 3] != 'u' && query[i + 3] != 'U' || query[i + 4] != 'r' && query[i + 4] != 'R' || query[i + 5] != 'n' && query[i + 5] != 'N' || query[i + 6] != 'i' && query[i + 6] != 'I' || query[i + 7] != 'n' && query[i + 7] != 'N' || query[i + 8] != 'g' && query[i + 8] != 'G' || i > 0 && query[i - 1] > ' ' && "();><=-+,".indexOf(query[i - 1]) == -1 || i + 9 < queryLength && query[i + 9] > ' ' && "();><=-+,".indexOf(query[i + 9]) == -1) break;
                    returning = true;
                    supportAddingReturning = false;
                    i += 8;
                    break;
                }
                case 'I': 
                case 'i': {
                    if (state != LexState.Normal || returning || queryLength <= i + 6 || query[i + 1] != 'n' && query[i + 1] != 'N' || query[i + 2] != 's' && query[i + 2] != 'S' || query[i + 3] != 'e' && query[i + 3] != 'E' || query[i + 4] != 'r' && query[i + 4] != 'R' || query[i + 5] != 't' && query[i + 5] != 'T') break;
                    if (i > 0 && query[i - 1] > ' ' && "();><=-+,".indexOf(query[i - 1]) == -1) {
                        i += 6;
                        break;
                    }
                    if (query[i + 6] > ' ' && "();><=-+,".indexOf(query[i + 6]) == -1) {
                        i += 6;
                        break;
                    }
                    supportAddingReturning = true;
                    i += 6;
                    break;
                }
                case 'U': 
                case 'u': {
                    if (state != LexState.Normal || returning || queryLength <= i + 6 || query[i + 1] != 'p' && query[i + 1] != 'P' || query[i + 2] != 'd' && query[i + 2] != 'D' || query[i + 3] != 'a' && query[i + 3] != 'A' || query[i + 4] != 't' && query[i + 4] != 'T' || query[i + 5] != 'e' && query[i + 5] != 'E') break;
                    if (i > 0 && query[i - 1] > ' ' && "();><=-+,".indexOf(query[i - 1]) == -1) {
                        i += 6;
                        break;
                    }
                    if (query[i + 6] > ' ' && "();><=-+,".indexOf(query[i + 6]) == -1) {
                        i += 6;
                        break;
                    }
                    supportAddingReturning = true;
                    i += 6;
                    break;
                }
                case 'D': 
                case 'd': {
                    if (state != LexState.Normal || returning || queryLength <= i + 6 || query[i + 1] != 'e' && query[i + 1] != 'E' || query[i + 2] != 'l' && query[i + 2] != 'L' || query[i + 3] != 'e' && query[i + 3] != 'E' || query[i + 4] != 't' && query[i + 4] != 'T' || query[i + 5] != 'e' && query[i + 5] != 'E') break;
                    if (i > 0 && query[i - 1] > ' ' && "();><=-+,".indexOf(query[i - 1]) == -1) {
                        i += 6;
                        break;
                    }
                    if (query[i + 6] > ' ' && "();><=-+,".indexOf(query[i + 6]) == -1) {
                        i += 6;
                        break;
                    }
                    supportAddingReturning = true;
                    i += 6;
                    break;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                    break;
                }
                default: {
                    if (state != LexState.Normal || !endingSemicolon || (byte)car < 40) break;
                    endingSemicolon = false;
                    multipleQueriesPrepare = true;
                }
            }
            lastChar = car;
        }
        if (lastParameterPosition == 0) {
            partList.add(queryString.getBytes(StandardCharsets.UTF_8));
        } else {
            partList.add(queryString.substring(lastParameterPosition, queryLength).getBytes(StandardCharsets.UTF_8));
        }
        return new ClientPrepareResult(partList, paramNameList, multipleQueriesPrepare, returning, supportAddingReturning);
    }

    public static boolean hasParameter(String queryString, boolean noBackslashEscapes) {
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        boolean singleQuotes = false;
        char[] query = queryString.toCharArray();
        int queryLength = query.length;
        for (int i = 0; i < queryLength; ++i) {
            char car = query[i];
            if (state == LexState.Escape) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state == LexState.SlashStarComment && lastChar == '*') {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != '-') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '\n': {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != LexState.String || singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != LexState.String || !singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case '?': {
                    if (state != LexState.Normal) break;
                    return true;
                }
                case ':': {
                    if (state != LexState.Normal) break;
                    while (++i < queryLength && (car = query[i]) != ' ' && (car >= '0' && car <= '9' || car >= 'A' && car <= 'Z' || car >= 'a' && car <= 'z' || car == '-' || car == '_')) {
                    }
                    return true;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                }
            }
            lastChar = car;
        }
        return false;
    }

    public List<byte[]> getQueryParts() {
        return this.queryParts;
    }

    public List<String> getParamNameList() {
        return this.paramNameList;
    }

    public boolean isQueryMultipleRewritable() {
        return this.isQueryMultipleRewritable;
    }

    public boolean isReturning() {
        return this.isReturning;
    }

    public boolean supportAddingReturning() {
        return this.supportAddingReturning;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientPrepareResult{queryParts=[");
        for (int i = 0; i < this.queryParts.size(); ++i) {
            byte[] part = this.queryParts.get(i);
            if (i != 0) {
                sb.append(",");
            }
            sb.append("'").append(new String(part, StandardCharsets.UTF_8)).append("'");
        }
        sb.append("], paramNameList=").append(String.join((CharSequence)",", this.paramNameList)).append(", paramCount=").append(this.paramCount).append('}');
        return sb.toString();
    }

    public void validateAddingReturning() {
        if (this.isReturning()) {
            throw new IllegalStateException("Statement already includes RETURNING clause");
        }
        if (!this.supportAddingReturning()) {
            throw new IllegalStateException("Cannot add RETURNING clause to query");
        }
    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        EOLComment,
        Backtick;

    }
}

