/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbCommonStatement;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.api.MariadbResult;
import org.mariadb.r2dbc.api.MariadbStatement;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.client.DecoderState;
import org.mariadb.r2dbc.message.Protocol;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.client.ExecutePacket;
import org.mariadb.r2dbc.message.client.PreparePacket;
import org.mariadb.r2dbc.message.client.QueryPacket;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.BindEncodedValue;
import org.mariadb.r2dbc.util.Binding;
import org.mariadb.r2dbc.util.ServerNamedParamParser;
import org.mariadb.r2dbc.util.ServerPrepareResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

final class MariadbServerParameterizedQueryStatement
extends MariadbCommonStatement
implements MariadbStatement {
    private ServerNamedParamParser paramParser;
    private final AtomicReference<ServerPrepareResult> prepareResult;

    MariadbServerParameterizedQueryStatement(Client client, String sql, MariadbConnectionConfiguration configuration) {
        super(client, sql, configuration, Protocol.BINARY);
        this.expectedSize = -1;
        this.paramParser = null;
        this.prepareResult = new AtomicReference<ServerPrepareResult>((ServerPrepareResult)client.getPrepareCache().get(sql));
    }

    @Override
    protected int getExpectedSize() {
        if (this.expectedSize == -1) {
            this.expectedSize = this.prepareResult.get() != null ? this.prepareResult.get().getNumParams() : (this.paramParser != null ? this.paramParser.getParamCount() : ServerNamedParamParser.parameterParts(this.initialSql, this.client.noBackslashEscapes()).getParamCount());
        }
        return this.expectedSize;
    }

    @Override
    protected int getColumnIndex(String name) {
        Assert.requireNonNull(name, "identifier cannot be null");
        if (this.paramParser == null) {
            this.paramParser = ServerNamedParamParser.parameterParts(this.initialSql, this.client.noBackslashEscapes());
        }
        for (int i = 0; i < this.paramParser.getParamNameList().size(); ++i) {
            if (!name.equals(this.paramParser.getParamNameList().get(i))) continue;
            return i;
        }
        throw new NoSuchElementException(String.format("No parameter with name '%s' found (possible values %s)", name, this.paramParser.getParamNameList().toString()));
    }

    @Override
    public MariadbServerParameterizedQueryStatement returnGeneratedValues(String ... columns) {
        Assert.requireNonNull(columns, "columns must not be null");
        if (!this.client.getVersion().supportReturning() && columns.length > 1) {
            throw new IllegalArgumentException("returnGeneratedValues can have only one column before MariaDB 10.5.1");
        }
        this.generatedColumns = columns;
        return this;
    }

    @Override
    public Flux<MariadbResult> execute() {
        String realSql = this.paramParser == null ? this.initialSql : this.paramParser.getRealSql();
        String sql = this.generatedColumns == null || !this.client.getVersion().supportReturning() ? realSql : MariadbServerParameterizedQueryStatement.augment(realSql, this.generatedColumns);
        ExceptionFactory factory = ExceptionFactory.withSql(sql);
        if (this.prepareResult.get() == null && this.client.getPrepareCache() != null) {
            this.prepareResult.set((ServerPrepareResult)this.client.getPrepareCache().get(sql));
        }
        if (this.getExpectedSize() != 0) {
            if (this.bindings.size() == 0) {
                throw new IllegalStateException("No parameters have been set");
            }
            this.bindings.forEach(b -> b.validate(this.getExpectedSize()));
            return Flux.defer(() -> {
                if (this.bindings.size() == 1) {
                    Binding binding2 = (Binding)this.bindings.pollFirst();
                    if (this.prepareResult.get() != null) {
                        ServerPrepareResult res;
                        if (this.client.getPrepareCache() != null && (res = (ServerPrepareResult)this.client.getPrepareCache().get(sql)) != null && !res.equals(this.prepareResult.get())) {
                            this.prepareResult.get().decrementUse(this.client);
                            this.prepareResult.set(res);
                        }
                        if (this.prepareResult.get().incrementUse()) {
                            Flux messages = MariadbServerParameterizedQueryStatement.bindingParameterResults(binding2, this.getExpectedSize()).flatMapMany(values -> this.client.sendCommand(new ExecutePacket(sql, this.prepareResult.get(), (List<BindEncodedValue>)values), DecoderState.QUERY_RESPONSE, sql, false)).doFinally(s -> this.prepareResult.get().decrementUse(this.client));
                            return MariadbServerParameterizedQueryStatement.toResult(Protocol.BINARY, this.client, (Flux<ServerMessage>)messages, factory, this.prepareResult, this.generatedColumns, this.configuration);
                        }
                        this.prepareResult.set(null);
                    }
                    Flux messages = this.configuration.allowPipelining() && this.client.getVersion().isMariaDBServer() && this.client.getVersion().versionGreaterOrEqual(10, 2, 0) ? MariadbServerParameterizedQueryStatement.bindingParameterResults(binding2, this.getExpectedSize()).flatMapMany(values -> this.client.sendCommand(new PreparePacket(sql), new ExecutePacket(sql, null, (List<BindEncodedValue>)values), false)) : this.client.sendPrepare(new PreparePacket(sql), factory, sql).flatMapMany(serverPrepareResult -> {
                        this.prepareResult.set((ServerPrepareResult)serverPrepareResult);
                        return MariadbServerParameterizedQueryStatement.bindingParameterResults(binding2, this.getExpectedSize()).flatMapMany(values -> this.client.sendCommand(new ExecutePacket(sql, this.prepareResult.get(), (List<BindEncodedValue>)values), DecoderState.QUERY_RESPONSE, sql, false));
                    });
                    return MariadbServerParameterizedQueryStatement.toResult(Protocol.BINARY, this.client, (Flux<ServerMessage>)messages, factory, this.prepareResult, this.generatedColumns, this.configuration).doFinally(s -> {
                        if (this.prepareResult.get() != null) {
                            this.prepareResult.get().decrementUse(this.client);
                        }
                    });
                }
                Iterator iterator = this.bindings.iterator();
                Sinks.Many bindingSink = Sinks.many().unicast().onBackpressureBuffer();
                AtomicBoolean canceled = new AtomicBoolean();
                return this.prepareIfNotDone(sql, factory).thenMany((Publisher)bindingSink.asFlux().map(binding -> {
                    Flux messages = MariadbServerParameterizedQueryStatement.bindingParameterResults(binding, this.getExpectedSize()).flatMapMany(values -> this.client.sendCommand(new ExecutePacket(sql, this.prepareResult.get(), (List<BindEncodedValue>)values), false)).doOnComplete(() -> MariadbServerParameterizedQueryStatement.tryNextBinding(iterator, (Sinks.Many<Binding>)bindingSink, canceled));
                    return MariadbServerParameterizedQueryStatement.toResult(Protocol.BINARY, this.client, (Flux<ServerMessage>)messages, factory, this.prepareResult, this.generatedColumns, this.configuration);
                }).doOnSubscribe(it -> bindingSink.emitNext((Object)((Binding)iterator.next()), Sinks.EmitFailureHandler.FAIL_FAST)).doOnComplete(this.bindings::clear).doFinally(s -> {
                    if (this.prepareResult.get() != null) {
                        this.prepareResult.get().decrementUse(this.client);
                    }
                }).doOnCancel(() -> this.clearBindings(iterator, canceled)).doOnError(e -> this.clearBindings(iterator, canceled))).flatMap(mariadbResultFlux -> mariadbResultFlux);
            });
        }
        return Flux.defer(() -> {
            Flux<ServerMessage> messages = this.client.sendCommand(new QueryPacket(sql), DecoderState.QUERY_RESPONSE, sql, false);
            return MariadbServerParameterizedQueryStatement.toResult(Protocol.TEXT, this.client, messages, factory, null, this.generatedColumns, this.configuration);
        });
    }

    private Mono<ServerPrepareResult> prepareIfNotDone(String sql, ExceptionFactory factory) {
        if (this.prepareResult.get() == null) {
            this.prepareResult.set((ServerPrepareResult)this.client.getPrepareCache().get(sql));
            if (this.prepareResult.get() == null) {
                return this.client.sendPrepare(new PreparePacket(sql), factory, sql).doOnSuccess(p -> this.prepareResult.set((ServerPrepareResult)p));
            }
        }
        this.prepareResult.get().incrementUse();
        return Mono.just((Object)this.prepareResult.get());
    }

    public String toString() {
        return "MariadbServerParameterizedQueryStatement{client=" + this.client + ", sql='" + this.initialSql + '\'' + ", configuration=" + this.configuration + ", bindings=" + this.bindings + ", generatedColumns=" + (this.generatedColumns != null ? Arrays.toString(this.generatedColumns) : null) + ", prepareResult=" + this.prepareResult.get() + '}';
    }
}

