/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import java.util.concurrent.atomic.AtomicLong;
import org.mariadb.r2dbc.client.DecoderState;
import org.mariadb.r2dbc.message.ServerMessage;
import reactor.core.publisher.FluxSink;

public class Exchange {
    private final FluxSink<ServerMessage> sink;
    private final DecoderState initialState;
    private final String sql;
    private final AtomicLong demand = new AtomicLong();

    public Exchange(FluxSink<ServerMessage> sink, DecoderState initialState) {
        this.sink = sink;
        this.initialState = initialState;
        this.sql = null;
    }

    public Exchange(FluxSink<ServerMessage> sink, DecoderState initialState, String sql) {
        this.sink = sink;
        this.initialState = initialState;
        this.sql = sql;
    }

    public FluxSink<ServerMessage> getSink() {
        return this.sink;
    }

    public DecoderState getInitialState() {
        return this.initialState;
    }

    public String getSql() {
        return this.sql;
    }

    public boolean hasDemand() {
        return this.demand.get() > 0L;
    }

    public void emit(ServerMessage srvMsg) {
        this.demand.decrementAndGet();
        if (this.sink.isCancelled()) {
            return;
        }
        this.sink.next((Object)srvMsg);
        if (srvMsg.ending()) {
            this.sink.complete();
        }
    }

    public void incrementDemand(long n) {
        this.demand.addAndGet(n);
    }
}

