/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class MariadbFrameDecoder
extends ByteToMessageDecoder {
    private CompositeByteBuf multipart = null;

    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        while (buf.readableBytes() > 4) {
            int length = buf.getUnsignedMediumLE(buf.readerIndex());
            if (buf.readableBytes() < length + 4) {
                return;
            }
            if (length == 0xFFFFFF) {
                if (this.multipart == null) {
                    this.multipart = buf.alloc().compositeBuffer();
                }
                buf.skipBytes(4);
                this.multipart.addComponent(true, buf.readRetainedSlice(length));
                continue;
            }
            if (this.multipart != null) {
                buf.skipBytes(3);
                this.multipart.addComponent(true, 0, Unpooled.wrappedBuffer((byte[])new byte[]{buf.readByte()}));
                this.multipart.addComponent(true, buf.readRetainedSlice(length));
                out.add(this.multipart);
                this.multipart = null;
                continue;
            }
            ByteBuf packet = buf.readRetainedSlice(4 + length);
            packet.skipBytes(3);
            out.add(packet);
        }
    }
}

