/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.Context;

public class MariadbPacketEncoder {
    private Context context = null;

    public CompositeByteBuf encodeFlux(ClientMessage msg) {
        ByteBuf header;
        int packetLength;
        ByteBufAllocator allocator = this.context.getByteBufAllocator();
        CompositeByteBuf out = allocator.compositeBuffer();
        ByteBuf buf = msg.encode(this.context, allocator);
        int initialReaderIndex = buf.readerIndex();
        do {
            packetLength = Math.min(0xFFFFFF, buf.readableBytes());
            header = Unpooled.buffer((int)4, (int)4);
            header.writeMediumLE(packetLength);
            header.writeByte((int)msg.getSequencer().next());
            out.addComponent(true, header);
            out.addComponent(true, buf.retainedSlice(buf.readerIndex(), packetLength));
            buf.skipBytes(packetLength);
        } while (buf.readableBytes() > 0);
        if (packetLength == 0xFFFFFF) {
            header = Unpooled.buffer((int)4, (int)4);
            header.writeMediumLE(0);
            header.writeByte((int)msg.getSequencer().next());
            out.addComponent(true, header);
        }
        this.context.saveRedo(msg, buf, initialReaderIndex);
        msg.releaseEncodedBinds();
        buf.release();
        return out;
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

