/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.BitSet;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BindValue;
import org.mariadb.r2dbc.util.BufferUtils;

public class BitSetCodec
implements Codec<BitSet> {
    public static final BitSetCodec INSTANCE = new BitSetCodec();

    public static BitSet parseBit(ByteBuf buf, int length) {
        byte[] arr = new byte[length];
        buf.readBytes(arr);
        BitSetCodec.revertOrder(arr);
        return BitSet.valueOf(arr);
    }

    public static void revertOrder(byte[] array) {
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return column.getDataType() == DataType.BIT && type.isAssignableFrom(BitSet.class);
    }

    @Override
    public BitSet decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends BitSet> type, ExceptionFactory factory) {
        return BitSetCodec.parseBit(buf, length);
    }

    @Override
    public BitSet decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends BitSet> type, ExceptionFactory factory) {
        return BitSetCodec.parseBit(buf, length);
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return BitSet.class.isAssignableFrom(value);
    }

    @Override
    public BindValue encodeText(ByteBufAllocator allocator, Object value, Context context, ExceptionFactory factory) {
        return this.createEncodedValue(() -> {
            byte[] bytes = ((BitSet)value).toByteArray();
            BitSetCodec.revertOrder(bytes);
            StringBuilder sb = new StringBuilder(bytes.length * 8 + 3);
            sb.append("b'");
            for (int i = 0; i < 8 * bytes.length; ++i) {
                sb.append((bytes[i / 8] << i % 8 & 0x80) == 0 ? (char)'0' : (char)'1');
            }
            sb.append("'");
            return BufferUtils.encodeAscii(allocator, sb.toString());
        });
    }

    @Override
    public BindValue encodeBinary(ByteBufAllocator allocator, Object value, ExceptionFactory factory) {
        return this.createEncodedValue(() -> {
            byte[] bytes = ((BitSet)value).toByteArray();
            BitSetCodec.revertOrder(bytes);
            return BufferUtils.encodeLengthBytes(allocator, bytes);
        });
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.BLOB;
    }
}

