/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.spi.Clob;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BindValue;
import org.mariadb.r2dbc.util.BufferUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClobCodec
implements Codec<Clob> {
    public static final ClobCodec INSTANCE = new ClobCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TEXT, DataType.VARSTRING, DataType.STRING);

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getDataType()) && type.isAssignableFrom(Clob.class);
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return Clob.class.isAssignableFrom(value);
    }

    @Override
    public Clob decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Clob> type, ExceptionFactory factory) {
        String rawValue = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        return Clob.from((Publisher)Mono.just((Object)rawValue));
    }

    @Override
    public Clob decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Clob> type, ExceptionFactory factory) {
        String rawValue = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        return Clob.from((Publisher)Mono.just((Object)rawValue));
    }

    @Override
    public BindValue encodeText(ByteBufAllocator allocator, Object value, Context context, ExceptionFactory factory) {
        return this.createEncodedValue((Mono<ByteBuf>)Flux.from((Publisher)((Clob)value).stream()).reduce((Object)new StringBuilder(), (a, b) -> a.append((CharSequence)b)).map(b -> BufferUtils.encodeEscapedBytes(allocator, BufferUtils.STRING_PREFIX, b.toString().getBytes(StandardCharsets.UTF_8), context)).doOnSubscribe(e -> ((Clob)value).discard()));
    }

    @Override
    public BindValue encodeBinary(ByteBufAllocator allocator, Object value, ExceptionFactory factory) {
        return this.createEncodedValue((Mono<ByteBuf>)Flux.from((Publisher)((Clob)value).stream()).reduce((Object)new StringBuilder(), (a, b) -> a.append((CharSequence)b)).map(b -> BufferUtils.encodeLengthUtf8(allocator, b.toString())).doOnSubscribe(e -> ((Clob)value).discard()));
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.VARSTRING;
    }
}

