/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BindValue;
import org.mariadb.r2dbc.util.BufferUtils;

public class LongCodec
implements Codec<Long> {
    public static final LongCodec INSTANCE = new LongCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.FLOAT, new DataType[]{DataType.DOUBLE, DataType.OLDDECIMAL, DataType.TEXT, DataType.DECIMAL, DataType.ENUM, DataType.VARSTRING, DataType.STRING, DataType.TINYINT, DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT, DataType.BIT, DataType.YEAR});

    public static long parse(ByteBuf buf, int length) {
        long result = 0L;
        boolean negate = false;
        int idx = 0;
        if (length > 0 && buf.getByte(buf.readerIndex()) == 45) {
            negate = true;
            buf.skipBytes(1);
        }
        while (true) {
            int n = ++idx;
            ++idx;
            if (n >= length) break;
            result = result * 10L + (long)buf.readByte() - 48L;
        }
        if (negate) {
            result = -1L * result;
        }
        return result;
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getDataType()) && (type.isPrimitive() && type == Long.TYPE || type.isAssignableFrom(Long.class));
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return Long.class.isAssignableFrom(value);
    }

    @Override
    public Long decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Long> type, ExceptionFactory factory) {
        long result;
        switch (column.getDataType()) {
            case DECIMAL: 
            case OLDDECIMAL: 
            case DOUBLE: 
            case FLOAT: {
                String str1 = buf.readCharSequence(length, StandardCharsets.US_ASCII).toString();
                try {
                    return new BigDecimal(str1).setScale(0, RoundingMode.DOWN).longValueExact();
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw factory.createParsingException(String.format("value '%s' cannot be decoded as Long", str1));
                }
            }
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case YEAR: {
                return LongCodec.parse(buf, length);
            }
            case BIGINT: {
                if (column.isSigned()) {
                    result = LongCodec.parse(buf, length);
                    break;
                }
                BigInteger val = new BigInteger(buf.readCharSequence(length, StandardCharsets.US_ASCII).toString());
                try {
                    return val.longValueExact();
                }
                catch (ArithmeticException ae) {
                    throw factory.createParsingException(String.format("value '%s' cannot be decoded as Long", val));
                }
            }
            case BIT: {
                long result2 = 0L;
                for (int i = 0; i < length; ++i) {
                    byte b = buf.readByte();
                    result2 = (result2 << 8) + (long)(b & 0xFF);
                }
                return result2;
            }
            default: {
                String str = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
                try {
                    return new BigInteger(str).longValueExact();
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw factory.createParsingException(String.format("value '%s' cannot be decoded as Long", str));
                }
            }
        }
        return result;
    }

    @Override
    public Long decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Long> type, ExceptionFactory factory) {
        switch (column.getDataType()) {
            case BIGINT: {
                if (column.isSigned()) {
                    return buf.readLongLE();
                }
                byte[] bb = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    bb[i] = buf.readByte();
                }
                BigInteger val = new BigInteger(1, bb);
                try {
                    return val.longValueExact();
                }
                catch (ArithmeticException ae) {
                    throw factory.createParsingException(String.format("value '%s' cannot be decoded as Long", val));
                }
            }
            case BIT: {
                long result = 0L;
                for (int i = 0; i < length; ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                return result;
            }
            case TINYINT: {
                if (!column.isSigned()) {
                    return buf.readUnsignedByte();
                }
                return buf.readByte();
            }
            case SMALLINT: 
            case YEAR: {
                if (!column.isSigned()) {
                    return buf.readUnsignedShortLE();
                }
                return buf.readShortLE();
            }
            case MEDIUMINT: {
                if (!column.isSigned()) {
                    return buf.readUnsignedMediumLE();
                }
                return buf.readMediumLE();
            }
            case INTEGER: {
                if (!column.isSigned()) {
                    return buf.readUnsignedIntLE();
                }
                return buf.readIntLE();
            }
            case FLOAT: {
                return (long)buf.readFloatLE();
            }
            case DOUBLE: {
                return (long)buf.readDoubleLE();
            }
        }
        String str = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        try {
            return new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw factory.createParsingException(String.format("value '%s' cannot be decoded as Long", str));
        }
    }

    @Override
    public BindValue encodeText(ByteBufAllocator allocator, Object value, Context context, ExceptionFactory factory) {
        return this.createEncodedValue(() -> BufferUtils.encodeAscii(allocator, String.valueOf(value)));
    }

    @Override
    public BindValue encodeBinary(ByteBufAllocator allocator, Object value, ExceptionFactory factory) {
        return this.createEncodedValue(() -> {
            ByteBuf buf = allocator.buffer(8, 8);
            buf.writeLongLE(((Long)value).longValue());
            return buf;
        });
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.BIGINT;
    }
}

