/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BindValue;
import org.mariadb.r2dbc.util.BufferUtils;

public class StreamCodec
implements Codec<InputStream> {
    public static final StreamCodec INSTANCE = new StreamCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.BLOB, new DataType[]{DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB, DataType.TEXT, DataType.VARSTRING, DataType.STRING});

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getDataType()) && type.isAssignableFrom(InputStream.class);
    }

    @Override
    public InputStream decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends InputStream> type, ExceptionFactory factory) {
        return new ByteBufInputStream(buf.readRetainedSlice(length), true);
    }

    @Override
    public InputStream decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends InputStream> type, ExceptionFactory factory) {
        return new ByteBufInputStream(buf.readRetainedSlice(length), true);
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return InputStream.class.isAssignableFrom(value);
    }

    @Override
    public BindValue encodeText(ByteBufAllocator allocator, Object value, Context context, ExceptionFactory factory) {
        return this.createEncodedValue(() -> {
            ByteBuf buf = allocator.buffer();
            try {
                int len;
                buf.writeBytes("_binary '".getBytes(StandardCharsets.US_ASCII));
                byte[] array = new byte[4096];
                while ((len = ((InputStream)value).read(array)) > 0) {
                    BufferUtils.escapedBytes(buf, array, len, context);
                }
                buf.writeByte(39);
            }
            catch (IOException ioe) {
                throw factory.createParsingException("Failed to read InputStream", ioe);
            }
            return buf;
        });
    }

    @Override
    public BindValue encodeBinary(ByteBufAllocator allocator, Object value, ExceptionFactory factory) {
        return this.createEncodedValue(() -> {
            ByteBuf val = allocator.buffer();
            try {
                int len;
                byte[] array = new byte[4096];
                while ((len = ((InputStream)value).read(array)) > 0) {
                    val.writeBytes(array, 0, len);
                }
            }
            catch (IOException ioe) {
                throw factory.createParsingException("Failed to read InputStream", ioe);
            }
            CompositeByteBuf compositeByteBuf = allocator.compositeBuffer();
            ByteBuf buf = Unpooled.wrappedBuffer((ByteBuf)val);
            compositeByteBuf.addComponent(true, Unpooled.wrappedBuffer((byte[])BufferUtils.encodeLength(buf.readableBytes())));
            compositeByteBuf.addComponent(true, buf);
            return compositeByteBuf;
        });
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.BLOB;
    }
}

