/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.List;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.MessageSequence;
import org.mariadb.r2dbc.message.client.PreparePacket;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.BindEncodedValue;
import org.mariadb.r2dbc.util.ServerPrepareResult;
import reactor.core.publisher.Mono;

public final class ExecutePacket
implements ClientMessage {
    private final List<BindEncodedValue> bindValues;
    private int statementId;
    private final int parameterCount;
    private final String sql;
    private final MessageSequence sequencer = new Sequencer(-1);
    private ByteBuf savedBuf = null;

    public ExecutePacket(String sql, ServerPrepareResult prepareResult, List<BindEncodedValue> bindValues) {
        this.sql = sql;
        this.bindValues = bindValues;
        this.statementId = prepareResult == null ? -1 : prepareResult.getStatementId();
        this.parameterCount = prepareResult == null ? bindValues.size() : prepareResult.getNumParams();
    }

    @Override
    public ByteBuf encode(Context context, ByteBufAllocator allocator) {
        if (this.savedBuf != null) {
            return this.savedBuf;
        }
        ByteBuf buf = allocator.ioBuffer();
        buf.writeByte(23);
        buf.writeIntLE(this.statementId);
        buf.writeByte(0);
        buf.writeIntLE(1);
        if (this.parameterCount > 0) {
            int i;
            int nullCount = (this.parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            for (i = 0; i < this.parameterCount; ++i) {
                if (this.bindValues.get(i).getValue() != null) continue;
                int n = i / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i % 8);
            }
            buf.writeBytes(nullBitsBuffer);
            buf.writeByte(1);
            for (i = 0; i < this.parameterCount; ++i) {
                buf.writeShortLE((int)this.bindValues.get(i).getCodec().getBinaryEncodeType().get());
            }
        }
        for (int i = 0; i < this.parameterCount; ++i) {
            ByteBuf param = this.bindValues.get(i).getValue();
            if (param == null) continue;
            buf.writeBytes(param);
        }
        return buf;
    }

    public Mono<ClientMessage> rePrepare(Client client) {
        ServerPrepareResult res;
        if (client.getPrepareCache() != null && (res = (ServerPrepareResult)client.getPrepareCache().get(this.sql)) != null) {
            this.forceStatementId(res.getStatementId());
            return Mono.just((Object)this);
        }
        return client.sendPrepare(new PreparePacket(this.sql), ExceptionFactory.INSTANCE, this.sql).flatMap(serverPrepareResult -> {
            this.forceStatementId(serverPrepareResult.getStatementId());
            return Mono.just((Object)this);
        });
    }

    @Override
    public void save(ByteBuf buf, int initialReaderIndex) {
        this.savedBuf = buf.readerIndex(initialReaderIndex).retain();
    }

    public void forceStatementId(int statementId) {
        this.statementId = statementId;
        if (this.savedBuf != null) {
            int writerIndex = this.savedBuf.writerIndex();
            this.savedBuf.writerIndex(this.savedBuf.readerIndex() + 1);
            this.savedBuf.writeIntLE(statementId);
            this.savedBuf.writerIndex(writerIndex);
        }
    }

    @Override
    public MessageSequence getSequencer() {
        return this.sequencer;
    }

    @Override
    public void resetSequencer() {
        this.sequencer.reset();
    }

    public String getSql() {
        return this.sql;
    }

    @Override
    public void releaseEncodedBinds() {
        this.bindValues.forEach(b -> {
            if (b.getValue() != null) {
                b.getValue().release();
            }
        });
        this.bindValues.clear();
    }

    public String toString() {
        return "ExecutePacket{sql='" + this.sql + '\'' + '}';
    }
}

