/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.MessageSequence;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.BindEncodedValue;
import org.mariadb.r2dbc.util.ClientPrepareResult;

public final class QueryWithParametersPacket
implements ClientMessage {
    private final ClientPrepareResult prepareResult;
    private final List<BindEncodedValue> bindValues;
    private final MessageSequence sequencer = new Sequencer(-1);
    private final String[] generatedColumns;
    private ByteBuf savedBuf = null;

    public QueryWithParametersPacket(ClientPrepareResult prepareResult, List<BindEncodedValue> bindValues, String[] generatedColumns) {
        this.prepareResult = prepareResult;
        this.bindValues = bindValues;
        this.generatedColumns = generatedColumns;
    }

    @Override
    public ByteBuf encode(Context context, ByteBufAllocator byteBufAllocator) {
        if (this.savedBuf != null) {
            return this.savedBuf;
        }
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        String additionalReturningPart = null;
        if (this.generatedColumns != null) {
            additionalReturningPart = this.generatedColumns.length == 0 ? " RETURNING *" : " RETURNING " + String.join((CharSequence)", ", this.generatedColumns);
        }
        ByteBuf out = byteBufAllocator.ioBuffer();
        out.writeByte(3);
        if (this.prepareResult.getParamCount() == 0) {
            out.writeBytes(this.prepareResult.getQueryParts().get(0));
            if (additionalReturningPart != null) {
                out.writeCharSequence((CharSequence)additionalReturningPart, StandardCharsets.UTF_8);
            }
        } else {
            out.writeBytes(this.prepareResult.getQueryParts().get(0));
            for (int i = 0; i < this.prepareResult.getParamCount(); ++i) {
                BindEncodedValue param = this.bindValues.get(i);
                if (param.getValue() == null) {
                    out.writeBytes("null".getBytes(StandardCharsets.US_ASCII));
                } else {
                    out.writeBytes(param.getValue());
                }
                out.writeBytes(this.prepareResult.getQueryParts().get(i + 1));
            }
            if (additionalReturningPart != null) {
                out.writeCharSequence((CharSequence)additionalReturningPart, StandardCharsets.UTF_8);
            }
        }
        return out;
    }

    @Override
    public void save(ByteBuf buf, int initialReaderIndex) {
        this.savedBuf = buf.readerIndex(initialReaderIndex).retain();
    }

    @Override
    public void releaseEncodedBinds() {
        this.bindValues.forEach(b -> {
            if (b.getValue() != null) {
                b.getValue().release();
            }
        });
        this.bindValues.clear();
    }

    @Override
    public void resetSequencer() {
        this.sequencer.reset();
    }

    @Override
    public MessageSequence getSequencer() {
        return this.sequencer;
    }
}

