/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import reactor.util.Logger;
import reactor.util.Loggers;

public class DefaultHostnameVerifier
implements HostnameVerifier {
    public static final DefaultHostnameVerifier INSTANCE = new DefaultHostnameVerifier();
    private static final Logger logger = Loggers.getLogger(DefaultHostnameVerifier.class);
    private static final Pattern IP_V4 = Pattern.compile("^(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern IP_V6 = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
    private static final Pattern IP_V6_COMPRESSED = Pattern.compile("^(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)::(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)$");

    private static boolean matchDns(String hostname, String tlsDnsPattern) throws SSLException {
        boolean hostIsIp = DefaultHostnameVerifier.isIPv4(hostname) || DefaultHostnameVerifier.isIPv6(hostname);
        StringTokenizer hostnameSt = new StringTokenizer(hostname.toLowerCase(Locale.ROOT), ".");
        StringTokenizer templateSt = new StringTokenizer(tlsDnsPattern.toLowerCase(Locale.ROOT), ".");
        if (hostnameSt.countTokens() != templateSt.countTokens()) {
            return false;
        }
        try {
            while (hostnameSt.hasMoreTokens()) {
                if (DefaultHostnameVerifier.matchWildCards(hostIsIp, hostnameSt.nextToken(), templateSt.nextToken())) continue;
                return false;
            }
        }
        catch (SSLException exception) {
            throw new SSLException(DefaultHostnameVerifier.normalizedHostMsg(hostname) + " doesn't correspond to certificate CN \"" + tlsDnsPattern + "\" : wildcards not possible for IPs");
        }
        return true;
    }

    private static boolean matchWildCards(boolean hostIsIp, String hostnameToken, String tlsDnsToken) throws SSLException {
        int wildcardIndex = tlsDnsToken.indexOf("*");
        String token = hostnameToken;
        if (wildcardIndex != -1) {
            if (hostIsIp) {
                throw new SSLException("WildCards not possible when using IP's");
            }
            boolean first = true;
            String afterWildcard = tlsDnsToken;
            while (wildcardIndex != -1) {
                String beforeWildcard = afterWildcard.substring(0, wildcardIndex);
                afterWildcard = afterWildcard.substring(wildcardIndex + 1);
                int beforeStartIdx = token.indexOf(beforeWildcard);
                if (beforeStartIdx == -1 || first && beforeStartIdx != 0) {
                    return false;
                }
                first = false;
                token = token.substring(beforeStartIdx + beforeWildcard.length());
                wildcardIndex = afterWildcard.indexOf("*");
            }
            return token.endsWith(afterWildcard);
        }
        return token.equals(tlsDnsToken);
    }

    private static String extractCommonName(String principal) throws SSLException {
        if (principal == null) {
            return null;
        }
        try {
            LdapName ldapName = new LdapName(principal);
            for (Rdn rdn : ldapName.getRdns()) {
                Object obj;
                if (!rdn.getType().equalsIgnoreCase("CN") || (obj = rdn.getValue()) == null) continue;
                return obj.toString();
            }
            return null;
        }
        catch (InvalidNameException e) {
            throw new SSLException("DN value \"" + principal + "\" is invalid");
        }
    }

    private static String normaliseAddress(String hostname) {
        try {
            if (hostname == null) {
                return null;
            }
            InetAddress inetAddress = InetAddress.getByName(hostname);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unexpected) {
            return hostname;
        }
    }

    private static String normalizedHostMsg(String normalizedHost) {
        StringBuilder msg = new StringBuilder();
        if (DefaultHostnameVerifier.isIPv4(normalizedHost)) {
            msg.append("IPv4 host \"");
        } else if (DefaultHostnameVerifier.isIPv6(normalizedHost)) {
            msg.append("IPv6 host \"");
        } else {
            msg.append("DNS host \"");
        }
        msg.append(normalizedHost).append("\"");
        return msg.toString();
    }

    public static boolean isIPv4(String ip) {
        return IP_V4.matcher(ip).matches();
    }

    public static boolean isIPv6(String ip) {
        return IP_V6.matcher(ip).matches() || IP_V6_COMPRESSED.matcher(ip).matches();
    }

    private static SubjectAltNames getSubjectAltNames(X509Certificate cert) throws CertificateParsingException {
        Collection<List<?>> entries = cert.getSubjectAlternativeNames();
        SubjectAltNames subjectAltNames = new SubjectAltNames();
        if (entries != null) {
            for (List<?> entry : entries) {
                String altNameIp;
                String altNameDns;
                if (entry.size() < 2) continue;
                int type = (Integer)entry.get(0);
                if (type == 2 && (altNameDns = (String)entry.get(1)) != null) {
                    String normalizedSubjectAlt = altNameDns.toLowerCase(Locale.ROOT);
                    subjectAltNames.add(new GeneralName(normalizedSubjectAlt, Extension.DNS));
                }
                if (type != 7 || (altNameIp = (String)entry.get(1)) == null) continue;
                subjectAltNames.add(new GeneralName(altNameIp, Extension.IP));
            }
        }
        return subjectAltNames;
    }

    @Override
    public boolean verify(String host, SSLSession session) {
        return this.verify(host, session, -1L);
    }

    public boolean verify(String host, SSLSession session, long serverThreadId) {
        try {
            Certificate[] certs = session.getPeerCertificates();
            X509Certificate cert = (X509Certificate)certs[0];
            DefaultHostnameVerifier.verify(host, cert, serverThreadId);
            return true;
        }
        catch (SSLException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
            return false;
        }
    }

    public static void verify(String host, X509Certificate cert, long serverThreadId) throws SSLException {
        if (host == null) {
            return;
        }
        String lowerCaseHost = host.toLowerCase(Locale.ROOT);
        try {
            X500Principal subjectPrincipal;
            String string;
            SubjectAltNames subjectAltNames = DefaultHostnameVerifier.getSubjectAltNames(cert);
            if (!subjectAltNames.isEmpty()) {
                if (DefaultHostnameVerifier.isIPv4(lowerCaseHost)) {
                    for (GeneralName generalName : subjectAltNames.getGeneralNames()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Conn={}. IPv4 verification of hostname : type={} value={} to {}", new Object[]{serverThreadId, generalName.extension, generalName.value, lowerCaseHost});
                        }
                        if (generalName.extension != Extension.IP || !lowerCaseHost.equals(generalName.value)) continue;
                        return;
                    }
                } else if (DefaultHostnameVerifier.isIPv6(lowerCaseHost)) {
                    String normalisedHost = DefaultHostnameVerifier.normaliseAddress(lowerCaseHost);
                    for (GeneralName entry : subjectAltNames.getGeneralNames()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Conn={}. IPv6 verification of hostname : type={} value={} to {}", new Object[]{serverThreadId, entry.extension, entry.value, lowerCaseHost});
                        }
                        if (entry.extension != Extension.IP || DefaultHostnameVerifier.isIPv4(entry.value) || !normalisedHost.equals(DefaultHostnameVerifier.normaliseAddress(entry.value))) continue;
                        return;
                    }
                } else {
                    for (GeneralName generalName : subjectAltNames.getGeneralNames()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Conn={}. DNS verification of hostname : type={} value={} to {}", new Object[]{serverThreadId, generalName.extension, generalName.value, lowerCaseHost});
                        }
                        if (generalName.extension != Extension.DNS || !DefaultHostnameVerifier.matchDns(lowerCaseHost, generalName.value.toLowerCase(Locale.ROOT))) continue;
                        return;
                    }
                }
            }
            if ((string = DefaultHostnameVerifier.extractCommonName((subjectPrincipal = cert.getSubjectX500Principal()).getName("RFC2253"))) == null) {
                if (subjectAltNames.isEmpty()) {
                    throw new SSLException("CN not found in certificate principal \"" + subjectPrincipal + "\" and certificate doesn't contain SAN");
                }
                throw new SSLException("CN not found in certificate principal \"" + subjectPrincipal + "\" and " + DefaultHostnameVerifier.normalizedHostMsg(lowerCaseHost) + " doesn't correspond to " + subjectAltNames);
            }
            String normalizedCn = string.toLowerCase(Locale.ROOT);
            if (logger.isTraceEnabled()) {
                logger.trace("Conn={}. DNS verification of hostname : CN={} to {}", new Object[]{serverThreadId, normalizedCn, lowerCaseHost});
            }
            if (!DefaultHostnameVerifier.matchDns(lowerCaseHost, normalizedCn)) {
                String errorMsg = DefaultHostnameVerifier.normalizedHostMsg(lowerCaseHost) + " doesn't correspond to certificate CN \"" + normalizedCn + "\"";
                if (!subjectAltNames.isEmpty()) {
                    errorMsg = errorMsg + " and " + subjectAltNames;
                }
                throw new SSLException(errorMsg);
            }
        }
        catch (CertificateParsingException cpe) {
            throw new SSLException("certificate parsing error : " + cpe.getMessage());
        }
    }

    private static class SubjectAltNames {
        private final List<GeneralName> generalNames = new ArrayList<GeneralName>();

        private SubjectAltNames() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SAN[");
            boolean first = true;
            for (GeneralName generalName : this.generalNames) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(generalName.toString());
            }
            sb.append("]");
            return sb.toString();
        }

        public List<GeneralName> getGeneralNames() {
            return this.generalNames;
        }

        public void add(GeneralName generalName) {
            this.generalNames.add(generalName);
        }

        public boolean isEmpty() {
            return this.generalNames.isEmpty();
        }
    }

    private static class GeneralName {
        private final String value;
        private final Extension extension;

        public GeneralName(String value, Extension extension) {
            this.value = value;
            this.extension = extension;
        }

        public String toString() {
            return "{" + (Object)((Object)this.extension) + ":\"" + this.value + "\"}";
        }
    }

    private static enum Extension {
        DNS,
        IP;

    }
}

