/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.flow;

import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import java.util.Arrays;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.SslMode;
import org.mariadb.r2dbc.authentication.AuthenticationFlowPluginLoader;
import org.mariadb.r2dbc.authentication.AuthenticationPlugin;
import org.mariadb.r2dbc.authentication.standard.CachingSha2PasswordFlow;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.client.DecoderState;
import org.mariadb.r2dbc.client.SimpleClient;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.client.HandshakeResponse;
import org.mariadb.r2dbc.message.client.SslRequestPacket;
import org.mariadb.r2dbc.message.server.AuthMoreDataPacket;
import org.mariadb.r2dbc.message.server.AuthSwitchPacket;
import org.mariadb.r2dbc.message.server.ErrorPacket;
import org.mariadb.r2dbc.message.server.InitialHandshakePacket;
import org.mariadb.r2dbc.message.server.OkPacket;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.HostAddress;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class AuthenticationFlow {
    private static final Logger logger = Loggers.getLogger(AuthenticationFlow.class);
    private final MariadbConnectionConfiguration configuration;
    private InitialHandshakePacket initialHandshakePacket;
    private AuthenticationPlugin pluginHandler;
    private byte[] seed;
    private Sequencer sequencer;
    private AuthMoreDataPacket authMoreDataPacket;
    private final SimpleClient client;
    private FluxSink<State> sink;
    private final HostAddress hostAddress;
    private long clientCapabilities;

    private AuthenticationFlow(SimpleClient client, MariadbConnectionConfiguration configuration, HostAddress hostAddress) {
        this.client = client;
        this.configuration = configuration;
        this.hostAddress = hostAddress;
    }

    public static Mono<Client> exchange(SimpleClient client, MariadbConnectionConfiguration configuration, HostAddress hostAddress) {
        AuthenticationFlow flow = new AuthenticationFlow(client, configuration, hostAddress);
        Assert.requireNonNull(client, "client must not be null");
        return Flux.create(sink -> {
            flow.sink = sink;
            State.INIT.handle(flow).subscribe(arg_0 -> ((FluxSink)sink).next(arg_0), arg_0 -> ((FluxSink)sink).error(arg_0));
        }).doOnNext(state -> {
            if (State.COMPLETED == state) {
                if (flow.authMoreDataPacket != null) {
                    flow.authMoreDataPacket.release();
                    flow.authMoreDataPacket = null;
                }
                flow.sink.complete();
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("authentication state {}", new Object[]{state});
                }
                state.handle(flow).subscribe(arg_0 -> flow.sink.next(arg_0), arg_0 -> flow.sink.error(arg_0));
            }
        }).doOnComplete(() -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Authentication success");
            }
        }).doOnError(e -> {
            logger.warn("Authentication failed", e);
            flow.client.handleConnectionError((Throwable)e);
        }).doFinally(c -> {
            if (flow.authMoreDataPacket != null) {
                flow.authMoreDataPacket.release();
                flow.authMoreDataPacket = null;
            }
        }).then(Mono.just((Object)client));
    }

    private static long initializeClientCapabilities(long serverCapabilities, MariadbConnectionConfiguration configuration) {
        long capabilities = 68731970306L;
        if (configuration.allowMultiQueries()) {
            capabilities |= 0x10000L;
        }
        if (configuration.getDatabase() != null) {
            capabilities |= 8L;
        }
        return capabilities & serverCapabilities;
    }

    private HandshakeResponse createHandshakeResponse(long clientCapabilities) {
        return new HandshakeResponse(this.initialHandshakePacket, this.configuration.getUsername(), this.configuration.getPassword(), this.configuration.getDatabase(), this.configuration.getConnectionAttributes(), this.hostAddress, clientCapabilities);
    }

    private SslRequestPacket createSslRequest(long clientCapabilities) {
        return new SslRequestPacket(this.initialHandshakePacket, clientCapabilities);
    }

    static /* synthetic */ byte[] access$702(AuthenticationFlow x0, byte[] x1) {
        x0.seed = x1;
        return x1;
    }

    public static enum State {
        INIT{

            @Override
            Mono<State> handle(AuthenticationFlow flow) {
                return flow.client.receive(DecoderState.INIT_HANDSHAKE).handle((message, sink) -> {
                    if (message instanceof ErrorPacket) {
                        sink.error((Throwable)ExceptionFactory.INSTANCE.from((ErrorPacket)message));
                    } else if (message instanceof InitialHandshakePacket) {
                        InitialHandshakePacket packet = (InitialHandshakePacket)message;
                        flow.initialHandshakePacket = packet;
                        flow.clientCapabilities = AuthenticationFlow.initializeClientCapabilities(flow.initialHandshakePacket.getCapabilities(), flow.configuration);
                        flow.client.setContext(packet, flow.clientCapabilities);
                        SslMode sslMode = flow.configuration.getSslConfig().getSslMode();
                        if (sslMode != SslMode.DISABLE && sslMode != SslMode.TUNNEL) {
                            if ((packet.getCapabilities() & 0x800L) == 0L) {
                                sink.error((Throwable)new R2dbcNonTransientResourceException("Trying to connect with ssl, but ssl not enabled in the server", "08000"));
                            } else {
                                sink.next((Object)SSL_REQUEST);
                            }
                        } else {
                            sink.next((Object)HANDSHAKE);
                        }
                    } else {
                        sink.error((Throwable)new IllegalStateException(String.format("Unexpected message type '%s' in handshake init phase", message.getClass().getSimpleName())));
                    }
                }).next();
            }
        }
        ,
        SSL_REQUEST{

            @Override
            Mono<State> handle(AuthenticationFlow flow) {
                flow.clientCapabilities |= 2048L;
                SslRequestPacket sslRequest = flow.createSslRequest(flow.clientCapabilities);
                return flow.client.sendSslRequest(sslRequest, flow.configuration).then(Mono.just((Object)((Object)HANDSHAKE)));
            }
        }
        ,
        HANDSHAKE{

            @Override
            Mono<State> handle(AuthenticationFlow flow) {
                AuthenticationFlow.access$702(flow, flow.initialHandshakePacket.getSeed());
                flow.sequencer = flow.initialHandshakePacket.getSequencer();
                if (flow.initialHandshakePacket.getAuthenticationPluginType().equals("caching_sha2_password")) {
                    AuthenticationPlugin authPlugin = AuthenticationFlowPluginLoader.get("caching_sha2_password");
                    ((CachingSha2PasswordFlow)authPlugin).setStateFastAuth();
                    flow.authMoreDataPacket = null;
                    flow.pluginHandler = authPlugin;
                }
                return flow.client.sendCommand(flow.createHandshakeResponse(flow.clientCapabilities), DecoderState.AUTHENTICATION_SWITCH_RESPONSE, false).handle((message, sink) -> {
                    if (message instanceof ErrorPacket) {
                        sink.error((Throwable)ExceptionFactory.createException((ErrorPacket)message, null));
                    } else if (message instanceof OkPacket) {
                        sink.next((Object)COMPLETED);
                    } else if (message instanceof AuthSwitchPacket) {
                        AuthSwitchPacket authSwitchPacket = (AuthSwitchPacket)message;
                        AuthenticationFlow.access$702(flow, authSwitchPacket.getSeed());
                        flow.sequencer = authSwitchPacket.getSequencer();
                        String plugin = authSwitchPacket.getPlugin();
                        if (flow.configuration.getRestrictedAuth() != null && !Arrays.stream(flow.configuration.getRestrictedAuth()).anyMatch(s -> plugin.equals(s))) {
                            sink.error((Throwable)new R2dbcPermissionDeniedException(String.format("Unsupported authentication plugin %s. Authorized plugin: %s", plugin, Arrays.toString(flow.configuration.getRestrictedAuth()))));
                        } else {
                            AuthenticationPlugin authPlugin = AuthenticationFlowPluginLoader.get(plugin);
                            flow.authMoreDataPacket = null;
                            flow.pluginHandler = authPlugin;
                            sink.next((Object)AUTH_SWITCH);
                        }
                    } else if (flow.pluginHandler != null && message instanceof AuthMoreDataPacket) {
                        flow.authMoreDataPacket = (AuthMoreDataPacket)message;
                        sink.next((Object)AUTH_SWITCH);
                    } else {
                        sink.error((Throwable)new IllegalStateException(String.format("Unexpected message type '%s' in handshake response phase", message.getClass().getSimpleName())));
                    }
                }).next();
            }
        }
        ,
        AUTH_SWITCH{

            @Override
            Mono<State> handle(AuthenticationFlow flow) {
                ClientMessage clientMessage;
                try {
                    clientMessage = flow.pluginHandler.next(flow.configuration, flow.seed, flow.sequencer, flow.authMoreDataPacket);
                }
                catch (R2dbcException ex) {
                    return Mono.error((Throwable)ex);
                }
                Flux<ServerMessage> flux = clientMessage != null ? flow.client.sendCommand(clientMessage, DecoderState.AUTHENTICATION_SWITCH_RESPONSE, false) : flow.client.receive(DecoderState.AUTHENTICATION_SWITCH_RESPONSE);
                if (flow.authMoreDataPacket != null) {
                    flow.authMoreDataPacket.release();
                    flow.authMoreDataPacket = null;
                }
                return flux.handle((message, sink) -> {
                    if (message instanceof ErrorPacket) {
                        sink.error((Throwable)new R2dbcNonTransientResourceException(((ErrorPacket)message).message()));
                    } else if (message instanceof OkPacket) {
                        sink.next((Object)COMPLETED);
                    } else if (message instanceof AuthSwitchPacket) {
                        AuthSwitchPacket authSwitchPacket = (AuthSwitchPacket)message;
                        AuthenticationFlow.access$702(flow, authSwitchPacket.getSeed());
                        flow.sequencer = authSwitchPacket.getSequencer();
                        String plugin = authSwitchPacket.getPlugin();
                        if (flow.configuration.getRestrictedAuth() != null && !Arrays.stream(flow.configuration.getRestrictedAuth()).anyMatch(s -> plugin.equals(s))) {
                            sink.error((Throwable)new R2dbcPermissionDeniedException(String.format("Unsupported authentication plugin %s. Authorized plugin: %s", plugin, Arrays.toString(flow.configuration.getRestrictedAuth()))));
                        } else {
                            AuthenticationPlugin authPlugin = AuthenticationFlowPluginLoader.get(plugin);
                            flow.authMoreDataPacket = null;
                            flow.pluginHandler = authPlugin;
                            sink.next((Object)AUTH_SWITCH);
                        }
                    } else if (message instanceof AuthMoreDataPacket) {
                        flow.authMoreDataPacket = (AuthMoreDataPacket)message;
                        sink.next((Object)AUTH_SWITCH);
                    } else {
                        sink.error((Throwable)new IllegalStateException(String.format("Unexpected message type '%s' in handshake response phase", message.getClass().getSimpleName())));
                    }
                }).next();
            }
        }
        ,
        COMPLETED{

            @Override
            Mono<State> handle(AuthenticationFlow flow) {
                return Mono.just((Object)((Object)COMPLETED));
            }
        };


        abstract Mono<State> handle(AuthenticationFlow var1);
    }
}

