/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbCommonStatement;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.api.MariadbResult;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.client.DecoderState;
import org.mariadb.r2dbc.message.Protocol;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.client.QueryPacket;
import org.mariadb.r2dbc.message.client.QueryWithParametersPacket;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.Binding;
import org.mariadb.r2dbc.util.ClientParser;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

final class MariadbClientParameterizedQueryStatement
extends MariadbCommonStatement {
    private ClientParser parser;

    MariadbClientParameterizedQueryStatement(Client client, String sql, MariadbConnectionConfiguration configuration) {
        super(client, sql, configuration, Protocol.TEXT);
        this.parser = ClientParser.parameterParts(this.initialSql, this.client.noBackslashEscapes());
        this.expectedSize = this.parser.getParamCount();
        this.initializeBinding();
    }

    @Override
    protected int getColumnIndex(String name) {
        Assert.requireNonNull(name, "identifier cannot be null");
        for (int i = 0; i < this.parser.getParamNameList().size(); ++i) {
            if (!name.equals(this.parser.getParamNameList().get(i))) continue;
            return i;
        }
        if (this.parser.getParamCount() <= 0) {
            throw new IndexOutOfBoundsException(String.format("Binding parameters is not supported for the statement '%s'", this.initialSql));
        }
        throw new NoSuchElementException(String.format("No parameter with name '%s' found (possible values %s)", name, this.parser.getParamNameList()));
    }

    @Override
    public Flux<MariadbResult> execute() {
        ExceptionFactory factory;
        String sql;
        if (this.generatedColumns == null || !this.client.getVersion().supportReturning()) {
            sql = this.initialSql;
            factory = this.factory;
        } else {
            sql = MariadbClientParameterizedQueryStatement.augment(this.initialSql, this.generatedColumns);
            factory = ExceptionFactory.withSql(sql);
        }
        if (this.getExpectedSize() != 0) {
            this.getCurrentBinding().validate(this.getExpectedSize());
            return Flux.defer(() -> {
                if (this.bindings.size() == 0) {
                    Binding binding = this.getCurrentBinding();
                    this.initializeBinding();
                    Flux<ServerMessage> messages = this.client.sendCommand(new QueryWithParametersPacket(this.parser, binding.getBindResultParameters(this.getExpectedSize()), this.client.getVersion().supportReturning() ? this.generatedColumns : null), false);
                    return this.toResult(Protocol.TEXT, messages, factory, null);
                }
                this.bindings.add(this.getCurrentBinding());
                this.initializeBinding();
                Iterator iterator = this.bindings.iterator();
                Sinks.Many bindingSink = Sinks.many().unicast().onBackpressureBuffer();
                AtomicBoolean canceled = new AtomicBoolean();
                return bindingSink.asFlux().doOnComplete(() -> this.clearBindings(iterator, canceled)).map(it -> {
                    Flux messages = this.client.sendCommand(new QueryWithParametersPacket(this.parser, it.getBindResultParameters(this.getExpectedSize()), this.client.getVersion().supportReturning() ? this.generatedColumns : null), false).doOnComplete(() -> MariadbClientParameterizedQueryStatement.tryNextBinding(iterator, (Sinks.Many<Binding>)bindingSink, canceled));
                    return this.toResult(Protocol.TEXT, (Flux<ServerMessage>)messages, factory, null);
                }).flatMap(mariadbResultFlux -> mariadbResultFlux).doOnCancel(() -> this.clearBindings(iterator, canceled)).doOnError(e -> this.clearBindings(iterator, canceled)).doOnSubscribe(it -> bindingSink.emitNext((Object)((Binding)iterator.next()), Sinks.EmitFailureHandler.FAIL_FAST));
            });
        }
        return Flux.defer(() -> {
            Flux<ServerMessage> messages = this.client.sendCommand(new QueryPacket(sql), DecoderState.QUERY_RESPONSE, sql, false);
            return this.toResult(Protocol.TEXT, messages, factory, null);
        });
    }

    @Override
    public MariadbClientParameterizedQueryStatement returnGeneratedValues(String ... columns) {
        Assert.requireNonNull(columns, "columns must not be null");
        if (this.parser.supportAddingReturning() == null) {
            this.parser = ClientParser.parameterPartsCheckReturning(this.initialSql, this.client.noBackslashEscapes());
        }
        if (!this.client.getVersion().supportReturning() && columns.length > 1) {
            throw new IllegalArgumentException("returnGeneratedValues can have only one column before MariaDB 10.5.1");
        }
        this.parser.validateAddingReturning();
        this.generatedColumns = columns;
        return this;
    }

    public String toString() {
        ArrayList<Binding> tmpBindings = new ArrayList<Binding>();
        tmpBindings.addAll(this.bindings);
        tmpBindings.add(this.getCurrentBinding());
        return "MariadbClientParameterizedQueryStatement{client=" + this.client + ", sql='" + this.initialSql + '\'' + ", bindings=" + Arrays.toString(tmpBindings.toArray()) + ", configuration=" + this.configuration + ", generatedColumns=" + Arrays.toString(this.generatedColumns) + '}';
    }
}

