/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.HaMode;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.MariadbConnectionFactoryMetadata;
import org.mariadb.r2dbc.api.MariadbConnection;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.client.FailoverClient;
import org.mariadb.r2dbc.client.MariadbResult;
import org.mariadb.r2dbc.client.SimpleClient;
import org.mariadb.r2dbc.message.Protocol;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.client.QueryPacket;
import org.mariadb.r2dbc.message.flow.AuthenticationFlow;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.HostAddress;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.resources.ConnectionProvider;

public final class MariadbConnectionFactory
implements ConnectionFactory {
    private final MariadbConnectionConfiguration configuration;

    public MariadbConnectionFactory(MariadbConnectionConfiguration configuration) {
        this.configuration = Assert.requireNonNull(configuration, "configuration must not be null");
    }

    public static MariadbConnectionFactory from(MariadbConnectionConfiguration configuration) {
        return new MariadbConnectionFactory(configuration);
    }

    public Mono<MariadbConnection> create() {
        ReentrantLock lock = new ReentrantLock();
        return (this.configuration.getSocket() != null ? MariadbConnectionFactory.connectToSocket(this.configuration, (SocketAddress)new DomainSocketAddress(this.configuration.getSocket()), null, lock) : (this.configuration.getHaMode().equals((Object)HaMode.NONE) ? this.configuration.getHaMode().connectHost(this.configuration, lock, false) : this.configuration.getHaMode().connectHost(this.configuration, lock, false).flatMap(c -> Mono.just((Object)new FailoverClient(this.configuration, lock, (Client)c))))).flatMap(client -> Mono.just((Object)new org.mariadb.r2dbc.MariadbConnection((Client)client, this.configuration.getIsolationLevel() == null ? IsolationLevel.REPEATABLE_READ : this.configuration.getIsolationLevel(), this.configuration)).onErrorResume(throwable -> MariadbConnectionFactory.closeWithError(client, throwable))).cast(MariadbConnection.class);
    }

    private static Mono<Client> connectToSocket(MariadbConnectionConfiguration configuration, SocketAddress endpoint, HostAddress hostAddress, ReentrantLock lock) {
        return SimpleClient.connect(ConnectionProvider.newConnection(), endpoint, hostAddress, configuration, lock).delayUntil(client -> AuthenticationFlow.exchange(client, configuration, hostAddress)).cast(Client.class).flatMap(client -> MariadbConnectionFactory.setSessionVariables(configuration, client).thenReturn(client)).onErrorMap(e -> MariadbConnectionFactory.cannotConnect(e, endpoint));
    }

    public static Mono<Void> setSessionVariables(MariadbConnectionConfiguration configuration, Client client) {
        StringBuilder sql = new StringBuilder("SET autocommit=" + (configuration.autocommit() ? "1" : "0"));
        String txIsolation = !client.getVersion().isMariaDBServer() && (client.getVersion().versionGreaterOrEqual(8, 0, 3) || client.getVersion().getMajorVersion() < 8 && client.getVersion().versionGreaterOrEqual(5, 7, 20)) ? "transaction_isolation" : "tx_isolation";
        sql.append(",").append(txIsolation).append("='").append(configuration.getIsolationLevel() == null ? "REPEATABLE-READ" : configuration.getIsolationLevel().asSql().replace(" ", "-")).append("'");
        if ((client.getContext().getClientCapabilities() & 0x800000L) > 0L) {
            sql.append(",session_track_schema=1");
            sql.append(",session_track_system_variables='autocommit,").append(txIsolation).append("'");
        }
        if (configuration.getSessionVariables() != null && configuration.getSessionVariables().size() > 0) {
            Map<String, String> sessionVariable = configuration.getSessionVariables();
            Iterator<String> keys = sessionVariable.keySet().iterator();
            for (int i = 0; i < sessionVariable.size(); ++i) {
                String key = keys.next();
                String value = sessionVariable.get(key);
                if (value == null) {
                    client.close().subscribe();
                    return Mono.error((Throwable)new R2dbcNonTransientResourceException(String.format("Session variable '%s' has no value", key)));
                }
                sql.append(",").append(key).append("=").append(value);
            }
        }
        return client.sendCommand(new QueryPacket(sql.toString()), true).doOnDiscard(ReferenceCounted.class, ReferenceCountUtil::release).windowUntil(it -> it.resultSetEnd()).map(dataRow -> new MariadbResult(Protocol.TEXT, null, (Flux<ServerMessage>)dataRow, ExceptionFactory.INSTANCE, null, false, configuration)).last().then();
    }

    public static Mono<org.mariadb.r2dbc.MariadbConnection> closeWithError(Client client, Throwable throwable) {
        return client.close().then(Mono.error((Throwable)throwable));
    }

    public static Throwable cannotConnect(Throwable throwable, SocketAddress endpoint) {
        if (throwable instanceof R2dbcException) {
            return throwable;
        }
        return new R2dbcNonTransientResourceException(String.format("Cannot connect to %s", endpoint), throwable);
    }

    public ConnectionFactoryMetadata getMetadata() {
        return MariadbConnectionFactoryMetadata.INSTANCE;
    }

    public String toString() {
        return "MariadbConnectionFactory{configuration=" + this.configuration + '}';
    }
}

