/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.api.MariadbRow;
import org.mariadb.r2dbc.client.MariadbRow;
import org.mariadb.r2dbc.client.MariadbRowBinary;
import org.mariadb.r2dbc.client.MariadbRowMetadata;
import org.mariadb.r2dbc.client.MariadbRowText;
import org.mariadb.r2dbc.client.MariadbSegmentResult;
import org.mariadb.r2dbc.message.Protocol;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.server.ColumnCountPacket;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.message.server.CompletePrepareResult;
import org.mariadb.r2dbc.message.server.EofPacket;
import org.mariadb.r2dbc.message.server.ErrorPacket;
import org.mariadb.r2dbc.message.server.OkPacket;
import org.mariadb.r2dbc.message.server.RowPacket;
import org.mariadb.r2dbc.util.ServerPrepareResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MariadbResult
extends AbstractReferenceCounted
implements org.mariadb.r2dbc.api.MariadbResult {
    private final Protocol protocol;
    private final Flux<ServerMessage> messages;
    private final ExceptionFactory factory;
    private final String[] generatedColumns;
    private final boolean supportReturning;
    private final MariadbConnectionConfiguration conf;
    private final AtomicReference<ServerPrepareResult> prepareResult;

    public MariadbResult(Protocol protocol, AtomicReference<ServerPrepareResult> prepareResult, Flux<ServerMessage> messages, ExceptionFactory factory, String[] generatedColumns, boolean supportReturning, MariadbConnectionConfiguration conf) {
        this.protocol = protocol;
        this.messages = messages;
        this.factory = factory;
        this.generatedColumns = generatedColumns;
        this.supportReturning = supportReturning;
        this.conf = conf;
        this.prepareResult = prepareResult;
    }

    @Override
    public Mono<Long> getRowsUpdated() {
        AtomicLong rowCount = new AtomicLong(0L);
        return this.messages.handle((serverMessage, sink) -> {
            if (serverMessage instanceof OkPacket) {
                OkPacket okPacket = (OkPacket)serverMessage;
                sink.next((Object)okPacket.value());
                return;
            }
            if (serverMessage instanceof ErrorPacket) {
                sink.error((Throwable)this.factory.from((ErrorPacket)serverMessage));
                return;
            }
            if (serverMessage instanceof EofPacket) {
                EofPacket eofPacket = (EofPacket)serverMessage;
                if (eofPacket.resultSetEnd()) {
                    sink.next((Object)rowCount.get());
                    rowCount.set(0L);
                }
                return;
            }
            if (serverMessage instanceof RowPacket) {
                rowCount.incrementAndGet();
                serverMessage.release();
            }
        }).collectList().handle((list, sink) -> {
            if (list.isEmpty()) {
                return;
            }
            long sum = 0L;
            for (Long i : list) {
                sum += i.longValue();
            }
            sink.next((Object)sum);
            sink.complete();
        });
    }

    @Override
    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> f) {
        ArrayList columns = new ArrayList();
        AtomicBoolean metaFollows = new AtomicBoolean(true);
        AtomicReference rowConstructor = new AtomicReference();
        AtomicReference meta = new AtomicReference();
        return this.messages.handle((message, sink) -> {
            if (message instanceof ErrorPacket) {
                sink.error((Throwable)this.factory.from((ErrorPacket)message));
                return;
            }
            if (message instanceof CompletePrepareResult) {
                this.prepareResult.set(((CompletePrepareResult)message).getPrepare());
                return;
            }
            if (message instanceof ColumnCountPacket) {
                metaFollows.set(((ColumnCountPacket)message).isMetaFollows());
                if (!metaFollows.get()) {
                    columns.addAll(Arrays.asList(this.prepareResult.get().getColumns()));
                }
                return;
            }
            if (message instanceof OkPacket) {
                OkPacket okPacket = (OkPacket)message;
                if (this.generatedColumns != null && !this.supportReturning) {
                    String colName = this.generatedColumns.length > 0 ? this.generatedColumns[0] : "ID";
                    MariadbRowMetadata tmpMeta = new MariadbRowMetadata(new ColumnDefinitionPacket[]{ColumnDefinitionPacket.fromGeneratedId(colName, this.conf)});
                    if (okPacket.value() > 1L) {
                        sink.error((Throwable)this.factory.createException("Connector cannot get generated ID (using returnGeneratedValues) multiple rows before MariaDB 10.5.1", "HY000", -1));
                        return;
                    }
                    ByteBuf buf = MariadbResult.getLongTextEncoded(okPacket.getLastInsertId());
                    MariadbRowText row = new MariadbRowText(buf, tmpMeta, this.factory);
                    sink.next(f.apply(row, row.getMetadata()));
                    ReferenceCountUtil.release((Object)row);
                }
                return;
            }
            if (message instanceof ColumnDefinitionPacket) {
                columns.add((ColumnDefinitionPacket)message);
                return;
            }
            if (message instanceof EofPacket) {
                EofPacket eof = (EofPacket)message;
                if (!eof.ending()) {
                    rowConstructor.set(this.protocol == Protocol.TEXT ? MariadbRowText::new : MariadbRowBinary::new);
                    ColumnDefinitionPacket[] columnsArray = columns.toArray(new ColumnDefinitionPacket[0]);
                    meta.set(new MariadbRowMetadata(columnsArray));
                    if (this.prepareResult != null && this.prepareResult.get() != null && metaFollows.get()) {
                        this.prepareResult.get().setColumns(columnsArray);
                    }
                }
                return;
            }
            if (message instanceof RowPacket) {
                try {
                    MariadbRow row = ((MariadbRow.MariadbRowConstructor)rowConstructor.get()).create(((RowPacket)message).getRaw(), (MariadbRowMetadata)meta.get(), this.factory);
                    sink.next(f.apply(row, (RowMetadata)meta.get()));
                }
                finally {
                    message.release();
                }
            }
        });
    }

    public static ByteBuf getLongTextEncoded(long value) {
        byte[] byteValue = Long.toString(value).getBytes(StandardCharsets.US_ASCII);
        int length = byteValue.length;
        byte[] encodedLength = new byte[]{(byte)length};
        return Unpooled.copiedBuffer((byte[][])new byte[][]{encodedLength, byteValue});
    }

    public org.mariadb.r2dbc.api.MariadbResult filter(Predicate<Result.Segment> filter) {
        return MariadbSegmentResult.toResult(this.protocol, this.prepareResult, this.messages, this.factory, this.generatedColumns, this.supportReturning, this.conf).filter((Predicate)filter);
    }

    public <T> Publisher<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> mappingFunction) {
        return MariadbSegmentResult.toResult(this.protocol, this.prepareResult, this.messages, this.factory, this.generatedColumns, this.supportReturning, this.conf).flatMap(mappingFunction);
    }

    protected void deallocate() {
        this.getRowsUpdated().subscribe();
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    public String toString() {
        return "MariadbResult{}";
    }
}

