/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.server;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Nullability;
import io.r2dbc.spi.OutParameterMetadata;
import java.nio.charset.StandardCharsets;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.MariadbType;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class ColumnDefinitionPacket
implements ServerMessage,
ColumnMetadata,
OutParameterMetadata {
    private static final Logger logger = Loggers.getLogger(ColumnDefinitionPacket.class);
    private static final int[] maxCharlen = new int[]{0, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 0, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1, 1, 4, 4, 0, 1, 1, 1, 4, 4, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 3, 2, 2, 2, 2, 2, 1, 2, 3, 1, 1, 1, 2, 2, 3, 3, 1, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 4, 4, 0, 0, 0, 0, 0, 0, 0, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final byte[] meta;
    private final int charset;
    private final long length;
    private final DataType dataType;
    private final byte decimals;
    private final int flags;
    private final boolean ending;
    private final MariadbConnectionConfiguration conf;

    private ColumnDefinitionPacket(byte[] meta, int charset, long length, DataType dataType, byte decimals, int flags, boolean ending, MariadbConnectionConfiguration conf) {
        this.meta = meta;
        this.charset = charset;
        this.length = length;
        this.dataType = dataType;
        this.decimals = decimals;
        this.flags = flags;
        this.ending = ending;
        this.conf = conf;
    }

    private ColumnDefinitionPacket(String name, MariadbConnectionConfiguration conf) {
        int i;
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        byte[] arr = new byte[6 + 2 * nameBytes.length];
        int pos = 0;
        for (i = 0; i < 4; ++i) {
            arr[pos++] = 0;
        }
        for (i = 0; i < 2; ++i) {
            arr[pos++] = (byte)nameBytes.length;
            System.arraycopy(nameBytes, 0, arr, pos, nameBytes.length);
            pos += nameBytes.length;
        }
        this.meta = arr;
        this.charset = 33;
        this.length = 8L;
        this.dataType = DataType.BIGINT;
        this.decimals = 0;
        this.flags = 2;
        this.ending = false;
        this.conf = conf;
    }

    public static ColumnDefinitionPacket decode(Sequencer sequencer, ByteBuf buf, Context context, boolean ending, MariadbConnectionConfiguration conf) {
        byte[] meta = new byte[buf.readableBytes() - 12];
        buf.readBytes(meta);
        int charset = buf.readUnsignedShortLE();
        long length = buf.readUnsignedIntLE();
        DataType dataType = DataType.fromServer(buf.readUnsignedByte(), charset);
        int flags = buf.readUnsignedShortLE();
        byte decimals = buf.readByte();
        return new ColumnDefinitionPacket(meta, charset, length, dataType, decimals, flags, ending, conf);
    }

    public static ColumnDefinitionPacket fromGeneratedId(String name, MariadbConnectionConfiguration conf) {
        return new ColumnDefinitionPacket(name, conf);
    }

    private String getString(int idx) {
        int pos = 0;
        for (int i = 0; i < idx; ++i) {
            int len = this.meta[pos++] & 0xFF;
            pos += len;
        }
        int length = this.meta[pos++] & 0xFF;
        return new String(this.meta, pos, length, StandardCharsets.UTF_8);
    }

    public String getSchema() {
        return this.getString(1);
    }

    public String getTableAlias() {
        return this.getString(2);
    }

    public String getTable() {
        return this.getString(3);
    }

    public String getName() {
        return this.getString(4);
    }

    public String getColumn() {
        return this.getString(5);
    }

    public int getCharset() {
        return this.charset;
    }

    public long getLength() {
        return this.length;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public byte getDecimals() {
        return this.decimals;
    }

    public boolean isSigned() {
        return (this.flags & 0x20) == 0;
    }

    public int getDisplaySize() {
        if (this.dataType == DataType.TEXT || this.dataType == DataType.JSON || this.dataType == DataType.ENUM || this.dataType == DataType.SET || this.dataType == DataType.VARSTRING || this.dataType == DataType.STRING) {
            return (int)(this.length / (long)(maxCharlen[this.charset] == 0 ? 1 : maxCharlen[this.charset]));
        }
        return (int)this.length;
    }

    public Nullability getNullability() {
        return (this.flags & 1) > 0 ? Nullability.NON_NULL : Nullability.NULLABLE;
    }

    public boolean isPrimaryKey() {
        return (this.flags & 2) > 0;
    }

    public boolean isUniqueKey() {
        return (this.flags & 4) > 0;
    }

    public boolean isMultipleKey() {
        return (this.flags & 8) > 0;
    }

    public boolean isBlob() {
        return (this.flags & 0x10) > 0;
    }

    public boolean isZeroFill() {
        return (this.flags & 0x40) > 0;
    }

    public boolean isBinary() {
        return this.charset == 63;
    }

    public MariadbType getType() {
        switch (this.dataType) {
            case TINYINT: {
                if (this.length == 1L && this.conf.tinyInt1isBit()) {
                    return MariadbType.BOOLEAN;
                }
                return this.isSigned() ? MariadbType.TINYINT : MariadbType.UNSIGNED_TINYINT;
            }
            case YEAR: {
                return MariadbType.SMALLINT;
            }
            case SMALLINT: {
                return this.isSigned() ? MariadbType.SMALLINT : MariadbType.UNSIGNED_SMALLINT;
            }
            case INTEGER: {
                return this.isSigned() ? MariadbType.INTEGER : MariadbType.UNSIGNED_INTEGER;
            }
            case FLOAT: {
                return MariadbType.FLOAT;
            }
            case DOUBLE: {
                return MariadbType.DOUBLE;
            }
            case TIMESTAMP: 
            case DATETIME: {
                return MariadbType.TIMESTAMP;
            }
            case BIGINT: {
                return this.isSigned() ? MariadbType.BIGINT : MariadbType.UNSIGNED_BIGINT;
            }
            case MEDIUMINT: {
                return MariadbType.INTEGER;
            }
            case DATE: 
            case NEWDATE: {
                return MariadbType.DATE;
            }
            case TIME: {
                return MariadbType.TIME;
            }
            case JSON: 
            case ENUM: 
            case SET: 
            case STRING: 
            case VARSTRING: 
            case NULL: {
                return this.isBinary() ? MariadbType.BYTES : MariadbType.VARCHAR;
            }
            case TEXT: {
                return MariadbType.CLOB;
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return MariadbType.DECIMAL;
            }
            case BIT: {
                if (this.length == 1L && this.conf.tinyInt1isBit()) {
                    return MariadbType.BOOLEAN;
                }
                return MariadbType.BIT;
            }
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case BLOB: 
            case GEOMETRY: {
                return MariadbType.BLOB;
            }
        }
        return null;
    }

    public Integer getPrecision() {
        switch (this.dataType) {
            case OLDDECIMAL: 
            case DECIMAL: {
                if (this.isSigned()) {
                    return (int)(this.length - (long)(this.getDecimals() > 0 ? 2 : 1));
                }
                return (int)(this.length - (long)(this.decimals > 0 ? 1 : 0));
            }
        }
        return (int)this.length;
    }

    public Integer getScale() {
        switch (this.dataType) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case BIGINT: 
            case MEDIUMINT: 
            case OLDDECIMAL: 
            case DECIMAL: 
            case BIT: {
                return this.decimals;
            }
        }
        return 0;
    }

    public Class<?> getJavaType() {
        return this.getType().getJavaType();
    }

    public ColumnDefinitionPacket getNativeTypeMetadata() {
        return this;
    }

    @Override
    public boolean ending() {
        return this.ending;
    }
}

