/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class HostAddress {
    String host;
    int port;

    public HostAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static List<HostAddress> parse(String hosts, int defaultPort) {
        if (hosts != null) {
            String[] tmpHosts;
            ArrayList<HostAddress> hostAddresses = new ArrayList<HostAddress>();
            for (String tmpHost : tmpHosts = hosts.split(",")) {
                if (tmpHost.contains(":")) {
                    hostAddresses.add(new HostAddress(tmpHost.substring(0, tmpHost.indexOf(":")), Integer.parseInt(tmpHost.substring(tmpHost.indexOf(":") + 1))));
                    continue;
                }
                hostAddresses.add(new HostAddress(tmpHost, defaultPort));
            }
            return hostAddresses;
        }
        return Collections.singletonList(new HostAddress("localhost", defaultPort));
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostAddress)) {
            return false;
        }
        HostAddress that = (HostAddress)o;
        return this.port == that.port && this.host.equals(that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return this.host + ':' + this.port;
    }
}

