/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.r2dbc.spi.R2dbcTransientResourceException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLException;
import org.mariadb.r2dbc.SslMode;

public class SslConfig {
    public static final SslConfig DISABLE_INSTANCE = new SslConfig(SslMode.DISABLE);
    private final SslMode sslMode;
    private String serverSslCert;
    private String clientSslCert;
    private String clientSslKey;
    private CharSequence clientSslPassword;
    private List<String> tlsProtocol;
    private SslContextBuilder sslContextBuilder;
    private UnaryOperator<SslContextBuilder> sslContextBuilderCustomizer;
    private boolean disableHostVerification;

    public SslConfig(SslMode sslMode, String serverSslCert, String clientSslCert, String clientSslKey, CharSequence clientSslPassword, List<String> tlsProtocol, boolean disableHostVerification, UnaryOperator<SslContextBuilder> sslContextBuilderCustomizer) throws R2dbcTransientResourceException {
        this.sslMode = sslMode;
        this.serverSslCert = serverSslCert;
        this.clientSslCert = clientSslCert;
        this.tlsProtocol = tlsProtocol;
        this.clientSslKey = clientSslKey;
        this.clientSslPassword = clientSslPassword;
        this.disableHostVerification = disableHostVerification;
        this.sslContextBuilderCustomizer = sslContextBuilderCustomizer;
        if (sslMode != SslMode.DISABLE) {
            this.sslContextBuilder = this.getSslContextBuilder();
        }
    }

    public SslConfig(SslMode sslMode) {
        this.sslMode = sslMode;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public boolean tunnelHostVerificationDisabled() {
        return this.disableHostVerification;
    }

    private SslContextBuilder getSslContextBuilder() throws R2dbcTransientResourceException {
        SslContextBuilder sslCtxBuilder = SslContextBuilder.forClient();
        if (this.sslMode == SslMode.TRUST || this.sslMode == SslMode.TUNNEL) {
            sslCtxBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else {
            if (this.serverSslCert != null) {
                InputStream inStream = null;
                try {
                    inStream = this.loadCert(this.serverSslCert);
                    sslCtxBuilder.trustManager(inStream);
                }
                catch (FileNotFoundException fileNotFoundEx) {
                    throw new R2dbcTransientResourceException("Failed to find serverSslCert file. serverSslCert=" + this.serverSslCert, "08000", (Throwable)fileNotFoundEx);
                }
                finally {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            throw new R2dbcTransientResourceException("Server certificate needed (option `serverSslCert`) for ssl mode " + (Object)((Object)this.sslMode), "08000");
        }
        if (this.clientSslCert != null && this.clientSslKey != null) {
            InputStream certificatesStream = null;
            try {
                certificatesStream = this.loadCert(this.clientSslCert);
            }
            catch (FileNotFoundException fileNotFoundEx) {
                if (certificatesStream != null) {
                    try {
                        certificatesStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new R2dbcTransientResourceException("Failed to find clientSslCert file. clientSslCert=" + this.clientSslCert, "08000", (Throwable)fileNotFoundEx);
            }
            InputStream privateKeyStream = null;
            try {
                privateKeyStream = this.loadCert(this.clientSslKey);
                sslCtxBuilder.keyManager(certificatesStream, privateKeyStream, this.clientSslPassword == null ? null : this.clientSslPassword.toString());
            }
            catch (FileNotFoundException fileNotFoundEx) {
                throw new R2dbcTransientResourceException("Failed to find clientSslKey file. clientSslKey=" + this.clientSslKey, "08000", (Throwable)fileNotFoundEx);
            }
            finally {
                if (privateKeyStream != null) {
                    try {
                        privateKeyStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (this.tlsProtocol != null) {
            sslCtxBuilder.protocols(this.tlsProtocol.toArray(new String[this.tlsProtocol.size()]));
        }
        if (this.sslContextBuilderCustomizer == null) {
            return sslCtxBuilder;
        }
        return (SslContextBuilder)this.sslContextBuilderCustomizer.apply(sslCtxBuilder);
    }

    public SslContext getSslContext() throws R2dbcTransientResourceException, SSLException {
        return this.sslContextBuilder.build();
    }

    private InputStream loadCert(String path) throws FileNotFoundException {
        InputStream inStream;
        if (path.startsWith("-----BEGIN CERTIFICATE-----")) {
            inStream = new ByteArrayInputStream(path.getBytes());
        } else if (path.startsWith("classpath:")) {
            String classpathFile = path.substring("classpath:".length());
            inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFile);
        } else {
            inStream = new FileInputStream(path);
        }
        return inStream;
    }

    public String toString() {
        return "SslConfig{sslMode=" + (Object)((Object)this.sslMode) + ", serverSslCert=" + this.serverSslCert + ", clientSslCert=" + this.clientSslCert + ", tlsProtocol=" + this.tlsProtocol + ", clientSslKey=" + this.clientSslKey + '}';
    }
}

