/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.MariadbConnectionFactory;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.client.SimpleClient;
import org.mariadb.r2dbc.message.flow.AuthenticationFlow;
import org.mariadb.r2dbc.util.HostAddress;
import reactor.core.publisher.Mono;
import reactor.netty.resources.ConnectionProvider;

public enum HaMode {
    SEQUENTIAL(new String[]{"sequential"}){

        @Override
        public List<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList) {
            return HaMode.getAvailableHostInOrder(hostAddresses, denyList);
        }

        @Override
        public Mono<Client> connectHost(MariadbConnectionConfiguration conf, ReentrantLock lock, boolean failFast) {
            long endingNanoTime = CONNECTION_LOOP_DURATION.getSeconds() * 1000000000L + System.nanoTime();
            return 1.connectHost(conf, lock, failFast, this::getAvailableHost, endingNanoTime);
        }
    }
    ,
    LOADBALANCE(new String[]{"load-balance", "loadbalance", "loadbalancing"}){

        @Override
        public List<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList) {
            ArrayList<HostAddress> loopAddress = new ArrayList<HostAddress>(HaMode.getAvailableHostInOrder(hostAddresses, denyList));
            Collections.shuffle(loopAddress);
            return loopAddress;
        }

        @Override
        public Mono<Client> connectHost(MariadbConnectionConfiguration conf, ReentrantLock lock, boolean failFast) {
            long endingNanoTime = CONNECTION_LOOP_DURATION.getSeconds() * 1000000000L + System.nanoTime();
            return 2.connectHost(conf, lock, failFast, this::getAvailableHost, endingNanoTime);
        }
    }
    ,
    NONE(new String[0]){

        @Override
        public List<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList) {
            return hostAddresses;
        }

        @Override
        public Mono<Client> connectHost(MariadbConnectionConfiguration conf, ReentrantLock lock, boolean failFast) {
            return 3.connectHost(conf, lock, true, this::getAvailableHost, 0L);
        }
    };

    private static final ConcurrentMap<HostAddress, Long> denyList;
    private static final long DENIED_LIST_TIMEOUT;
    private static final Duration CONNECTION_LOOP_DURATION;
    private final String[] aliases;

    private HaMode(String[] value) {
        this.aliases = value;
    }

    public static HaMode from(String value) {
        for (HaMode haMode : HaMode.values()) {
            if (haMode.name().equalsIgnoreCase(value)) {
                return haMode;
            }
            for (String alias : haMode.aliases) {
                if (!alias.equalsIgnoreCase(value)) continue;
                return haMode;
            }
        }
        throw new IllegalArgumentException(String.format("Wrong argument value '%s' for HaMode", value));
    }

    private static Mono<Client> connect(MariadbConnectionConfiguration conf, ReentrantLock lock, HostAddress hostAddress) {
        return SimpleClient.connect(ConnectionProvider.newConnection(), InetSocketAddress.createUnresolved(hostAddress.getHost(), hostAddress.getPort()), hostAddress, conf, lock).delayUntil(client -> AuthenticationFlow.exchange(client, conf, hostAddress)).doOnError(e -> HaMode.failHost(hostAddress)).cast(Client.class).flatMap(client -> MariadbConnectionFactory.setSessionVariables(conf, client).then(Mono.just((Object)client)));
    }

    private static List<HostAddress> getAvailableHostInOrder(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList) {
        ArrayList<HostAddress> copiedList = new ArrayList<HostAddress>(hostAddresses);
        denyList.entrySet().stream().filter(e -> (Long)e.getValue() < System.nanoTime()).forEach(e -> denyList.remove(e.getKey()));
        copiedList.removeAll(denyList.keySet());
        return copiedList;
    }

    public static Mono<Client> resumeConnect(Throwable t, MariadbConnectionConfiguration conf, ReentrantLock lock, boolean failFast, List<HostAddress> availableHosts, BiFunction<List<HostAddress>, ConcurrentMap<HostAddress, Long>, List<HostAddress>> availHost, Iterator<HostAddress> iterator, long endingNanoTime) {
        if (!iterator.hasNext()) {
            if (failFast || System.nanoTime() > endingNanoTime) {
                return Mono.error((Throwable)ExceptionFactory.INSTANCE.createParsingException(String.format("Fail to establish connection to %s %s: %s", availableHosts, failFast || endingNanoTime == 0L ? "" : ", reaching timeout", t.getMessage()), t));
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return HaMode.connectHost(conf, lock, failFast, availHost, endingNanoTime);
        }
        return HaMode.connect(conf, lock, iterator.next()).onErrorResume(tt -> HaMode.resumeConnect(tt, conf, lock, failFast, availableHosts, availHost, iterator, endingNanoTime));
    }

    public static Mono<Client> connectHost(MariadbConnectionConfiguration conf, ReentrantLock lock, boolean failFast, BiFunction<List<HostAddress>, ConcurrentMap<HostAddress, Long>, List<HostAddress>> availHost, long endingNanoTime) {
        List<HostAddress> availableHosts;
        List<HostAddress> nonBlacklistHosts = availHost.apply(conf.getHostAddresses(), denyList);
        if (!failFast) {
            nonBlacklistHosts.addAll(denyList.keySet());
            availableHosts = nonBlacklistHosts.stream().filter(h -> conf.getHostAddresses().contains(h)).collect(Collectors.toList());
        } else {
            availableHosts = nonBlacklistHosts;
        }
        Iterator<HostAddress> iterator = availableHosts.iterator();
        if (!iterator.hasNext()) {
            return Mono.error((Throwable)ExceptionFactory.INSTANCE.createParsingException("Fail to establish connection: no available host"));
        }
        return HaMode.connect(conf, lock, iterator.next()).onErrorResume(t -> HaMode.resumeConnect(t, conf, lock, failFast, availableHosts, availHost, iterator, endingNanoTime));
    }

    public static void failHost(HostAddress hostAddress) {
        denyList.put(hostAddress, System.nanoTime() + DENIED_LIST_TIMEOUT);
    }

    public abstract List<HostAddress> getAvailableHost(List<HostAddress> var1, ConcurrentMap<HostAddress, Long> var2);

    public abstract Mono<Client> connectHost(MariadbConnectionConfiguration var1, ReentrantLock var2, boolean var3);

    static {
        denyList = new ConcurrentHashMap<HostAddress, Long>();
        DENIED_LIST_TIMEOUT = Long.parseLong(System.getProperty("deniedListTimeout", "60000000000"));
        CONNECTION_LOOP_DURATION = Duration.parse(System.getProperty("connectionLoopDuration", "PT10S"));
    }
}

