/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.api.MariadbResult;
import org.mariadb.r2dbc.api.MariadbStatement;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.codec.Codecs;
import org.mariadb.r2dbc.message.Protocol;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.Binding;
import org.mariadb.r2dbc.util.ServerPrepareResult;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public abstract class MariadbCommonStatement
implements MariadbStatement {
    public static final int UNKNOWN_SIZE = -1;
    protected final List<Binding> bindings = new ArrayList<Binding>();
    protected final Client client;
    protected final String initialSql;
    protected final MariadbConnectionConfiguration configuration;
    private final Protocol defaultProtocol;
    protected int expectedSize;
    protected ExceptionFactory factory;
    protected String[] generatedColumns;
    private Binding currentBinding;

    public MariadbCommonStatement(Client client, String sql, MariadbConnectionConfiguration configuration, Protocol defaultProtocol) {
        this.defaultProtocol = defaultProtocol;
        this.client = client;
        this.configuration = configuration;
        this.initialSql = Assert.requireNonNull(sql, "sql must not be null");
        this.factory = ExceptionFactory.withSql(sql);
    }

    public static String augment(String sql, String[] generatedColumns) {
        Assert.requireNonNull(sql, "sql must not be null");
        Assert.requireNonNull(generatedColumns, "generatedColumns must not be null");
        return String.format("%s RETURNING %s", sql, generatedColumns.length == 0 ? "*" : String.join((CharSequence)", ", generatedColumns));
    }

    protected static void tryNextBinding(Iterator<Binding> iterator, Sinks.Many<Binding> bindingSink, AtomicBoolean canceled) {
        if (canceled.get()) {
            return;
        }
        try {
            if (iterator.hasNext()) {
                bindingSink.emitNext((Object)iterator.next(), Sinks.EmitFailureHandler.FAIL_FAST);
            } else {
                bindingSink.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST);
            }
        }
        catch (Exception e) {
            bindingSink.emitError((Throwable)e, Sinks.EmitFailureHandler.FAIL_FAST);
        }
    }

    protected void initializeBinding() {
        this.currentBinding = new Binding(this.getExpectedSize());
    }

    @Override
    public MariadbStatement add() {
        this.currentBinding.validate(this.getExpectedSize());
        this.bindings.add(this.currentBinding);
        this.currentBinding = new Binding(this.getExpectedSize());
        return this;
    }

    @Override
    public MariadbStatement bind(String identifier, Object value) {
        return this.bind(this.getColumnIndex(identifier), value);
    }

    @Override
    public MariadbStatement bindNull(String identifier, Class<?> type) {
        return this.bindNull(this.getColumnIndex(identifier), (Class)type);
    }

    @Override
    public MariadbStatement bindNull(int index, Class<?> type) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.format("wrong index value %d, index must be positive", index));
        }
        if (index >= this.expectedSize && this.expectedSize != -1) {
            throw new IndexOutOfBoundsException(this.getExpectedSize() == 0 ? String.format("Binding parameters is not supported for the statement '%s'", this.initialSql) : String.format("Cannot bind parameter %d, statement has %d parameters", index, this.expectedSize));
        }
        this.getCurrentBinding().add(index, Codecs.encodeNull(type, index));
        return this;
    }

    @Override
    public MariadbStatement bind(int index, Object value) {
        Assert.requireNonNull(value, "value must not be null");
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.format("wrong index value %d, index must be positive", index));
        }
        this.getCurrentBinding().add(index, Codecs.encode(value, index));
        return this;
    }

    protected abstract int getColumnIndex(String var1);

    @Nonnull
    protected Binding getCurrentBinding() {
        return this.currentBinding;
    }

    public Flux<MariadbResult> toResult(Protocol protocol, Flux<ServerMessage> messages, ExceptionFactory factory, AtomicReference<ServerPrepareResult> prepareResult) {
        return messages.doOnDiscard(ReferenceCounted.class, ReferenceCountUtil::release).windowUntil(ServerMessage::resultSetEnd).map(dataRow -> new org.mariadb.r2dbc.client.MariadbResult(protocol, prepareResult, (Flux<ServerMessage>)dataRow, factory, this.generatedColumns, this.client.getVersion().supportReturning(), this.configuration)).flatMap(m -> this.client.redirect().then(Mono.just((Object)m))).cast(MariadbResult.class);
    }

    protected void clearBindings(Iterator<Binding> iterator, AtomicBoolean canceled) {
        canceled.set(true);
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
        this.bindings.forEach(Binding::clear);
    }

    protected int getExpectedSize() {
        return this.expectedSize;
    }
}

