/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import java.util.ArrayList;
import java.util.List;
import org.mariadb.r2dbc.util.PrepareResult;

public class ServerNamedParamParser
implements PrepareResult {
    private final String realSql;
    private final List<String> paramNameList;
    private final int paramCount;

    private ServerNamedParamParser(String realSql, List<String> paramNameList) {
        this.realSql = realSql;
        this.paramNameList = paramNameList;
        this.paramCount = paramNameList.size();
    }

    public static ServerNamedParamParser parameterParts(String queryString, boolean noBackslashEscapes) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> paramNameList = new ArrayList<String>();
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        boolean endingSemicolon = false;
        boolean singleQuotes = false;
        int lastParameterPosition = 0;
        char[] query = queryString.toCharArray();
        int queryLength = query.length;
        for (int i = 0; i < queryLength; ++i) {
            char car = query[i];
            if (state == LexState.Escape) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state == LexState.SlashStarComment && lastChar == '*') {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != '-') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '\n': {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != LexState.String || singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != LexState.String || !singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case ';': {
                    if (state != LexState.Normal) break;
                    endingSemicolon = true;
                    break;
                }
                case '?': {
                    if (state != LexState.Normal) break;
                    sb.append(queryString, lastParameterPosition, i).append("?");
                    lastParameterPosition = i + 1;
                    paramNameList.add(null);
                    break;
                }
                case ':': {
                    if (state != LexState.Normal) break;
                    sb.append(queryString, lastParameterPosition, i).append("?");
                    String placeholderName = "";
                    while (++i < queryLength && (car = query[i]) != ' ' && (car >= '0' && car <= '9' || car >= 'A' && car <= 'Z' || car >= 'a' && car <= 'z' || car == '-' || car == '_')) {
                        placeholderName = placeholderName + car;
                    }
                    lastParameterPosition = i;
                    paramNameList.add(placeholderName);
                    break;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                    break;
                }
                default: {
                    if (state != LexState.Normal || !endingSemicolon || (byte)car < 40) break;
                    endingSemicolon = false;
                }
            }
            lastChar = car;
        }
        if (lastParameterPosition == 0) {
            sb.append(queryString);
        } else {
            sb.append(queryString, lastParameterPosition, queryLength);
        }
        return new ServerNamedParamParser(sb.toString(), paramNameList);
    }

    public String getRealSql() {
        return this.realSql;
    }

    public List<String> getParamNameList() {
        return this.paramNameList;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        EOLComment,
        Backtick;

    }
}

