/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.Context;
import reactor.core.publisher.Mono;

public class MariadbPacketEncoder {
    private Context context = null;

    public Mono<CompositeByteBuf> encodeFlux(ClientMessage msg) {
        ByteBufAllocator allocator = this.context.getByteBufAllocator();
        return msg.encode(this.context, allocator).map(buf -> {
            ByteBuf header;
            int packetLength;
            CompositeByteBuf out = allocator.compositeBuffer();
            int initialReaderIndex = buf.readerIndex();
            do {
                packetLength = Math.min(0xFFFFFF, buf.readableBytes());
                header = Unpooled.buffer((int)4, (int)4);
                header.writeMediumLE(packetLength);
                header.writeByte((int)msg.getSequencer().next());
                out.addComponent(true, header);
                out.addComponent(true, buf.readRetainedSlice(packetLength));
            } while (buf.readableBytes() > 0);
            if (packetLength == 0xFFFFFF) {
                header = Unpooled.buffer((int)4, (int)4);
                header.writeMediumLE(0);
                header.writeByte((int)msg.getSequencer().next());
                out.addComponent(true, header);
            }
            this.context.saveRedo(msg, (ByteBuf)buf, initialReaderIndex);
            buf.release();
            return out;
        });
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

