/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.TokenModification;
import org.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;
import org.mariuszgromada.math.mxparser.mathcollection.PrimesCache;
import org.mariuszgromada.math.mxparser.mathcollection.ProbabilityDistributions;
import org.mariuszgromada.math.mxparser.parsertokens.KeyWord;
import org.mariuszgromada.math.mxparser.parsertokens.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class mXparser {
    static final String VERSION = "4.1.1";
    static final int NOT_FOUND = -1;
    static final int FOUND = 0;
    private static String CONSOLE_OUTPUT = "";
    private static String CONSOLE_PREFIX;
    private static String CONSOLE_OUTPUT_PREFIX;
    private static int CONSOLE_ROW_NUMBER;
    public static PrimesCache primesCache;
    public static final int PRIMES_CACHE_NOT_INITIALIZED = -1;
    private static int THREADS_NUMBER;
    static final Expression mXparserExp;
    static boolean ulpRounding;
    static int MAX_RECURSION_CALLS;
    static final List<String> tokensToRemove;
    static final List<TokenModification> tokensToModify;
    static boolean overrideBuiltinTokens;
    static int optionsChangesetNumber;
    public static final String LICENSE = "                      mXparser - version 4.1.1\n         A flexible mathematical eXpressions parser for JAVA.\n\nYou may use this software under the condition of Simplified BSD License:\n\nCopyright 2010-2017 MARIUSZ GROMADA. All rights reserved.\n\nRedistribution and use in source and binary forms, with or without modification, are\npermitted provided that the following conditions are met:\n\n   1. Redistributions of source code must retain the above copyright notice, this list of\n      conditions and the following disclaimer.\n\n   2. Redistributions in binary form must reproduce the above copyright notice, this list\n      of conditions and the following disclaimer in the documentation and/or other materials\n      provided with the distribution.\n\nTHIS SOFTWARE IS PROVIDED BY MARIUSZ GROMADA ``AS IS'' AND ANY EXPRESS OR IMPLIED\nWARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND\nFITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MARIUSZ GROMADA OR\nCONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\nCONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR\nSERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON\nANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\nNEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF\nADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\nThe views and conclusions contained in the software and documentation are those of the\nauthors and should not be interpreted as representing official policies, either expressed\nor implied, of MARIUSZ GROMADA.\n\nIf you have any questions/bugs feel free to contact:\n\n    Mariusz Gromada\n    mariuszgromada.org@gmail.com\n    http://mathspace.plt/\n    http://mathparser.org/\n    http://github.com/mariuszgromada/MathParser.org-mXparser\n    http://mariuszgromada.github.io/MathParser.org-mXparser/\n    http://mxparser.sourceforge.net/\n    http://bitbucket.org/mariuszgromada/mxparser/\n    http://mxparser.codeplex.com/\n    http://janetsudoku.mariuszgromada.org/\n";
    public static final String NAMEv10 = "1.0";
    public static final String NAMEv20 = "2.0";
    public static final String NAMEv23 = "2.3";
    public static final String NAMEv24 = "2.4";
    public static final String NAMEv30 = "3.0";
    public static final String NAMEv40 = "4.0";
    public static final String NAMEv41 = "4.1";

    public static final void initPrimesCache() {
        primesCache = new PrimesCache();
    }

    public static final void initPrimesCache(int mximumNumberInCache) {
        primesCache = new PrimesCache(mximumNumberInCache);
    }

    public static final void initPrimesCache(PrimesCache primesCache) {
        mXparser.primesCache = primesCache;
    }

    public static void setNoPrimesCache() {
        primesCache = null;
    }

    public static final int getMaxNumInPrimesCache() {
        if (primesCache != null) {
            return primesCache.getMaxNumInCache();
        }
        return -1;
    }

    public static final int getThreadsNumber() {
        return THREADS_NUMBER;
    }

    public static final void setDefaultThreadsNumber() {
        THREADS_NUMBER = Runtime.getRuntime().availableProcessors();
    }

    public static final void setThreadsNumber(int threadsNumber) {
        if (threadsNumber > 0) {
            THREADS_NUMBER = threadsNumber;
        }
    }

    public static final double getFunctionValue(Expression f, Argument x, double x0) {
        x.setArgumentValue(x0);
        return f.calculate();
    }

    public static final double[] arrayList2double(List<Double> numbers) {
        if (numbers == null) {
            return null;
        }
        int size = numbers.size();
        double[] newNumbers = new double[size];
        for (int i = 0; i < size; ++i) {
            newNumbers[i] = numbers.get(i);
        }
        return newNumbers;
    }

    public static final double[] getFunctionValues(Expression f, Argument index, double from, double to, double delta) {
        double[] values;
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return null;
        }
        int n = 0;
        if (to >= from && delta > 0.0) {
            for (double i = from; i < to; i += delta) {
                ++n;
            }
            values = new double[++n];
            int j = 0;
            for (double i = from; i < to; i += delta) {
                values[j] = mXparser.getFunctionValue(f, index, i);
                ++j;
            }
            values[j] = mXparser.getFunctionValue(f, index, to);
        } else if (to <= from && delta < 0.0) {
            for (double i = from; i > to; i += delta) {
                ++n;
            }
            values = new double[++n];
            int j = 0;
            for (double i = from; i > to; i += delta) {
                values[j] = mXparser.getFunctionValue(f, index, i);
                ++j;
            }
            values[j] = mXparser.getFunctionValue(f, index, to);
        } else if (from == to) {
            n = 1;
            values = new double[n];
            values[0] = mXparser.getFunctionValue(f, index, from);
        } else {
            values = null;
        }
        return values;
    }

    public static final void setRandomGenerator(Random randomGenerator) {
        if (randomGenerator != null) {
            ProbabilityDistributions.randomGenerator = randomGenerator;
        }
    }

    public static final void setExactComparison() {
        BinaryRelations.setExactComparison();
    }

    public static final void setEpsilonComparison() {
        BinaryRelations.setEpsilonComparison();
    }

    public static final void setEpsilon(double epsilon) {
        BinaryRelations.setEpsilon(epsilon);
    }

    public static final void setDefaultEpsilon() {
        BinaryRelations.setDefaultEpsilon();
    }

    public static final double getEpsilon() {
        return BinaryRelations.getEpsilon();
    }

    public static final boolean checkIfEpsilonMode() {
        return BinaryRelations.checkIfEpsilonMode();
    }

    public static final boolean checkIfExactMode() {
        return BinaryRelations.checkIfExactMode();
    }

    public static final void enableUlpRounding() {
        ulpRounding = true;
    }

    public static final void disableUlpRounding() {
        ulpRounding = false;
    }

    public static final boolean checkIfUlpRounding() {
        return ulpRounding;
    }

    public static final void setMaxAllowedRecursionDepth(int maxAllowedRecursionDepth) {
        MAX_RECURSION_CALLS = maxAllowedRecursionDepth;
    }

    public static final int getMaxAllowedRecursionDepth() {
        return MAX_RECURSION_CALLS;
    }

    public static final void removeBuiltinTokens(String ... tokens) {
        if (tokens == null) {
            return;
        }
        for (String token : tokens) {
            if (token == null || token.length() <= 0 || tokensToRemove.contains(token)) continue;
            tokensToRemove.add(token);
        }
        ++optionsChangesetNumber;
    }

    public static final void unremoveBuiltinTokens(String ... tokens) {
        if (tokens == null) {
            return;
        }
        if (tokens.length == 0) {
            return;
        }
        if (tokensToRemove.size() == 0) {
            return;
        }
        for (String token : tokens) {
            if (token == null) continue;
            tokensToRemove.remove(token);
        }
        ++optionsChangesetNumber;
    }

    public static final void unremoveAllBuiltinTokens() {
        tokensToRemove.clear();
        ++optionsChangesetNumber;
    }

    public static final String[] getBuiltinTokensToRemove() {
        int tokensNum = tokensToRemove.size();
        String[] tokensToRemoveArray = new String[tokensNum];
        for (int i = 0; i < tokensNum; ++i) {
            tokensToRemoveArray[i] = tokensToRemove.get(i);
        }
        return tokensToRemoveArray;
    }

    public static final void modifyBuiltinToken(String currentToken, String newToken) {
        if (currentToken == null) {
            return;
        }
        if (currentToken.length() == 0) {
            return;
        }
        if (newToken == null) {
            return;
        }
        if (newToken.length() == 0) {
            return;
        }
        for (TokenModification tm : tokensToModify) {
            if (!tm.currentToken.equals(currentToken)) continue;
            return;
        }
        TokenModification tma = new TokenModification();
        tma.currentToken = currentToken;
        tma.newToken = newToken;
        tma.newTokenDescription = null;
        tokensToModify.add(tma);
        ++optionsChangesetNumber;
    }

    public static final void modifyBuiltinToken(String currentToken, String newToken, String newTokenDescription) {
        if (currentToken == null) {
            return;
        }
        if (currentToken.length() == 0) {
            return;
        }
        if (newToken == null) {
            return;
        }
        if (newToken.length() == 0) {
            return;
        }
        for (TokenModification tm : tokensToModify) {
            if (!tm.currentToken.equals(currentToken)) continue;
            return;
        }
        TokenModification tma = new TokenModification();
        tma.currentToken = currentToken;
        tma.newToken = newToken;
        tma.newTokenDescription = newTokenDescription;
        tokensToModify.add(tma);
        ++optionsChangesetNumber;
    }

    public static final void unmodifyBuiltinTokens(String ... currentOrNewTokens) {
        if (currentOrNewTokens == null) {
            return;
        }
        if (currentOrNewTokens.length == 0) {
            return;
        }
        if (tokensToModify.size() == 0) {
            return;
        }
        ArrayList<TokenModification> toRemove = new ArrayList<TokenModification>();
        for (String token : currentOrNewTokens) {
            if (token == null || token.length() <= 0) continue;
            for (TokenModification tm : tokensToModify) {
                if (!token.equals(tm.currentToken) && !token.equals(tm.newToken)) continue;
                toRemove.add(tm);
            }
        }
        for (TokenModification tm : toRemove) {
            tokensToModify.remove(tm);
        }
        ++optionsChangesetNumber;
    }

    public static final void unmodifyAllBuiltinTokens() {
        tokensToModify.clear();
        ++optionsChangesetNumber;
    }

    public static final String[][] getBuiltinTokensToModify() {
        int tokensNum = tokensToModify.size();
        String[][] tokensToModifyArray = new String[tokensNum][3];
        for (int i = 0; i < tokensNum; ++i) {
            TokenModification tm = tokensToModify.get(i);
            tokensToModifyArray[i][0] = tm.currentToken;
            tokensToModifyArray[i][1] = tm.newToken;
            tokensToModifyArray[i][2] = tm.newTokenDescription;
        }
        return tokensToModifyArray;
    }

    public static final void setToOverrideBuiltinTokens() {
        overrideBuiltinTokens = true;
        ++optionsChangesetNumber;
    }

    public static final void setNotToOverrideBuiltinTokens() {
        overrideBuiltinTokens = false;
        ++optionsChangesetNumber;
    }

    public static final boolean checkIfsetToOverrideBuiltinTokens() {
        return overrideBuiltinTokens;
    }

    public static final String getTokenTypeDescription(int tokenTypeId) {
        String type = "";
        switch (tokenTypeId) {
            case 20: {
                type = "Parser Symbol";
                break;
            }
            case 0: {
                type = "number";
                break;
            }
            case 1: {
                type = "Operator";
                break;
            }
            case 2: {
                type = "Boolean Operator";
                break;
            }
            case 3: {
                type = "Binary Relation";
                break;
            }
            case 4: {
                type = "Unary Function";
                break;
            }
            case 5: {
                type = "Binary Function";
                break;
            }
            case 6: {
                type = "3-args Function";
                break;
            }
            case 7: {
                type = "Variadic Function";
                break;
            }
            case 8: {
                type = "Calculus Operator";
                break;
            }
            case 10: {
                type = "Random Variable";
                break;
            }
            case 9: {
                type = "Constant Value";
                break;
            }
            case 101: {
                type = "User defined argument";
                break;
            }
            case 102: {
                type = "User defined recursive argument";
                break;
            }
            case 103: {
                type = "User defined function";
                break;
            }
            case 104: {
                type = "User defined constant";
                break;
            }
            case 12: {
                type = "Unit";
                break;
            }
            case 11: {
                type = "Bitwise Operator";
            }
        }
        return type;
    }

    public static final String numberToHexString(int number) {
        return Integer.toHexString(number);
    }

    public static final String numberToHexString(long number) {
        return Long.toHexString(number);
    }

    public static final String numberToHexString(double number) {
        return mXparser.numberToHexString((long)number);
    }

    public static final String hexString2AsciiString(String hexString) {
        String asciiString = "";
        for (int i = 0; i < hexString.length(); i += 2) {
            String hexByteStr = hexString.substring(i, i + 2);
            int hexByteInt = Integer.parseInt(hexByteStr, 16);
            asciiString = asciiString + (char)hexByteInt;
        }
        return asciiString;
    }

    public static final String numberToAsciiString(int number) {
        return mXparser.hexString2AsciiString(mXparser.numberToHexString(number));
    }

    public static final String numberToAsciiString(long number) {
        return mXparser.hexString2AsciiString(mXparser.numberToHexString(number));
    }

    public static final String numberToAsciiString(double number) {
        return mXparser.hexString2AsciiString(mXparser.numberToHexString(number));
    }

    public static final double convOthBase2Decimal(String numberLiteral, int numeralSystemBase) {
        return NumberTheory.convOthBase2Decimal(numberLiteral, numeralSystemBase);
    }

    public static final double convOthBase2Decimal(String numberLiteral) {
        return NumberTheory.convOthBase2Decimal(numberLiteral);
    }

    public static final double convOthBase2Decimal(int numeralSystemBase, int ... digits) {
        return NumberTheory.convOthBase2Decimal(numeralSystemBase, digits);
    }

    public static final double convOthBase2Decimal(double numeralSystemBase, double ... digits) {
        return NumberTheory.convOthBase2Decimal(numeralSystemBase, digits);
    }

    public static final String convDecimal2OthBase(double decimalNumber, int numeralSystemBase) {
        return NumberTheory.convDecimal2OthBase(decimalNumber, numeralSystemBase);
    }

    public static final String convDecimal2OthBase(double decimalNumber, int numeralSystemBase, int format) {
        return NumberTheory.convDecimal2OthBase(decimalNumber, numeralSystemBase, format);
    }

    public static final void consolePrintln(Object o) {
        if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.equals("")) {
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT = CONSOLE_PREFIX;
        }
        System.out.println(o);
        ++CONSOLE_ROW_NUMBER;
        System.out.print(CONSOLE_PREFIX);
        CONSOLE_OUTPUT = CONSOLE_OUTPUT + o + "\n" + CONSOLE_OUTPUT_PREFIX;
    }

    public static final void consolePrintln(String[] stringArray) {
        if (stringArray == null) {
            mXparser.consolePrintln("null");
            return;
        }
        for (String s : stringArray) {
            mXparser.consolePrintln(s);
        }
    }

    public static final void consolePrintln() {
        if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.equals("")) {
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT = CONSOLE_PREFIX;
        }
        System.out.println();
        ++CONSOLE_ROW_NUMBER;
        System.out.print(CONSOLE_PREFIX);
        CONSOLE_OUTPUT = CONSOLE_OUTPUT + "\n" + CONSOLE_OUTPUT_PREFIX;
    }

    public static final void consolePrint(Object o) {
        if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.equals("")) {
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT = CONSOLE_PREFIX;
        }
        System.out.print(o);
        CONSOLE_OUTPUT = CONSOLE_OUTPUT + o;
    }

    public static final void resetConsoleOutput() {
        CONSOLE_OUTPUT = "";
        CONSOLE_ROW_NUMBER = 1;
    }

    public static void setDefaultConsolePrefix() {
        CONSOLE_PREFIX = "[mXparser-v.4.1.1] ";
    }

    public static void setDefaultConsoleOutputPrefix() {
        CONSOLE_OUTPUT_PREFIX = "[mXparser-v.4.1.1] ";
    }

    public static void setConsolePrefix(String consolePrefix) {
        CONSOLE_PREFIX = consolePrefix;
    }

    public static void setConsoleOutputPrefix(String consoleOutputPrefix) {
        CONSOLE_OUTPUT_PREFIX = consoleOutputPrefix;
    }

    public static final String getConsoleOutput() {
        return CONSOLE_OUTPUT;
    }

    public static final String getHelp() {
        return mXparserExp.getHelp();
    }

    public static final String getHelp(String word) {
        return mXparserExp.getHelp(word);
    }

    public static final void consolePrintHelp() {
        System.out.println(mXparser.getHelp());
    }

    public static final void consolePrintHelp(String word) {
        System.out.println(mXparser.getHelp(word));
    }

    public static final List<KeyWord> getKeyWords() {
        return mXparserExp.getKeyWords();
    }

    public static final List<KeyWord> getKeyWords(String query) {
        return mXparserExp.getKeyWords(query);
    }

    public static final boolean regexMatch(String str, String pattern) {
        return Pattern.matches(pattern, str);
    }

    public static final void consolePrintTokens(List<Token> tokens) {
        Expression.showTokens(tokens);
    }

    public static final String getLicense() {
        return LICENSE;
    }

    public static final void wait(int n) {
        long t1;
        long t0 = System.currentTimeMillis();
        while ((t1 = System.currentTimeMillis()) - t0 < (long)n) {
        }
    }

    static {
        CONSOLE_OUTPUT_PREFIX = CONSOLE_PREFIX = "[mXparser-v.4.1.1] ";
        CONSOLE_ROW_NUMBER = 1;
        THREADS_NUMBER = Runtime.getRuntime().availableProcessors();
        mXparserExp = new Expression(new PrimitiveElement[0]);
        ulpRounding = true;
        MAX_RECURSION_CALLS = 200;
        tokensToRemove = new ArrayList<String>();
        tokensToModify = new ArrayList<TokenModification>();
        overrideBuiltinTokens = false;
        optionsChangesetNumber = 0;
    }
}

