/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.regressiontesting;

import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.regressiontesting.PerformanceTestResult;
import org.mariuszgromada.math.mxparser.regressiontesting.Test011Thread;
import org.mariuszgromada.math.mxparser.regressiontesting.Test012Thread;
import org.mariuszgromada.math.mxparser.regressiontesting.Test013Thread;
import org.mariuszgromada.math.mxparser.regressiontesting.Test014Thread;
import org.mariuszgromada.math.mxparser.regressiontesting.Test015Thread;
import org.mariuszgromada.math.mxparser.regressiontesting.Test016Thread;
import org.mariuszgromada.math.mxparser.regressiontesting.Test017Thread;
import org.mariuszgromada.math.mxparser.regressiontesting.Test018Thread;
import org.mariuszgromada.math.mxparser.regressiontesting.Test019Thread;
import org.mariuszgromada.math.mxparser.regressiontesting.Test020Thread;
import org.mariuszgromada.math.mxparser.regressiontesting.TestSimpleCalcThread;
import org.mariuszgromada.math.mxparser.regressiontesting.TestThread;

public class PerformanceTests {
    private static PerformanceTestResult[] tests;

    static void createRunJoinThreads(PerformanceTestResult test, int classId) {
        int threadId;
        test.testInit();
        TestThread[] runners = new TestThread[test.threadsNum];
        Thread[] threads = new Thread[test.threadsNum];
        for (threadId = 0; threadId < test.threadsNum; ++threadId) {
            switch (classId) {
                case 0: {
                    runners[threadId] = new TestSimpleCalcThread(test);
                    break;
                }
                case 1: {
                    runners[threadId] = new TestSimpleCalcThread(test);
                    break;
                }
                case 2: {
                    runners[threadId] = new TestSimpleCalcThread(test);
                    break;
                }
                case 3: {
                    runners[threadId] = new TestSimpleCalcThread(test);
                    break;
                }
                case 4: {
                    runners[threadId] = new TestSimpleCalcThread(test);
                    break;
                }
                case 5: {
                    runners[threadId] = new TestSimpleCalcThread(test);
                    break;
                }
                case 6: {
                    runners[threadId] = new TestSimpleCalcThread(test);
                    break;
                }
                case 7: {
                    runners[threadId] = new TestSimpleCalcThread(test);
                    break;
                }
                case 8: {
                    runners[threadId] = new TestSimpleCalcThread(test);
                    break;
                }
                case 9: {
                    runners[threadId] = new TestSimpleCalcThread(test);
                    break;
                }
                case 10: {
                    runners[threadId] = new TestSimpleCalcThread(test);
                    break;
                }
                case 11: {
                    runners[threadId] = new Test011Thread(test);
                    break;
                }
                case 12: {
                    runners[threadId] = new Test012Thread(test);
                    break;
                }
                case 13: {
                    runners[threadId] = new Test013Thread(test);
                    break;
                }
                case 14: {
                    runners[threadId] = new Test014Thread(test);
                    break;
                }
                case 15: {
                    runners[threadId] = new Test015Thread(test);
                    break;
                }
                case 16: {
                    runners[threadId] = new Test016Thread(test);
                    break;
                }
                case 17: {
                    runners[threadId] = new Test017Thread(test);
                    break;
                }
                case 18: {
                    runners[threadId] = new Test018Thread(test);
                    break;
                }
                case 19: {
                    runners[threadId] = new Test019Thread(test);
                    break;
                }
                case 20: {
                    runners[threadId] = new Test020Thread(test);
                }
            }
            threads[threadId] = new Thread(runners[threadId]);
            threads[threadId].start();
        }
        for (threadId = 0; threadId < test.threadsNum; ++threadId) {
            try {
                threads[threadId].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        test.testClose();
    }

    static void test000(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Simple calculations - addition. Expression created once. Iteration: repeatedly recalculated same expression.";
        test.iterNum = 20000000;
        test.exprStr = "2+3";
        PerformanceTests.createRunJoinThreads(test, 0);
    }

    static void test001(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Simple calculations - multiplication. Expression created once. Iteration: repeatedly recalculated same expression.";
        test.iterNum = 20000000;
        test.exprStr = "2*3";
        PerformanceTests.createRunJoinThreads(test, 1);
    }

    static void test002(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Simple calculations - division. Expression created once. Iteration: repeatedly recalculated same expression.";
        test.iterNum = 20000000;
        test.exprStr = "2/3";
        PerformanceTests.createRunJoinThreads(test, 2);
    }

    static void test003(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Simple calculations - power. Expression created once. Iteration: repeatedly recalculated same expression.";
        test.iterNum = 20000000;
        test.exprStr = "2^3";
        PerformanceTests.createRunJoinThreads(test, 3);
    }

    static void test004(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Simple calculations - sinus. Expression created once. Iteration: repeatedly recalculated same expression.";
        test.iterNum = 20000000;
        test.exprStr = "sin(3)";
        PerformanceTests.createRunJoinThreads(test, 4);
    }

    static void test005(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Simple calculations - 2 additions. Expression created once. Iteration: repeatedly recalculated same expression.";
        test.iterNum = 20000000;
        test.exprStr = "2+3+4";
        PerformanceTests.createRunJoinThreads(test, 5);
    }

    static void test006(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Simple calculations - 3 additions. Expression created once. Iteration: repeatedly recalculated same expression.";
        test.iterNum = 20000000;
        test.exprStr = "2+3+4+5";
        PerformanceTests.createRunJoinThreads(test, 6);
    }

    static void test007(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Simple calculations - 3 additions + 1 parenthesis. Expression created once. Iteration: repeatedly recalculated same expression.";
        test.iterNum = 20000000;
        test.exprStr = "2+(3+4)+5";
        PerformanceTests.createRunJoinThreads(test, 7);
    }

    static void test008(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Simple calculations - 3 additions + 2 brackets. Expression created once. Iteration: repeatedly recalculated same expression.";
        test.iterNum = 20000000;
        test.exprStr = "(2+3)+(4+5)";
        PerformanceTests.createRunJoinThreads(test, 8);
    }

    static void test009(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Simple calculations - 3 additions + 2 brackets. Expression created once. Iteration: repeatedly recalculated same expression.";
        test.iterNum = 20000000;
        test.exprStr = "2+(3+(4+5))";
        PerformanceTests.createRunJoinThreads(test, 9);
    }

    static void test010(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Combination of different operations. Expression created once. Iteration: repeatedly recalculated same expression.";
        test.iterNum = 20000000;
        test.exprStr = "sin(2+(3*4)^2)/10";
        PerformanceTests.createRunJoinThreads(test, 10);
    }

    static void test011(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Simple calculations - addition with argument. Expression created once, containing argument 'x'. Iteration: argument value is being modified (increased), then expression is recalculated";
        test.iterNum = 20000000;
        test.exprStr = "2+x";
        PerformanceTests.createRunJoinThreads(test, 11);
    }

    static void test012(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "User defined function f(x,y)=3*x+4*y. Expression &Function created once, containing argument 'x'. Iteration: argument value is being modified (increased), then expression is recalculated";
        test.iterNum = 2000000;
        test.exprStr = "3*f(x,y)-(2*x+3*y)";
        PerformanceTests.createRunJoinThreads(test, 12);
    }

    static void test013(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Creating constants: Iteration: Constant c = new Constant(\"c\", 5)";
        test.iterNum = 1000000;
        test.exprStr = "Constant c = new Constant(\"c\", 5)";
        PerformanceTests.createRunJoinThreads(test, 13);
    }

    static void test014(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Creating constants: Iteration: Constant c = new Constant(\"c=5\")";
        test.iterNum = 100000;
        test.exprStr = "Constant c = new Constant(\"c=5\")";
        PerformanceTests.createRunJoinThreads(test, 14);
    }

    static void test015(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Creating arguments: Iteration: Argument x = new Argument(\"x\", 5)";
        test.iterNum = 1000000;
        test.exprStr = "Argument x = new Argument(\"x\", 5)";
        PerformanceTests.createRunJoinThreads(test, 15);
    }

    static void test016(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Creating arguments: Iteration: Argument x = new Argument(\"x=5\")";
        test.iterNum = 100000;
        test.exprStr = "Argument x = new Argument(\"x=5\")";
        PerformanceTests.createRunJoinThreads(test, 16);
    }

    static void test017(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Creating functions: Iteration: Function f = new Function(\"f\", \"x+y\", \"x\", \"y\")";
        test.iterNum = 1000000;
        test.exprStr = "Function f = new Function(\"f\", \"x+y\", \"x\", \"y\")";
        PerformanceTests.createRunJoinThreads(test, 17);
    }

    static void test018(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Creating functions: Iteration: Function f = new Function(\"f(x,y)=x+y\")";
        test.iterNum = 100000;
        test.exprStr = "Function f = new Function(\"f(x,y)=x+y\")";
        PerformanceTests.createRunJoinThreads(test, 18);
    }

    static void test019(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Creating expressions: Iteration: Expression e = new Expression(\"sin(2+(3*4)^2)/10\")";
        test.iterNum = 1000000;
        test.exprStr = "Expression e = new Expression(\"sin(2+(3*4)^2)/10\")";
        PerformanceTests.createRunJoinThreads(test, 19);
    }

    static void test020(PerformanceTestResult test, int testId) {
        test.Id = testId;
        test.description = "Creating expressions + checking syntax: Iteration: Expression e = new Expression(\"sin(2+(3*4)^2)/10\")";
        test.iterNum = 100000;
        test.exprStr = "Expression e = new Expression(\"sin(2+(3*4)^2)/10\")";
        PerformanceTests.createRunJoinThreads(test, 20);
    }

    public static int start(int threadsNum) {
        mXparser.disableUlpRounding();
        if (threadsNum <= 0) {
            threadsNum = mXparser.getThreadsNumber();
        }
        tests = new PerformanceTestResult[100];
        int testId = -1;
        int lastTestId = 20;
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test000(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test001(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test002(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test003(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test004(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test005(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test006(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test007(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test008(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test009(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test010(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test011(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test012(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test013(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test014(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test015(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test016(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test017(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test018(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test019(tests[testId], testId);
        PerformanceTests.tests[++testId] = new PerformanceTestResult(threadsNum);
        PerformanceTests.test020(tests[testId], testId);
        return lastTestId - testId;
    }

    public static int start() {
        return PerformanceTests.start(mXparser.getThreadsNumber());
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            int threadsNumber = Integer.parseInt(args[0]);
            if (threadsNumber > 0) {
                PerformanceTests.start(threadsNumber);
            } else {
                PerformanceTests.start();
            }
        } else {
            PerformanceTests.start();
        }
    }
}

