/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.ArgumentParameter;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.DescKwLenComparator;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.FunctionParameter;
import org.mariuszgromada.math.mxparser.IterativeOperatorParameters;
import org.mariuszgromada.math.mxparser.KwStrComparator;
import org.mariuszgromada.math.mxparser.KwTypeComparator;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.RecursiveArgument;
import org.mariuszgromada.math.mxparser.SyntaxStackElement;
import org.mariuszgromada.math.mxparser.TokenModification;
import org.mariuszgromada.math.mxparser.TokenStackElement;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import org.mariuszgromada.math.mxparser.mathcollection.BooleanAlgebra;
import org.mariuszgromada.math.mxparser.mathcollection.Calculus;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;
import org.mariuszgromada.math.mxparser.mathcollection.ProbabilityDistributions;
import org.mariuszgromada.math.mxparser.mathcollection.SpecialFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.Statistics;
import org.mariuszgromada.math.mxparser.parsertokens.KeyWord;
import org.mariuszgromada.math.mxparser.parsertokens.Token;
import org.mariuszgromada.math.mxparser.syntaxchecker.SyntaxChecker;

public class Expression
extends PrimitiveElement {
    public static final int TYPE_ID = 100;
    public static final String TYPE_DESC = "User defined expression";
    static final int NOT_FOUND = -1;
    static final int FOUND = 0;
    static final boolean INTERNAL = true;
    private static final boolean WITH_EXP_STR = true;
    private static final boolean NO_EXP_STR = false;
    public static final boolean NO_SYNTAX_ERRORS = true;
    public static final boolean SYNTAX_ERROR_OR_STATUS_UNKNOWN = false;
    String expressionString;
    private String description;
    List<Argument> argumentsList;
    List<Function> functionsList;
    List<Constant> constantsList;
    private List<KeyWord> keyWordsList;
    private List<Token> initialTokens;
    private List<Token> tokensList;
    List<Expression> relatedExpressionsList;
    private double computingTime;
    private boolean expressionWasModified;
    boolean recursiveMode;
    private boolean verboseMode;
    boolean disableRounding;
    static final boolean DISABLE_ROUNDING = true;
    static final boolean KEEP_ROUNDING_SETTINGS = false;
    private boolean syntaxStatus;
    private String errorMessage;
    private boolean recursionCallPending;
    private int recursionCallsCounter;
    private boolean parserKeyWordsOnly;
    boolean UDFExpression = false;
    List<Double> UDFVariadicParamsAtRunTime;
    private boolean internalClone;
    private int optionsChangesetNumber = -1;
    private final String FUNCTION = "function";
    private final String ARGUMENT = "argument";
    private final String UNITCONST = "unit/const";
    private final String ERROR = "error";

    void addRelatedExpression(Expression expression) {
        if (expression != null && expression != this && !this.relatedExpressionsList.contains(expression)) {
            this.relatedExpressionsList.add(expression);
        }
    }

    void removeRelatedExpression(Expression expression) {
        this.relatedExpressionsList.remove(expression);
    }

    void showRelatedExpressions() {
        mXparser.consolePrintln();
        mXparser.consolePrintln(this.description + " = " + this.expressionString + ":");
        for (Expression e : this.relatedExpressionsList) {
            mXparser.consolePrintln("-> " + e.description + " = " + e.expressionString);
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getSyntaxStatus() {
        return this.syntaxStatus;
    }

    void setSyntaxStatus(boolean syntaxStatus, String errorMessage) {
        this.syntaxStatus = syntaxStatus;
        this.errorMessage = errorMessage;
        this.expressionWasModified = false;
    }

    void setExpressionModifiedFlag() {
        if (!this.recursionCallPending) {
            this.recursionCallPending = true;
            this.recursionCallsCounter = 0;
            this.internalClone = false;
            this.expressionWasModified = true;
            this.syntaxStatus = false;
            this.errorMessage = "Syntax status unknown.";
            for (Expression e : this.relatedExpressionsList) {
                e.setExpressionModifiedFlag();
            }
            this.recursionCallPending = false;
        }
    }

    private void expressionInternalVarsInit() {
        this.description = "";
        this.errorMessage = "";
        this.computingTime = 0.0;
        this.recursionCallPending = false;
        this.recursionCallsCounter = 0;
        this.internalClone = false;
        this.parserKeyWordsOnly = false;
        this.disableRounding = false;
    }

    private void expressionInit() {
        this.argumentsList = new ArrayList<Argument>();
        this.functionsList = new ArrayList<Function>();
        this.constantsList = new ArrayList<Constant>();
        this.relatedExpressionsList = new ArrayList<Expression>();
        this.setSilentMode();
        this.disableRecursiveMode();
        this.expressionInternalVarsInit();
    }

    public Expression(PrimitiveElement ... elements) {
        super(100);
        this.expressionString = "";
        this.expressionInit();
        this.setExpressionModifiedFlag();
        this.addDefinitions(elements);
    }

    public Expression(String expressionString, PrimitiveElement ... elements) {
        super(100);
        this.expressionInit();
        this.expressionString = new String(expressionString);
        this.setExpressionModifiedFlag();
        this.addDefinitions(elements);
    }

    Expression(String expressionString, boolean parserKeyWordsOnly) {
        super(100);
        this.expressionInit();
        this.expressionString = new String(expressionString);
        this.setExpressionModifiedFlag();
        this.parserKeyWordsOnly = parserKeyWordsOnly;
    }

    Expression(String expressionString, List<Token> initialTokens, List<Argument> argumentsList, List<Function> functionsList, List<Constant> constantsList, boolean disableUlpRounding, boolean UDFExpression, List<Double> UDFVariadicParamsAtRunTime) {
        super(100);
        this.expressionString = expressionString;
        this.initialTokens = initialTokens;
        this.argumentsList = argumentsList;
        this.functionsList = functionsList;
        this.constantsList = constantsList;
        this.relatedExpressionsList = new ArrayList<Expression>();
        this.expressionWasModified = false;
        this.syntaxStatus = true;
        this.description = "_internal_";
        this.errorMessage = "";
        this.computingTime = 0.0;
        this.recursionCallPending = false;
        this.recursionCallsCounter = 0;
        this.internalClone = false;
        this.parserKeyWordsOnly = false;
        this.UDFExpression = UDFExpression;
        this.UDFVariadicParamsAtRunTime = UDFVariadicParamsAtRunTime;
        this.disableRounding = disableUlpRounding;
        this.setSilentMode();
        this.disableRecursiveMode();
    }

    Expression(String expressionString, List<Argument> argumentsList, List<Function> functionsList, List<Constant> constantsList, boolean internal, boolean UDFExpression, List<Double> UDFVariadicParamsAtRunTime) {
        super(100);
        this.expressionString = new String(expressionString);
        this.expressionInternalVarsInit();
        this.setSilentMode();
        this.disableRecursiveMode();
        this.argumentsList = argumentsList;
        this.functionsList = functionsList;
        this.constantsList = constantsList;
        this.UDFExpression = UDFExpression;
        this.UDFVariadicParamsAtRunTime = UDFVariadicParamsAtRunTime;
        this.relatedExpressionsList = new ArrayList<Expression>();
        this.setExpressionModifiedFlag();
    }

    private Expression(Expression expression) {
        super(100);
        this.expressionString = new String(expression.expressionString);
        this.description = new String(expression.description);
        this.argumentsList = expression.argumentsList;
        this.functionsList = expression.functionsList;
        this.constantsList = expression.constantsList;
        this.keyWordsList = expression.keyWordsList;
        this.relatedExpressionsList = expression.relatedExpressionsList;
        this.computingTime = 0.0;
        this.expressionWasModified = expression.expressionWasModified;
        this.recursiveMode = expression.recursiveMode;
        this.verboseMode = expression.verboseMode;
        this.syntaxStatus = expression.syntaxStatus;
        this.errorMessage = new String(expression.errorMessage);
        this.recursionCallPending = expression.recursionCallPending;
        this.recursionCallsCounter = expression.recursionCallsCounter;
        this.parserKeyWordsOnly = expression.parserKeyWordsOnly;
        this.disableRounding = expression.disableRounding;
        this.UDFExpression = expression.UDFExpression;
        this.UDFVariadicParamsAtRunTime = expression.UDFVariadicParamsAtRunTime;
        this.internalClone = true;
    }

    public void setExpressionString(String expressionString) {
        this.expressionString = expressionString;
        this.setExpressionModifiedFlag();
    }

    public String getExpressionString() {
        return this.expressionString;
    }

    public void clearExpressionString() {
        this.expressionString = "";
        this.setExpressionModifiedFlag();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void clearDescription() {
        this.description = "";
    }

    public void setVerboseMode() {
        this.verboseMode = true;
    }

    public void setSilentMode() {
        this.verboseMode = false;
    }

    public boolean getVerboseMode() {
        return this.verboseMode;
    }

    void setRecursiveMode() {
        this.recursiveMode = true;
    }

    void disableRecursiveMode() {
        this.recursiveMode = false;
    }

    public boolean getRecursiveMode() {
        return this.recursiveMode;
    }

    public double getComputingTime() {
        return this.computingTime;
    }

    public void addDefinitions(PrimitiveElement ... elements) {
        for (PrimitiveElement e : elements) {
            if (e == null) continue;
            int elementTypeId = e.getMyTypeId();
            if (elementTypeId == 101) {
                this.addArguments((Argument)e);
                continue;
            }
            if (elementTypeId == 104) {
                this.addConstants((Constant)e);
                continue;
            }
            if (elementTypeId == 103) {
                this.addFunctions((Function)e);
                continue;
            }
            if (elementTypeId != 102) continue;
            this.addArguments((Argument)e);
        }
    }

    public void removeDefinitions(PrimitiveElement ... elements) {
        for (PrimitiveElement e : elements) {
            if (e == null) continue;
            int elementTypeId = e.getMyTypeId();
            if (elementTypeId == 101) {
                this.removeArguments((Argument)e);
                continue;
            }
            if (elementTypeId == 104) {
                this.removeConstants((Constant)e);
                continue;
            }
            if (elementTypeId == 103) {
                this.removeFunctions((Function)e);
                continue;
            }
            if (elementTypeId != 102) continue;
            this.removeArguments((Argument)e);
        }
    }

    public void addArguments(Argument ... arguments) {
        for (Argument arg : arguments) {
            if (arg == null) continue;
            this.argumentsList.add(arg);
            if (arg.getArgumentBodyType() != 1) continue;
            arg.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineArguments(String ... argumentsNames) {
        for (String argName : argumentsNames) {
            Argument arg = new Argument(argName, new PrimitiveElement[0]);
            arg.addRelatedExpression(this);
            this.argumentsList.add(arg);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineArgument(String argumentName, double argumentValue) {
        Argument arg = new Argument(argumentName, argumentValue);
        arg.addRelatedExpression(this);
        this.argumentsList.add(arg);
        this.setExpressionModifiedFlag();
    }

    public int getArgumentIndex(String argumentName) {
        int argumentsNumber = this.argumentsList.size();
        if (argumentsNumber > 0) {
            int argumentIndex = 0;
            int searchResult = -1;
            while (argumentIndex < argumentsNumber && searchResult == -1) {
                if (this.argumentsList.get(argumentIndex).getArgumentName().equals(argumentName)) {
                    searchResult = 0;
                    continue;
                }
                ++argumentIndex;
            }
            if (searchResult == 0) {
                return argumentIndex;
            }
            return -1;
        }
        return -1;
    }

    public Argument getArgument(String argumentName) {
        int argumentIndex = this.getArgumentIndex(argumentName);
        if (argumentIndex == -1) {
            return null;
        }
        return this.argumentsList.get(argumentIndex);
    }

    public Argument getArgument(int argumentIndex) {
        if (argumentIndex < 0 || argumentIndex >= this.argumentsList.size()) {
            return null;
        }
        return this.argumentsList.get(argumentIndex);
    }

    public int getArgumentsNumber() {
        return this.argumentsList.size();
    }

    public void setArgumentValue(String argumentName, double argumentValue) {
        int argumentIndex = this.getArgumentIndex(argumentName);
        if (argumentIndex != -1) {
            this.argumentsList.get(argumentIndex).setArgumentValue(argumentValue);
        }
    }

    public double getArgumentValue(String argumentName) {
        int argumentIndex = this.getArgumentIndex(argumentName);
        if (argumentIndex != -1) {
            return this.argumentsList.get(argumentIndex).getArgumentValue();
        }
        return Double.NaN;
    }

    public void removeArguments(String ... argumentsNames) {
        for (String argumentName : argumentsNames) {
            int argumentIndex = this.getArgumentIndex(argumentName);
            if (argumentIndex == -1) continue;
            Argument arg = this.argumentsList.get(argumentIndex);
            arg.removeRelatedExpression(this);
            this.argumentsList.remove(argumentIndex);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeArguments(Argument ... arguments) {
        for (Argument argument : arguments) {
            if (argument == null) continue;
            this.argumentsList.remove(argument);
            argument.removeRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeAllArguments() {
        for (Argument arg : this.argumentsList) {
            arg.removeRelatedExpression(this);
        }
        this.argumentsList.clear();
        this.setExpressionModifiedFlag();
    }

    public void addConstants(Constant ... constants) {
        for (Constant constant : constants) {
            if (constant == null) continue;
            this.constantsList.add(constant);
            constant.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void addConstants(List<Constant> constantsList) {
        this.constantsList.addAll(constantsList);
        for (Constant c : constantsList) {
            c.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineConstant(String constantName, double constantValue) {
        Constant c = new Constant(constantName, constantValue);
        c.addRelatedExpression(this);
        this.constantsList.add(c);
        this.setExpressionModifiedFlag();
    }

    public int getConstantIndex(String constantName) {
        int constantsNumber = this.constantsList.size();
        if (constantsNumber > 0) {
            int constantIndex = 0;
            int searchResult = -1;
            while (constantIndex < constantsNumber && searchResult == -1) {
                if (this.constantsList.get(constantIndex).getConstantName().equals(constantName)) {
                    searchResult = 0;
                    continue;
                }
                ++constantIndex;
            }
            if (searchResult == 0) {
                return constantIndex;
            }
            return -1;
        }
        return -1;
    }

    public Constant getConstant(String constantName) {
        int constantIndex = this.getConstantIndex(constantName);
        if (constantIndex == -1) {
            return null;
        }
        return this.constantsList.get(constantIndex);
    }

    public Constant getConstant(int constantIndex) {
        if (constantIndex < 0 || constantIndex >= this.constantsList.size()) {
            return null;
        }
        return this.constantsList.get(constantIndex);
    }

    public int getConstantsNumber() {
        return this.constantsList.size();
    }

    public void removeConstants(String ... constantsNames) {
        for (String constantName : constantsNames) {
            int constantIndex = this.getConstantIndex(constantName);
            if (constantIndex == -1) continue;
            Constant c = this.constantsList.get(constantIndex);
            c.removeRelatedExpression(this);
            this.constantsList.remove(constantIndex);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeConstants(Constant ... constants) {
        for (Constant constant : constants) {
            if (constant == null) continue;
            this.constantsList.remove(constant);
            constant.removeRelatedExpression(this);
            this.setExpressionModifiedFlag();
        }
    }

    public void removeAllConstants() {
        for (Constant c : this.constantsList) {
            c.removeRelatedExpression(this);
        }
        this.constantsList.clear();
        this.setExpressionModifiedFlag();
    }

    public void addFunctions(Function ... functions) {
        for (Function f : functions) {
            if (f == null) continue;
            this.functionsList.add(f);
            if (f.getFunctionBodyType() != 1) continue;
            f.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineFunction(String functionName, String functionExpressionString, String ... argumentsNames) {
        Function f = new Function(functionName, functionExpressionString, argumentsNames);
        this.functionsList.add(f);
        f.addRelatedExpression(this);
        this.setExpressionModifiedFlag();
    }

    public int getFunctionIndex(String functionName) {
        int functionsNumber = this.functionsList.size();
        if (functionsNumber > 0) {
            int functionIndex = 0;
            int searchResult = -1;
            while (functionIndex < functionsNumber && searchResult == -1) {
                if (this.functionsList.get(functionIndex).getFunctionName().equals(functionName)) {
                    searchResult = 0;
                    continue;
                }
                ++functionIndex;
            }
            if (searchResult == 0) {
                return functionIndex;
            }
            return -1;
        }
        return -1;
    }

    public Function getFunction(String functionName) {
        int functionIndex = this.getFunctionIndex(functionName);
        if (functionIndex == -1) {
            return null;
        }
        return this.functionsList.get(functionIndex);
    }

    public Function getFunction(int functionIndex) {
        if (functionIndex < 0 || functionIndex >= this.functionsList.size()) {
            return null;
        }
        return this.functionsList.get(functionIndex);
    }

    public int getFunctionsNumber() {
        return this.functionsList.size();
    }

    public void removeFunctions(String ... functionsNames) {
        for (String functionName : functionsNames) {
            int functionIndex = this.getFunctionIndex(functionName);
            if (functionIndex == -1) continue;
            Function f = this.functionsList.get(functionIndex);
            f.removeRelatedExpression(this);
            this.functionsList.remove(f);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeFunctions(Function ... functions) {
        for (Function function : functions) {
            if (function == null) continue;
            function.removeRelatedExpression(this);
            this.functionsList.remove(function);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeAllFunctions() {
        for (Function f : this.functionsList) {
            f.removeRelatedExpression(this);
        }
        this.functionsList.clear();
        this.setExpressionModifiedFlag();
    }

    private void setToNumber(int pos, double number, boolean ulpRound) {
        int precision;
        Token token = this.tokensList.get(pos);
        token.tokenValue = mXparser.ulpRounding && !this.disableRounding ? (ulpRound ? (Double.isNaN(number) || Double.isInfinite(number) ? number : ((precision = MathFunctions.ulpDecimalDigitsBefore(number)) >= 0 ? MathFunctions.round(number, precision) : number)) : number) : number;
        token.tokenTypeId = 0;
        token.tokenId = 1;
        token.keyWord = "_num_";
    }

    private void setToNumber(int pos, double number) {
        this.setToNumber(pos, number, false);
    }

    private void f1SetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        this.tokensList.remove(pos + 1);
    }

    private void f1SetDecreaseRemove(int pos, double result) {
        this.f1SetDecreaseRemove(pos, result, false);
    }

    private void f2SetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        this.tokensList.remove(pos + 2);
        this.tokensList.remove(pos + 1);
    }

    private void f2SetDecreaseRemove(int pos, double result) {
        this.f2SetDecreaseRemove(pos, result, false);
    }

    private void f3SetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        this.tokensList.remove(pos + 3);
        this.tokensList.remove(pos + 2);
        this.tokensList.remove(pos + 1);
    }

    private void f3SetDecreaseRemove(int pos, double result) {
        this.f3SetDecreaseRemove(pos, result, false);
    }

    private void opSetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        this.tokensList.remove(pos + 1);
        this.tokensList.remove(pos - 1);
    }

    private void opSetDecreaseRemove(int pos, double result) {
        this.opSetDecreaseRemove(pos, result, false);
    }

    private void calcSetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        int lPos = pos + 1;
        int rPos = lPos + 1;
        while (this.tokensList.get((int)rPos).tokenTypeId != 20 || this.tokensList.get((int)rPos).tokenId != 2 || this.tokensList.get((int)rPos).tokenLevel != this.tokensList.get((int)lPos).tokenLevel) {
            ++rPos;
        }
        for (int p = rPos; p >= lPos; --p) {
            this.tokensList.remove(p);
        }
    }

    private void calcSetDecreaseRemove(int pos, double result) {
        this.calcSetDecreaseRemove(pos, result, false);
    }

    private void variadicSetDecreaseRemove(int pos, double value, int length, boolean ulpRound) {
        this.setToNumber(pos, value, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        for (int p = pos + length; p > pos; --p) {
            this.tokensList.remove(p);
        }
    }

    private void variadicSetDecreaseRemove(int pos, double value, int length) {
        this.variadicSetDecreaseRemove(pos, value, length, false);
    }

    private void ifSetRemove(int pos, double ifCondition, boolean ulpRound) {
        int lPos = pos + 1;
        int ifLevel = this.tokensList.get((int)lPos).tokenLevel;
        int c1Pos = lPos + 1;
        while (this.tokensList.get((int)c1Pos).tokenTypeId != 20 || this.tokensList.get((int)c1Pos).tokenId != 3 || this.tokensList.get((int)c1Pos).tokenLevel != ifLevel) {
            ++c1Pos;
        }
        int c2Pos = c1Pos + 1;
        while (this.tokensList.get((int)c2Pos).tokenTypeId != 20 || this.tokensList.get((int)c2Pos).tokenId != 3 || this.tokensList.get((int)c2Pos).tokenLevel != ifLevel) {
            ++c2Pos;
        }
        int rPos = c2Pos + 1;
        while (this.tokensList.get((int)rPos).tokenTypeId != 20 || this.tokensList.get((int)rPos).tokenId != 2 || this.tokensList.get((int)rPos).tokenLevel != ifLevel) {
            ++rPos;
        }
        if (!Double.isNaN(ifCondition)) {
            if (ifCondition != 0.0) {
                this.setToNumber(c2Pos + 1, Double.NaN);
                this.tokensList.get((int)(c2Pos + 1)).tokenLevel = ifLevel;
                this.removeTokens(c2Pos + 2, rPos - 1);
            } else {
                this.setToNumber(c1Pos + 1, Double.NaN);
                this.tokensList.get((int)(c1Pos + 1)).tokenLevel = ifLevel;
                this.removeTokens(c1Pos + 2, c2Pos - 1);
            }
        } else {
            this.setToNumber(c1Pos + 1, Double.NaN);
            this.setToNumber(c2Pos + 1, Double.NaN);
            this.tokensList.get((int)(c1Pos + 1)).tokenLevel = ifLevel;
            this.tokensList.get((int)(c2Pos + 1)).tokenLevel = ifLevel;
            this.removeTokens(c2Pos + 2, rPos - 1);
            this.removeTokens(c1Pos + 2, c2Pos - 1);
        }
        this.setToNumber(lPos + 1, ifCondition, ulpRound);
        this.tokensList.get((int)(lPos + 1)).tokenLevel = ifLevel;
        this.removeTokens(lPos + 2, c1Pos - 1);
        this.tokensList.get((int)pos).tokenId = 2;
    }

    private void removeTokens(int from, int to) {
        if (from < to) {
            for (int p = to; p >= from; --p) {
                this.tokensList.remove(p);
            }
        } else if (from == to) {
            this.tokensList.remove(from);
        }
    }

    private void ifSetRemove(int pos, double ifCondition) {
        this.ifSetRemove(pos, ifCondition, false);
    }

    private List<Token> createInitialTokens(int startPos, int endPos, List<Token> tokensList) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (int p = startPos; p <= endPos; ++p) {
            Token t = tokensList.get(p).clone();
            tokens.add(t);
        }
        return tokens;
    }

    private int getParametersNumber(int pos) {
        int lPpos = pos + 1;
        if (lPpos == this.initialTokens.size()) {
            return -1;
        }
        if (this.initialTokens.get((int)lPpos).tokenTypeId == 20 && this.initialTokens.get((int)lPpos).tokenId == 1) {
            int tokenLevel = this.initialTokens.get((int)lPpos).tokenLevel;
            int endPos = lPpos + 1;
            while (this.initialTokens.get((int)endPos).tokenTypeId != 20 || this.initialTokens.get((int)endPos).tokenId != 2 || this.initialTokens.get((int)endPos).tokenLevel != tokenLevel) {
                ++endPos;
            }
            if (endPos == lPpos + 1) {
                return 0;
            }
            int numberOfCommas = 0;
            for (int p = lPpos; p < endPos; ++p) {
                Token token = this.initialTokens.get(p);
                if (token.tokenTypeId != 20 || token.tokenId != 3 || token.tokenLevel != tokenLevel) continue;
                ++numberOfCommas;
            }
            return numberOfCommas + 1;
        }
        return -1;
    }

    private List<FunctionParameter> getFunctionParameters(int pos, List<Token> tokensList) {
        ArrayList<FunctionParameter> functionParameters = new ArrayList<FunctionParameter>();
        int cPos = pos + 2;
        int tokenLevel = tokensList.get((int)(pos + 1)).tokenLevel;
        int pPos = cPos;
        boolean end = false;
        ArrayList<Token> paramTkones = new ArrayList<Token>();
        String paramStr = "";
        do {
            Token t = tokensList.get(cPos);
            boolean comma = false;
            boolean paren = false;
            if (t.tokenLevel == tokenLevel && t.tokenTypeId == 20) {
                if (t.tokenId == 2) {
                    paren = true;
                } else if (t.tokenId == 3) {
                    comma = true;
                }
            }
            if (paren || comma) {
                if (cPos > pos + 2) {
                    functionParameters.add(new FunctionParameter(paramTkones, paramStr, pPos, cPos - 1));
                    paramTkones = new ArrayList();
                    paramStr = "";
                    pPos = cPos + 1;
                }
            } else {
                paramTkones.add(t);
                paramStr = paramStr + t.tokenStr;
            }
            if (paren) {
                end = true;
                continue;
            }
            ++cPos;
        } while (!end);
        return functionParameters;
    }

    private ArgumentParameter getParamArgument(String argumentName) {
        ArgumentParameter argParam = new ArgumentParameter();
        argParam.index = this.getArgumentIndex(argumentName);
        argParam.argument = this.getArgument(argParam.index);
        argParam.presence = 0;
        if (argParam.argument == null) {
            argParam.argument = new Argument(argumentName, new PrimitiveElement[0]);
            this.argumentsList.add(argParam.argument);
            argParam.index = this.argumentsList.size() - 1;
            argParam.presence = -1;
        } else {
            argParam.initialValue = argParam.argument.argumentValue;
            argParam.initialType = argParam.argument.argumentType;
            argParam.argument.argumentValue = argParam.argument.getArgumentValue();
            argParam.argument.argumentType = 1;
        }
        return argParam;
    }

    private void clearParamArgument(ArgumentParameter argParam) {
        if (argParam.presence == -1) {
            this.argumentsList.remove(argParam.index);
        } else {
            argParam.argument.argumentValue = argParam.initialValue;
            argParam.argument.argumentType = argParam.initialType;
        }
    }

    private void FREE_ARGUMENT(int pos) {
        Argument argument = this.argumentsList.get(this.tokensList.get((int)pos).tokenId);
        boolean argumentVerboseMode = argument.getVerboseMode();
        if (this.verboseMode) {
            argument.setVerboseMode();
        }
        this.setToNumber(pos, argument.getArgumentValue());
        if (!argumentVerboseMode) {
            argument.setSilentMode();
        }
    }

    private void DEPENDENT_ARGUMENT(int pos) {
        Argument argument = this.argumentsList.get(this.tokensList.get((int)pos).tokenId);
        boolean argumentVerboseMode = argument.getVerboseMode();
        if (this.verboseMode) {
            argument.setVerboseMode();
        }
        int tokensListSizeBefore = this.tokensList.size();
        Token tokenBefore = this.tokensList.get(pos);
        double argumentValue = argument.getArgumentValue();
        int tokensListSizeAfter = this.tokensList.size();
        if (tokensListSizeBefore == tokensListSizeAfter) {
            Token tokenAfter = this.tokensList.get(pos);
            if (tokenBefore.tokenTypeId == tokenAfter.tokenTypeId && tokenBefore.tokenId == tokenAfter.tokenId) {
                this.setToNumber(pos, argumentValue);
            }
        }
        if (!argumentVerboseMode) {
            argument.setSilentMode();
        }
    }

    private void USER_FUNCTION(int pos) {
        double value;
        Function function;
        Function fun = this.functionsList.get(this.tokensList.get((int)pos).tokenId);
        if (fun.getRecursiveMode()) {
            function = fun.clone();
            function.functionExpression.recursionCallsCounter = this.recursionCallsCounter;
        } else {
            function = fun;
        }
        function.functionExpression.UDFVariadicParamsAtRunTime = this.getNumbers(pos);
        int argsNumber = function.getParametersNumber();
        if (!function.isVariadic) {
            for (int argIdx = 0; argIdx < argsNumber; ++argIdx) {
                function.setArgumentValue(argIdx, this.tokensList.get((int)(pos + argIdx + 1)).tokenValue);
            }
        }
        boolean functionVerboseMode = function.getVerboseMode();
        if (this.verboseMode) {
            function.setVerboseMode();
        }
        int tokensListSizeBefore = this.tokensList.size();
        Token tokenBefore = this.tokensList.get(pos);
        try {
            value = function.calculate();
        }
        catch (StackOverflowError soe) {
            value = Double.NaN;
            this.errorMessage = soe.getMessage();
        }
        int tokensListSizeAfter = this.tokensList.size();
        if (tokensListSizeBefore == tokensListSizeAfter) {
            Token tokenAfter = this.tokensList.get(pos);
            if (tokenBefore.tokenTypeId == tokenAfter.tokenTypeId && tokenBefore.tokenId == tokenAfter.tokenId) {
                this.setToNumber(pos, value);
                --this.tokensList.get((int)pos).tokenLevel;
                for (int argIdx = argsNumber; argIdx > 0; --argIdx) {
                    this.tokensList.remove(pos + argIdx);
                }
            }
        }
        if (!functionVerboseMode) {
            function.setSilentMode();
        }
    }

    private void USER_CONSTANT(int pos) {
        Constant constant = this.constantsList.get(this.tokensList.get((int)pos).tokenId);
        this.setToNumber(pos, constant.getConstantValue());
    }

    private void RECURSIVE_ARGUMENT(int pos) {
        double index = this.tokensList.get((int)(pos + 1)).tokenValue;
        RecursiveArgument argument = (RecursiveArgument)this.argumentsList.get(this.tokensList.get((int)pos).tokenId);
        boolean argumentVerboseMode = argument.getVerboseMode();
        if (this.verboseMode) {
            argument.setVerboseMode();
        }
        double result = argument.getArgumentValue(index);
        this.f1SetDecreaseRemove(pos, result);
        if (!argumentVerboseMode) {
            argument.setSilentMode();
        }
    }

    private void CONSTANT(int pos) {
        double constValue = Double.NaN;
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                constValue = Math.PI;
                break;
            }
            case 2: {
                constValue = Math.E;
                break;
            }
            case 3: {
                constValue = 0.5772156649015329;
                break;
            }
            case 4: {
                constValue = 1.618033988749895;
                break;
            }
            case 5: {
                constValue = 1.324717957244746;
                break;
            }
            case 6: {
                constValue = 0.70258;
                break;
            }
            case 7: {
                constValue = 4.66920160910299;
                break;
            }
            case 8: {
                constValue = 2.5029078750958926;
                break;
            }
            case 9: {
                constValue = 0.6601618158468696;
                break;
            }
            case 10: {
                constValue = 0.26149721284764277;
                break;
            }
            case 11: {
                constValue = 1.9021605823;
                break;
            }
            case 12: {
                constValue = 0.87058838;
                break;
            }
            case 13: {
                constValue = -2.7E-9;
                break;
            }
            case 14: {
                constValue = 0.915965594177219;
                break;
            }
            case 15: {
                constValue = 0.7642236535892206;
                break;
            }
            case 16: {
                constValue = 1.13198824;
                break;
            }
            case 17: {
                constValue = 1.0;
                break;
            }
            case 18: {
                constValue = 1.451369234883381;
                break;
            }
            case 19: {
                constValue = 1.6066951524152917;
                break;
            }
            case 20: {
                constValue = 0.2801694990238691;
                break;
            }
            case 21: {
                constValue = 0.30366300289873266;
                break;
            }
            case 22: {
                constValue = 0.353236371854996;
                break;
            }
            case 23: {
                constValue = 0.6243299885435508;
                break;
            }
            case 24: {
                constValue = 0.6434105463;
                break;
            }
            case 25: {
                constValue = 0.6627434193491816;
                break;
            }
            case 26: {
                constValue = 0.8093940205;
                break;
            }
            case 27: {
                constValue = 1.0986858055;
                break;
            }
            case 28: {
                constValue = 3.2758229187218113;
                break;
            }
            case 29: {
                constValue = 1.2020569031595942;
                break;
            }
            case 30: {
                constValue = 1.3063778838630806;
                break;
            }
            case 31: {
                constValue = 1.4560749485826896;
                break;
            }
            case 32: {
                constValue = 1.4670780794;
                break;
            }
            case 33: {
                constValue = 1.5396007178;
                break;
            }
            case 34: {
                constValue = 1.7052111401053678;
                break;
            }
            case 35: {
                constValue = 2.5849817595792532;
                break;
            }
            case 36: {
                constValue = 2.6854520010653062;
                break;
            }
            case 37: {
                constValue = 2.8077702420285195;
                break;
            }
            case 38: {
                constValue = 0.5;
                break;
            }
            case 39: {
                constValue = 2.295587149392638;
                break;
            }
            case 40: {
                constValue = 0.5671432904097838;
                break;
            }
            case 41: {
                constValue = 0.187859;
                break;
            }
            case 42: {
                constValue = 1.045163780117493;
                break;
            }
            case 43: {
                constValue = 0.5963473623231941;
                break;
            }
            case 101: {
                constValue = 2.99792458E8;
                break;
            }
            case 102: {
                constValue = 6.67408E-11;
                break;
            }
            case 103: {
                constValue = 9.80665;
                break;
            }
            case 104: {
                constValue = 6.62607004E-34;
                break;
            }
            case 105: {
                constValue = 1.0545718001391127E-34;
                break;
            }
            case 106: {
                constValue = 1.616229E-35;
                break;
            }
            case 107: {
                constValue = 2.17647E-8;
                break;
            }
            case 108: {
                constValue = 5.39116E-44;
                break;
            }
            case 201: {
                constValue = 9.4607304725808E15;
                break;
            }
            case 202: {
                constValue = 1.495978707E11;
                break;
            }
            case 203: {
                constValue = 3.085677581491362E16;
                break;
            }
            case 204: {
                constValue = 3.085677581491362E19;
                break;
            }
            case 205: {
                constValue = 6378137.0;
                break;
            }
            case 206: {
                constValue = 6356752.3;
                break;
            }
            case 207: {
                constValue = 6371008.8;
                break;
            }
            case 208: {
                constValue = 5.9722E24;
                break;
            }
            case 209: {
                constValue = 1.495980229906324E11;
                break;
            }
            case 210: {
                constValue = 1737100.0;
                break;
            }
            case 211: {
                constValue = 7.34582809714E22;
                break;
            }
            case 212: {
                constValue = 3.84399E8;
                break;
            }
            case 213: {
                constValue = 6.957E8;
                break;
            }
            case 214: {
                constValue = 1.98842039204614E30;
                break;
            }
            case 215: {
                constValue = 2439700.0;
                break;
            }
            case 216: {
                constValue = 3.3026266E23;
                break;
            }
            case 217: {
                constValue = 5.79090365522286E10;
                break;
            }
            case 218: {
                constValue = 6051800.0;
                break;
            }
            case 219: {
                constValue = 4.867343E24;
                break;
            }
            case 220: {
                constValue = 1.082089270091724E11;
                break;
            }
            case 221: {
                constValue = 3389500.0;
                break;
            }
            case 222: {
                constValue = 6.390254E23;
                break;
            }
            case 223: {
                constValue = 2.279391340303053E11;
                break;
            }
            case 224: {
                constValue = 6.9911E7;
                break;
            }
            case 225: {
                constValue = 1.8979651600000002E27;
                break;
            }
            case 226: {
                constValue = 7.782978821038201E11;
                break;
            }
            case 227: {
                constValue = 5.8232E7;
                break;
            }
            case 228: {
                constValue = 5.6830857980000005E26;
                break;
            }
            case 229: {
                constValue = 1.42939269475143E12;
                break;
            }
            case 230: {
                constValue = 2.5362E7;
                break;
            }
            case 231: {
                constValue = 8.681189920000001E25;
                break;
            }
            case 232: {
                constValue = 2.87503171826088E12;
                break;
            }
            case 233: {
                constValue = 2.4622E7;
                break;
            }
            case 234: {
                constValue = 1.024053134E26;
                break;
            }
            case 235: {
                constValue = 4.504449781152961E12;
                break;
            }
            case 301: {
                constValue = 1.0;
                break;
            }
            case 302: {
                constValue = 0.0;
                break;
            }
            case 999: {
                constValue = Double.NaN;
                break;
            }
            case 303: {
                constValue = this.UDFVariadicParamsAtRunTime.size();
            }
        }
        this.setToNumber(pos, constValue);
    }

    private void UNIT(int pos) {
        double unitValue = Double.NaN;
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                unitValue = 0.01;
                break;
            }
            case 2: {
                unitValue = 0.001;
                break;
            }
            case 101: {
                unitValue = 1.0E24;
                break;
            }
            case 102: {
                unitValue = 1.0E21;
                break;
            }
            case 103: {
                unitValue = 1.0E18;
                break;
            }
            case 104: {
                unitValue = 1.0E15;
                break;
            }
            case 105: {
                unitValue = 1.0E12;
                break;
            }
            case 106: {
                unitValue = 1.0E9;
                break;
            }
            case 107: {
                unitValue = 1000000.0;
                break;
            }
            case 108: {
                unitValue = 1000.0;
                break;
            }
            case 109: {
                unitValue = 100.0;
                break;
            }
            case 110: {
                unitValue = 10.0;
                break;
            }
            case 111: {
                unitValue = 0.1;
                break;
            }
            case 112: {
                unitValue = 0.01;
                break;
            }
            case 113: {
                unitValue = 0.001;
                break;
            }
            case 114: {
                unitValue = 1.0E-6;
                break;
            }
            case 115: {
                unitValue = 1.0E-9;
                break;
            }
            case 116: {
                unitValue = 1.0E-12;
                break;
            }
            case 117: {
                unitValue = 1.0E-15;
                break;
            }
            case 118: {
                unitValue = 1.0E-18;
                break;
            }
            case 119: {
                unitValue = 1.0E-21;
                break;
            }
            case 120: {
                unitValue = 1.0E-24;
                break;
            }
            case 201: {
                unitValue = 1.0;
                break;
            }
            case 202: {
                unitValue = 1000.0;
                break;
            }
            case 203: {
                unitValue = 0.01;
                break;
            }
            case 204: {
                unitValue = 0.001;
                break;
            }
            case 205: {
                unitValue = 0.025400000000000002;
                break;
            }
            case 206: {
                unitValue = 0.9144;
                break;
            }
            case 207: {
                unitValue = 0.3048;
                break;
            }
            case 208: {
                unitValue = 1609.344;
                break;
            }
            case 209: {
                unitValue = 1852.0;
                break;
            }
            case 301: {
                unitValue = 1.0;
                break;
            }
            case 302: {
                unitValue = 1.0E-4;
                break;
            }
            case 303: {
                unitValue = 1.0E-6;
                break;
            }
            case 304: {
                unitValue = 100.0;
                break;
            }
            case 305: {
                unitValue = 10000.0;
                break;
            }
            case 306: {
                unitValue = 4046.8564224000006;
                break;
            }
            case 307: {
                unitValue = 1000000.0;
                break;
            }
            case 401: {
                unitValue = 1.0E-9;
                break;
            }
            case 402: {
                unitValue = 1.0000000000000002E-6;
                break;
            }
            case 403: {
                unitValue = 1.0;
                break;
            }
            case 404: {
                unitValue = 1.0E9;
                break;
            }
            case 405: {
                unitValue = 1.0000000000000002E-6;
                break;
            }
            case 406: {
                unitValue = 0.0010000000000000002;
                break;
            }
            case 407: {
                unitValue = 0.003785411780000001;
                break;
            }
            case 408: {
                unitValue = 4.7317647300000007E-4;
                break;
            }
            case 501: {
                unitValue = 1.0;
                break;
            }
            case 502: {
                unitValue = 0.001;
                break;
            }
            case 503: {
                unitValue = 60.0;
                break;
            }
            case 504: {
                unitValue = 3600.0;
                break;
            }
            case 505: {
                unitValue = 86400.0;
                break;
            }
            case 506: {
                unitValue = 604800.0;
                break;
            }
            case 507: {
                unitValue = 3.15576E7;
                break;
            }
            case 508: {
                unitValue = 1.0;
                break;
            }
            case 509: {
                unitValue = 0.001;
                break;
            }
            case 510: {
                unitValue = 1.0E-6;
                break;
            }
            case 511: {
                unitValue = 0.01;
                break;
            }
            case 512: {
                unitValue = 1000.0;
                break;
            }
            case 513: {
                unitValue = 0.0283495231;
                break;
            }
            case 514: {
                unitValue = 0.45359237;
                break;
            }
            case 601: {
                unitValue = 1.0;
                break;
            }
            case 602: {
                unitValue = 1024.0;
                break;
            }
            case 603: {
                unitValue = 1048576.0;
                break;
            }
            case 604: {
                unitValue = 1.073741824E9;
                break;
            }
            case 605: {
                unitValue = 1.099511627776E12;
                break;
            }
            case 606: {
                unitValue = 1.125899906842624E15;
                break;
            }
            case 607: {
                unitValue = 1.152921504606847E18;
                break;
            }
            case 608: {
                unitValue = 1.1805916207174113E21;
                break;
            }
            case 609: {
                unitValue = 1.2089258196146292E24;
                break;
            }
            case 610: {
                unitValue = 8.0;
                break;
            }
            case 611: {
                unitValue = 8192.0;
                break;
            }
            case 612: {
                unitValue = 8388608.0;
                break;
            }
            case 613: {
                unitValue = 8.589934592E9;
                break;
            }
            case 614: {
                unitValue = 8.796093022208E12;
                break;
            }
            case 615: {
                unitValue = 9.007199254740992E15;
                break;
            }
            case 616: {
                unitValue = 9.223372036854776E18;
                break;
            }
            case 617: {
                unitValue = 9.44473296573929E21;
                break;
            }
            case 618: {
                unitValue = 9.671406556917033E24;
                break;
            }
            case 701: {
                unitValue = 1.0;
                break;
            }
            case 702: {
                unitValue = 1.6021766208E-19;
                break;
            }
            case 703: {
                unitValue = 1.6021766208000002E-16;
                break;
            }
            case 704: {
                unitValue = 1.6021766208000001E-13;
                break;
            }
            case 705: {
                unitValue = 1.6021766208000002E-10;
                break;
            }
            case 706: {
                unitValue = 1.6021766208000002E-7;
                break;
            }
            case 801: {
                unitValue = 1.0;
                break;
            }
            case 802: {
                unitValue = 0.2777777777777778;
                break;
            }
            case 803: {
                unitValue = 0.44704;
                break;
            }
            case 804: {
                unitValue = 0.514444444;
                break;
            }
            case 901: {
                unitValue = 1.0;
                break;
            }
            case 902: {
                unitValue = 7.716049382716049E-5;
                break;
            }
            case 903: {
                unitValue = 1.2417777777777778E-4;
                break;
            }
            case 1001: {
                unitValue = 1.0;
                break;
            }
            case 1002: {
                unitValue = Math.PI / 180;
                break;
            }
            case 1003: {
                unitValue = 2.908882086657216E-4;
                break;
            }
            case 1004: {
                unitValue = 4.84813681109536E-6;
            }
        }
        this.setToNumber(pos, unitValue);
    }

    private void RANDOM_VARIABLE(int pos) {
        double rndVar = Double.NaN;
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                rndVar = ProbabilityDistributions.rndUniformContinuous(ProbabilityDistributions.randomGenerator);
                break;
            }
            case 2: {
                rndVar = ProbabilityDistributions.rndInteger(ProbabilityDistributions.randomGenerator);
                break;
            }
            case 3: {
                rndVar = ProbabilityDistributions.rndInteger(-10, 10, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 4: {
                rndVar = ProbabilityDistributions.rndInteger(-100, 100, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 5: {
                rndVar = ProbabilityDistributions.rndInteger(-1000, 1000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 6: {
                rndVar = ProbabilityDistributions.rndInteger(-10000, 10000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 7: {
                rndVar = ProbabilityDistributions.rndInteger(-100000, 100000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 8: {
                rndVar = ProbabilityDistributions.rndInteger(-1000000, 1000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 9: {
                rndVar = ProbabilityDistributions.rndInteger(-10000000, 10000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 10: {
                rndVar = ProbabilityDistributions.rndInteger(-100000000, 100000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 11: {
                rndVar = ProbabilityDistributions.rndInteger(-1000000000, 1000000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 12: {
                rndVar = ProbabilityDistributions.rndInteger(0, 0x7FFFFFFE, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 13: {
                rndVar = ProbabilityDistributions.rndInteger(0, 10, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 14: {
                rndVar = ProbabilityDistributions.rndInteger(0, 100, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 15: {
                rndVar = ProbabilityDistributions.rndInteger(0, 1000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 16: {
                rndVar = ProbabilityDistributions.rndInteger(0, 10000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 17: {
                rndVar = ProbabilityDistributions.rndInteger(0, 100000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 18: {
                rndVar = ProbabilityDistributions.rndInteger(0, 1000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 19: {
                rndVar = ProbabilityDistributions.rndInteger(0, 10000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 20: {
                rndVar = ProbabilityDistributions.rndInteger(0, 100000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 21: {
                rndVar = ProbabilityDistributions.rndInteger(0, 1000000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 22: {
                rndVar = ProbabilityDistributions.rndInteger(1, 0x7FFFFFFE, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 23: {
                rndVar = ProbabilityDistributions.rndInteger(1, 10, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 24: {
                rndVar = ProbabilityDistributions.rndInteger(1, 100, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 25: {
                rndVar = ProbabilityDistributions.rndInteger(1, 1000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 26: {
                rndVar = ProbabilityDistributions.rndInteger(1, 10000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 27: {
                rndVar = ProbabilityDistributions.rndInteger(1, 100000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 28: {
                rndVar = ProbabilityDistributions.rndInteger(1, 1000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 29: {
                rndVar = ProbabilityDistributions.rndInteger(1, 10000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 30: {
                rndVar = ProbabilityDistributions.rndInteger(1, 100000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 31: {
                rndVar = ProbabilityDistributions.rndInteger(1, 1000000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 32: {
                rndVar = ProbabilityDistributions.rndNormal(0.0, 1.0, ProbabilityDistributions.randomGenerator);
            }
        }
        this.setToNumber(pos, rndVar);
    }

    private double getTokenValue(int tokenIndex) {
        return this.tokensList.get((int)tokenIndex).tokenValue;
    }

    private void TETRATION(int pos) {
        double a = this.getTokenValue(pos - 1);
        double n = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, MathFunctions.tetration(a, n), true);
    }

    private void POWER(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, MathFunctions.power(a, b), true);
    }

    private void MODULO(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, MathFunctions.mod(a, b));
    }

    private void DIVIDE(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        if (this.disableRounding) {
            double result = Double.NaN;
            if (b != 0.0) {
                result = a / b;
            }
            this.opSetDecreaseRemove(pos, result, true);
        } else {
            this.opSetDecreaseRemove(pos, MathFunctions.div(a, b), true);
        }
    }

    private void MULTIPLY(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        if (this.disableRounding) {
            this.opSetDecreaseRemove(pos, a * b, true);
        } else {
            this.opSetDecreaseRemove(pos, MathFunctions.multiply(a, b), true);
        }
    }

    private void PLUS(int pos) {
        Token b = this.tokensList.get(pos + 1);
        if (pos > 0) {
            Token a = this.tokensList.get(pos - 1);
            if (a.tokenTypeId == 0 && b.tokenTypeId == 0) {
                if (this.disableRounding) {
                    this.opSetDecreaseRemove(pos, a.tokenValue + b.tokenValue, true);
                } else {
                    this.opSetDecreaseRemove(pos, MathFunctions.plus(a.tokenValue, b.tokenValue), true);
                }
            } else if (b.tokenTypeId == 0) {
                this.setToNumber(pos, b.tokenValue);
                this.tokensList.remove(pos + 1);
            }
        } else if (b.tokenTypeId == 0) {
            this.setToNumber(pos, b.tokenValue);
            this.tokensList.remove(pos + 1);
        }
    }

    private void MINUS(int pos) {
        Token b = this.tokensList.get(pos + 1);
        if (pos > 0) {
            Token a = this.tokensList.get(pos - 1);
            if (a.tokenTypeId == 0 && b.tokenTypeId == 0) {
                if (this.disableRounding) {
                    this.opSetDecreaseRemove(pos, a.tokenValue - b.tokenValue, true);
                } else {
                    this.opSetDecreaseRemove(pos, MathFunctions.minus(a.tokenValue, b.tokenValue), true);
                }
            } else if (b.tokenTypeId == 0) {
                this.setToNumber(pos, -b.tokenValue);
                this.tokensList.remove(pos + 1);
            }
        } else if (b.tokenTypeId == 0) {
            this.setToNumber(pos, -b.tokenValue);
            this.tokensList.remove(pos + 1);
        }
    }

    private void AND(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.and(a, b));
    }

    private void OR(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.or(a, b));
    }

    private void NAND(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.nand(a, b));
    }

    private void NOR(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.nor(a, b));
    }

    private void XOR(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.xor(a, b));
    }

    private void IMP(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.imp(a, b));
    }

    private void CIMP(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.cimp(a, b));
    }

    private void NIMP(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.nimp(a, b));
    }

    private void CNIMP(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.cnimp(a, b));
    }

    private void EQV(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.eqv(a, b));
    }

    private void NEG(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.setToNumber(pos, BooleanAlgebra.not(a));
        this.tokensList.remove(pos + 1);
    }

    private void EQ(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.eq(a, b));
    }

    private void NEQ(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.neq(a, b));
    }

    private void LT(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.lt(a, b));
    }

    private void GT(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.gt(a, b));
    }

    private void LEQ(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.leq(a, b));
    }

    private void GEQ(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.geq(a, b));
    }

    private void BITWISE_COMPL(int pos) {
        long a = (long)this.getTokenValue(pos + 1);
        this.setToNumber(pos, a ^ 0xFFFFFFFFFFFFFFFFL);
        this.tokensList.remove(pos + 1);
    }

    private void BITWISE_AND(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a & b);
    }

    private void BITWISE_OR(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a | b);
    }

    private void BITWISE_XOR(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a ^ b);
    }

    private void BITWISE_LEFT_SHIFT(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        int b = (int)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a << b);
    }

    private void BITWISE_RIGHT_SHIFT(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        int b = (int)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a >> b);
    }

    private void SIN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sin(a));
    }

    private void COS(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.cos(a));
    }

    private void TAN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.tan(a));
    }

    private void CTAN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.ctan(a));
    }

    private void SEC(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sec(a));
    }

    private void COSEC(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.cosec(a));
    }

    private void ASIN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.asin(a));
    }

    private void ACOS(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.acos(a));
    }

    private void ATAN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.atan(a));
    }

    private void ACTAN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.actan(a));
    }

    private void LN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.ln(a));
    }

    private void LOG2(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.log2(a));
    }

    private void LOG10(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.log10(a));
    }

    private void RAD(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.rad(a));
    }

    private void EXP(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.exp(a));
    }

    private void SQRT(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sqrt(a));
    }

    private void SINH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sinh(a));
    }

    private void COSH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.cosh(a));
    }

    private void TANH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.tanh(a));
    }

    private void COTH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.coth(a));
    }

    private void SECH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sech(a));
    }

    private void CSCH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.csch(a));
    }

    private void DEG(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.deg(a));
    }

    private void ABS(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.abs(a));
    }

    private void SGN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sgn(a));
    }

    private void FLOOR(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.floor(a));
    }

    private void CEIL(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.ceil(a));
    }

    private void ARSINH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arsinh(a));
    }

    private void ARCOSH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arcosh(a));
    }

    private void ARTANH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.artanh(a));
    }

    private void ARCOTH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arcoth(a));
    }

    private void ARSECH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arsech(a));
    }

    private void ARCSCH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arcsch(a));
    }

    private void SA(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sa(a));
    }

    private void SINC(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sinc(a));
    }

    private void BELL_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.bellNumber(n));
    }

    private void LUCAS_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.lucasNumber(n));
    }

    private void FIBONACCI_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.fibonacciNumber(n));
    }

    private void HARMONIC_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.harmonicNumber(n));
    }

    private void IS_PRIME(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, NumberTheory.primeTest(n));
    }

    private void PRIME_COUNT(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, NumberTheory.primeCount(n));
    }

    private void EXP_INT(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.exponentialIntegralEi(x));
    }

    private void LOG_INT(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.logarithmicIntegralLi(x));
    }

    private void OFF_LOG_INT(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.offsetLogarithmicIntegralLi(x));
    }

    private void FACT(int pos) {
        double a = this.getTokenValue(pos - 1);
        this.setToNumber(pos, MathFunctions.factorial(a));
        this.tokensList.remove(pos - 1);
    }

    private void PERC(int pos) {
        double a = this.getTokenValue(pos - 1);
        this.setToNumber(pos, a * 0.01);
        this.tokensList.remove(pos - 1);
    }

    private void NOT(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, BooleanAlgebra.not(a));
    }

    private void GAUSS_ERF(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.erf(x));
    }

    private void GAUSS_ERFC(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.erfc(x));
    }

    private void GAUSS_ERF_INV(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.erfInv(x));
    }

    private void GAUSS_ERFC_INV(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.erfcInv(x));
    }

    private void ULP(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.ulp(x));
    }

    private void ISNAN(int pos) {
        double x = this.getTokenValue(pos + 1);
        if (Double.isNaN(x)) {
            this.f1SetDecreaseRemove(pos, 1.0);
        } else {
            this.f1SetDecreaseRemove(pos, 0.0);
        }
    }

    private void NDIG10(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, NumberTheory.numberOfDigits(x));
    }

    private void NFACT(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, NumberTheory.numberOfPrimeFactors(n));
    }

    private void ARCSEC(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.asec(x));
    }

    private void ARCCSC(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.acosec(x));
    }

    private void GAMMA(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.gamma(x));
    }

    private void LAMBERT_W0(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.lambertW(x, 0.0));
    }

    private void LAMBERT_W1(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.lambertW(x, -1.0));
    }

    private void SGN_GAMMA(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.sgnGamma(x));
    }

    private void LOG_GAMMA(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.logGamma(x));
    }

    private void DI_GAMMA(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.diGamma(x));
    }

    private void UDF_PARAM(int pos) {
        double value = Double.NaN;
        double x = this.getTokenValue(pos + 1);
        int npar = this.UDFVariadicParamsAtRunTime.size();
        if (!Double.isNaN(x) && x != Double.POSITIVE_INFINITY && x != Double.NEGATIVE_INFINITY) {
            int i = (int)MathFunctions.integerPart(x);
            if (i == 0) {
                value = npar;
            } else if (Math.abs(i) <= npar) {
                if (i >= 1) {
                    value = this.UDFVariadicParamsAtRunTime.get(i - 1);
                } else if (i <= -1) {
                    value = this.UDFVariadicParamsAtRunTime.get(npar + i);
                }
            }
        }
        this.f1SetDecreaseRemove(pos, value);
    }

    private void LOG(int pos) {
        double b = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.log(a, b));
    }

    private List<Double> getNumbers(int pos) {
        ArrayList<Double> numbers = new ArrayList<Double>();
        int pn = pos;
        int lastIndex = this.tokensList.size() - 1;
        boolean end = false;
        do {
            Token t = this.tokensList.get(++pn);
            boolean isNumber = false;
            if (t.tokenTypeId == 0 && t.tokenId == 1) {
                isNumber = true;
                numbers.add(t.tokenValue);
            }
            if (pn != lastIndex && isNumber) continue;
            end = true;
        } while (!end);
        return numbers;
    }

    private void MOD(int pos) {
        double a = this.getTokenValue(pos + 1);
        double b = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.mod(a, b));
    }

    private void BINOM_COEFF(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.binomCoeff(n, k));
    }

    private void PERMUTATIONS(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.numberOfPermutations(n, k));
    }

    private void BETA(int pos) {
        double x = this.getTokenValue(pos + 1);
        double y = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, SpecialFunctions.beta(x, y));
    }

    private void LOG_BETA(int pos) {
        double x = this.getTokenValue(pos + 1);
        double y = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, SpecialFunctions.logBeta(x, y));
    }

    private void BERNOULLI_NUMBER(int pos) {
        double m = this.getTokenValue(pos + 1);
        double n = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.bernoulliNumber(m, n));
    }

    private void STIRLING1_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.Stirling1Number(n, k));
    }

    private void STIRLING2_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.Stirling2Number(n, k));
    }

    private void WORPITZKY_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.worpitzkyNumber(n, k));
    }

    private void EULER_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.eulerNumber(n, k));
    }

    private void KRONECKER_DELTA(int pos) {
        double i = this.getTokenValue(pos + 1);
        double j = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.kroneckerDelta(i, j));
    }

    private void EULER_POLYNOMIAL(int pos) {
        double m = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.eulerPolynomial(m, x));
    }

    private void HARMONIC2_NUMBER(int pos) {
        double x = this.getTokenValue(pos + 1);
        double n = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.harmonicNumber(x, n));
    }

    private void ROUND(int pos) {
        double value = this.getTokenValue(pos + 1);
        int places = (int)this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.round(value, places));
    }

    private void RND_VAR_UNIFORM_CONT(int pos) {
        double a = this.getTokenValue(pos + 1);
        double b = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.rndUniformContinuous(a, b, ProbabilityDistributions.randomGenerator));
    }

    private void RND_VAR_UNIFORM_DISCR(int pos) {
        int a = (int)this.getTokenValue(pos + 1);
        int b = (int)this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.rndInteger(a, b, ProbabilityDistributions.randomGenerator));
    }

    private void RND_NORMAL(int pos) {
        double mean = this.getTokenValue(pos + 1);
        double stddev = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.rndNormal(mean, stddev, ProbabilityDistributions.randomGenerator));
    }

    private void NDIG(int pos) {
        double number = this.getTokenValue(pos + 1);
        double numeralSystemBase = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, NumberTheory.numberOfDigits(number, numeralSystemBase));
    }

    private void DIGIT10(int pos) {
        double number = this.getTokenValue(pos + 1);
        double position = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, NumberTheory.digitAtPosition(number, position));
    }

    private void FACTVAL(int pos) {
        double number = this.getTokenValue(pos + 1);
        double id = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, NumberTheory.primeFactorValue(number, id));
    }

    private void FACTEXP(int pos) {
        double number = this.getTokenValue(pos + 1);
        double id = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, NumberTheory.primeFactorExponent(number, id));
    }

    private void ROOT(int pos) {
        double n = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.root(n, x));
    }

    private void INC_GAMMA_LOWER(int pos) {
        double s = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, SpecialFunctions.incompleteGammaLower(s, x));
    }

    private void INC_GAMMA_UPPER(int pos) {
        double s = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, SpecialFunctions.incompleteGammaUpper(s, x));
    }

    private void REG_GAMMA_LOWER(int pos) {
        double s = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, SpecialFunctions.regularizedGammaLowerP(s, x));
    }

    private void REG_GAMMA_UPPER(int pos) {
        double s = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, SpecialFunctions.regularizedGammaUpperQ(s, x));
    }

    private void IF_CONDITION(int pos) {
        List<FunctionParameter> ifParams = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter ifParam = ifParams.get(0);
        Expression ifExp = new Expression(ifParam.paramStr, ifParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        if (this.verboseMode) {
            ifExp.setVerboseMode();
        }
        this.ifSetRemove(pos, ifExp.calculate());
    }

    private void IFF(int pos) {
        List<FunctionParameter> iffParams = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter iffParam = iffParams.get(0);
        int parametersNumber = iffParams.size();
        int paramNumber = 1;
        double iffValue = 0.0;
        boolean iffCon = true;
        do {
            Expression iffExp = new Expression(iffParam.paramStr, iffParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            if (this.verboseMode) {
                iffExp.setVerboseMode();
            }
            iffCon = true;
            iffValue = iffExp.calculate();
            if (iffValue != 0.0 && !Double.isNaN(iffValue)) continue;
            iffCon = false;
            if ((paramNumber += 2) >= parametersNumber) continue;
            iffParam = iffParams.get(paramNumber - 1);
        } while (!iffCon && paramNumber < parametersNumber);
        if (iffCon) {
            int p;
            int trueParamNumber = paramNumber + 1;
            int from = pos + 1;
            int to = iffParams.get((int)(parametersNumber - 1)).toIndex + 1;
            --this.tokensList.get((int)from).tokenLevel;
            --this.tokensList.get((int)to).tokenLevel;
            if (trueParamNumber < parametersNumber) {
                to = iffParams.get((int)(parametersNumber - 1)).toIndex;
                from = iffParams.get((int)trueParamNumber).fromIndex - 1;
                for (p = to; p >= from; --p) {
                    this.tokensList.remove(p);
                }
            }
            from = iffParams.get((int)(trueParamNumber - 1)).fromIndex;
            to = iffParams.get((int)(trueParamNumber - 1)).toIndex;
            for (p = from; p <= to; ++p) {
                --this.tokensList.get((int)p).tokenLevel;
            }
            to = from - 1;
            from = pos;
            for (p = to; p >= from; --p) {
                if (p == pos + 1) continue;
                this.tokensList.remove(p);
            }
        } else {
            int to = iffParams.get((int)(parametersNumber - 1)).toIndex + 1;
            int from = pos + 1;
            for (int p = to; p >= from; --p) {
                this.tokensList.remove(p);
            }
            this.setToNumber(pos, Double.NaN);
            --this.tokensList.get((int)pos).tokenLevel;
        }
    }

    private void IF(int pos) {
        double ifFalse;
        double ifCondition = this.tokensList.get((int)(pos + 1)).tokenValue;
        double ifTrue = this.tokensList.get((int)(pos + 2)).tokenValue;
        double result = ifFalse = this.tokensList.get((int)(pos + 3)).tokenValue;
        if (ifCondition != 0.0) {
            result = ifTrue;
        }
        if (ifCondition == Double.NaN) {
            result = Double.NaN;
        }
        this.f3SetDecreaseRemove(pos, result);
    }

    private void CHI(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, MathFunctions.chi(x, a, b));
    }

    private void CHI_LR(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, MathFunctions.chi_LR(x, a, b));
    }

    private void CHI_L(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, MathFunctions.chi_L(x, a, b));
    }

    private void CHI_R(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, MathFunctions.chi_R(x, a, b));
    }

    private void PDF_UNIFORM_CONT(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.pdfUniformContinuous(x, a, b));
    }

    private void CDF_UNIFORM_CONT(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.cdfUniformContinuous(x, a, b));
    }

    private void QNT_UNIFORM_CONT(int pos) {
        double q = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.qntUniformContinuous(q, a, b));
    }

    private void PDF_NORMAL(int pos) {
        double x = this.getTokenValue(pos + 1);
        double mean = this.getTokenValue(pos + 2);
        double stddev = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.pdfNormal(x, mean, stddev));
    }

    private void CDF_NORMAL(int pos) {
        double x = this.getTokenValue(pos + 1);
        double mean = this.getTokenValue(pos + 2);
        double stddev = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.cdfNormal(x, mean, stddev));
    }

    private void QNT_NORMAL(int pos) {
        double q = this.getTokenValue(pos + 1);
        double mean = this.getTokenValue(pos + 2);
        double stddev = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.qntNormal(q, mean, stddev));
    }

    private void DIGIT(int pos) {
        double number = this.getTokenValue(pos + 1);
        double position = this.getTokenValue(pos + 2);
        double numeralSystemBase = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, NumberTheory.digitAtPosition(number, position, numeralSystemBase));
    }

    private void INC_BETA(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, SpecialFunctions.incompleteBeta(a, b, x));
    }

    private void REG_BETA(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, SpecialFunctions.regularizedBeta(a, b, x));
    }

    private void updateMissingTokens(List<Token> tokens, String keyWord, int tokenId, int tokenTypeId) {
        for (Token t : tokens) {
            if (t.tokenTypeId != -1 || !t.tokenStr.equals(keyWord)) continue;
            t.keyWord = keyWord;
            t.tokenId = tokenId;
            t.tokenTypeId = tokenTypeId;
        }
    }

    private void updateMissingTokens(ArgumentParameter index, IterativeOperatorParameters iterParams) {
        if (index.presence == -1) {
            this.updateMissingTokens(iterParams.indexParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
            this.updateMissingTokens(iterParams.fromParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
            this.updateMissingTokens(iterParams.toParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
            this.updateMissingTokens(iterParams.funParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
        }
    }

    private void evalFromToDeltaParameters(ArgumentParameter index, IterativeOperatorParameters iterParams) {
        iterParams.fromExp = new Expression(iterParams.fromParam.paramStr, iterParams.fromParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        iterParams.toExp = new Expression(iterParams.toParam.paramStr, iterParams.toParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        iterParams.funExp = new Expression(iterParams.funParam.paramStr, iterParams.funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        iterParams.deltaExp = null;
        if (this.verboseMode) {
            iterParams.fromExp.setVerboseMode();
            iterParams.toExp.setVerboseMode();
            iterParams.funExp.setVerboseMode();
        }
        iterParams.from = iterParams.fromExp.calculate();
        iterParams.to = iterParams.toExp.calculate();
        iterParams.delta = 1.0;
        if (iterParams.to < iterParams.from) {
            iterParams.delta = -1.0;
        }
        if (iterParams.withDelta) {
            iterParams.deltaExp = new Expression(iterParams.deltaParam.paramStr, iterParams.deltaParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            if (index.presence == -1) {
                this.updateMissingTokens(iterParams.deltaParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
            }
            if (this.verboseMode) {
                iterParams.deltaExp.setVerboseMode();
            }
            iterParams.delta = iterParams.deltaExp.calculate();
        }
    }

    private void SUM(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double sigma = NumberTheory.sigmaSummation(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, sigma, true);
    }

    private void PROD(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double product = NumberTheory.piProduct(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, product, true);
    }

    private void MIN(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double min = NumberTheory.min(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, min);
    }

    private void MAX(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double max = NumberTheory.max(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, max);
    }

    private void AVG(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double avg = Statistics.avg(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, avg, true);
    }

    private void VAR(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double var = Statistics.var(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, var, true);
    }

    private void STD(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double std = Statistics.std(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, std, true);
    }

    private void DERIVATIVE(int pos, int derivativeType) {
        List<FunctionParameter> derParams = this.getFunctionParameters(pos, this.tokensList);
        double DEF_EPS = 1.0E-8;
        int DEF_MAX_STEPS = 20;
        FunctionParameter funParam = derParams.get(0);
        FunctionParameter xParam = derParams.get(1);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        if (x.presence == -1) {
            this.updateMissingTokens(xParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(funParam.tokens, xParam.paramStr, x.index, 101);
        }
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        double x0 = Double.NaN;
        if (derParams.size() == 2 || derParams.size() == 4) {
            x0 = x.argument.getArgumentValue();
        }
        if (derParams.size() == 3 || derParams.size() == 5) {
            FunctionParameter x0Param = derParams.get(2);
            if (x.presence == -1) {
                this.updateMissingTokens(x0Param.tokens, xParam.paramStr, x.index, 101);
            }
            Expression x0Expr = new Expression(x0Param.paramStr, x0Param.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            x0 = x0Expr.calculate();
        }
        double eps = 1.0E-8;
        int maxSteps = 20;
        if (derParams.size() == 4 || derParams.size() == 5) {
            FunctionParameter maxStepsParam;
            FunctionParameter epsParam;
            if (derParams.size() == 4) {
                epsParam = derParams.get(2);
                maxStepsParam = derParams.get(3);
            } else {
                epsParam = derParams.get(3);
                maxStepsParam = derParams.get(4);
            }
            if (x.presence == -1) {
                this.updateMissingTokens(epsParam.tokens, xParam.paramStr, x.index, 101);
                this.updateMissingTokens(maxStepsParam.tokens, xParam.paramStr, x.index, 101);
            }
            Expression epsExpr = new Expression(epsParam.paramStr, epsParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            Expression maxStepsExp = new Expression(maxStepsParam.paramStr, maxStepsParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            eps = epsExpr.calculate();
            maxSteps = (int)Math.round(maxStepsExp.calculate());
        }
        if (derivativeType == 3) {
            double general = Calculus.derivative(funExp, x.argument, x0, 3, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, general);
        } else if (derivativeType == 1) {
            double left = Calculus.derivative(funExp, x.argument, x0, 1, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, left);
        } else {
            double right = Calculus.derivative(funExp, x.argument, x0, 2, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, right);
        }
        this.clearParamArgument(x);
    }

    private void DERIVATIVE_NTH(int pos, int derivativeType) {
        double DEF_EPS = 1.0E-6;
        int DEF_MAX_STEPS = 20;
        List<FunctionParameter> derParams = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = derParams.get(0);
        FunctionParameter nParam = derParams.get(1);
        FunctionParameter xParam = derParams.get(2);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        if (x.presence == -1) {
            this.updateMissingTokens(xParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(funParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(nParam.tokens, xParam.paramStr, x.index, 101);
        }
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression nExp = new Expression(nParam.paramStr, nParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        double n = nExp.calculate();
        double x0 = x.argument.getArgumentValue();
        double eps = 1.0E-6;
        int maxSteps = 20;
        if (derParams.size() == 5) {
            FunctionParameter epsParam = derParams.get(3);
            FunctionParameter maxStepsParam = derParams.get(4);
            if (x.presence == -1) {
                this.updateMissingTokens(epsParam.tokens, xParam.paramStr, x.index, 101);
                this.updateMissingTokens(maxStepsParam.tokens, xParam.paramStr, x.index, 101);
            }
            Expression epsExpr = new Expression(epsParam.paramStr, epsParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            Expression maxStepsExp = new Expression(maxStepsParam.paramStr, maxStepsParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            eps = epsExpr.calculate();
            maxSteps = (int)Math.round(maxStepsExp.calculate());
        }
        if (derivativeType == 3) {
            double left = Calculus.derivativeNth(funExp, n, x.argument, x0, 1, eps, maxSteps);
            double right = Calculus.derivativeNth(funExp, n, x.argument, x0, 2, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, (left + right) / 2.0);
        } else if (derivativeType == 1) {
            double left = Calculus.derivativeNth(funExp, n, x.argument, x0, 1, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, left);
        } else {
            double right = Calculus.derivativeNth(funExp, n, x.argument, x0, 2, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, right);
        }
        this.clearParamArgument(x);
    }

    private void INTEGRAL(int pos) {
        double DEF_EPS = 1.0E-6;
        int DEF_MAX_STEPS = 20;
        List<FunctionParameter> intParams = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = intParams.get(0);
        FunctionParameter xParam = intParams.get(1);
        FunctionParameter aParam = intParams.get(2);
        FunctionParameter bParam = intParams.get(3);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        if (x.presence == -1) {
            this.updateMissingTokens(xParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(funParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(aParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(bParam.tokens, xParam.paramStr, x.index, 101);
        }
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression aExp = new Expression(aParam.paramStr, aParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression bExp = new Expression(bParam.paramStr, bParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        double eps = 1.0E-6;
        int maxSteps = 20;
        this.calcSetDecreaseRemove(pos, Calculus.integralTrapezoid(funExp, x.argument, aExp.calculate(), bExp.calculate(), eps, maxSteps));
        this.clearParamArgument(x);
    }

    private void SOLVE(int pos) {
        double DEF_EPS = 1.0E-9;
        int DEF_MAX_STEPS = 100;
        List<FunctionParameter> intParams = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = intParams.get(0);
        FunctionParameter xParam = intParams.get(1);
        FunctionParameter aParam = intParams.get(2);
        FunctionParameter bParam = intParams.get(3);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        if (x.presence == -1) {
            this.updateMissingTokens(xParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(funParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(aParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(bParam.tokens, xParam.paramStr, x.index, 101);
        }
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression aExp = new Expression(aParam.paramStr, aParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        Expression bExp = new Expression(bParam.paramStr, bParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        double eps = 1.0E-9;
        int maxSteps = 100;
        this.calcSetDecreaseRemove(pos, Calculus.solveBrent(funExp, x.argument, aExp.calculate(), bExp.calculate(), eps, maxSteps));
        this.clearParamArgument(x);
    }

    private void FORWARD_DIFFERENCE(int pos) {
        List<FunctionParameter> params = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = params.get(0);
        FunctionParameter xParam = params.get(1);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        if (this.verboseMode) {
            funExp.setVerboseMode();
        }
        double h = 1.0;
        if (params.size() == 3) {
            FunctionParameter hParam = params.get(2);
            Expression hExp = new Expression(hParam.paramStr, hParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            if (this.verboseMode) {
                hExp.setVerboseMode();
            }
            h = hExp.calculate();
        }
        this.calcSetDecreaseRemove(pos, Calculus.forwardDifference(funExp, h, x.argument));
        this.clearParamArgument(x);
    }

    private void BACKWARD_DIFFERENCE(int pos) {
        List<FunctionParameter> params = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = params.get(0);
        FunctionParameter xParam = params.get(1);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
        if (this.verboseMode) {
            funExp.setVerboseMode();
        }
        double h = 1.0;
        if (params.size() == 3) {
            FunctionParameter hParam = params.get(2);
            Expression hExp = new Expression(hParam.paramStr, hParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true, this.UDFExpression, this.UDFVariadicParamsAtRunTime);
            if (this.verboseMode) {
                hExp.setVerboseMode();
            }
            h = hExp.calculate();
        }
        this.calcSetDecreaseRemove(pos, Calculus.backwardDifference(funExp, h, x.argument));
        this.clearParamArgument(x);
    }

    private void MIN_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.min(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void MAX_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.max(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void SUM_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.sum(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void PROD_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.prod(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void AVG_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.avg(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void VAR_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.var(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void STD_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.std(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void CONTINUED_FRACTION(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, MathFunctions.continuedFraction(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void CONTINUED_POLYNOMIAL(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, MathFunctions.continuedPolynomial(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void GCD(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.gcd(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void LCM(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.lcm(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void RND_LIST(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        int n = numbers.size();
        int i = ProbabilityDistributions.rndIndex(n, ProbabilityDistributions.randomGenerator);
        this.variadicSetDecreaseRemove(pos, numbers.get(i), numbers.size());
    }

    private void COALESCE(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, MathFunctions.coalesce(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void OR_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, BooleanAlgebra.orVariadic(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void AND_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, BooleanAlgebra.andVariadic(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void XOR_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, BooleanAlgebra.xorVariadic(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void ARGMIN_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.argmin(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void ARGMAX_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.argmax(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void MEDIAN_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.median(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void MODE_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.mode(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void BASE_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.convOthBase2Decimal(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void NDIST_VARIADIC(int pos) {
        List<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.numberOfDistValues(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void COMMA(int pos) {
        this.tokensList.remove(pos);
    }

    private void PARENTHESES(int lPos, int rPos) {
        for (int p = lPos; p <= rPos; ++p) {
            --this.tokensList.get((int)p).tokenLevel;
        }
        this.tokensList.remove(rPos);
        this.tokensList.remove(lPos);
    }

    public boolean checkLexSyntax() {
        boolean syntax = true;
        this.recursionCallsCounter = 0;
        if (this.expressionString.length() == 0) {
            syntax = false;
            this.errorMessage = "Empty expression string\n";
            return syntax;
        }
        SyntaxChecker syn = new SyntaxChecker(new ByteArrayInputStream(this.expressionString.getBytes()));
        try {
            syn.checkSyntax();
        }
        catch (Exception e) {
            syntax = false;
            this.errorMessage = "lexical error \n\n" + e.getMessage() + "\n";
        }
        return syntax;
    }

    public boolean checkSyntax() {
        boolean syntax = this.checkSyntax("[" + this.expressionString + "] ", false);
        return syntax;
    }

    private int checkCalculusParameter(String param) {
        int errors = 0;
        for (KeyWord kw : this.keyWordsList) {
            if (kw.wordTypeId == 101 || !param.equals(kw.wordString)) continue;
            ++errors;
        }
        return errors;
    }

    private boolean checkIfKnownArgument(FunctionParameter param) {
        if (param.tokens.size() > 1) {
            return false;
        }
        Token t = param.tokens.get(0);
        return t.tokenTypeId == 101;
    }

    private boolean checkIfUnknownToken(FunctionParameter param) {
        if (param.tokens.size() > 1) {
            return false;
        }
        Token t = param.tokens.get(0);
        return t.tokenTypeId == -1;
    }

    private boolean checkSyntax(String level, boolean functionWithBodyExt) {
        if (!this.expressionWasModified && this.syntaxStatus && this.optionsChangesetNumber == mXparser.optionsChangesetNumber) {
            this.errorMessage = level + "already checked - no errors!\n";
            this.recursionCallPending = false;
            return true;
        }
        this.optionsChangesetNumber = mXparser.optionsChangesetNumber;
        if (functionWithBodyExt) {
            this.syntaxStatus = true;
            this.recursionCallPending = false;
            this.expressionWasModified = false;
            this.errorMessage = this.errorMessage + level + "function with extended body - assuming no errors.\n";
            return true;
        }
        this.recursionCallPending = true;
        this.errorMessage = level + "checking ...\n";
        boolean syntax = true;
        if (this.expressionString.length() == 0) {
            syntax = false;
            this.errorMessage = this.errorMessage + level + "Empty expression string\n";
            this.syntaxStatus = syntax;
            this.recursionCallPending = false;
            return syntax;
        }
        SyntaxChecker syn = new SyntaxChecker(new ByteArrayInputStream(this.expressionString.getBytes()));
        try {
            syn.checkSyntax();
            this.tokenizeExpressionString();
            Collections.sort(this.keyWordsList, new KwStrComparator());
            for (int kwId = 1; kwId < this.keyWordsList.size(); ++kwId) {
                String kw1 = this.keyWordsList.get((int)(kwId - 1)).wordString;
                String kw2 = this.keyWordsList.get((int)kwId).wordString;
                if (!kw1.equals(kw2)) continue;
                syntax = false;
                this.errorMessage = this.errorMessage + level + "(" + kw1 + ") Duplicated <KEYWORD>.\n";
            }
            int tokensNumber = this.initialTokens.size();
            Stack<SyntaxStackElement> syntaxStack = new Stack<SyntaxStackElement>();
            for (int tokenIndex = 0; tokenIndex < tokensNumber; ++tokenIndex) {
                boolean syntaxRec;
                Argument arg;
                Token t = this.initialTokens.get(tokenIndex);
                String tokenStr = "(" + t.tokenStr + ", " + tokenIndex + ") ";
                if (t.tokenTypeId == 101) {
                    arg = this.getArgument(t.tokenId);
                    if (this.getParametersNumber(tokenIndex) >= 0) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "<ARGUMENT> was expected.\n";
                    } else if (arg.getArgumentBodyType() == 1) {
                        if (arg.getArgumentType() == 2 && arg.argumentExpression != this && !arg.argumentExpression.recursionCallPending) {
                            syntaxRec = arg.argumentExpression.checkSyntax(level + "-> [" + t.tokenStr + "] = [" + arg.argumentExpression.getExpressionString() + "] ", false);
                            syntax = syntax && syntaxRec;
                            this.errorMessage = this.errorMessage + level + tokenStr + "checking dependent argument ...\n" + arg.argumentExpression.getErrorMessage();
                        }
                    } else {
                        this.errorMessage = this.errorMessage + level + tokenStr + "argument with extended body - assuming no errors.\n";
                    }
                }
                if (t.tokenTypeId == 102) {
                    arg = this.getArgument(t.tokenId);
                    if (this.getParametersNumber(tokenIndex) != 1) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "<RECURSIVE_ARGUMENT> expecting 1 parameter.\n";
                    } else if (arg.argumentExpression != this && !arg.argumentExpression.recursionCallPending) {
                        syntaxRec = arg.argumentExpression.checkSyntax(level + "-> [" + t.tokenStr + "] = [" + arg.argumentExpression.getExpressionString() + "] ", false);
                        syntax = syntax && syntaxRec;
                        this.errorMessage = this.errorMessage + level + tokenStr + "checking recursive argument ...\n" + arg.argumentExpression.getErrorMessage();
                    }
                }
                if (t.tokenTypeId == -1) {
                    boolean calculusToken = false;
                    for (SyntaxStackElement e : syntaxStack) {
                        if (!e.tokenStr.equals(t.tokenStr)) continue;
                        calculusToken = true;
                    }
                    if (!calculusToken) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "invalid <TOKEN>.\n";
                    }
                }
                if (t.tokenTypeId == 103) {
                    Function fun = this.getFunction(t.tokenId);
                    fun.checkRecursiveMode();
                    int npar = this.getParametersNumber(tokenIndex);
                    int fpar = fun.getParametersNumber();
                    if (npar == 0) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "<USER_DEFINED_FUNCTION> expecting at least one argument.\n";
                    } else if (!fun.isVariadic && fpar != npar) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "<USER_DEFINED_FUNCTION> expecting " + fpar + " arguments.\n";
                    } else if (fun.functionExpression != this && !fun.functionExpression.recursionCallPending) {
                        boolean syntaxRec2 = fun.getFunctionBodyType() == 1 ? fun.functionExpression.checkSyntax(level + "-> [" + t.tokenStr + "] = [" + fun.functionExpression.getExpressionString() + "] ", false) : fun.functionExpression.checkSyntax(level + "-> [" + t.tokenStr + "] = [" + fun.functionExpression.getExpressionString() + "] ", true);
                        syntax = syntax && syntaxRec2;
                        this.errorMessage = fun.isVariadic ? this.errorMessage + level + tokenStr + "checking variadic user defined function ...\n" + fun.functionExpression.getErrorMessage() : this.errorMessage + level + tokenStr + "checking user defined function ...\n" + fun.functionExpression.getErrorMessage();
                    }
                }
                if (t.tokenTypeId == 9 && this.getParametersNumber(tokenIndex) >= 0) {
                    syntax = false;
                    this.errorMessage = this.errorMessage + level + tokenStr + "<CONSTANT> was expected.\n";
                }
                if (t.tokenTypeId == 104 && this.getParametersNumber(tokenIndex) >= 0) {
                    syntax = false;
                    this.errorMessage = this.errorMessage + level + tokenStr + "<USER_DEFINED_CONSTANT> was expected.\n";
                }
                if (t.tokenTypeId == 4 && this.getParametersNumber(tokenIndex) != 1) {
                    syntax = false;
                    this.errorMessage = this.errorMessage + level + tokenStr + "<FUNCTION> expecting 1 argument.\n";
                }
                if (t.tokenTypeId == 5 && this.getParametersNumber(tokenIndex) != 2) {
                    syntax = false;
                    this.errorMessage = this.errorMessage + level + tokenStr + "<FUNCTION> expecting 2 arguments.\n";
                }
                if (t.tokenTypeId == 6 && this.getParametersNumber(tokenIndex) != 3) {
                    syntax = false;
                    this.errorMessage = this.errorMessage + level + tokenStr + "<FUNCTION> expecting 3 arguments.\n";
                }
                if (t.tokenTypeId == 8) {
                    int errors;
                    SyntaxStackElement stackElement;
                    int paramsNumber = this.getParametersNumber(tokenIndex);
                    List<FunctionParameter> funParams = null;
                    if (paramsNumber > 0) {
                        funParams = this.getFunctionParameters(tokenIndex, this.initialTokens);
                    }
                    if (t.tokenId == 6 || t.tokenId == 7 || t.tokenId == 8) {
                        if (paramsNumber < 2 || paramsNumber > 5) {
                            syntax = false;
                            this.errorMessage = this.errorMessage + level + tokenStr + "<DERIVATIVE> expecting 2 or 3 or 4 or 5 calculus parameters.\n";
                        } else if (paramsNumber == 2 || paramsNumber == 4) {
                            FunctionParameter argParam = funParams.get(1);
                            if (!this.checkIfKnownArgument(argParam)) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "<DERIVATIVE> argument was expected.\n";
                            }
                        } else {
                            FunctionParameter argParam = funParams.get(1);
                            stackElement = new SyntaxStackElement(argParam.paramStr, t.tokenLevel + 1);
                            syntaxStack.push(stackElement);
                            errors = this.checkCalculusParameter(stackElement.tokenStr);
                            if (errors > 0) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "<DERIVATIVE> Found duplicated key words for calculus parameter (" + stackElement.tokenStr + ", " + errors + ").\n";
                            }
                            if (!this.checkIfKnownArgument(argParam) && !this.checkIfUnknownToken(argParam)) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "<DERIVATIVE> One token (argument or unknown) was expected.\n";
                            }
                        }
                    }
                    if (t.tokenId == 9) {
                        if (paramsNumber != 3 && paramsNumber != 5) {
                            syntax = false;
                            this.errorMessage = this.errorMessage + level + tokenStr + "<NTH_DERIVATIVE> expecting 3 or 5 calculus arguments.\n";
                        } else {
                            FunctionParameter argParam = funParams.get(2);
                            if (!this.checkIfKnownArgument(argParam)) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "<DERIVATIVE> argument was expected.\n";
                            }
                        }
                    }
                    if (t.tokenId == 5 || t.tokenId == 17) {
                        if (paramsNumber != 4) {
                            syntax = false;
                            this.errorMessage = this.errorMessage + level + tokenStr + "<INTEGRAL/SOLVE> expecting 4 calculus arguments.\n";
                        } else {
                            FunctionParameter argParam = funParams.get(1);
                            stackElement = new SyntaxStackElement(argParam.paramStr, t.tokenLevel + 1);
                            syntaxStack.push(stackElement);
                            errors = this.checkCalculusParameter(stackElement.tokenStr);
                            if (errors > 0) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "Found duplicated key words for calculus parameter (" + stackElement.tokenStr + ", " + errors + ").\n";
                            }
                            if (!this.checkIfKnownArgument(argParam) && !this.checkIfUnknownToken(argParam)) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "One token (argument or unknown) was expected.\n";
                            }
                        }
                    }
                    if (t.tokenId == 3 || t.tokenId == 1 || t.tokenId == 15 || t.tokenId == 16 || t.tokenId == 12 || t.tokenId == 13 || t.tokenId == 14) {
                        if (paramsNumber != 4 && paramsNumber != 5) {
                            syntax = false;
                            this.errorMessage = this.errorMessage + level + tokenStr + "<ITER_OPERATOR> expecting 4 or 5 calculus arguments.\n";
                        } else {
                            FunctionParameter indexParam = funParams.get(0);
                            stackElement = new SyntaxStackElement(indexParam.paramStr, t.tokenLevel + 1);
                            syntaxStack.push(stackElement);
                            errors = this.checkCalculusParameter(stackElement.tokenStr);
                            if (errors > 0) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "Found duplicated key words for calculus parameter (" + stackElement.tokenStr + ", " + errors + ").\n";
                            }
                            if (!this.checkIfKnownArgument(indexParam) && !this.checkIfUnknownToken(indexParam)) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "One token (argument or unknown) was expected.\n";
                            }
                        }
                    }
                    if (t.tokenId == 10 || t.tokenId == 11) {
                        if (paramsNumber != 2 && paramsNumber != 3) {
                            syntax = false;
                            this.errorMessage = this.errorMessage + level + tokenStr + "<DIFF> expecting 2 or 3 arguments.\n";
                        } else {
                            FunctionParameter xParam = funParams.get(1);
                            if (!this.checkIfKnownArgument(xParam)) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "<DIFF> argument was expected.\n";
                            }
                        }
                    }
                }
                if (t.tokenTypeId == 7) {
                    int paramsNumber = this.getParametersNumber(tokenIndex);
                    if (paramsNumber < 1) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "At least one argument was expected.\n";
                    }
                    if (t.tokenId == 1 && (paramsNumber % 2 != 0 || paramsNumber < 2)) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "Expecting parity number of arguments.\n";
                    }
                }
                if (t.tokenTypeId != 20 || t.tokenId != 2 || syntaxStack.size() <= 0 || t.tokenLevel != ((SyntaxStackElement)syntaxStack.lastElement()).tokenLevel) continue;
                syntaxStack.pop();
            }
        }
        catch (Exception e) {
            syntax = false;
            this.errorMessage = this.errorMessage + level + "lexical error \n\n" + e.getMessage() + "\n";
        }
        if (syntax) {
            this.errorMessage = this.errorMessage + level + "no errors.\n";
            this.expressionWasModified = false;
        } else {
            this.errorMessage = this.errorMessage + level + "errors were found.\n";
            this.expressionWasModified = true;
        }
        this.syntaxStatus = syntax;
        this.recursionCallPending = false;
        return syntax;
    }

    public double calculate() {
        double resultint;
        this.computingTime = 0.0;
        long startTime = System.currentTimeMillis();
        if (this.verboseMode) {
            this.printSystemInfo("\n", false);
            this.printSystemInfo("\n", true);
            this.printSystemInfo("Starting ...\n", true);
            this.showArguments();
        }
        if (this.expressionWasModified || !this.syntaxStatus) {
            this.syntaxStatus = this.checkSyntax();
        }
        if (!this.syntaxStatus) {
            this.errorMessage = this.errorMessage + "Problem with expression syntax\n";
            if (this.verboseMode) {
                this.printSystemInfo("syntaxStatus == SYNTAX_ERROR_OR_STATUS_UNKNOWN, returning Double.NaN\n", false);
            }
            this.recursionCallsCounter = 0;
            return Double.NaN;
        }
        if (this.recursionCallsCounter == 0 || this.internalClone) {
            this.copyInitialTokens();
        }
        if (this.tokensList.size() == 0) {
            this.errorMessage = this.errorMessage + "Empty expression\n";
            if (this.verboseMode) {
                this.printSystemInfo("tokensList.size() == 0, returning Double.NaN\n", false);
            }
            this.recursionCallsCounter = 0;
            return Double.NaN;
        }
        if (this.recursionCallsCounter >= mXparser.MAX_RECURSION_CALLS) {
            this.errorMessage = this.errorMessage + "recursionCallsCounter >= MAX_RECURSION_CALLS\n";
            if (this.verboseMode) {
                this.printSystemInfo("recursionCallsCounter >= mXparser.MAX_RECURSION_CALLS, returning Double.NaN\n", false);
                this.printSystemInfo("recursionCallsCounter = " + this.recursionCallsCounter + "\n", false);
                this.printSystemInfo("mXparser.MAX_RECURSION_CALLS = " + mXparser.MAX_RECURSION_CALLS + "\n", false);
            }
            this.recursionCallsCounter = 0;
            this.errorMessage = this.errorMessage + "\n[" + this.description + "][" + this.expressionString + "] Maximum recursion calls reached.\n";
            return Double.NaN;
        }
        ++this.recursionCallsCounter;
        ArrayList<Integer> commas = null;
        int emptyLoopCounter = 0;
        if (this.verboseMode) {
            this.printSystemInfo("Starting calculation loop\n", true);
        }
        do {
            Token token;
            if (mXparser.isCurrentCalculationCancelled()) {
                this.errorMessage = this.errorMessage + "\nCancel request - finishing";
                return Double.NaN;
            }
            int tokensNumber = this.tokensList.size();
            int maxPartLevel = -1;
            int lPos = -1;
            int rPos = -1;
            int calculusPos = -1;
            int ifPos = -1;
            int iffPos = -1;
            int variadicFunPos = -1;
            int recArgPos = -1;
            int depArgPos = -1;
            int f3ArgPos = -1;
            int f2ArgPos = -1;
            int f1ArgPos = -1;
            int userFunPos = -1;
            int plusPos = -1;
            int minusPos = -1;
            int multiplyPos = -1;
            int dividePos = -1;
            int powerPos = -1;
            int tetrationPos = -1;
            int factPos = -1;
            int modPos = -1;
            int percPos = -1;
            int powerNum = 0;
            int negPos = -1;
            int andGroupPos = -1;
            int orGroupPos = -1;
            int implGroupPos = -1;
            int bolPos = -1;
            int eqPos = -1;
            int neqPos = -1;
            int ltPos = -1;
            int gtPos = -1;
            int leqPos = -1;
            int geqPos = -1;
            int commaPos = -1;
            int lParPos = -1;
            int rParPos = -1;
            int bitwisePos = -1;
            int bitwiseComplPos = -1;
            int p = -1;
            do {
                token = this.tokensList.get(++p);
                if (token.tokenTypeId == 8) {
                    calculusPos = p;
                    continue;
                }
                if (token.tokenTypeId == 6 && token.tokenId == 1) {
                    ifPos = p;
                    continue;
                }
                if (token.tokenTypeId != 7 || token.tokenId != 1) continue;
                iffPos = p;
            } while (p < tokensNumber - 1 && calculusPos < 0 && ifPos < 0 && iffPos < 0);
            if (calculusPos < 0 && ifPos < 0 && iffPos < 0) {
                Argument argument;
                int tokenIndex;
                for (tokenIndex = 0; tokenIndex < tokensNumber; ++tokenIndex) {
                    token = this.tokensList.get(tokenIndex);
                    if (token.tokenLevel > maxPartLevel) {
                        maxPartLevel = this.tokensList.get((int)tokenIndex).tokenLevel;
                        lPos = tokenIndex;
                    }
                    if (token.tokenTypeId == 101) {
                        argument = this.argumentsList.get(this.tokensList.get((int)tokenIndex).tokenId);
                        if (argument.argumentType == 1) {
                            this.FREE_ARGUMENT(tokenIndex);
                            continue;
                        }
                        depArgPos = tokenIndex;
                        continue;
                    }
                    if (token.tokenTypeId == 9) {
                        this.CONSTANT(tokenIndex);
                        continue;
                    }
                    if (token.tokenTypeId == 12) {
                        this.UNIT(tokenIndex);
                        continue;
                    }
                    if (token.tokenTypeId == 104) {
                        this.USER_CONSTANT(tokenIndex);
                        continue;
                    }
                    if (token.tokenTypeId != 10) continue;
                    this.RANDOM_VARIABLE(tokenIndex);
                }
                if (lPos < 0) {
                    this.errorMessage = this.errorMessage + "\nInternal error / strange token level - finishing";
                    return Double.NaN;
                }
                if (depArgPos >= 0) {
                    boolean depArgFound;
                    block3: do {
                        depArgFound = false;
                        int currentTokensNumber = this.tokensList.size();
                        for (tokenIndex = 0; tokenIndex < currentTokensNumber; ++tokenIndex) {
                            token = this.tokensList.get(tokenIndex);
                            if (token.tokenTypeId != 101) continue;
                            argument = this.argumentsList.get(this.tokensList.get((int)tokenIndex).tokenId);
                            if (argument.argumentType != 2) continue;
                            this.DEPENDENT_ARGUMENT(tokenIndex);
                            depArgFound = true;
                            continue block3;
                        }
                    } while (depArgFound);
                } else {
                    for (tokenIndex = lPos; tokenIndex < tokensNumber && maxPartLevel == this.tokensList.get((int)tokenIndex).tokenLevel; ++tokenIndex) {
                    }
                    rPos = tokenIndex - 1;
                    if (this.verboseMode) {
                        this.printSystemInfo("Parsing (" + lPos + ", " + rPos + ") ", true);
                        this.showParsing(lPos, rPos);
                    }
                    for (int pos = lPos; pos <= rPos; ++pos) {
                        boolean leftIsNumber = false;
                        boolean rigthIsNumber = false;
                        token = this.tokensList.get(pos);
                        if (pos - 1 >= 0) {
                            Token tokenL = this.tokensList.get(pos - 1);
                            if (tokenL.tokenTypeId == 0) {
                                leftIsNumber = true;
                            }
                        }
                        if (pos + 1 < tokensNumber) {
                            Token tokenR = this.tokensList.get(pos + 1);
                            if (tokenR.tokenTypeId == 0) {
                                rigthIsNumber = true;
                            }
                        }
                        if (token.tokenTypeId == 102 && recArgPos < 0) {
                            recArgPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 7 && variadicFunPos < 0) {
                            variadicFunPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 6 && f3ArgPos < 0) {
                            f3ArgPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 5 && f2ArgPos < 0) {
                            f2ArgPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 4 && f1ArgPos < 0) {
                            f1ArgPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 103 && userFunPos < 0) {
                            userFunPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 1) {
                            if (token.tokenId == 5 && leftIsNumber && rigthIsNumber) {
                                powerPos = pos;
                                ++powerNum;
                                continue;
                            }
                            if (token.tokenId == 9 && leftIsNumber && rigthIsNumber) {
                                tetrationPos = pos;
                                continue;
                            }
                            if (token.tokenId == 6 && factPos < 0 && leftIsNumber) {
                                factPos = pos;
                                continue;
                            }
                            if (token.tokenId == 8 && percPos < 0 && leftIsNumber) {
                                percPos = pos;
                                continue;
                            }
                            if (token.tokenId == 7 && modPos < 0 && leftIsNumber && rigthIsNumber) {
                                modPos = pos;
                                continue;
                            }
                            if (token.tokenId == 1 && plusPos < 0 && rigthIsNumber) {
                                plusPos = pos;
                                continue;
                            }
                            if (token.tokenId == 2 && minusPos < 0 && rigthIsNumber) {
                                minusPos = pos;
                                continue;
                            }
                            if (token.tokenId == 3 && multiplyPos < 0 && leftIsNumber && rigthIsNumber) {
                                multiplyPos = pos;
                                continue;
                            }
                            if (token.tokenId != 4 || dividePos >= 0 || !leftIsNumber || !rigthIsNumber) continue;
                            dividePos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 2) {
                            if (token.tokenId == 11 && negPos < 0 && rigthIsNumber) {
                                negPos = pos;
                                continue;
                            }
                            if (!leftIsNumber || !rigthIsNumber) continue;
                            if ((token.tokenId == 1 || token.tokenId == 2) && andGroupPos < 0) {
                                andGroupPos = pos;
                                continue;
                            }
                            if ((token.tokenId == 3 || token.tokenId == 4 || token.tokenId == 5) && orGroupPos < 0) {
                                orGroupPos = pos;
                                continue;
                            }
                            if ((token.tokenId == 6 || token.tokenId == 7 || token.tokenId == 8 || token.tokenId == 9 || token.tokenId == 10) && implGroupPos < 0) {
                                implGroupPos = pos;
                                continue;
                            }
                            if (bolPos >= 0) continue;
                            bolPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 3) {
                            if (token.tokenId == 1 && eqPos < 0 && leftIsNumber && rigthIsNumber) {
                                eqPos = pos;
                                continue;
                            }
                            if (token.tokenId == 2 && neqPos < 0 && leftIsNumber && rigthIsNumber) {
                                neqPos = pos;
                                continue;
                            }
                            if (token.tokenId == 3 && ltPos < 0 && leftIsNumber && rigthIsNumber) {
                                ltPos = pos;
                                continue;
                            }
                            if (token.tokenId == 4 && gtPos < 0 && leftIsNumber && rigthIsNumber) {
                                gtPos = pos;
                                continue;
                            }
                            if (token.tokenId == 5 && leqPos < 0 && leftIsNumber && rigthIsNumber) {
                                leqPos = pos;
                                continue;
                            }
                            if (token.tokenId != 6 || geqPos >= 0 || !leftIsNumber || !rigthIsNumber) continue;
                            geqPos = pos;
                            continue;
                        }
                        if (token.tokenTypeId == 11) {
                            if (token.tokenId == 1 && bitwiseComplPos < 0 && rigthIsNumber) {
                                bitwiseComplPos = pos;
                                continue;
                            }
                            if (bitwisePos >= 0 || !leftIsNumber || !rigthIsNumber) continue;
                            bitwisePos = pos;
                            continue;
                        }
                        if (token.tokenTypeId != 20) continue;
                        if (token.tokenId == 3) {
                            if (commaPos < 0) {
                                commas = new ArrayList<Integer>();
                            }
                            commas.add(pos);
                            commaPos = pos;
                            continue;
                        }
                        if (token.tokenId == 1 && lParPos < 0) {
                            lParPos = pos;
                            continue;
                        }
                        if (token.tokenId != 2 || rParPos >= 0) continue;
                        rParPos = pos;
                    }
                    if (powerNum > 1) {
                        powerPos = -1;
                        p = rPos + 1;
                        do {
                            token = this.tokensList.get(--p);
                            if (token.tokenTypeId != 1 || token.tokenId != 5) continue;
                            powerPos = p;
                        } while (p > lPos && powerPos == -1);
                    }
                }
            }
            if (calculusPos >= 0) {
                this.calculusCalc(calculusPos);
            } else if (ifPos >= 0) {
                this.IF_CONDITION(ifPos);
            } else if (iffPos >= 0) {
                this.IFF(iffPos);
            } else if (recArgPos >= 0) {
                this.RECURSIVE_ARGUMENT(recArgPos);
            } else if (variadicFunPos >= 0) {
                this.variadicFunCalc(variadicFunPos);
            } else if (f3ArgPos >= 0) {
                this.f3ArgCalc(f3ArgPos);
            } else if (f2ArgPos >= 0) {
                this.f2ArgCalc(f2ArgPos);
            } else if (f1ArgPos >= 0) {
                this.f1ArgCalc(f1ArgPos);
            } else if (userFunPos >= 0) {
                this.USER_FUNCTION(userFunPos);
            } else if (tetrationPos >= 0) {
                this.TETRATION(tetrationPos);
            } else if (powerPos >= 0) {
                this.POWER(powerPos);
            } else if (factPos >= 0) {
                this.FACT(factPos);
            } else if (percPos >= 0) {
                this.PERC(percPos);
            } else if (modPos >= 0) {
                this.MODULO(modPos);
            } else if (negPos >= 0) {
                this.NEG(negPos);
            } else if (bitwiseComplPos >= 0) {
                this.BITWISE_COMPL(bitwiseComplPos);
            } else if (multiplyPos >= 0 || dividePos >= 0) {
                if (multiplyPos >= 0 && dividePos >= 0) {
                    if (multiplyPos <= dividePos) {
                        this.MULTIPLY(multiplyPos);
                    } else {
                        this.DIVIDE(dividePos);
                    }
                } else if (multiplyPos >= 0) {
                    this.MULTIPLY(multiplyPos);
                } else {
                    this.DIVIDE(dividePos);
                }
            } else if (minusPos >= 0 || plusPos >= 0) {
                if (minusPos >= 0 && plusPos >= 0) {
                    if (minusPos <= plusPos) {
                        this.MINUS(minusPos);
                    } else {
                        this.PLUS(plusPos);
                    }
                } else if (minusPos >= 0) {
                    this.MINUS(minusPos);
                } else {
                    this.PLUS(plusPos);
                }
            } else if (neqPos >= 0) {
                this.NEQ(neqPos);
            } else if (eqPos >= 0) {
                this.EQ(eqPos);
            } else if (ltPos >= 0) {
                this.LT(ltPos);
            } else if (gtPos >= 0) {
                this.GT(gtPos);
            } else if (leqPos >= 0) {
                this.LEQ(leqPos);
            } else if (geqPos >= 0) {
                this.GEQ(geqPos);
            } else if (commaPos >= 0) {
                for (int i = commas.size() - 1; i >= 0; --i) {
                    this.COMMA((Integer)commas.get(i));
                }
            } else if (andGroupPos >= 0) {
                this.bolCalc(andGroupPos);
            } else if (orGroupPos >= 0) {
                this.bolCalc(orGroupPos);
            } else if (implGroupPos >= 0) {
                this.bolCalc(implGroupPos);
            } else if (bolPos >= 0) {
                this.bolCalc(bolPos);
            } else if (bitwisePos >= 0) {
                this.bitwiseCalc(bitwisePos);
            } else if (lParPos >= 0 && rParPos > lParPos) {
                this.PARENTHESES(lParPos, rParPos);
            } else if (this.tokensList.size() > 1) {
                this.errorMessage = this.errorMessage + "\n[" + this.description + "][" + this.expressionString + "] Fatal error - not know what to do with tokens while calculate().\n";
            }
            if (this.verboseMode) {
                this.showParsing(0, this.tokensList.size() - 1);
                this.printSystemInfo(" done\n", false);
            }
            emptyLoopCounter = this.tokensList.size() == tokensNumber ? ++emptyLoopCounter : 0;
            if (emptyLoopCounter <= 10) continue;
            this.errorMessage = this.errorMessage + "\nInternal error, do not know what to do with the token, probably mXparser bug, please report - finishing";
            return Double.NaN;
        } while (this.tokensList.size() > 1);
        if (this.verboseMode) {
            this.printSystemInfo("Calculated value: " + this.tokensList.get((int)0).tokenValue + "\n", true);
            this.printSystemInfo("Exiting\n", true);
            this.printSystemInfo("\n", false);
        }
        long endTime = System.currentTimeMillis();
        this.computingTime = (double)(endTime - startTime) / 1000.0;
        this.recursionCallsCounter = 0;
        double result = this.tokensList.get((int)0).tokenValue;
        if (mXparser.almostIntRounding && Math.abs(result - (resultint = (double)Math.round(result))) <= BinaryRelations.getEpsilon()) {
            result = resultint;
        }
        return result;
    }

    private void f1ArgCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.SIN(pos);
                break;
            }
            case 2: {
                this.COS(pos);
                break;
            }
            case 3: {
                this.TAN(pos);
                break;
            }
            case 4: {
                this.CTAN(pos);
                break;
            }
            case 5: {
                this.SEC(pos);
                break;
            }
            case 6: {
                this.COSEC(pos);
                break;
            }
            case 7: {
                this.ASIN(pos);
                break;
            }
            case 8: {
                this.ACOS(pos);
                break;
            }
            case 9: {
                this.ATAN(pos);
                break;
            }
            case 10: {
                this.ACTAN(pos);
                break;
            }
            case 11: {
                this.LN(pos);
                break;
            }
            case 12: {
                this.LOG2(pos);
                break;
            }
            case 13: {
                this.LOG10(pos);
                break;
            }
            case 14: {
                this.RAD(pos);
                break;
            }
            case 15: {
                this.EXP(pos);
                break;
            }
            case 16: {
                this.SQRT(pos);
                break;
            }
            case 17: {
                this.SINH(pos);
                break;
            }
            case 18: {
                this.COSH(pos);
                break;
            }
            case 19: {
                this.TANH(pos);
                break;
            }
            case 20: {
                this.COTH(pos);
                break;
            }
            case 21: {
                this.SECH(pos);
                break;
            }
            case 22: {
                this.CSCH(pos);
                break;
            }
            case 23: {
                this.DEG(pos);
                break;
            }
            case 24: {
                this.ABS(pos);
                break;
            }
            case 25: {
                this.SGN(pos);
                break;
            }
            case 26: {
                this.FLOOR(pos);
                break;
            }
            case 27: {
                this.CEIL(pos);
                break;
            }
            case 29: {
                this.NOT(pos);
                break;
            }
            case 30: {
                this.ARSINH(pos);
                break;
            }
            case 31: {
                this.ARCOSH(pos);
                break;
            }
            case 32: {
                this.ARTANH(pos);
                break;
            }
            case 33: {
                this.ARCOTH(pos);
                break;
            }
            case 34: {
                this.ARSECH(pos);
                break;
            }
            case 35: {
                this.ARCSCH(pos);
                break;
            }
            case 36: {
                this.SA(pos);
                break;
            }
            case 37: {
                this.SINC(pos);
                break;
            }
            case 38: {
                this.BELL_NUMBER(pos);
                break;
            }
            case 39: {
                this.LUCAS_NUMBER(pos);
                break;
            }
            case 40: {
                this.FIBONACCI_NUMBER(pos);
                break;
            }
            case 41: {
                this.HARMONIC_NUMBER(pos);
                break;
            }
            case 42: {
                this.IS_PRIME(pos);
                break;
            }
            case 43: {
                this.PRIME_COUNT(pos);
                break;
            }
            case 44: {
                this.EXP_INT(pos);
                break;
            }
            case 45: {
                this.LOG_INT(pos);
                break;
            }
            case 46: {
                this.OFF_LOG_INT(pos);
                break;
            }
            case 47: {
                this.GAUSS_ERF(pos);
                break;
            }
            case 48: {
                this.GAUSS_ERFC(pos);
                break;
            }
            case 49: {
                this.GAUSS_ERF_INV(pos);
                break;
            }
            case 50: {
                this.GAUSS_ERFC_INV(pos);
                break;
            }
            case 51: {
                this.ULP(pos);
                break;
            }
            case 52: {
                this.ISNAN(pos);
                break;
            }
            case 53: {
                this.NDIG10(pos);
                break;
            }
            case 54: {
                this.NFACT(pos);
                break;
            }
            case 55: {
                this.ARCSEC(pos);
                break;
            }
            case 56: {
                this.ARCCSC(pos);
                break;
            }
            case 57: {
                this.GAMMA(pos);
                break;
            }
            case 58: {
                this.LAMBERT_W0(pos);
                break;
            }
            case 59: {
                this.LAMBERT_W1(pos);
                break;
            }
            case 60: {
                this.SGN_GAMMA(pos);
                break;
            }
            case 61: {
                this.LOG_GAMMA(pos);
                break;
            }
            case 62: {
                this.DI_GAMMA(pos);
                break;
            }
            case 63: {
                this.UDF_PARAM(pos);
            }
        }
    }

    private void f2ArgCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.LOG(pos);
                break;
            }
            case 2: {
                this.MOD(pos);
                break;
            }
            case 3: {
                this.BINOM_COEFF(pos);
                break;
            }
            case 4: {
                this.BERNOULLI_NUMBER(pos);
                break;
            }
            case 5: {
                this.STIRLING1_NUMBER(pos);
                break;
            }
            case 6: {
                this.STIRLING2_NUMBER(pos);
                break;
            }
            case 7: {
                this.WORPITZKY_NUMBER(pos);
                break;
            }
            case 8: {
                this.EULER_NUMBER(pos);
                break;
            }
            case 9: {
                this.KRONECKER_DELTA(pos);
                break;
            }
            case 10: {
                this.EULER_POLYNOMIAL(pos);
                break;
            }
            case 11: {
                this.HARMONIC2_NUMBER(pos);
                break;
            }
            case 12: {
                this.RND_VAR_UNIFORM_CONT(pos);
                break;
            }
            case 13: {
                this.RND_VAR_UNIFORM_DISCR(pos);
                break;
            }
            case 14: {
                this.ROUND(pos);
                break;
            }
            case 15: {
                this.RND_NORMAL(pos);
                break;
            }
            case 16: {
                this.NDIG(pos);
                break;
            }
            case 17: {
                this.DIGIT10(pos);
                break;
            }
            case 18: {
                this.FACTVAL(pos);
                break;
            }
            case 19: {
                this.FACTEXP(pos);
                break;
            }
            case 20: {
                this.ROOT(pos);
                break;
            }
            case 21: {
                this.INC_GAMMA_LOWER(pos);
                break;
            }
            case 22: {
                this.INC_GAMMA_UPPER(pos);
                break;
            }
            case 23: {
                this.REG_GAMMA_LOWER(pos);
                break;
            }
            case 24: {
                this.REG_GAMMA_UPPER(pos);
                break;
            }
            case 25: {
                this.PERMUTATIONS(pos);
                break;
            }
            case 26: {
                this.BETA(pos);
                break;
            }
            case 27: {
                this.LOG_BETA(pos);
            }
        }
    }

    private void f3ArgCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 2: {
                this.IF(pos);
                break;
            }
            case 3: {
                this.CHI(pos);
                break;
            }
            case 4: {
                this.CHI_LR(pos);
                break;
            }
            case 5: {
                this.CHI_L(pos);
                break;
            }
            case 6: {
                this.CHI_R(pos);
                break;
            }
            case 7: {
                this.PDF_UNIFORM_CONT(pos);
                break;
            }
            case 8: {
                this.CDF_UNIFORM_CONT(pos);
                break;
            }
            case 9: {
                this.QNT_UNIFORM_CONT(pos);
                break;
            }
            case 10: {
                this.PDF_NORMAL(pos);
                break;
            }
            case 11: {
                this.CDF_NORMAL(pos);
                break;
            }
            case 12: {
                this.QNT_NORMAL(pos);
                break;
            }
            case 13: {
                this.DIGIT(pos);
                break;
            }
            case 14: {
                this.INC_BETA(pos);
                break;
            }
            case 15: {
                this.REG_BETA(pos);
            }
        }
    }

    private void variadicFunCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.IFF(pos);
                break;
            }
            case 2: {
                this.MIN_VARIADIC(pos);
                break;
            }
            case 3: {
                this.MAX_VARIADIC(pos);
                break;
            }
            case 8: {
                this.SUM_VARIADIC(pos);
                break;
            }
            case 9: {
                this.PROD_VARIADIC(pos);
                break;
            }
            case 10: {
                this.AVG_VARIADIC(pos);
                break;
            }
            case 11: {
                this.VAR_VARIADIC(pos);
                break;
            }
            case 12: {
                this.STD_VARIADIC(pos);
                break;
            }
            case 4: {
                this.CONTINUED_FRACTION(pos);
                break;
            }
            case 5: {
                this.CONTINUED_POLYNOMIAL(pos);
                break;
            }
            case 6: {
                this.GCD(pos);
                break;
            }
            case 7: {
                this.LCM(pos);
                break;
            }
            case 13: {
                this.RND_LIST(pos);
                break;
            }
            case 14: {
                this.COALESCE(pos);
                break;
            }
            case 15: {
                this.OR_VARIADIC(pos);
                break;
            }
            case 16: {
                this.AND_VARIADIC(pos);
                break;
            }
            case 17: {
                this.XOR_VARIADIC(pos);
                break;
            }
            case 18: {
                this.ARGMIN_VARIADIC(pos);
                break;
            }
            case 19: {
                this.ARGMAX_VARIADIC(pos);
                break;
            }
            case 20: {
                this.MEDIAN_VARIADIC(pos);
                break;
            }
            case 21: {
                this.MODE_VARIADIC(pos);
                break;
            }
            case 22: {
                this.BASE_VARIADIC(pos);
                break;
            }
            case 23: {
                this.NDIST_VARIADIC(pos);
            }
        }
    }

    private void calculusCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.SUM(pos);
                break;
            }
            case 3: {
                this.PROD(pos);
                break;
            }
            case 15: {
                this.MIN(pos);
                break;
            }
            case 16: {
                this.MAX(pos);
                break;
            }
            case 12: {
                this.AVG(pos);
                break;
            }
            case 13: {
                this.VAR(pos);
                break;
            }
            case 14: {
                this.STD(pos);
                break;
            }
            case 5: {
                this.INTEGRAL(pos);
                break;
            }
            case 17: {
                this.SOLVE(pos);
                break;
            }
            case 6: {
                this.DERIVATIVE(pos, 3);
                break;
            }
            case 7: {
                this.DERIVATIVE(pos, 1);
                break;
            }
            case 8: {
                this.DERIVATIVE(pos, 2);
                break;
            }
            case 9: {
                this.DERIVATIVE_NTH(pos, 3);
                break;
            }
            case 10: {
                this.FORWARD_DIFFERENCE(pos);
                break;
            }
            case 11: {
                this.BACKWARD_DIFFERENCE(pos);
            }
        }
    }

    private void bolCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.AND(pos);
                break;
            }
            case 7: {
                this.CIMP(pos);
                break;
            }
            case 9: {
                this.CNIMP(pos);
                break;
            }
            case 10: {
                this.EQV(pos);
                break;
            }
            case 6: {
                this.IMP(pos);
                break;
            }
            case 2: {
                this.NAND(pos);
                break;
            }
            case 8: {
                this.NIMP(pos);
                break;
            }
            case 4: {
                this.NOR(pos);
                break;
            }
            case 3: {
                this.OR(pos);
                break;
            }
            case 5: {
                this.XOR(pos);
            }
        }
    }

    private void bitwiseCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 2: {
                this.BITWISE_AND(pos);
                break;
            }
            case 4: {
                this.BITWISE_OR(pos);
                break;
            }
            case 3: {
                this.BITWISE_XOR(pos);
                break;
            }
            case 5: {
                this.BITWISE_LEFT_SHIFT(pos);
                break;
            }
            case 6: {
                this.BITWISE_RIGHT_SHIFT(pos);
            }
        }
    }

    private void addUDFSpecificParserKeyWords() {
        this.addKeyWord("par", "Automatically generated function for user defined functions, returns function parameter value at index 'i'", 63, "par(i)", "4.2", 4);
        this.addKeyWord("[npar]", "Automatically generated constant for user defined functions, returns number of given function parameters", 303, "[npar]", "4.2", 9);
    }

    private void addParserKeyWords() {
        this.addKeyWord("+", "Addition", 1, "a + b", "1.0", 1);
        this.addKeyWord("-", "Subtraction", 2, "a - b", "1.0", 1);
        this.addKeyWord("*", "Nultiplication", 3, "a * b", "1.0", 1);
        this.addKeyWord("/", "Division", 4, "a / b", "1.0", 1);
        this.addKeyWord("^", "Exponentiation", 5, "a^b", "1.0", 1);
        this.addKeyWord("!", "Factorial", 6, "n!", "1.0", 1);
        this.addKeyWord("#", "Modulo function", 7, "a # b", "1.0", 1);
        this.addKeyWord("%", "Percentage", 8, "n%", "4.1", 1);
        this.addKeyWord("^^", "Tetration (hyper-4, power tower, exponential tower)", 9, "a^^n", "4.2", 1);
        this.addKeyWord("~", "Negation", 11, "~p", "1.0", 2);
        this.addKeyWord("&", "Logical conjunction (AND)", 1, "p & q", "1.0", 2);
        this.addKeyWord("&&", "Logical conjunction (AND)", 1, "p && q", "1.0", 2);
        this.addKeyWord("/\\", "Logical conjunction (AND)", 1, "p /\\ q", "1.0", 2);
        this.addKeyWord("~&", "NAND - Sheffer stroke", 2, "p ~& q", "1.0", 2);
        this.addKeyWord("~&&", "NAND - Sheffer stroke", 2, "p ~&& q", "1.0", 2);
        this.addKeyWord("~/\\", "NAND - Sheffer stroke", 2, "p ~/\\ q", "1.0", 2);
        this.addKeyWord("|", "Logical disjunction (OR)", 3, "p | q", "1.0", 2);
        this.addKeyWord("||", "Logical disjunction (OR)", 3, "p || q", "1.0", 2);
        this.addKeyWord("\\/", "Logical disjunction (OR)", 3, "p \\/ q", "1.0", 2);
        this.addKeyWord("~|", "Logical NOR", 4, "p ~| q", "1.0", 2);
        this.addKeyWord("~||", "Logical NOR", 4, "p ~|| q", "1.0", 2);
        this.addKeyWord("~\\/", "Logical NOR", 4, "p ~\\/ q", "1.0", 2);
        this.addKeyWord("(+)", "Exclusive or (XOR)", 5, "p (+) q", "1.0", 2);
        this.addKeyWord("-->", "Implication (IMP)", 6, "p --> q", "1.0", 2);
        this.addKeyWord("-/>", "Material nonimplication (NIMP)", 8, "p  -/> q", "1.0", 2);
        this.addKeyWord("<--", "Converse implication (CIMP)", 7, "p <-- q", "1.0", 2);
        this.addKeyWord("</-", "Converse nonimplication (CNIMP)", 9, "p </- q", "1.0", 2);
        this.addKeyWord("<->", "Logical biconditional (EQV)", 10, "p <-> q", "1.0", 2);
        this.addKeyWord("=", "Equality", 1, "a = b", "1.0", 3);
        this.addKeyWord("==", "Equality", 1, "a == b", "1.0", 3);
        this.addKeyWord("<>", "Inequation", 2, "a <> b", "1.0", 3);
        this.addKeyWord("~=", "Inequation", 2, "a ~= b", "1.0", 3);
        this.addKeyWord("!=", "Inequation", 2, "a != b", "1.0", 3);
        this.addKeyWord("<", "Lower than", 3, "a < b", "1.0", 3);
        this.addKeyWord(">", "Greater than", 4, "a > b", "1.0", 3);
        this.addKeyWord("<=", "Lower or equal", 5, "a <= b", "1.0", 3);
        this.addKeyWord(">=", "Greater or equal", 6, "a >= b", "1.0", 3);
        if (!this.parserKeyWordsOnly) {
            this.addKeyWord("sin", "Trigonometric sine function", 1, "sin(x)", "1.0", 4);
            this.addKeyWord("cos", "Trigonometric cosine function", 2, "cos(x)", "1.0", 4);
            this.addKeyWord("tan", "Trigonometric tangent function", 3, "tan(x)", "1.0", 4);
            this.addKeyWord("tg", "Trigonometric tangent function", 3, "tg(x)", "1.0", 4);
            this.addKeyWord("ctan", "Trigonometric cotangent function", 4, "ctan(x)", "1.0", 4);
            this.addKeyWord("ctg", "Trigonometric cotangent function", 4, "ctg(x)", "1.0", 4);
            this.addKeyWord("cot", "Trigonometric cotangent function", 4, "cot(x)", "1.0", 4);
            this.addKeyWord("sec", "Trigonometric secant function", 5, "sec(x)", "1.0", 4);
            this.addKeyWord("cosec", "Trigonometric cosecant function", 6, "cosec(x)", "1.0", 4);
            this.addKeyWord("csc", "Trigonometric cosecant function", 6, "csc(x)", "1.0", 4);
            this.addKeyWord("asin", "Inverse trigonometric sine function", 7, "asin(x)", "1.0", 4);
            this.addKeyWord("arsin", "Inverse trigonometric sine function", 7, "arsin(x)", "1.0", 4);
            this.addKeyWord("arcsin", "Inverse trigonometric sine function", 7, "arcsin(x)", "1.0", 4);
            this.addKeyWord("acos", "Inverse trigonometric cosine function", 8, "acos(x)", "1.0", 4);
            this.addKeyWord("arcos", "Inverse trigonometric cosine function", 8, "arcos(x)", "1.0", 4);
            this.addKeyWord("arccos", "Inverse trigonometric cosine function", 8, "arccos(x)", "1.0", 4);
            this.addKeyWord("atan", "Inverse trigonometric tangent function", 9, "atan(x)", "1.0", 4);
            this.addKeyWord("arctan", "Inverse trigonometric tangent function", 9, "arctan(x)", "1.0", 4);
            this.addKeyWord("atg", "Inverse trigonometric tangent function", 9, "atg(x)", "1.0", 4);
            this.addKeyWord("arctg", "Inverse trigonometric tangent function", 9, "arctg(x)", "1.0", 4);
            this.addKeyWord("actan", "Inverse trigonometric cotangent function", 10, "actan(x)", "1.0", 4);
            this.addKeyWord("arcctan", "Inverse trigonometric cotangent function", 10, "arcctan(x)", "1.0", 4);
            this.addKeyWord("actg", "Inverse trigonometric cotangent function", 10, "actg(x)", "1.0", 4);
            this.addKeyWord("arcctg", "Inverse trigonometric cotangent function", 10, "arcctg(x)", "1.0", 4);
            this.addKeyWord("acot", "Inverse trigonometric cotangent function", 10, "acot(x)", "1.0", 4);
            this.addKeyWord("arccot", "Inverse trigonometric cotangent function", 10, "arccot(x)", "1.0", 4);
            this.addKeyWord("ln", "Natural logarithm function (base e)", 11, "ln(x)", "1.0", 4);
            this.addKeyWord("log2", "Binary logarithm function (base 2)", 12, "log2(x)", "1.0", 4);
            this.addKeyWord("log10", "Common logarithm function (base 10)", 13, "log10(x)", "1.0", 4);
            this.addKeyWord("rad", "Degrees to radians function", 14, "rad(x)", "1.0", 4);
            this.addKeyWord("exp", "Exponential function", 15, "exp(x)", "1.0", 4);
            this.addKeyWord("sqrt", "Squre root function", 16, "sqrt(x)", "1.0", 4);
            this.addKeyWord("sinh", "Hyperbolic sine function", 17, "sinh(x)", "1.0", 4);
            this.addKeyWord("cosh", "Hyperbolic cosine function", 18, "cosh(x)", "1.0", 4);
            this.addKeyWord("tanh", "Hyperbolic tangent function", 19, "tanh(x)", "1.0", 4);
            this.addKeyWord("tgh", "Hyperbolic tangent function", 19, "tgh(x)", "1.0", 4);
            this.addKeyWord("ctanh", "Hyperbolic cotangent function", 20, "ctanh(x)", "1.0", 4);
            this.addKeyWord("coth", "Hyperbolic cotangent function", 20, "coth(x)", "1.0", 4);
            this.addKeyWord("ctgh", "Hyperbolic cotangent function", 20, "ctgh(x)", "1.0", 4);
            this.addKeyWord("sech", "Hyperbolic secant function", 21, "sech(x)", "1.0", 4);
            this.addKeyWord("csch", "Hyperbolic cosecant function", 22, "csch(x)", "1.0", 4);
            this.addKeyWord("cosech", "Hyperbolic cosecant function", 22, "cosech(x)", "1.0", 4);
            this.addKeyWord("deg", "Radians to degrees function", 23, "deg(x)", "1.0", 4);
            this.addKeyWord("abs", "Absolut value function", 24, "abs(x)", "1.0", 4);
            this.addKeyWord("sgn", "Signum function", 25, "sgn(x)", "1.0", 4);
            this.addKeyWord("floor", "Floor function", 26, "floor(x)", "1.0", 4);
            this.addKeyWord("ceil", "Ceiling function", 27, "ceil(x)", "1.0", 4);
            this.addKeyWord("not", "Negation function", 29, "not(x)", "1.0", 4);
            this.addKeyWord("asinh", "Inverse hyperbolic sine function", 30, "asinh(x)", "1.0", 4);
            this.addKeyWord("arsinh", "Inverse hyperbolic sine function", 30, "arsinh(x)", "1.0", 4);
            this.addKeyWord("arcsinh", "Inverse hyperbolic sine function", 30, "arcsinh(x)", "1.0", 4);
            this.addKeyWord("acosh", "Inverse hyperbolic cosine function", 31, "acosh(x)", "1.0", 4);
            this.addKeyWord("arcosh", "Inverse hyperbolic cosine function", 31, "arcosh(x)", "1.0", 4);
            this.addKeyWord("arccosh", "Inverse hyperbolic cosine function", 31, "arccosh(x)", "1.0", 4);
            this.addKeyWord("atanh", "Inverse hyperbolic tangent function", 32, "atanh(x)", "1.0", 4);
            this.addKeyWord("arctanh", "Inverse hyperbolic tangent function", 32, "arctanh(x)", "1.0", 4);
            this.addKeyWord("atgh", "Inverse hyperbolic tangent function", 32, "atgh(x)", "1.0", 4);
            this.addKeyWord("arctgh", "Inverse hyperbolic tangent function", 32, "arctgh(x)", "1.0", 4);
            this.addKeyWord("actanh", "Inverse hyperbolic cotangent function", 33, "actanh(x)", "1.0", 4);
            this.addKeyWord("arcctanh", "Inverse hyperbolic cotangent function", 33, "arcctanh(x)", "1.0", 4);
            this.addKeyWord("acoth", "Inverse hyperbolic cotangent function", 33, "acoth(x)", "1.0", 4);
            this.addKeyWord("arcoth", "Inverse hyperbolic cotangent function", 33, "arcoth(x)", "1.0", 4);
            this.addKeyWord("arccoth", "Inverse hyperbolic cotangent function", 33, "arccoth(x)", "1.0", 4);
            this.addKeyWord("actgh", "Inverse hyperbolic cotangent function", 33, "actgh(x)", "1.0", 4);
            this.addKeyWord("arcctgh", "Inverse hyperbolic cotangent function", 33, "arcctgh(x)", "1.0", 4);
            this.addKeyWord("asech", "Inverse hyperbolic secant function", 34, "asech(x)", "1.0", 4);
            this.addKeyWord("arsech", "Inverse hyperbolic secant function", 34, "arsech(x)", "1.0", 4);
            this.addKeyWord("arcsech", "Inverse hyperbolic secant function", 34, "arcsech(x)", "1.0", 4);
            this.addKeyWord("acsch", "Inverse hyperbolic cosecant function", 35, "acsch(x)", "1.0", 4);
            this.addKeyWord("arcsch", "Inverse hyperbolic cosecant function", 35, "arcsch(x)", "1.0", 4);
            this.addKeyWord("arccsch", "Inverse hyperbolic cosecant function", 35, "arccsch(x)", "1.0", 4);
            this.addKeyWord("acosech", "Inverse hyperbolic cosecant function", 35, "acosech(x)", "1.0", 4);
            this.addKeyWord("arcosech", "Inverse hyperbolic cosecant function", 35, "arcosech(x)", "1.0", 4);
            this.addKeyWord("arccosech", "Inverse hyperbolic cosecant function", 35, "arccosech(x)", "1.0", 4);
            this.addKeyWord("sinc", "Sinc function (normalized)", 36, "sinc(x)", "1.0", 4);
            this.addKeyWord("Sa", "Sinc function (normalized)", 36, "Sa(x)", "1.0", 4);
            this.addKeyWord("Sinc", "Sinc function (unnormalized)", 37, "Sinc(x)", "1.0", 4);
            this.addKeyWord("Bell", "Bell number", 38, "Bell(n)", "1.0", 4);
            this.addKeyWord("Fib", "Fibonacci number", 40, "Fib(n)", "1.0", 4);
            this.addKeyWord("Luc", "Lucas number", 39, "Luc(n)", "1.0", 4);
            this.addKeyWord("harm", "Harmonic number", 41, "harm(n)", "1.0", 4);
            this.addKeyWord("ispr", "Prime number test (is number a prime?)", 42, "ispr(n)", "2.3", 4);
            this.addKeyWord("Pi", "Prime-counting function - Pi(x)", 43, "Pi(n)", "2.3", 4);
            this.addKeyWord("Ei", "Exponential integral function (non-elementary special function) - usage example: Ei(x)", 44, "Ei(x)", "2.3", 4);
            this.addKeyWord("li", "Logarithmic integral function (non-elementary special function) - usage example: li(x)", 45, "li(x)", "2.3", 4);
            this.addKeyWord("Li", "Offset logarithmic integral function (non-elementary special function) - usage example: Li(x)", 46, "Li(x)", "2.3", 4);
            this.addKeyWord("erf", "Gauss error function (non-elementary special function) - usage example: 2 + erf(x)", 47, "erf(x)", "3.0", 4);
            this.addKeyWord("erfc", "Gauss complementary error function (non-elementary special function) - usage example: 1 - erfc(x)", 48, "erfc(x)", "3.0", 4);
            this.addKeyWord("erfInv", "Inverse Gauss error function (non-elementary special function) - usage example: erfInv(x)", 49, "erfInv(x)", "3.0", 4);
            this.addKeyWord("erfcInv", "Inverse Gauss complementary error function (non-elementary special function) - usage example: erfcInv(x)", 50, "erfcInv(x)", "3.0", 4);
            this.addKeyWord("ulp", "Unit in The Last Place - ulp(0.1)", 51, "ulp(x)", "3.0", 4);
            this.addKeyWord("isNaN", "Returns true = 1 if value is a Not-a-Number (NaN), false = 0 otherwise - usage example: isNaN(x)", 52, "isNaN(x)", "4.1", 4);
            this.addKeyWord("ndig10", "Number of digits in numeral system with base 10", 53, "ndig10(x)", "4.1", 4);
            this.addKeyWord("nfact", "Prime decomposition - number of distinct prime factors", 54, "nfact(x)", "4.1", 4);
            this.addKeyWord("arcsec", "Inverse trigonometric secant", 55, "arcsec(x)", "4.1", 4);
            this.addKeyWord("arccsc", "Inverse trigonometric cosecant", 56, "arccsc(x)", "4.1", 4);
            this.addKeyWord("Gamma", "Gamma special function \u0393(s)", 57, "Gamma(x)", "4.2", 4);
            this.addKeyWord("LambW0", "Lambert-W special function, principal branch 0, also called the omega function or product logarithm", 58, "LambW0(x)", "4.2", 4);
            this.addKeyWord("LambW1", "Lambert-W special function, branch -1, also called the omega function or product logarithm", 59, "LambW1(x)", "4.2", 4);
            this.addKeyWord("sgnGamma", "Signum of Gamma special function, \u0393(s)", 60, "sgnGamma(x)", "4.2", 4);
            this.addKeyWord("logGamma", "Log Gamma special function, ln\u0393(s)", 61, "logGamma(x)", "4.2", 4);
            this.addKeyWord("diGamma", "Digamma function as the logarithmic derivative of the Gamma special function, \u03c8(x)", 62, "diGamma(x)", "4.2", 4);
            this.addKeyWord("log", "Logarithm function", 1, "log(a, b)", "1.0", 5);
            this.addKeyWord("mod", "Modulo function", 2, "mod(a, b)", "1.0", 5);
            this.addKeyWord("C", "Binomial coefficient function, number of k-combinations that can be drawn from n-elements set", 3, "C(n, k)", "1.0", 5);
            this.addKeyWord("nCk", "Binomial coefficient function, number of k-combinations that can be drawn from n-elements set", 3, "nCk(n,k)", "4.2", 5);
            this.addKeyWord("Bern", "Bernoulli numbers", 4, "Bern(m, n)", "1.0", 5);
            this.addKeyWord("Stirl1", "Stirling numbers of the first kind", 5, "Stirl1(n, k)", "1.0", 5);
            this.addKeyWord("Stirl2", "Stirling numbers of the second kind", 6, "Stirl2(n, k)", "1.0", 5);
            this.addKeyWord("Worp", "Worpitzky number", 7, "Worp(n, k)", "1.0", 5);
            this.addKeyWord("Euler", "Euler number", 8, "Euler(n, k)", "1.0", 5);
            this.addKeyWord("KDelta", "Kronecker delta", 9, "KDelta(i, j)", "1.0", 5);
            this.addKeyWord("EulerPol", "EulerPol", 10, "EulerPol", "1.0", 5);
            this.addKeyWord("Harm", "Harmonic number", 11, "Harm(x, n)", "1.0", 5);
            this.addKeyWord("rUni", "Random variable - Uniform continuous distribution U(a,b), usage example: 2*rUni(2,10)", 12, "rUni(a, b)", "3.0", 5);
            this.addKeyWord("rUnid", "Random variable - Uniform discrete distribution U{a,b}, usage example: 2*rUnid(2,100)", 13, "rUnid(a, b)", "3.0", 5);
            this.addKeyWord("round", "Half-up rounding, usage examples: round(2.2, 0) = 2, round(2.6, 0) = 3, round(2.66,1) = 2.7", 14, "round(x, n)", "3.0", 5);
            this.addKeyWord("rNor", "Random variable - Normal distribution N(m,s) m - mean, s - stddev, usage example: 3*rNor(0,1)", 15, "rNor(mean, stdv)", "3.0", 5);
            this.addKeyWord("ndig", "Number of digits representing the number in numeral system with given base", 16, "ndig(number, base)", "4.1", 5);
            this.addKeyWord("dig10", "Digit at position 1 ... n (left -> right) or 0 ... -(n-1) (right -> left) - base 10 numeral system", 17, "dig10(num, pos)", "4.1", 5);
            this.addKeyWord("factval", "Prime decomposition - factor value at position between 1 ... nfact(n) - ascending order by factor value", 18, "factval(number, factorid)", "4.1", 5);
            this.addKeyWord("factexp", "Prime decomposition - factor exponent / multiplicity at position between 1 ... nfact(n) - ascending order by factor value", 19, "factexp(number, factorid)", "4.1", 5);
            this.addKeyWord("root", "N-th order root of a number", 20, "root(rootorder, number)", "4.1", 5);
            this.addKeyWord("GammaL", "Lower incomplete gamma special function, \u03b3(s,x)", 21, "GammaL(s,x)", "4.2", 5);
            this.addKeyWord("GammaU", "Upper incomplete Gamma special function, \u0393(s,x)", 22, "GammaU(s,x)", "4.2", 5);
            this.addKeyWord("GammaRegL", "Lower regularized P gamma special function, P(s,x)", 23, "GammaRegL(s,x)", "4.2", 5);
            this.addKeyWord("GammaRegU", "Upper regularized Q Gamma special function, Q(s,x)", 24, "GammaRegU(s,x)", "4.2", 5);
            this.addKeyWord("GammaP", "Lower regularized P gamma special function, P(s,x)", 23, "GammaP(s,x)", "4.2", 5);
            this.addKeyWord("GammaQ", "Upper regularized Q Gamma special function, Q(s,x)", 24, "GammaQ(s,x)", "4.2", 5);
            this.addKeyWord("nPk", "Number of k-permutations that can be drawn from n-elements set", 25, "nPk(n,k)", "4.2", 5);
            this.addKeyWord("Beta", "The Beta special function B(x,y), also called the Euler integral of the first kind", 26, "Beta(x,y)", "4.2", 5);
            this.addKeyWord("logBeta", "The Log Beta special function ln B(x,y), also called the Log Euler integral of the first kind, ln B(x,y)", 27, "logBeta(x,y)", "4.2", 5);
            this.addKeyWord("if", "If function", 1, "if( cond, expr-if-true, expr-if-false )", "1.0", 6);
            this.addKeyWord("chi", "Characteristic function for x in (a,b)", 3, "chi(x, a, b)", "1.0", 6);
            this.addKeyWord("CHi", "Characteristic function for x in [a,b]", 4, "CHi(x, a, b)", "1.0", 6);
            this.addKeyWord("Chi", "Characteristic function for x in [a,b)", 5, "Chi(x, a, b)", "1.0", 6);
            this.addKeyWord("cHi", "Characteristic function for x in (a,b]", 6, "cHi(x, a, b)", "1.0", 6);
            this.addKeyWord("pUni", "Probability distribution function - Uniform continuous distribution U(a,b)", 7, "pUni(x, a, b)", "3.0", 6);
            this.addKeyWord("cUni", "Cumulative distribution function - Uniform continuous distribution U(a,b)", 8, "cUni(x, a, b)", "3.0", 6);
            this.addKeyWord("qUni", "Quantile function (inverse cumulative distribution function) - Uniform continuous distribution U(a,b)", 9, "qUni(q, a, b)", "3.0", 6);
            this.addKeyWord("pNor", "Probability distribution function - Normal distribution N(m,s)", 10, "pNor(x, mean, stdv)", "3.0", 6);
            this.addKeyWord("cNor", "Cumulative distribution function - Normal distribution N(m,s)", 11, "cNor(x, mean, stdv)", "3.0", 6);
            this.addKeyWord("qNor", "Quantile function (inverse cumulative distribution function)", 12, "qNor(q, mean, stdv)", "3.0", 6);
            this.addKeyWord("dig", "Digit at position 1 ... n (left -> right) or 0 ... -(n-1) (right -> left) - numeral system with given base", 13, "dig(num, pos, base)", "4.1", 6);
            this.addKeyWord("BetaInc", "The incomplete beta special function B(x; a, b), also called the incomplete Euler integral of the first kind", 14, "BetaInc(x,a,b)", "4.2", 6);
            this.addKeyWord("BetaReg", "The regularized incomplete beta (or regularized beta) special function I(x; a, b), also called the regularized incomplete Euler integral of the first kind", 15, "BetaReg(x,a,b)", "4.2", 6);
            this.addKeyWord("BetaI", "The regularized incomplete beta (or regularized beta) special function I(x; a, b), also called the regularized incomplete Euler integral of the first kind", 15, "BetaI(x,a,b)", "4.2", 6);
            this.addKeyWord("iff", "If function", 1, "iff( cond-1, expr-1; ... ; cond-n, expr-n )", "1.0", 7);
            this.addKeyWord("min", "Minimum function", 2, "min(a1, ..., an)", "1.0", 7);
            this.addKeyWord("max", "Maximum function", 3, "max(a1, ..., an)", "1.0", 7);
            this.addKeyWord("ConFrac", "Continued fraction", 4, "ConFrac(a1, ..., an)", "1.0", 7);
            this.addKeyWord("ConPol", "Continued polynomial", 5, "ConPol(a1, ..., an)", "1.0", 7);
            this.addKeyWord("gcd", "Greatest common divisor", 6, "gcd(a1, ..., an)", "1.0", 7);
            this.addKeyWord("lcm", "Least common multiple", 7, "lcm(a1, ..., an)", "1.0", 7);
            this.addKeyWord("add", "Summation operator", 8, "add(a1, ..., an)", "2.4", 7);
            this.addKeyWord("multi", "Multiplication", 9, "multi(a1, ..., an)", "2.4", 7);
            this.addKeyWord("mean", "Mean / average value", 10, "mean(a1, ..., an)", "2.4", 7);
            this.addKeyWord("var", "Bias-corrected sample variance", 11, "var(a1, ..., an)", "2.4", 7);
            this.addKeyWord("std", "Bias-corrected sample standard deviation", 12, "std(a1, ..., an)", "2.4", 7);
            this.addKeyWord("rList", "Random number from given list of numbers", 13, "rList(a1, ..., an)", "3.0", 7);
            this.addKeyWord("coalesce", "Returns the first non-NaN value", 14, "coalesce(a1, ..., an)", "4.1", 7);
            this.addKeyWord("or", "Logical disjunction (OR) - variadic", 15, "or(a1, ..., an)", "4.1", 7);
            this.addKeyWord("and", "Logical conjunction (AND) - variadic", 16, "and(a1, ..., an)", "4.1", 7);
            this.addKeyWord("xor", "Exclusive or (XOR) - variadic", 17, "xor(a1, ..., an)", "4.1", 7);
            this.addKeyWord("argmin", "Arguments / indices of the minima", 18, "argmin(a1, ..., an)", "4.1", 7);
            this.addKeyWord("argmax", "Arguments / indices of the maxima", 19, "argmax(a1, ..., an)", "4.1", 7);
            this.addKeyWord("med", "The sample median", 20, "med(a1, ..., an)", "4.1", 7);
            this.addKeyWord("mode", "Mode - the value that appears most often", 21, "mode(a1, ..., an)", "4.1", 7);
            this.addKeyWord("base", "Returns number in given numeral system base represented by list of digits", 22, "base(b, d1, ..., dn)", "4.1", 7);
            this.addKeyWord("ndist", "Number of distinct values", 23, "ndist(v1, ..., vn)", "4.1", 7);
            this.addKeyWord("sum", "Summation operator - SIGMA", 1, "sum( i, from, to, expr , <by> )", "1.0", 8);
            this.addKeyWord("prod", "Product operator - PI", 3, "prod( i, from, to, expr , <by> )", "1.0", 8);
            this.addKeyWord("int", "Definite integral operator", 5, "int( expr, arg, from, to )", "1.0", 8);
            this.addKeyWord("der", "Derivative operator", 6, "der( expr, arg, <point> )", "1.0", 8);
            this.addKeyWord("der-", "Left derivative operator", 7, "der-( expr, arg, <point> )", "1.0", 8);
            this.addKeyWord("der+", "Right derivative operator", 8, "der+( expr, arg, <point> )", "1.0", 8);
            this.addKeyWord("dern", "n-th derivative operator", 9, "dern( expr, n, arg )", "1.0", 8);
            this.addKeyWord("diff", "Forward difference operator", 10, "diff( expr, arg, <delta> )", "1.0", 8);
            this.addKeyWord("difb", "Backward difference operator", 11, "difb( expr, arg, <delta> )", "1.0", 8);
            this.addKeyWord("avg", "Average operator", 12, "avg( i, from, to, expr , <by> )", "2.4", 8);
            this.addKeyWord("vari", "Bias-corrected sample variance operator", 13, "vari( i, from, to, expr , <by> )", "2.4", 8);
            this.addKeyWord("stdi", "Bias-corrected sample standard deviation operator", 14, "stdi( i, from, to, expr , <by> )", "2.4", 8);
            this.addKeyWord("mini", "Minimum value", 15, "mini( i, from, to, expr , <by> )", "2.4", 8);
            this.addKeyWord("maxi", "Maximum value", 16, "maxi( i, from, to, expr , <by> )", "2.4", 8);
            this.addKeyWord("solve", "f(x) = 0 equation solving, function root finding", 17, "solve( expr, arg, from, to )", "4.0", 8);
            this.addKeyWord("pi", "Pi, Archimedes' constant or Ludolph's number", 1, "pi", "1.0", 9);
            this.addKeyWord("e", "Napier's constant, or Euler's number, base of Natural logarithm", 2, "e", "1.0", 9);
            this.addKeyWord("[gam]", "Euler-Mascheroni constant", 3, "[gam]", "1.0", 9);
            this.addKeyWord("[phi]", "Golden ratio", 4, "[phi]", "1.0", 9);
            this.addKeyWord("[PN]", "Plastic constant", 5, "[PN]", "1.0", 9);
            this.addKeyWord("[B*]", "Embree-Trefethen constant", 6, "[B*]", "1.0", 9);
            this.addKeyWord("[F'd]", "Feigenbaum constant alfa", 7, "[F'd]", "1.0", 9);
            this.addKeyWord("[F'a]", "Feigenbaum constant delta", 8, "[F'a]", "1.0", 9);
            this.addKeyWord("[C2]", "Twin prime constant", 9, "[C2]", "1.0", 9);
            this.addKeyWord("[M1]", "Meissel-Mertens constant", 10, "[M1]", "1.0", 9);
            this.addKeyWord("[B2]", "Brun's constant for twin primes", 11, "[B2]", "1.0", 9);
            this.addKeyWord("[B4]", "Brun's constant for prime quadruplets", 12, "[B4]", "1.0", 9);
            this.addKeyWord("[BN'L]", "de Bruijn-Newman constant", 13, "[BN'L]", "1.0", 9);
            this.addKeyWord("[Kat]", "Catalan's constant", 14, "[Kat]", "1.0", 9);
            this.addKeyWord("[K*]", "Landau-Ramanujan constant", 15, "[K*]", "1.0", 9);
            this.addKeyWord("[K.]", "Viswanath's constant", 16, "[K.]", "1.0", 9);
            this.addKeyWord("[B'L]", "Legendre's constant", 17, "[B'L]", "1.0", 9);
            this.addKeyWord("[RS'm]", "Ramanujan-Soldner constant", 18, "[RS'm]", "1.0", 9);
            this.addKeyWord("[EB'e]", "Erdos-Borwein constant", 19, "[EB'e]", "1.0", 9);
            this.addKeyWord("[Bern]", "Bernstein's constant", 20, "[Bern]", "1.0", 9);
            this.addKeyWord("[GKW'l]", "Gauss-Kuzmin-Wirsing constant", 21, "[GKW'l]", "1.0", 9);
            this.addKeyWord("[HSM's]", "Hafner-Sarnak-McCurley constant", 22, "[HSM's]", "1.0", 9);
            this.addKeyWord("[lm]", "Golomb-Dickman constant", 23, "[lm]", "1.0", 9);
            this.addKeyWord("[Cah]", "Cahen's constant", 24, "[Cah]", "1.0", 9);
            this.addKeyWord("[Ll]", "Laplace limit", 25, "[Ll]", "1.0", 9);
            this.addKeyWord("[AG]", "Alladi-Grinstead constant", 26, "[AG]", "1.0", 9);
            this.addKeyWord("[L*]", "Lengyel's constant", 27, "[L*]", "1.0", 9);
            this.addKeyWord("[L.]", "Levy's constant", 28, "[L.]", "1.0", 9);
            this.addKeyWord("[Dz3]", "Apery's constant", 29, "[Dz3]", "1.0", 9);
            this.addKeyWord("[A3n]", "Mills' constant", 30, "[A3n]", "1.0", 9);
            this.addKeyWord("[Bh]", "Backhouse's constant", 31, "[Bh]", "1.0", 9);
            this.addKeyWord("[Pt]", "Porter's constant", 32, "[Pt]", "1.0", 9);
            this.addKeyWord("[L2]", "Lieb's square ice constant", 33, "[L2]", "1.0", 9);
            this.addKeyWord("[Nv]", "Niven's constant", 34, "[Nv]", "1.0", 9);
            this.addKeyWord("[Ks]", "Sierpinski's constant", 35, "[Ks]", "1.0", 9);
            this.addKeyWord("[Kh]", "Khinchin's constant", 36, "[Kh]", "1.0", 9);
            this.addKeyWord("[FR]", "Fransen-Robinson constant", 37, "[FR]", "1.0", 9);
            this.addKeyWord("[La]", "Landau's constant", 38, "[La]", "1.0", 9);
            this.addKeyWord("[P2]", "Parabolic constant", 39, "[P2]", "1.0", 9);
            this.addKeyWord("[Om]", "Omega constant", 40, "[Om]", "1.0", 9);
            this.addKeyWord("[MRB]", "MRB constant", 41, "[MRB]", "1.0", 9);
            this.addKeyWord("[li2]", "li(2) - Logarithmic integral function at x=2", 42, "[li2]", "2.3", 9);
            this.addKeyWord("[EG]", "Gompertz constant", 43, "[EG]", "2.3", 9);
            this.addKeyWord("[c]", "<Physical Constant> Light speed in vacuum [m/s] (m=1, s=1)", 101, "[c]", "4.0", 9);
            this.addKeyWord("[G.]", "<Physical Constant> Gravitational constant (m=1, kg=1, s=1)]", 102, "[G.]", "4.0", 9);
            this.addKeyWord("[g]", "<Physical Constant> Gravitational acceleration on Earth [m/s^2] (m=1, s=1)", 103, "[g]", "4.0", 9);
            this.addKeyWord("[hP]", "<Physical Constant> Planck constant (m=1, kg=1, s=1)", 104, "[hP]", "4.0", 9);
            this.addKeyWord("[h-]", "<Physical Constant> Reduced Planck constant / Dirac constant (m=1, kg=1, s=1)]", 105, "[h-]", "4.0", 9);
            this.addKeyWord("[lP]", "<Physical Constant> Planck length [m] (m=1)", 106, "[lP]", "4.0", 9);
            this.addKeyWord("[mP]", "<Physical Constant> Planck mass [kg] (kg=1)", 107, "[mP]", "4.0", 9);
            this.addKeyWord("[tP]", "<Physical Constant> Planck time [s] (s=1)", 108, "[tP]", "4.0", 9);
            this.addKeyWord("[ly]", "<Astronomical Constant> Light year [m] (m=1)", 201, "[ly]", "4.0", 9);
            this.addKeyWord("[au]", "<Astronomical Constant> Astronomical unit [m] (m=1)", 202, "[au]", "4.0", 9);
            this.addKeyWord("[pc]", "<Astronomical Constant> Parsec [m] (m=1)", 203, "[pc]", "4.0", 9);
            this.addKeyWord("[kpc]", "<Astronomical Constant> Kiloparsec [m] (m=1)", 204, "[kpc]", "4.0", 9);
            this.addKeyWord("[Earth-R-eq]", "<Astronomical Constant> Earth equatorial radius [m] (m=1)", 205, "[Earth-R-eq]", "4.0", 9);
            this.addKeyWord("[Earth-R-po]", "<Astronomical Constant> Earth polar radius [m] (m=1)", 206, "[Earth-R-po]", "4.0", 9);
            this.addKeyWord("[Earth-R]", "<Astronomical Constant> Earth mean radius (m=1)", 207, "[Earth-R]", "4.0", 9);
            this.addKeyWord("[Earth-M]", "<Astronomical Constant> Earth mass [kg] (kg=1)", 208, "[Earth-M]", "4.0", 9);
            this.addKeyWord("[Earth-D]", "<Astronomical Constant> Earth-Sun distance - semi major axis [m] (m=1)", 209, "[Earth-D]", "4.0", 9);
            this.addKeyWord("[Moon-R]", "<Astronomical Constant> Moon mean radius [m] (m=1)", 210, "[Moon-R]", "4.0", 9);
            this.addKeyWord("[Moon-M]", "<Astronomical Constant> Moon mass [kg] (kg=1)", 211, "[Moon-M]", "4.0", 9);
            this.addKeyWord("[Moon-D]", "<Astronomical Constant> Moon-Earth distance - semi major axis [m] (m=1)", 212, "[Moon-D]", "4.0", 9);
            this.addKeyWord("[Solar-R]", "<Astronomical Constant> Solar mean radius [m] (m=1)", 213, "[Solar-R]", "4.0", 9);
            this.addKeyWord("[Solar-M]", "<Astronomical Constant> Solar mass [kg] (kg=1)", 214, "[Solar-M]", "4.0", 9);
            this.addKeyWord("[Mercury-R]", "<Astronomical Constant> Mercury mean radius [m] (m=1)", 215, "[Mercury-R]", "4.0", 9);
            this.addKeyWord("[Mercury-M]", "<Astronomical Constant> Mercury mass [kg] (kg=1)", 216, "[Mercury-M]", "4.0", 9);
            this.addKeyWord("[Mercury-D]", "<Astronomical Constant> Mercury-Sun distance - semi major axis [m] (m=1)", 217, "[Mercury-D]", "4.0", 9);
            this.addKeyWord("[Venus-R]", "<Astronomical Constant> Venus mean radius [m] (m=1)", 218, "[Venus-R]", "4.0", 9);
            this.addKeyWord("[Venus-M]", "<Astronomical Constant> Venus mass [kg] (kg=1)", 219, "[Venus-M]", "4.0", 9);
            this.addKeyWord("[Venus-D]", "<Astronomical Constant> Venus-Sun distance - semi major axis [m] (m=1)", 220, "[Venus-D]", "4.0", 9);
            this.addKeyWord("[Mars-R]", "<Astronomical Constant> Mars mean radius [m] (m=1)", 221, "[Mars-R]", "4.0", 9);
            this.addKeyWord("[Mars-M]", "<Astronomical Constant> Mars mass [kg] (kg=1)", 222, "[Mars-M]", "4.0", 9);
            this.addKeyWord("[Mars-D]", "<Astronomical Constant> Mars-Sun distance - semi major axis [m] (m=1)", 223, "[Mars-D]", "4.0", 9);
            this.addKeyWord("[Jupiter-R]", "<Astronomical Constant> Jupiter mean radius [m] (m=1)", 224, "[Jupiter-R]", "4.0", 9);
            this.addKeyWord("[Jupiter-M]", "<Astronomical Constant> Jupiter mass [kg] (kg=1)", 225, "[Jupiter-M]", "4.0", 9);
            this.addKeyWord("[Jupiter-D]", "<Astronomical Constant> Jupiter-Sun distance - semi major axis [m] (m=1)", 226, "[Jupiter-D]", "4.0", 9);
            this.addKeyWord("[Saturn-R]", "<Astronomical Constant> Saturn mean radius [m] (m=1)", 227, "[Saturn-R]", "4.0", 9);
            this.addKeyWord("[Saturn-M]", "<Astronomical Constant> Saturn mass [kg] (kg=1)", 228, "[Saturn-M]", "4.0", 9);
            this.addKeyWord("[Saturn-D]", "<Astronomical Constant> Saturn-Sun distance - semi major axis [m] (m=1)", 229, "[Saturn-D]", "4.0", 9);
            this.addKeyWord("[Uranus-R]", "<Astronomical Constant> Uranus mean radius [m] (m=1)", 230, "[Uranus-R]", "4.0", 9);
            this.addKeyWord("[Uranus-M]", "<Astronomical Constant> Uranus mass [kg] (kg=1)", 231, "[Uranus-M]", "4.0", 9);
            this.addKeyWord("[Uranus-D]", "<Astronomical Constant> Uranus-Sun distance - semi major axis [m] (m=1)", 232, "[Uranus-D]", "4.0", 9);
            this.addKeyWord("[Neptune-R]", "<Astronomical Constant> Neptune mean radius [m] (m=1)", 233, "[Neptune-R]", "4.0", 9);
            this.addKeyWord("[Neptune-M]", "<Astronomical Constant> Neptune mass [kg] (kg=1)", 234, "[Neptune-M]", "4.0", 9);
            this.addKeyWord("[Neptune-D]", "<Astronomical Constant> Neptune-Sun distance - semi major axis [m] (m=1)", 235, "[Neptune-D]", "4.0", 9);
            this.addKeyWord("[true]", "Boolean True represented as double, [true] = 1", 301, "[true]", "4.1", 9);
            this.addKeyWord("[false]", "Boolean False represented as double, [false] = 0", 302, "[false]", "4.1", 9);
            this.addKeyWord("[NaN]", "Not-a-Number", 999, "[NaN]", "4.1", 9);
            this.addKeyWord("[Uni]", "Random variable - Uniform continuous distribution U(0,1)", 1, "[Uni]", "3.0", 10);
            this.addKeyWord("[Int]", "Random variable - random integer", 2, "[Int]", "3.0", 10);
            this.addKeyWord("[Int1]", "Random variable - random integer - Uniform discrete distribution U{-10^1, 10^1}", 3, "[Int1]", "3.0", 10);
            this.addKeyWord("[Int2]", "Random variable - random integer - Uniform discrete distribution U{-10^2, 10^2}", 4, "[Int2]", "3.0", 10);
            this.addKeyWord("[Int3]", "Random variable - random integer - Uniform discrete distribution U{-10^3, 10^3}", 5, "[Int3]", "3.0", 10);
            this.addKeyWord("[Int4]", "Random variable - random integer - Uniform discrete distribution U{-10^4, 10^4}", 6, "[Int4]", "3.0", 10);
            this.addKeyWord("[Int5]", "Random variable - random integer - Uniform discrete distribution U{-10^5, 10^5}", 7, "[Int5]", "3.0", 10);
            this.addKeyWord("[Int6]", "Random variable - random integer - Uniform discrete distribution U{-10^6, 10^6}", 8, "[Int6]", "3.0", 10);
            this.addKeyWord("[Int7]", "Random variable - random integer - Uniform discrete distribution U{-10^7, 10^7}", 9, "[Int7]", "3.0", 10);
            this.addKeyWord("[Int8]", "Random variable - random integer - Uniform discrete distribution U{-10^8, 10^8}", 10, "[Int8]", "3.0", 10);
            this.addKeyWord("[Int9]", "Random variable - random integer - Uniform discrete distribution U{-10^9, 10^9}", 11, "[Int9]", "3.0", 10);
            this.addKeyWord("[nat]", "Random variable - random natural number including 0", 12, "[nat]", "3.0", 10);
            this.addKeyWord("[nat1]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^1}", 13, "[nat1]", "3.0", 10);
            this.addKeyWord("[nat2]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^2}", 14, "[nat2]", "3.0", 10);
            this.addKeyWord("[nat3]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^3}", 15, "[nat3]", "3.0", 10);
            this.addKeyWord("[nat4]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^4}", 16, "[nat4]", "3.0", 10);
            this.addKeyWord("[nat5]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^5}", 17, "[nat5]", "3.0", 10);
            this.addKeyWord("[nat6]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^6}", 18, "[nat6]", "3.0", 10);
            this.addKeyWord("[nat7]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^7}", 19, "[nat7]", "3.0", 10);
            this.addKeyWord("[nat8]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^8}", 20, "[nat8]", "3.0", 10);
            this.addKeyWord("[nat9]", "Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^9}", 21, "[nat9]", "3.0", 10);
            this.addKeyWord("[Nat]", "Random variable - random natural number", 22, "[Nat]", "3.0", 10);
            this.addKeyWord("[Nat1]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^1}", 23, "[Nat1]", "3.0", 10);
            this.addKeyWord("[Nat2]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^2}", 24, "[Nat2]", "3.0", 10);
            this.addKeyWord("[Nat3]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^3}", 25, "[Nat3]", "3.0", 10);
            this.addKeyWord("[Nat4]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^4}", 26, "[Nat4]", "3.0", 10);
            this.addKeyWord("[Nat5]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^5}", 27, "[Nat5]", "3.0", 10);
            this.addKeyWord("[Nat6]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^6}", 28, "[Nat6]", "3.0", 10);
            this.addKeyWord("[Nat7]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^7}", 29, "[Nat7]", "3.0", 10);
            this.addKeyWord("[Nat8]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^8}", 30, "[Nat8]", "3.0", 10);
            this.addKeyWord("[Nat9]", "Random variable - random natural number - Uniform discrete distribution U{1, 10^9}", 31, "[Nat9]", "3.0", 10);
            this.addKeyWord("[Nor]", "Random variable - Normal distribution N(0,1)", 32, "[Nor]", "3.0", 10);
            this.addKeyWord("@~", "Bitwise unary complement", 1, "@~a", "4.0", 11);
            this.addKeyWord("@&", "Bitwise AND", 2, "a @& b", "4.0", 11);
            this.addKeyWord("@^", "Bitwise exclusive OR", 3, "a @^ b", "4.0", 11);
            this.addKeyWord("@|", "Bitwise inclusive OR", 4, "a @| b", "4.0", 11);
            this.addKeyWord("@<<", "Signed left shift", 5, "a @<< b", "4.0", 11);
            this.addKeyWord("@>>", "Signed right shift", 6, "a @>> b", "4.0", 11);
            this.addKeyWord("[%]", "<Ratio, Fraction> Percentage = 0.01", 1, "[%]", "4.0", 12);
            this.addKeyWord("[%%]", "<Ratio, Fraction> Promil, Per mille = 0.001", 2, "[%%]", "4.0", 12);
            this.addKeyWord("[Y]", "<Metric prefix> Septillion / Yotta = 10^24", 101, "[Y]", "4.0", 12);
            this.addKeyWord("[sept]", "<Metric prefix> Septillion / Yotta = 10^24", 101, "[sept]", "4.0", 12);
            this.addKeyWord("[Z]", "<Metric prefix> Sextillion / Zetta = 10^21", 102, "[Z]", "4.0", 12);
            this.addKeyWord("[sext]", "<Metric prefix> Sextillion / Zetta = 10^21", 102, "[sext]", "4.0", 12);
            this.addKeyWord("[E]", "<Metric prefix> Quintillion / Exa = 10^18", 103, "[E]", "4.0", 12);
            this.addKeyWord("[quint]", "<Metric prefix> Quintillion / Exa = 10^18", 103, "[quint]", "4.0", 12);
            this.addKeyWord("[P]", "<Metric prefix> Quadrillion / Peta = 10^15", 104, "[P]", "4.0", 12);
            this.addKeyWord("[quad]", "<Metric prefix> Quadrillion / Peta = 10^15", 104, "[quad]", "4.0", 12);
            this.addKeyWord("[T]", "<Metric prefix> Trillion / Tera = 10^12", 105, "[T]", "4.0", 12);
            this.addKeyWord("[tril]", "<Metric prefix> Trillion / Tera = 10^12", 105, "[tril]", "4.0", 12);
            this.addKeyWord("[G]", "<Metric prefix> Billion / Giga = 10^9", 106, "[G]", "4.0", 12);
            this.addKeyWord("[bil]", "<Metric prefix> Billion / Giga = 10^9", 106, "[bil]", "4.0", 12);
            this.addKeyWord("[M]", "<Metric prefix> Million / Mega = 10^6", 107, "[M]", "4.0", 12);
            this.addKeyWord("[mil]", "<Metric prefix> Million / Mega = 10^6", 107, "[mil]", "4.0", 12);
            this.addKeyWord("[k]", "<Metric prefix> Thousand / Kilo = 10^3", 108, "[k]", "4.0", 12);
            this.addKeyWord("[th]", "<Metric prefix> Thousand / Kilo = 10^3", 108, "[th]", "4.0", 12);
            this.addKeyWord("[hecto]", "<Metric prefix> Hundred / Hecto = 10^2", 109, "[hecto]", "4.0", 12);
            this.addKeyWord("[hund]", "<Metric prefix> Hundred / Hecto = 10^2", 109, "[hund]", "4.0", 12);
            this.addKeyWord("[deca]", "<Metric prefix> Ten / Deca = 10", 110, "[deca]", "4.0", 12);
            this.addKeyWord("[ten]", "<Metric prefix> Ten / Deca = 10", 110, "[ten]", "4.0", 12);
            this.addKeyWord("[deci]", "<Metric prefix> Tenth / Deci = 0.1", 111, "[deci]", "4.0", 12);
            this.addKeyWord("[centi]", "<Metric prefix> Hundredth / Centi = 0.01", 112, "[centi]", "4.0", 12);
            this.addKeyWord("[milli]", "<Metric prefix> Thousandth / Milli = 0.001", 113, "[milli]", "4.0", 12);
            this.addKeyWord("[mic]", "<Metric prefix> Millionth / Micro = 10^-6", 114, "[mic]", "4.0", 12);
            this.addKeyWord("[n]", "<Metric prefix> Billionth / Nano = 10^-9", 115, "[n]", "4.0", 12);
            this.addKeyWord("[p]", "<Metric prefix> Trillionth / Pico = 10^-12", 116, "[p]", "4.0", 12);
            this.addKeyWord("[f]", "<Metric prefix> Quadrillionth / Femto = 10^-15", 117, "[f]", "4.0", 12);
            this.addKeyWord("[a]", "<Metric prefix> Quintillionth / Atoo = 10^-18", 118, "[a]", "4.0", 12);
            this.addKeyWord("[z]", "<Metric prefix> Sextillionth / Zepto = 10^-21", 119, "[z]", "4.0", 12);
            this.addKeyWord("[y]", "<Metric prefix> Septillionth / Yocto = 10^-24", 120, "[y]", "4.0", 12);
            this.addKeyWord("[m]", "<Unit of length> Metre / Meter (m=1)", 201, "[m]", "4.0", 12);
            this.addKeyWord("[km]", "<Unit of length> Kilometre / Kilometer (m=1)", 202, "[km]", "4.0", 12);
            this.addKeyWord("[cm]", "<Unit of length> Centimetre / Centimeter (m=1)", 203, "[cm]", "4.0", 12);
            this.addKeyWord("[mm]", "<Unit of length> Millimetre / Millimeter (m=1)", 204, "[mm]", "4.0", 12);
            this.addKeyWord("[inch]", "<Unit of length> Inch (m=1)", 205, "[inch]", "4.0", 12);
            this.addKeyWord("[yd]", "<Unit of length> Yard (m=1)", 206, "[yd]", "4.0", 12);
            this.addKeyWord("[ft]", "<Unit of length> Feet (m=1)", 207, "[ft]", "4.0", 12);
            this.addKeyWord("[mile]", "<Unit of length> Mile (m=1)", 208, "[mile]", "4.0", 12);
            this.addKeyWord("[nmi]", "<Unit of length> Nautical mile (m=1)", 209, "[nmi]", "4.0", 12);
            this.addKeyWord("[m2]", "<Unit of area> Square metre / Square meter (m=1)", 301, "[m2]", "4.0", 12);
            this.addKeyWord("[cm2]", "<Unit of area> Square centimetre / Square centimeter (m=1)", 302, "[cm2]", "4.0", 12);
            this.addKeyWord("[mm2]", "<Unit of area> Square millimetre / Square millimeter (m=1)", 303, "[mm2]", "4.0", 12);
            this.addKeyWord("[are]", "<Unit of area> Are (m=1)", 304, "[are]", "4.0", 12);
            this.addKeyWord("[ha]", "<Unit of area> Hectare (m=1)", 305, "[ha]", "4.0", 12);
            this.addKeyWord("[acre]", "<Unit of area> Acre (m=1)", 306, "[acre]", "4.0", 12);
            this.addKeyWord("[km2]", "<Unit of area> Square kilometre / Square kilometer (m=1)", 307, "[km2]", "4.0", 12);
            this.addKeyWord("[mm3]", "<Unit of volume> Cubic millimetre / Cubic millimeter (m=1)", 401, "[mm3]", "4.0", 12);
            this.addKeyWord("[cm3]", "<Unit of volume> Cubic centimetre / Cubic centimeter (m=1)", 402, "[cm3]", "4.0", 12);
            this.addKeyWord("[m3]", "<Unit of volume> Cubic metre / Cubic meter (m=1)", 403, "[m3]", "4.0", 12);
            this.addKeyWord("[km3]", "<Unit of volume> Cubic kilometre / Cubic kilometer (m=1)", 404, "[km3]", "4.0", 12);
            this.addKeyWord("[ml]", "<Unit of volume> Millilitre / Milliliter (m=1)", 405, "[ml]", "4.0", 12);
            this.addKeyWord("[l]", "<Unit of volume> Litre / Liter (m=1)", 406, "[l]", "4.0", 12);
            this.addKeyWord("[gall]", "<Unit of volume> Gallon (m=1)", 407, "[gall]", "4.0", 12);
            this.addKeyWord("[pint]", "<Unit of volume> Pint (m=1)", 408, "[pint]", "4.0", 12);
            this.addKeyWord("[s]", "<Unit of time> Second (s=1)", 501, "[s]", "4.0", 12);
            this.addKeyWord("[ms]", "<Unit of time> Millisecond (s=1)", 502, "[ms]", "4.0", 12);
            this.addKeyWord("[min]", "<Unit of time> Minute (s=1)", 503, "[min]", "4.0", 12);
            this.addKeyWord("[h]", "<Unit of time> Hour (s=1)", 504, "[h]", "4.0", 12);
            this.addKeyWord("[day]", "<Unit of time> Day (s=1)", 505, "[day]", "4.0", 12);
            this.addKeyWord("[week]", "<Unit of time> Week (s=1)", 506, "[week]", "4.0", 12);
            this.addKeyWord("[yearj]", "<Unit of time> Julian year = 365.25 days (s=1)", 507, "[yearj]", "4.0", 12);
            this.addKeyWord("[kg]", "<Unit of mass> Kilogram (kg=1)", 508, "[kg]", "4.0", 12);
            this.addKeyWord("[gr]", "<Unit of mass> Gram (kg=1)", 509, "[gr]", "4.0", 12);
            this.addKeyWord("[mg]", "<Unit of mass> Milligram (kg=1)", 510, "[mg]", "4.0", 12);
            this.addKeyWord("[dag]", "<Unit of mass> Decagram (kg=1)", 511, "[dag]", "4.0", 12);
            this.addKeyWord("[t]", "<Unit of mass> Tonne (kg=1)", 512, "[t]", "4.0", 12);
            this.addKeyWord("[oz]", "<Unit of mass> Ounce (kg=1)", 513, "[oz]", "4.0", 12);
            this.addKeyWord("[lb]", "<Unit of mass> Pound (kg=1)", 514, "[lb]", "4.0", 12);
            this.addKeyWord("[b]", "<Unit of information> Bit (bit=1)", 601, "[b]", "4.0", 12);
            this.addKeyWord("[kb]", "<Unit of information> Kilobit (bit=1)", 602, "[kb]", "4.0", 12);
            this.addKeyWord("[Mb]", "<Unit of information> Megabit (bit=1)", 603, "[Mb]", "4.0", 12);
            this.addKeyWord("[Gb]", "<Unit of information> Gigabit (bit=1)", 604, "[Gb]", "4.0", 12);
            this.addKeyWord("[Tb]", "<Unit of information> Terabit (bit=1)", 605, "[Tb]", "4.0", 12);
            this.addKeyWord("[Pb]", "<Unit of information> Petabit (bit=1)", 606, "[Pb]", "4.0", 12);
            this.addKeyWord("[Eb]", "<Unit of information> Exabit (bit=1)", 607, "[Eb]", "4.0", 12);
            this.addKeyWord("[Zb]", "<Unit of information> Zettabit (bit=1)", 608, "[Zb]", "4.0", 12);
            this.addKeyWord("[Yb]", "<Unit of information> Yottabit (bit=1)", 609, "[Yb]", "4.0", 12);
            this.addKeyWord("[B]", "<Unit of information> Byte (bit=1)", 610, "[B]", "4.0", 12);
            this.addKeyWord("[kB]", "<Unit of information> Kilobyte (bit=1)", 611, "[kB]", "4.0", 12);
            this.addKeyWord("[MB]", "<Unit of information> Megabyte (bit=1)", 612, "[MB]", "4.0", 12);
            this.addKeyWord("[GB]", "<Unit of information> Gigabyte (bit=1)", 613, "[GB]", "4.0", 12);
            this.addKeyWord("[TB]", "<Unit of information> Terabyte (bit=1)", 614, "[TB]", "4.0", 12);
            this.addKeyWord("[PB]", "<Unit of information> Petabyte (bit=1)", 615, "[PB]", "4.0", 12);
            this.addKeyWord("[EB]", "<Unit of information> Exabyte (bit=1)", 616, "[EB]", "4.0", 12);
            this.addKeyWord("[ZB]", "<Unit of information> Zettabyte (bit=1)", 617, "[ZB]", "4.0", 12);
            this.addKeyWord("[YB]", "<Unit of information> Yottabyte (bit=1)", 618, "[YB]", "4.0", 12);
            this.addKeyWord("[J]", "<Unit of energy> Joule (m=1, kg=1, s=1)", 701, "[J]", "4.0", 12);
            this.addKeyWord("[eV]", "<Unit of energy> Electronovolt (m=1, kg=1, s=1)", 702, "[eV]", "4.0", 12);
            this.addKeyWord("[keV]", "<Unit of energy> Kiloelectronovolt (m=1, kg=1, s=1)", 703, "[keV]", "4.0", 12);
            this.addKeyWord("[MeV]", "<Unit of energy> Megaelectronovolt (m=1, kg=1, s=1)", 704, "[MeV]", "4.0", 12);
            this.addKeyWord("[GeV]", "<Unit of energy> Gigaelectronovolt (m=1, kg=1, s=1)", 705, "[GeV]", "4.0", 12);
            this.addKeyWord("[TeV]", "<Unit of energy> Teraelectronovolt (m=1, kg=1, s=1)", 706, "[TeV]", "4.0", 12);
            this.addKeyWord("[m/s]", "<Unit of speed> Metre / Meter per second (m=1, s=1)", 801, "[m/s]", "4.0", 12);
            this.addKeyWord("[km/h]", "<Unit of speed> Kilometre / Kilometer per hour (m=1, s=1)", 802, "[km/h]", "4.0", 12);
            this.addKeyWord("[mi/h]", "<Unit of speed> Mile per hour (m=1, s=1)", 803, "[mi/h]", "4.0", 12);
            this.addKeyWord("[knot]", "<Unit of speed> Knot (m=1, s=1)", 804, "[knot]", "4.0", 12);
            this.addKeyWord("[m/s2]", "<Unit of acceleration> Metre / Meter per square second (m=1, s=1)", 901, "[m/s2]", "4.0", 12);
            this.addKeyWord("[km/h2]", "<Unit of acceleration> Kilometre / Kilometer per square hour (m=1, s=1)", 902, "[km/h2]", "4.0", 12);
            this.addKeyWord("[mi/h2]", "<Unit of acceleration> Mile per square hour (m=1, s=1)", 903, "[mi/h2]", "4.0", 12);
            this.addKeyWord("[rad]", "<Unit of angle> Radian (rad=1)", 1001, "[rad]", "4.0", 12);
            this.addKeyWord("[deg]", "<Unit of angle> Degree of arc (rad=1)", 1002, "[deg]", "4.0", 12);
            this.addKeyWord("[']", "<Unit of angle> Minute of arc (rad=1)", 1003, "[']", "4.0", 12);
            this.addKeyWord("['']", "<Unit of angle> Second of arc (rad=1)", 1004, "['']", "4.0", 12);
            if (this.UDFExpression) {
                this.addUDFSpecificParserKeyWords();
            }
        }
        this.addKeyWord("(", "Left parentheses", 1, "( ... )", "1.0", 20);
        this.addKeyWord(")", "Right parentheses", 2, "( ... )", "1.0", 20);
        this.addKeyWord(",", "Comma (function parameters)", 3, "(a1, ... ,an)", "1.0", 20);
        this.addKeyWord(";", "Semicolon (function parameters)", 3, "(a1; ... ;an)", "1.0", 20);
        this.addKeyWord("[+-]?(([0-9]([0-9])*)?\\.[0-9]([0-9])*|[0-9]([0-9])*)([eE][+-]?[0-9]([0-9])*)?", "Regullar expression for decimal numbers", 1, "Integer (since v.1.0): 1, -2; Decimal (since v.1.0): 0.2, -0.3, 1.2; Leading zero (since v.4.1): 001, -002.1; Scientific notation (since v.4.2): 1.2e-10, 1.2e+10, 2.3e10; No leading zero (since v.4.2): .2, -.212; Fractions (since v.4.2): 1_2, 2_1_3, 14_3; Other systems (since v.4.1): b1.111, b2.1001, b3.12021, b16.af12, h.af1, b.1001, o.0127", "1.0", 0);
        this.addKeyWord(" ", "Blank (whitespace) character", 4, " ", "4.2", 20);
    }

    private void addArgumentsKeyWords() {
        int argumentsNumber = this.argumentsList.size();
        for (int argumentIndex = 0; argumentIndex < argumentsNumber; ++argumentIndex) {
            Argument arg = this.argumentsList.get(argumentIndex);
            if (arg.getArgumentType() != 3) {
                this.addKeyWord(arg.getArgumentName(), arg.getDescription(), argumentIndex, arg.getArgumentName(), "", 101);
                continue;
            }
            this.addKeyWord(arg.getArgumentName(), arg.getDescription(), argumentIndex, arg.getArgumentName() + "(n)", "", 102);
        }
    }

    private void addFunctionsKeyWords() {
        int functionsNumber = this.functionsList.size();
        for (int functionIndex = 0; functionIndex < functionsNumber; ++functionIndex) {
            Function fun = this.functionsList.get(functionIndex);
            String syntax = fun.getFunctionName() + "(";
            int paramsNum = fun.getParametersNumber();
            for (int i = 0; i < paramsNum; ++i) {
                syntax = syntax + fun.getParameterName(i);
                if (paramsNum <= 1 || i >= paramsNum - 1) continue;
                syntax = syntax + ",";
            }
            syntax = syntax + ")";
            this.addKeyWord(fun.getFunctionName(), fun.getDescription(), functionIndex, syntax, "", 103);
        }
    }

    private void addConstantsKeyWords() {
        int constantsNumber = this.constantsList.size();
        for (int constantIndex = 0; constantIndex < constantsNumber; ++constantIndex) {
            Constant c = this.constantsList.get(constantIndex);
            this.addKeyWord(c.getConstantName(), c.getDescription(), constantIndex, c.getConstantName(), "", 104);
        }
    }

    private void validateParserKeyWords() {
        if (mXparser.overrideBuiltinTokens) {
            ArrayList<String> userDefinedTokens = new ArrayList<String>();
            for (Argument arg : this.argumentsList) {
                userDefinedTokens.add(arg.getArgumentName());
            }
            for (Function fun : this.functionsList) {
                userDefinedTokens.add(fun.getFunctionName());
            }
            for (Constant cons : this.constantsList) {
                userDefinedTokens.add(cons.getConstantName());
            }
            if (userDefinedTokens.isEmpty()) {
                return;
            }
            ArrayList<KeyWord> keyWordsToOverride = new ArrayList<KeyWord>();
            for (KeyWord kw : this.keyWordsList) {
                if (!userDefinedTokens.contains(kw.wordString)) continue;
                keyWordsToOverride.add(kw);
            }
            if (keyWordsToOverride.isEmpty()) {
                return;
            }
            for (KeyWord kw : keyWordsToOverride) {
                this.keyWordsList.remove(kw);
            }
        }
    }

    private void addKeyWord(String wordString, String wordDescription, int wordId, String wordSyntax, String wordSince, int wordTypeId) {
        if (!(mXparser.tokensToRemove.size() <= 0 && mXparser.tokensToModify.size() <= 0 || wordTypeId != 4 && wordTypeId != 5 && wordTypeId != 6 && wordTypeId != 7 && wordTypeId != 8 && wordTypeId != 9 && wordTypeId != 10 && wordTypeId != 12)) {
            if (mXparser.tokensToRemove.size() > 0 && mXparser.tokensToRemove.contains(wordString)) {
                return;
            }
            if (mXparser.tokensToModify.size() > 0) {
                for (TokenModification tm : mXparser.tokensToModify) {
                    if (!tm.currentToken.equals(wordString)) continue;
                    wordString = tm.newToken;
                    if (tm.newTokenDescription != null) {
                        wordDescription = tm.newTokenDescription;
                    }
                    wordSyntax = wordSyntax.replace(tm.currentToken, tm.newToken);
                }
            }
        }
        this.keyWordsList.add(new KeyWord(wordString, wordDescription, wordId, wordSyntax, wordSince, wordTypeId));
    }

    private void checkOtherNumberBases(Token token) {
        int dotPos = 0;
        int tokenStrLength = token.tokenStr.length();
        if (tokenStrLength >= 2 && token.tokenStr.charAt(1) == '.') {
            dotPos = 1;
        }
        if (dotPos == 0 && tokenStrLength >= 3 && token.tokenStr.charAt(2) == '.') {
            dotPos = 2;
        }
        if (dotPos == 0 && tokenStrLength >= 4 && token.tokenStr.charAt(3) == '.') {
            dotPos = 3;
        }
        if (dotPos == 0) {
            return;
        }
        String baseInd = token.tokenStr.substring(0, dotPos).toLowerCase();
        String numberLiteral = "";
        if (tokenStrLength > dotPos + 1) {
            numberLiteral = token.tokenStr.substring(dotPos + 1);
        }
        int numeralSystemBase = 0;
        if (baseInd.equals("b")) {
            numeralSystemBase = 2;
        } else if (baseInd.equals("o")) {
            numeralSystemBase = 8;
        } else if (baseInd.equals("h")) {
            numeralSystemBase = 16;
        } else if (baseInd.equals("b1")) {
            numeralSystemBase = 1;
        } else if (baseInd.equals("b2")) {
            numeralSystemBase = 2;
        } else if (baseInd.equals("b3")) {
            numeralSystemBase = 3;
        } else if (baseInd.equals("b4")) {
            numeralSystemBase = 4;
        } else if (baseInd.equals("b5")) {
            numeralSystemBase = 5;
        } else if (baseInd.equals("b6")) {
            numeralSystemBase = 6;
        } else if (baseInd.equals("b7")) {
            numeralSystemBase = 7;
        } else if (baseInd.equals("b8")) {
            numeralSystemBase = 8;
        } else if (baseInd.equals("b9")) {
            numeralSystemBase = 9;
        } else if (baseInd.equals("b10")) {
            numeralSystemBase = 10;
        } else if (baseInd.equals("b11")) {
            numeralSystemBase = 11;
        } else if (baseInd.equals("b12")) {
            numeralSystemBase = 12;
        } else if (baseInd.equals("b13")) {
            numeralSystemBase = 13;
        } else if (baseInd.equals("b14")) {
            numeralSystemBase = 14;
        } else if (baseInd.equals("b15")) {
            numeralSystemBase = 15;
        } else if (baseInd.equals("b16")) {
            numeralSystemBase = 16;
        } else if (baseInd.equals("b17")) {
            numeralSystemBase = 17;
        } else if (baseInd.equals("b18")) {
            numeralSystemBase = 18;
        } else if (baseInd.equals("b19")) {
            numeralSystemBase = 19;
        } else if (baseInd.equals("b20")) {
            numeralSystemBase = 20;
        } else if (baseInd.equals("b21")) {
            numeralSystemBase = 21;
        } else if (baseInd.equals("b22")) {
            numeralSystemBase = 22;
        } else if (baseInd.equals("b23")) {
            numeralSystemBase = 23;
        } else if (baseInd.equals("b24")) {
            numeralSystemBase = 24;
        } else if (baseInd.equals("b25")) {
            numeralSystemBase = 25;
        } else if (baseInd.equals("b26")) {
            numeralSystemBase = 26;
        } else if (baseInd.equals("b27")) {
            numeralSystemBase = 27;
        } else if (baseInd.equals("b28")) {
            numeralSystemBase = 28;
        } else if (baseInd.equals("b29")) {
            numeralSystemBase = 29;
        } else if (baseInd.equals("b30")) {
            numeralSystemBase = 30;
        } else if (baseInd.equals("b31")) {
            numeralSystemBase = 31;
        } else if (baseInd.equals("b32")) {
            numeralSystemBase = 32;
        } else if (baseInd.equals("b33")) {
            numeralSystemBase = 33;
        } else if (baseInd.equals("b34")) {
            numeralSystemBase = 34;
        } else if (baseInd.equals("b35")) {
            numeralSystemBase = 35;
        } else if (baseInd.equals("b36")) {
            numeralSystemBase = 36;
        }
        if (numeralSystemBase > 0 && numeralSystemBase <= 36) {
            token.tokenTypeId = 0;
            token.tokenId = 1;
            token.tokenValue = NumberTheory.convOthBase2Decimal(numberLiteral, numeralSystemBase);
        }
    }

    private void checkFraction(Token token) {
        double fractionValue;
        int tokenStrLength = token.tokenStr.length();
        if (tokenStrLength < 3) {
            return;
        }
        if (!mXparser.regexMatch(token.tokenStr, "([0-9]([0-9])*\\_)?[0-9]([0-9])*\\_[0-9]([0-9])*")) {
            return;
        }
        int underscore1stPos = token.tokenStr.indexOf(95);
        int underscore2ndPos = token.tokenStr.indexOf(95, underscore1stPos + 1);
        boolean mixedFraction = false;
        if (underscore2ndPos > 0) {
            mixedFraction = true;
        }
        if (mixedFraction) {
            String wholeStr = token.tokenStr.substring(0, underscore1stPos);
            String numeratorStr = token.tokenStr.substring(underscore1stPos + 1, underscore2ndPos);
            String denominatorStr = token.tokenStr.substring(underscore2ndPos + 1);
            double whole = Double.parseDouble(wholeStr);
            double numerator = Double.parseDouble(numeratorStr);
            double denominator = Double.parseDouble(denominatorStr);
            fractionValue = denominator == 0.0 ? Double.NaN : whole + numerator / denominator;
        } else {
            String numeratorStr = token.tokenStr.substring(0, underscore1stPos);
            String denominatorStr = token.tokenStr.substring(underscore1stPos + 1);
            double numerator = Double.parseDouble(numeratorStr);
            double denominator = Double.parseDouble(denominatorStr);
            fractionValue = denominator == 0.0 ? Double.NaN : numerator / denominator;
        }
        token.tokenTypeId = 0;
        token.tokenId = 1;
        token.tokenValue = fractionValue;
    }

    private void addToken(String tokenStr, KeyWord keyWord) {
        Token token = new Token();
        this.initialTokens.add(token);
        token.tokenStr = tokenStr;
        token.keyWord = keyWord.wordString;
        token.tokenTypeId = keyWord.wordTypeId;
        token.tokenId = keyWord.wordId;
        if (token.tokenTypeId == 101) {
            token.tokenValue = this.argumentsList.get((int)token.tokenId).argumentValue;
        } else if (token.tokenTypeId == 0) {
            token.tokenValue = Double.valueOf(token.tokenStr);
            token.keyWord = "_num_";
        } else if (token.tokenTypeId == -1) {
            this.checkOtherNumberBases(token);
            if (token.tokenTypeId == -1) {
                this.checkFraction(token);
            }
        }
    }

    private boolean isNotSpecialChar(char c) {
        if (c == '+') {
            return false;
        }
        if (c == '-') {
            return false;
        }
        if (c == '+') {
            return false;
        }
        if (c == '*') {
            return false;
        }
        if (c == '/') {
            return false;
        }
        if (c == '^') {
            return false;
        }
        if (c == ',') {
            return false;
        }
        if (c == ';') {
            return false;
        }
        if (c == '(') {
            return false;
        }
        if (c == ')') {
            return false;
        }
        if (c == '|') {
            return false;
        }
        if (c == '&') {
            return false;
        }
        if (c == '=') {
            return false;
        }
        if (c == '>') {
            return false;
        }
        if (c == '<') {
            return false;
        }
        if (c == '~') {
            return false;
        }
        if (c == '\\') {
            return false;
        }
        if (c == '#') {
            return false;
        }
        return c != '@';
    }

    private void tokenizeExpressionString() {
        char c;
        this.keyWordsList = new ArrayList<KeyWord>();
        this.addParserKeyWords();
        this.validateParserKeyWords();
        if (!this.parserKeyWordsOnly) {
            this.addArgumentsKeyWords();
            this.addFunctionsKeyWords();
            this.addConstantsKeyWords();
        }
        Collections.sort(this.keyWordsList, new DescKwLenComparator());
        int numberKwId = -1;
        int plusKwId = -1;
        int minusKwId = -1;
        for (int kwId = 0; kwId < this.keyWordsList.size(); ++kwId) {
            if (this.keyWordsList.get((int)kwId).wordTypeId == 0) {
                numberKwId = kwId;
            }
            if (this.keyWordsList.get((int)kwId).wordTypeId != 1) continue;
            if (this.keyWordsList.get((int)kwId).wordId == 1) {
                plusKwId = kwId;
            }
            if (this.keyWordsList.get((int)kwId).wordId != 2) continue;
            minusKwId = kwId;
        }
        this.initialTokens = new ArrayList<Token>();
        int expLen = this.expressionString.length();
        if (expLen == 0) {
            return;
        }
        String newExpressionString = "";
        char clag1 = 'a';
        int blankCnt = 0;
        int newExpLen = 0;
        for (int i = 0; i < expLen; ++i) {
            c = this.expressionString.charAt(i);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t' || c == '\f') {
                ++blankCnt;
            } else if (blankCnt > 0) {
                if (newExpLen > 0 && this.isNotSpecialChar(clag1)) {
                    newExpressionString = newExpressionString + " ";
                }
                blankCnt = 0;
            }
            if (blankCnt != 0) continue;
            newExpressionString = newExpressionString + c;
            clag1 = c;
            ++newExpLen;
        }
        if (newExpressionString.length() == 0) {
            return;
        }
        int lastPos = 0;
        int pos = 0;
        String tokenStr = "";
        int matchStatusPrev = -1;
        int matchStatus = -1;
        KeyWord kw = null;
        String sub = "";
        String kwStr = "";
        do {
            char followingChar;
            char precedingChar;
            int numEnd = -1;
            char firstChar = newExpressionString.charAt(pos);
            if (firstChar == '+' || firstChar == '-' || firstChar == '.' || firstChar == '0' || firstChar == '1' || firstChar == '2' || firstChar == '3' || firstChar == '4' || firstChar == '5' || firstChar == '6' || firstChar == '7' || firstChar == '8' || firstChar == '9') {
                for (int i = pos; i < newExpressionString.length() && (i <= pos || (c = newExpressionString.charAt(i)) == '+' || c == '-' || c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == '.' || c == 'e' || c == 'E'); ++i) {
                    String str = newExpressionString.substring(pos, i + 1);
                    if (!mXparser.regexMatch(str, "[+-]?(([0-9]([0-9])*)?\\.[0-9]([0-9])*|[0-9]([0-9])*)([eE][+-]?[0-9]([0-9])*)?")) continue;
                    numEnd = i;
                }
            }
            if (numEnd >= 0 && pos > 0 && (precedingChar = newExpressionString.charAt(pos - 1)) != ' ' && precedingChar != ',' && precedingChar != ';' && precedingChar != '|' && precedingChar != '&' && precedingChar != '+' && precedingChar != '-' && precedingChar != '*' && precedingChar != '\\' && precedingChar != '/' && precedingChar != '(' && precedingChar != ')' && precedingChar != '=' && precedingChar != '>' && precedingChar != '<' && precedingChar != '~' && precedingChar != '^' && precedingChar != '#' && precedingChar != '%' && precedingChar != '@' && precedingChar != '!') {
                numEnd = -1;
            }
            if (numEnd >= 0 && numEnd < newExpressionString.length() - 1 && (followingChar = newExpressionString.charAt(numEnd + 1)) != ' ' && followingChar != ',' && followingChar != ';' && followingChar != '|' && followingChar != '&' && followingChar != '+' && followingChar != '-' && followingChar != '*' && followingChar != '\\' && followingChar != '/' && followingChar != '(' && followingChar != ')' && followingChar != '=' && followingChar != '>' && followingChar != '<' && followingChar != '~' && followingChar != '^' && followingChar != '#' && followingChar != '%' && followingChar != '@' && followingChar != '!') {
                numEnd = -1;
            }
            if (numEnd >= 0) {
                if (matchStatusPrev == -1 && pos > 0) {
                    tokenStr = newExpressionString.substring(lastPos, pos);
                    this.addToken(tokenStr, new KeyWord());
                }
                firstChar = newExpressionString.charAt(pos);
                boolean leadingOp = true;
                if (firstChar == '-' || firstChar == '+') {
                    if (this.initialTokens.size() > 0) {
                        Token lastToken = this.initialTokens.get(this.initialTokens.size() - 1);
                        leadingOp = !(lastToken.tokenTypeId == 1 && lastToken.tokenId != 6 && lastToken.tokenId != 8 || lastToken.tokenTypeId == 3 || lastToken.tokenTypeId == 2 || lastToken.tokenTypeId == 11 || lastToken.tokenTypeId == 20 && lastToken.tokenId == 1);
                    } else {
                        leadingOp = false;
                    }
                } else {
                    leadingOp = false;
                }
                if (leadingOp) {
                    if (firstChar == '-') {
                        this.addToken("-", this.keyWordsList.get(minusKwId));
                    }
                    if (firstChar == '+') {
                        this.addToken("+", this.keyWordsList.get(plusKwId));
                    }
                    ++pos;
                }
                tokenStr = newExpressionString.substring(pos, numEnd + 1);
                this.addToken(tokenStr, this.keyWordsList.get(numberKwId));
                lastPos = pos = numEnd + 1;
                matchStatus = 0;
                matchStatusPrev = 0;
                continue;
            }
            int kwId = -1;
            matchStatus = -1;
            do {
                kw = this.keyWordsList.get(++kwId);
                kwStr = kw.wordString;
                if (pos + kwStr.length() > newExpressionString.length()) continue;
                sub = newExpressionString.substring(pos, pos + kwStr.length());
                if (sub.equals(kwStr)) {
                    matchStatus = 0;
                }
                if (matchStatus != 0 || kw.wordTypeId != 101 && kw.wordTypeId != 102 && kw.wordTypeId != 4 && kw.wordTypeId != 5 && kw.wordTypeId != 6 && kw.wordTypeId != 7 && kw.wordTypeId != 9 && kw.wordTypeId != 104 && kw.wordTypeId != 10 && kw.wordTypeId != 12 && kw.wordTypeId != 103 && kw.wordTypeId != 8) continue;
                if (pos > 0 && (precedingChar = newExpressionString.charAt(pos - 1)) != ' ' && precedingChar != ',' && precedingChar != ';' && precedingChar != '|' && precedingChar != '&' && precedingChar != '+' && precedingChar != '-' && precedingChar != '*' && precedingChar != '\\' && precedingChar != '/' && precedingChar != '(' && precedingChar != ')' && precedingChar != '=' && precedingChar != '>' && precedingChar != '<' && precedingChar != '~' && precedingChar != '^' && precedingChar != '#' && precedingChar != '%' && precedingChar != '@' && precedingChar != '!') {
                    matchStatus = -1;
                }
                if (matchStatus != 0 || pos + kwStr.length() >= newExpressionString.length() || (followingChar = newExpressionString.charAt(pos + kwStr.length())) == ' ' || followingChar == ',' || followingChar == ';' || followingChar == '|' || followingChar == '&' || followingChar == '+' || followingChar == '-' || followingChar == '*' || followingChar == '\\' || followingChar == '/' || followingChar == '(' || followingChar == ')' || followingChar == '=' || followingChar == '>' || followingChar == '<' || followingChar == '~' || followingChar == '^' || followingChar == '#' || followingChar == '%' || followingChar == '@' || followingChar == '!') continue;
                matchStatus = -1;
            } while (kwId < this.keyWordsList.size() - 1 && matchStatus == -1);
            if (matchStatus == 0) {
                if (matchStatusPrev == -1 && pos > 0) {
                    tokenStr = newExpressionString.substring(lastPos, pos);
                    this.addToken(tokenStr, new KeyWord());
                }
                matchStatusPrev = 0;
                tokenStr = newExpressionString.substring(pos, pos + kwStr.length());
                if (kw.wordTypeId != 20 || kw.wordId != 4) {
                    this.addToken(tokenStr, kw);
                }
                lastPos = pos + kwStr.length();
                pos += kwStr.length();
                continue;
            }
            matchStatusPrev = -1;
            if (pos >= newExpressionString.length()) continue;
            ++pos;
        } while (pos < newExpressionString.length());
        if (matchStatus == -1) {
            tokenStr = newExpressionString.substring(lastPos, pos);
            this.addToken(tokenStr, new KeyWord());
        }
        this.evaluateTokensLevels();
    }

    private void evaluateTokensLevels() {
        int tokenLevel = 0;
        Stack<TokenStackElement> tokenStack = new Stack<TokenStackElement>();
        boolean precedingFunction = false;
        if (this.initialTokens.size() > 0) {
            for (int tokenIndex = 0; tokenIndex < this.initialTokens.size(); ++tokenIndex) {
                TokenStackElement stackEl;
                Token token = this.initialTokens.get(tokenIndex);
                if (token.tokenTypeId == 4 || token.tokenTypeId == 5 || token.tokenTypeId == 6 || token.tokenTypeId == 103 || token.tokenTypeId == 8 || token.tokenTypeId == 102 || token.tokenTypeId == 7) {
                    precedingFunction = true;
                } else if (token.tokenTypeId == 20 && token.tokenId == 1) {
                    stackEl = new TokenStackElement();
                    stackEl.tokenId = token.tokenId;
                    stackEl.tokenIndex = tokenIndex;
                    stackEl.tokenLevel = ++tokenLevel;
                    stackEl.tokenTypeId = token.tokenTypeId;
                    stackEl.precedingFunction = precedingFunction;
                    tokenStack.push(stackEl);
                    precedingFunction = false;
                } else {
                    precedingFunction = false;
                }
                token.tokenLevel = ++tokenLevel;
                if (token.tokenTypeId != 20 || token.tokenId != 2) continue;
                --tokenLevel;
                if (tokenStack.isEmpty()) continue;
                stackEl = (TokenStackElement)tokenStack.pop();
                if (!stackEl.precedingFunction) continue;
                --tokenLevel;
            }
        }
    }

    private void copyInitialTokens() {
        this.tokensList = new ArrayList<Token>();
        for (Token token : this.initialTokens) {
            this.tokensList.add(token.clone());
        }
    }

    public List<Token> getCopyOfInitialTokens() {
        ArrayList<Token> tokensListCopy = new ArrayList<Token>();
        if (this.expressionString.length() == 0) {
            return tokensListCopy;
        }
        this.tokenizeExpressionString();
        if (this.initialTokens.size() == 0) {
            return tokensListCopy;
        }
        for (int i = 0; i < this.initialTokens.size(); ++i) {
            Token token = this.initialTokens.get(i);
            if (token.tokenTypeId == -1) {
                if (mXparser.regexMatch(token.tokenStr, "\\[([a-zA-Z_])+([a-zA-Z0-9_])*\\]")) {
                    token.looksLike = "unit/const";
                } else if (mXparser.regexMatch(token.tokenStr, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
                    token.looksLike = "argument";
                    if (i < this.initialTokens.size() - 1) {
                        Token tokenNext = this.initialTokens.get(i + 1);
                        if (tokenNext.tokenTypeId == 20 && tokenNext.tokenId == 1) {
                            token.looksLike = "function";
                        }
                    }
                } else {
                    token.looksLike = "error";
                }
            }
            tokensListCopy.add(token.clone());
        }
        return tokensListCopy;
    }

    public String[] getMissingUserDefinedArguments() {
        List<Token> tokens = this.getCopyOfInitialTokens();
        ArrayList<String> missingArguments = new ArrayList<String>();
        for (Token t : tokens) {
            if (!t.looksLike.equals("argument") || missingArguments.contains(t.tokenStr)) continue;
            missingArguments.add(t.tokenStr);
        }
        int n = missingArguments.size();
        String[] missArgs = new String[n];
        for (int i = 0; i < n; ++i) {
            missArgs[i] = (String)missingArguments.get(i);
        }
        return missArgs;
    }

    public String[] getMissingUserDefinedUnits() {
        List<Token> tokens = this.getCopyOfInitialTokens();
        ArrayList<String> missingUnits = new ArrayList<String>();
        for (Token t : tokens) {
            if (!t.looksLike.equals("unit/const") || missingUnits.contains(t.tokenStr)) continue;
            missingUnits.add(t.tokenStr);
        }
        int n = missingUnits.size();
        String[] missUnits = new String[n];
        for (int i = 0; i < n; ++i) {
            missUnits[i] = (String)missingUnits.get(i);
        }
        return missUnits;
    }

    public String[] getMissingUserDefinedFunctions() {
        List<Token> tokens = this.getCopyOfInitialTokens();
        ArrayList<String> missingFunctions = new ArrayList<String>();
        for (Token t : tokens) {
            if (!t.looksLike.equals("function") || missingFunctions.contains(t.tokenStr)) continue;
            missingFunctions.add(t.tokenStr);
        }
        int n = missingFunctions.size();
        String[] missFun = new String[n];
        for (int i = 0; i < n; ++i) {
            missFun[i] = (String)missingFunctions.get(i);
        }
        return missFun;
    }

    List<Token> getInitialTokens() {
        return this.initialTokens;
    }

    private static final String getLeftSpaces(String maxStr, String str) {
        String spc = "";
        for (int i = 0; i < maxStr.length() - str.length(); ++i) {
            spc = spc + " ";
        }
        return spc + str;
    }

    private static final String getRightSpaces(String maxStr, String str) {
        String spc = "";
        for (int i = 0; i < maxStr.length() - str.length(); ++i) {
            spc = " " + spc;
        }
        return str + spc;
    }

    private void showParsing(int lPos, int rPos) {
        mXparser.consolePrint(" ---> ");
        for (int i = lPos; i <= rPos; ++i) {
            Token token = this.tokensList.get(i);
            if (token.tokenTypeId == 0) {
                mXparser.consolePrint(token.tokenValue + " ");
                continue;
            }
            mXparser.consolePrint(token.tokenStr + " ");
        }
        mXparser.consolePrint(" ... ");
    }

    void showKeyWords() {
        int keyWordsNumber = this.keyWordsList.size();
        String maxStr = "KEY_WORD";
        mXparser.consolePrintln("KEY WORDS:");
        mXparser.consolePrintln(" -------------------------------------------");
        mXparser.consolePrintln("|      IDX | KEY_WORD |       ID |  TYPE_ID |");
        mXparser.consolePrintln(" -------------------------------------------");
        for (int keyWordIndex = 0; keyWordIndex < keyWordsNumber; ++keyWordIndex) {
            KeyWord keyWord = this.keyWordsList.get(keyWordIndex);
            String idxStr = Expression.getLeftSpaces(maxStr, Integer.toString(keyWordIndex));
            String wordStr = Expression.getLeftSpaces(maxStr, keyWord.wordString);
            String idStr = Expression.getLeftSpaces(maxStr, Integer.toString(keyWord.wordId));
            String typeIdStr = Expression.getLeftSpaces(maxStr, Integer.toString(keyWord.wordTypeId));
            mXparser.consolePrintln("| " + idxStr + " | " + wordStr + " | " + idStr + " | " + typeIdStr + " |");
        }
        mXparser.consolePrintln(" -------------------------------------------");
    }

    public String getHelp() {
        return this.getHelp("");
    }

    public String getHelp(String word) {
        this.keyWordsList = new ArrayList<KeyWord>();
        String helpStr = "Help content: \n\n";
        this.addParserKeyWords();
        this.validateParserKeyWords();
        if (!this.parserKeyWordsOnly) {
            this.addArgumentsKeyWords();
            this.addFunctionsKeyWords();
            this.addConstantsKeyWords();
        }
        helpStr = helpStr + Expression.getLeftSpaces("12345", "#") + "  " + Expression.getRightSpaces("01234567890123456789", "key word") + Expression.getRightSpaces("                        ", "type") + Expression.getRightSpaces("0123456789012345678901234567890123456789012345", "syntax") + Expression.getRightSpaces("012345", "since") + "description\n";
        helpStr = helpStr + Expression.getLeftSpaces("12345", "-") + "  " + Expression.getRightSpaces("01234567890123456789", "--------") + Expression.getRightSpaces("                        ", "----") + Expression.getRightSpaces("0123456789012345678901234567890123456789012345", "------") + Expression.getRightSpaces("012345", "-----") + "-----------\n";
        Collections.sort(this.keyWordsList, new KwTypeComparator());
        int keyWordsNumber = this.keyWordsList.size();
        for (int keyWordIndex = 0; keyWordIndex < keyWordsNumber; ++keyWordIndex) {
            KeyWord keyWord = this.keyWordsList.get(keyWordIndex);
            String type = "";
            String kw = keyWord.wordString;
            switch (keyWord.wordTypeId) {
                case 20: {
                    type = "Parser Symbol";
                    break;
                }
                case 0: {
                    type = "number";
                    kw = "_number_";
                    break;
                }
                case 1: {
                    type = "Operator";
                    break;
                }
                case 2: {
                    type = "Boolean Operator";
                    break;
                }
                case 3: {
                    type = "Binary Relation";
                    break;
                }
                case 4: {
                    type = "Unary Function";
                    break;
                }
                case 5: {
                    type = "Binary Function";
                    break;
                }
                case 6: {
                    type = "3-args Function";
                    break;
                }
                case 7: {
                    type = "Variadic Function";
                    break;
                }
                case 8: {
                    type = "Calculus Operator";
                    break;
                }
                case 10: {
                    type = "Random Variable";
                    break;
                }
                case 9: {
                    type = "Constant Value";
                    break;
                }
                case 101: {
                    type = "User defined argument";
                    break;
                }
                case 102: {
                    type = "User defined recursive argument";
                    break;
                }
                case 103: {
                    type = "User defined function";
                    break;
                }
                case 104: {
                    type = "User defined constant";
                    break;
                }
                case 12: {
                    type = "Unit";
                    break;
                }
                case 11: {
                    type = "Bitwise Operator";
                }
            }
            String line = Expression.getLeftSpaces("12345", Integer.toString(keyWordIndex + 1)) + ". " + Expression.getRightSpaces("01234567890123456789", kw) + Expression.getRightSpaces("                        ", "<" + type + ">") + Expression.getRightSpaces("0123456789012345678901234567890123456789012345", keyWord.syntax) + Expression.getRightSpaces("012345", keyWord.since) + keyWord.description + "\n";
            if (line.toLowerCase().indexOf(word.toLowerCase()) < 0) continue;
            helpStr = helpStr + line;
        }
        return helpStr;
    }

    public List<KeyWord> getKeyWords() {
        return this.getKeyWords("");
    }

    public List<KeyWord> getKeyWords(String query) {
        this.keyWordsList = new ArrayList<KeyWord>();
        ArrayList<KeyWord> kwyWordsToReturn = new ArrayList<KeyWord>();
        this.addParserKeyWords();
        this.validateParserKeyWords();
        if (!this.parserKeyWordsOnly) {
            this.addArgumentsKeyWords();
            this.addFunctionsKeyWords();
            this.addConstantsKeyWords();
        }
        Collections.sort(this.keyWordsList, new KwTypeComparator());
        for (KeyWord kw : this.keyWordsList) {
            String line = "str=" + kw.wordString + " desc=" + kw.description + " syn=" + kw.syntax + " sin=" + kw.since + " wid=" + kw.wordId + " tid=" + kw.wordTypeId;
            if (line.toLowerCase().indexOf(query.toLowerCase()) < 0) continue;
            kwyWordsToReturn.add(kw);
        }
        return kwyWordsToReturn;
    }

    void showTokens() {
        Expression.showTokens(this.tokensList);
    }

    static final void showTokens(List<Token> tokensList) {
        String maxStr = "TokenTypeId";
        mXparser.consolePrintln(" --------------------");
        mXparser.consolePrintln("| Expression tokens: |");
        mXparser.consolePrintln(" ---------------------------------------------------------------------------------------------------------------");
        mXparser.consolePrintln("|    TokenIdx |       Token |        KeyW |     TokenId | TokenTypeId |  TokenLevel |  TokenValue |   LooksLike |");
        mXparser.consolePrintln(" ---------------------------------------------------------------------------------------------------------------");
        if (tokensList == null) {
            mXparser.consolePrintln("NULL tokens list");
            return;
        }
        int tokensNumber = tokensList.size();
        for (int tokenIndex = 0; tokenIndex < tokensNumber; ++tokenIndex) {
            String tokenIndexStr = Expression.getLeftSpaces(maxStr, Integer.toString(tokenIndex));
            String tokenStr = Expression.getLeftSpaces(maxStr, tokensList.get((int)tokenIndex).tokenStr);
            String keyWordStr = Expression.getLeftSpaces(maxStr, tokensList.get((int)tokenIndex).keyWord);
            String tokenIdStr = Expression.getLeftSpaces(maxStr, Integer.toString(tokensList.get((int)tokenIndex).tokenId));
            String tokenTypeIdStr = Expression.getLeftSpaces(maxStr, Integer.toString(tokensList.get((int)tokenIndex).tokenTypeId));
            String tokenLevelStr = Expression.getLeftSpaces(maxStr, Integer.toString(tokensList.get((int)tokenIndex).tokenLevel));
            String tokenValueStr = Expression.getLeftSpaces(maxStr, Double.toString(tokensList.get((int)tokenIndex).tokenValue));
            String tokenLooksLikeStr = Expression.getLeftSpaces(maxStr, tokensList.get((int)tokenIndex).looksLike);
            mXparser.consolePrintln("| " + tokenIndexStr + " | " + tokenStr + " | " + keyWordStr + " | " + tokenIdStr + " | " + tokenTypeIdStr + " | " + tokenLevelStr + " | " + tokenValueStr + " | " + tokenLooksLikeStr + " |");
        }
        mXparser.consolePrintln(" ---------------------------------------------------------------------------------------------------------------");
    }

    void showInitialTokens() {
        Expression.showTokens(this.initialTokens);
    }

    private void showArguments() {
        for (Argument a : this.argumentsList) {
            boolean vMode = a.getVerboseMode();
            a.setSilentMode();
            this.printSystemInfo(a.getArgumentName() + " = " + a.getArgumentValue() + "\n", true);
            if (!vMode) continue;
            a.setVerboseMode();
        }
    }

    private void printSystemInfo(String info, boolean withExpressionString) {
        if (withExpressionString) {
            mXparser.consolePrint("[" + this.description + "][" + this.expressionString + "] " + info);
        } else {
            mXparser.consolePrint(info);
        }
    }

    protected Expression clone() {
        Expression newExp = new Expression(this);
        if (this.initialTokens != null && this.initialTokens.size() > 0) {
            newExp.initialTokens = this.createInitialTokens(0, this.initialTokens.size() - 1, this.initialTokens);
        }
        return newExp;
    }
}

