/*
 * @(#)StringResourcesItalian.java        6.1.0    2024-10-06
 *
 * MathParser.org-mXparser DUAL LICENSE AGREEMENT as of date 2024-05-19
 * The most up-to-date license is available at the below link:
 * - https://mathparser.org/mxparser-license
 *
 * AUTHOR: Copyright 2010 - 2024 Mariusz Gromada - All rights reserved
 * PUBLISHER: INFIMA - https://payhip.com/infima
 *
 * SOFTWARE means source code and/or binary form and/or documentation.
 * PRODUCT: MathParser.org-mXparser SOFTWARE
 * LICENSE: DUAL LICENSE AGREEMENT
 *
 * BY INSTALLING, COPYING, OR OTHERWISE USING THE PRODUCT, YOU AGREE TO BE
 * BOUND BY ALL OF THE TERMS AND CONDITIONS OF THE DUAL LICENSE AGREEMENT.
 *
 * The AUTHOR & PUBLISHER provide the PRODUCT under the DUAL LICENSE AGREEMENT
 * model designed to meet the needs of both non-commercial use and commercial
 * use.
 *
 * NON-COMMERCIAL USE means any use or activity where a fee is not charged
 * and the purpose is not the sale of a good or service, and the use or
 * activity is not intended to produce a profit. Examples of NON-COMMERCIAL USE
 * include:
 *
 * 1. Non-commercial open-source software.
 * 2. Non-commercial mobile applications.
 * 3. Non-commercial desktop software.
 * 4. Non-commercial web applications/solutions.
 * 5. Non-commercial use in research, scholarly and educational context.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * COMMERCIAL USE means any use or activity where a fee is charged or the
 * purpose is the sale of a good or service, or the use or activity is
 * intended to produce a profit. COMMERCIAL USE examples:
 *
 * 1. OEMs (Original Equipment Manufacturers).
 * 2. ISVs (Independent Software Vendors).
 * 3. VARs (Value Added Resellers).
 * 4. Other distributors that combine and distribute commercially licensed
 *    software.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * IN CASE YOU WANT TO USE THE PRODUCT COMMERCIALLY, YOU MUST PURCHASE THE
 * APPROPRIATE LICENSE FROM "INFIMA" ONLINE STORE, STORE ADDRESS:
 *
 * 1. https://mathparser.org/order-commercial-license
 * 2. https://payhip.com/infima
 *
 * NON-COMMERCIAL LICENSE
 *
 * Redistribution and use of the PRODUCT in source and/or binary forms,
 * with or without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the unmodified content of
 *    the entire MathParser.org-mXparser DUAL LICENSE AGREEMENT, including
 *    the definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE,
 *    the NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 2. Redistributions in binary form must reproduce the entire content of
 *    MathParser.org-mXparser DUAL LICENSE AGREEMENT in the documentation
 *    and/or other materials provided with the distribution, including the
 *    definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE, the
 *    NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 3. Any form of redistribution requires confirmation and signature of
 *    the NON-COMMERCIAL USE by successfully calling the method:
 *       License.iConfirmNonCommercialUse(...)
 *    The method call is used only internally for logging purposes, and
 *    there is no connection with other external services, and no data is
 *    sent or collected. The lack of a method call (or its successful call)
 *    does not affect the operation of the PRODUCT in any way. Please see
 *    the API documentation.
 *
 * COMMERCIAL LICENSE
 *
 *  1. Before purchasing a commercial license, the AUTHOR & PUBLISHER allow
 *     you to download, install, and use up to three copies of the PRODUCT to
 *     perform integration tests, confirm the quality of the PRODUCT, and
 *     its suitability. The testing period should be limited to fourteen
 *     days. Tests should be performed under the test environments conditions
 *     and not for profit generation.
 *  2. Provided that you purchased a license from "INFIMA" online store
 *     (store address: https://mathparser.org/order-commercial-license or
 *     https://payhip.com/infima), and you comply with all terms and
 *     conditions below, and you have acknowledged and understood the
 *     following DISCLAIMER, the AUTHOR & PUBLISHER grant you a nonexclusive
 *     license with the following rights:
 *  3. The license is granted only to you, the person or entity that made
 *     the purchase, identified and confirmed by the data provided during
 *     the purchase.
 *  4. If you purchased a license in the "ONE-TIME PURCHASE" model, the
 *     license is granted only for the PRODUCT version specified in the
 *     purchase. The upgrade policy gives you additional rights, described
 *     in the dedicated section below.
 *  5. If you purchased a license in the "SUBSCRIPTION" model, you may
 *     install and use any version of the PRODUCT during the subscription
 *     validity period.
 *  6. If you purchased a "SINGLE LICENSE" you may install and use the
 *     PRODUCT on/from one workstation that is located/accessible at/from
 *     any of your premises.
 *  7. Additional copies of the PRODUCT may be installed and used on/from
 *     more than one workstation, limited to the number of workstations
 *     purchased per order.
 *  8. If you purchased a "SITE LICENSE", the PRODUCT may be installed
 *     and used on/from all workstations located/accessible at/from any
 *     of your premises.
 *  9. You may incorporate the unmodified PRODUCT into your own products
 *     and software.
 * 10. If you purchased a license with the "SOURCE CODE" option, you may
 *     modify the PRODUCT's source code and incorporate the modified source
 *     code into your own products and/or software.
 * 11. Provided that the license validity period has not expired, you may
 *     distribute your product and/or software with the incorporated
 *     PRODUCT royalty-free.
 * 12. You may make copies of the PRODUCT for backup and archival purposes.
 * 13. Any form of redistribution requires confirmation and signature of
 *     the COMMERCIAL USE by successfully calling the method:
 *        License.iConfirmCommercialUse(...)
 *     The method call is used only internally for logging purposes, and
 *     there is no connection with other external services, and no data is
 *     sent or collected. The lack of a method call (or its successful call)
 *     does not affect the operation of the PRODUCT in any way. Please see
 *     the API documentation.
 * 14. The AUTHOR & PUBLISHER reserve all rights not expressly granted to
 *     you in this agreement.
 *
 * ADDITIONAL CLARIFICATION ON WORKSTATION
 *
 * A workstation is a device, a remote device, or a virtual device, used by
 * you, your employees, or other entities to whom you have commissioned
 * tasks. For example, the number of workstations may refer to the number
 * of software developers, engineers, architects, scientists, and other
 * professionals who use the PRODUCT on your behalf. The number of
 * workstations is not the number of copies of your end-product that you
 * distribute to your end-users.
 *
 * By purchasing the COMMERCIAL LICENSE, you only pay for the number of
 * workstations, while the number of copies/users of your final product
 * (delivered to your end-users) is not limited.
 *
 * Below are some examples to help you select the right license size:
 *
 * Example 1: Single Workstation License
 * Only one developer works on the development of your application. You do
 * not use separate environments for testing, meaning you design, create,
 * test, and compile your final application on one environment. In this
 * case, you need a license for a single workstation.
 *
 * Example 2: Up to 5 Workstations License
 * Two developers are working on the development of your application.
 * Additionally, one tester conducts tests in a separate environment.
 * You use three workstations in total, so you need a license for up to
 * five workstations.
 *
 * Example 3: Up to 20 Workstations License
 * Ten developers are working on the development of your application.
 * Additionally, five testers conduct tests in separate environments.
 * You use fifteen workstations in total, so you need a license for
 * up to twenty workstations.
 *
 * Example 4: Site License
 * Several dozen developers and testers work on the development of your
 * application using multiple environments. You have a large,
 * multi-disciplinary team involved in creating your solution. As your team
 * is growing and you want to avoid licensing limitations, the best choice
 * would be a site license.
 *
 * UPGRADE POLICY
 *
 * The PRODUCT is versioned according to the following convention:
 *
 *    [MAJOR].[MINOR].[PATCH]
 *
 * 1. COMMERCIAL LICENSE holders can install and use the updated version
 *    for bug fixes free of charge, i.e. if you have purchased a license
 *    for the [MAJOR].[MINOR] version (e.g., 5.0), you can freely install
 *    all releases specified in the [PATCH] version (e.g., 5.0.2).
 *    The license terms remain unchanged after the update.
 * 2. COMMERCIAL LICENSE holders for the [MAJOR].[MINOR] version (e.g., 5.0)
 *    can install and use the updated version [MAJOR].[MINOR + 1] free of
 *    charge, i.e., plus one release in the [MINOR] range (e.g., 5.1). The
 *    license terms remain unchanged after the update.
 * 3. COMMERCIAL LICENSE holders who wish to upgrade their version, but are
 *    not eligible for the free upgrade, can claim a discount when
 *    purchasing the upgrade. For this purpose, please contact us via e-mail.
 *
 * DISCLAIMER
 *
 * THIS PRODUCT IS PROVIDED BY THE AUTHOR & PUBLISHER "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AUTHOR OR PUBLISHER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS PRODUCT, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE VIEWS AND CONCLUSIONS CONTAINED IN THE PRODUCT AND DOCUMENTATION ARE
 * THOSE OF THE AUTHORS AND SHOULD NOT BE INTERPRETED AS REPRESENTING
 * OFFICIAL POLICIES, EITHER EXPRESSED OR IMPLIED, OF THE AUTHOR OR PUBLISHER.
 *
 * CONTACT
 *
 * - e-mail: info@mathparser.org
 * - website: https://mathparser.org
 * - source code: https://github.com/mariuszgromada/MathParser.org-mXparser
 * - online store: https://mathparser.org/order-commercial-license
 * - online store: https://payhip.com/infima
 */
package org.mariuszgromada.math.mxparser;

/**
 * A class containing definition of Italian user language
 *
 * @author         <b>Mariusz Gromada</b><br>
 *                 <a href="https://mathparser.org" target="_blank">MathParser.org - mXparser project page</a><br>
 *                 <a href="https://github.com/mariuszgromada/MathParser.org-mXparser" target="_blank">mXparser on GitHub</a><br>
 *                 <a href="https://payhip.com/INFIMA" target="_blank">INFIMA place to purchase a commercial MathParser.org-mXparser software license</a><br>
 *                 <a href="mailto:info@mathparser.org">info@mathparser.org</a><br>
 *                 <a href="https://scalarmath.org/" target="_blank">ScalarMath.org - a powerful math engine and math scripting language</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.lite" target="_blank">Scalar Lite</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.pro" target="_blank">Scalar Pro</a><br>
 *                 <a href="https://mathspace.pl" target="_blank">MathSpace.pl</a><br>
 *
 * @version        6.0.0
 *
 * @see StringResources
 * @see StringModel
 * @see StringModel#setStringResources(StringResources)
 * @see StringModel#getStringResources()
 */
class StringResourcesItalian extends StringResources {
    StringResourcesItalian() {
        USER_LANGUAGE = "Italiano";
        // -------------------------------------------------
        STARTING_SYNTAX_CHECK = "Inizio controllo della sintassi...";
        NO_ERRORS_DETECTED = "Nessun errore rilevato.";
        NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION = "Nessun errore rilevato nella definizione dell'argomento.";
        NO_ERRORS_DETECTED_IN_RECURSIVE_ARGUMENT_DEFINITION = "Nessun errore rilevato nella definizione ricorsiva dell'argomento.";
        NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION = "Nessun errore rilevato nella definizione della funzione.";
        NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION = "Nessun errore rilevato nella definizione della costante.";
        LEXICAL_ERROR_HAS_BEEN_FOUND = "È stato trovato un errore lessicale.";
        ERRORS_HAVE_BEEN_FOUND = "Sono stati trovati degli errori.";
        ALREADY_CHECKED_NO_ERRORS = "La sintassi è già stata controllata: nessun errore rilevato.";
        SYNTAX_STATUS_UNKNOWN = "Lo stato della sintassi è sconosciuto.";
        PROBLEM_WITH_EXPRESSION_SYNTAX = "Ci sono dei problemi con la sintassi dell'espressione.";
        // -------------------------------------------------
        ENCOUNTERED = "Rilevato";
        AT_INDEX = "all'indice";
        WAS_EXPECTING = "Era previsto";
        WAS_EXPECTING_ONE_OF = "Era previsto uno di";
        UNEXPECTED_EXCEPTION_WAS_ENCOUNTERED = "Si è verificata un'eccezione inaspettata. Probabilmente causato da un errore del parser: ti preghiamo di segnalarlo.";
        UNEXPECTED_TOKEN_MANAGER_ERROR_WAS_ENCOUNTERED = "Si è verificato un errore inaspettato del gestore del token. Probabilmente causato da un errore del parser: ti preghiamo di segnalarlo.";
        // -------------------------------------------------
        EXPRESSION_STRING_IS_EMPTY = "La stringa dell'espressione è vuota.";
        EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS = "L'espressione non contiene alcun token.";
        DUPLICATED_KEYWORD = "Sono stati trovati dei duplicati delle parole chiave. Controlla gli elementi definiti dall'utente. Considera la possibilità di sovrascrivere i token predefiniti.";
        ELEMENT = "Elemento";
        ERROR = "Errore";
        EXCEPTION = "Eccezione";
        TOKEN = "Token";
        INDEX = "indice";
        INVALID_TOKEN = "Token non valido.";
        INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR = "Token non valido. È possibile che manchi l'operatore di moltiplicazione: prova la modalità di moltiplicazione implicita";
        EXPRESSION_TOKENS = "Token dell'espressione";
        NULL_TOKENS_LIST = "Elenco dei token nullo";
        // -------------------------------------------------
        FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS = "Funzione definita dall'utente con corpo esteso - nessun errore ipotizzato.";
        ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS = "Argomento definito dall'utente con corpo esteso - nessun errore ipotizzato.";
        PROVIDED_EXTENSION_IS_NULL = "L'estensione fornita è nulla.";
        PROVIDED_STRING_IS_NULL = "La stringa fornita è nulla.";
        PROVIDED_ELEMENTS_ARE_NULL = "Gli elementi forniti sono nulli.";
        MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE = "Manca l'operatore di moltiplicazione: prova la modalità di moltiplicazione implicita.";
        // -------------------------------------------------
        STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT = "Inizio controllo della sintassi dell'argomento dipendente definito dall'utente.";
        STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT = "Inizio controllo della sintassi dell'argomento ricorsivo definito dall'utente.";
        STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION = "Inizio controllo della sintassi della funzione definita dall'utente.";
        STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION = "Inizio controllo della sintassi della funzione definita dall'utente con numero variabile di argomenti.";
        // -------------------------------------------------
        ARGUMENT_WAS_EXPECTED = "Era previsto un argomento definito dall'utente.";
        RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER = "Un argomento definito dall'utente ricorsivo richiede un parametro.";
        // -------------------------------------------------
        INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION = "Numero errato di parametri nella funzione definita dall'utente.";
        // -------------------------------------------------
        INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS = "Numero errato di parametri della funzione.";
        EXPECTED = "Previsto";
        PROVIDED = "fornito";
        USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT = "Numero errato di parametri nella funzione definita dall'utente: è previsto almeno un argomento.";
        EXPECTED_EVEN_NUMBER_OF_ARGUMENTS = "Era previsto un numero pari di argomenti.";
        // -------------------------------------------------
        INVALID_FUNCTION_NAME = "Nome della funzione non valido.";
        INVALID_ARGUMENT_NAME = "Nome dell'argomento non valido.";
        INVALID_CONSTANT_NAME = "Nome della costante non valido.";
        INVALID_FUNCTION_DEFINITION = "Definizione della funzione non valida.";
        INVALID_ARGUMENT_DEFINITION = "Definizione dell'argomento non valida.";
        INVALID_CONSTANT_DEFINITION = "Definizione della costante non valida.";
        PATTERN_DOES_NOT_MATCH = "Il pattern non corrisponde.";
        PATTERN_EXAMPLES = "Esempi di pattern";
        // -------------------------------------------------
        CONSTANT_WAS_EXPECTED = "Era previsto un valore costante.";
        USER_CONSTANT_WAS_EXPECTED = "Era prevista una costante definita dall'utente.";
        // -------------------------------------------------
        UNARY_FUNCTION_EXPECTS_1_PARAMETER = "Una funzione unaria richiede 1 parametro.";
        BINARY_FUNCTION_EXPECTS_2_PARAMETERS = "Una funzione binaria richiede 2 parametri.";
        TERNARY_FUNCTION_EXPECTS_3_PARAMETERS = "Una funzione ternaria richiede 3 parametri.";
        // -------------------------------------------------
        DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS = "L'operatore di derivazione richiede 2, 3, 4 o 5 parametri di calcolo.";
        ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION = "Era previsto un argomento nella chiamata con operatore di derivazione.";
        DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Sono stati trovati duplicati di parole chiave nella chiamata con l'operatore di calcolo: controlal i parametri di calcolo.";
        ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Era previsto un token /un argomento o altro sconosciuto) nella chiamata con l'operatore di calcolo.";
        NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS = "L'operatore di derivazione di ordine N richiede 3 o 5 parametri di calcolo.";
        INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS = "L'operatore di integrale/risoluzione richiede 4 parametri di calcolo.";
        ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS = "L'operatore iterato richiede 4 o 5 parametri di calcolo.";
        FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS = "L'operatore di differenza in avanti/indietro richiede 2 o 3 parametri di calcolo.";
        FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED = "Era previsto un argomento nell'invocazione dell'operatore di differenza in avanti/indietro.";
        AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED = "Era previsto almeno un argomento.";
        // -------------------------------------------------
        ERROR_WHILE_EXECUTING_THE_CALCULATE = "Errore durante l'esecuzione del calcolo.";
        RECURSION_CALLS_COUNTER_EXCEEDED = "Il numero massimo di chiamate ricorsive definito nel contatore è stato superato.";
        RECURSION_CALLS_COUNTER = "Contatore delle chiamate ricorsive";
        STARTING_CALCULATION_LOOP = "Inizio del ciclo di calcolo.";
        CANCEL_REQUEST_FINISHING = "Richiesta di annullamento rilevata: conclusione.";
        INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING = "Errore interno/livello strano del token: conclusione. Probabilmente un errore del parser: ti preghiamo di segnalarlo.";
        FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN = "Errore fatale: non so cosa fare con il token incontrato. Probabilmente un errore del parser: ti preghiamo di segnalarlo.";
        MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED = "È stata superata la lunghezza massima del messaggio di errore.";
        // -------------------------------------------------
        STARTING = "Inizio...";
        PARSING = "In analisi";
        FULLY_COMPILED = "Completamente compilato";
        CALCULATED_VALUE = "Valore calcolato";
        EXITING = "Uscita.";
        DONE = "completato.";
        // -------------------------------------------------
        KEYWORD = "Parola chiave";
        SYNTAX = "Sintassi";
        NUMBER = "Numero";
        NUMBER_LITERAL = "Numero letterale";
        TYPE = "Tipo";
        SINCE = "Dal";
        DESCRIPTION = "Descrizione";
        // -------------------------------------------------
        CALC_STEPS_REGISTER_IS_EMPTY = "Il registro dei passaggi di calcolo è vuoto.";
        CALC_STEPS_REGISTER_FOR = "Registro dei passaggi di calcolo per";
        ARGUMENT = "Argomento";
        FUNCTION = "Funzione";
        EXPRESSION = "Espressione";
        RESULT = "risultato";
        COMPUTING_TIME = "Tempo di calcolo";
        GROUP_SHORT = "g.";
        NUMBER_SHORT = "n.";
        FIRST = "primo";
        LAST = "ultimo";
        DESCRIPTION_SHORT = "desc.";
        STEP = "passo";
        // -------------------------------------------------
        SERIALIZATION_PERFORMED = "Serializzazione eseguita:";
        DESERIALIZATION_PERFORMED = "Deserializzazione eseguita:";
        NULL_OBJECT_PROVIDED = "È stato fornito un oggetto nullo.";
        NULL_FILE_PATH_PROVIDED = "È stato fornito un percorso file nullo.";
        FILE_PATH_ZERO_LENGTH_PROVIDED = "Il percorso del file non contiene caratteri.";
        FILE_PATH_IS_NOT_A_FILE = "Il percorso del file non è un file:";
        FILE_PATH_NOT_EXISTS = "Il percorso del file non esiste:";
        NULL_DATA_PROVIDED = "Sono stati forniti dati nulli.";
        BINARY_SERIALIZATION_ENABLED = "La serializzazione binaria è abilitata. Utilizzala solo in modo consapevole e limitato.";
        BINARY_SERIALIZATION_DISABLED = "La serializzazione binaria è disabilitata. Puoi abilitarla se sei consapevole dei rischi di sicurezza.";
        // -------------------------------------------------
        USER_DEFINED_EXPRESSION = "Espressione definita dall'utente";
        USER_DEFINED_ARGUMENT = "Argomento definito dall'utente";
        USER_DEFINED_CONSTANT = "Costante definita dall'utente";
        USER_DEFINED_FUNCTION = "Funzione definita dall'utente";
        USER_DEFINED_RECURSIVE_ARGUMENT = "Argomento ricorsivo definito dall'utente";
        // -------------------------------------------------
        HELP_CONTENT_LIMITED_TO_QUERY = "Contenuto della guida limitato alla ricerca";
        ALL_HELP_CONTENT = "Tutto il contenuto della guida.";
        CAPTION = "Didascalia";
        // -------------------------------------------------
        WARNING_BINARY_SERIALIZATION_SECURITY_RISKS = "AVVERTIMENTO DI SICUREZZA:" + StringInvariant.NEW_LINE
                + "La deserializzazione di dati da una fonte non affidabile può introdurre vulnerabilità" + StringInvariant.NEW_LINE
                + "di sicurezza nella tua applicazione. A seconda delle impostazioni utilizzate durante" + StringInvariant.NEW_LINE
                + "la deserializzazione, i dati non affidabili possono essere in grado di eseguire codice" + StringInvariant.NEW_LINE
                + "arbitrario o causare un attacco di negazione del servizio. I dati non affidabili possono" + StringInvariant.NEW_LINE
                + "provenire dalla rete da una fonte non affidabile (ad es. qualsiasi client di rete), o possono" + StringInvariant.NEW_LINE
                + "essere manipolati/alterati da un intermediario durante il transito su una connessione non" + StringInvariant.NEW_LINE
                + "autenticata, o da un archivio locale dove possono essere stati compromessi/alterati, o da" + StringInvariant.NEW_LINE
                + "molte altre fonti. MathParser.org-mXparser non fornisce alcun mezzo per autenticare i dati" + StringInvariant.NEW_LINE
                + "o proteggerli da alterazioni. Utilizza un metodo di autenticazione dei dati appropriato" + StringInvariant.NEW_LINE
                + "prima della deserializzazione. Fai molta attenzione a questi scenari di attacco; in passato," + StringInvariant.NEW_LINE
                + "molti progetti e aziende e utenti con librerie di serializzazione sono stati colpiti dalla" + StringInvariant.NEW_LINE
                + "deserializzazione non affidabile dei dati dell'utente."  + StringInvariant.NEW_LINE
        ;
        // -------------------------------------------------
        BINARY_RELATION = "Relazione binaria";
        BITWISE_OPERATOR = "Operatore bit a bit";
        BOOLEAN_OPERATOR = "Operatore booleano";
        CALCULUS_OPERATOR = "Operatore di calcolo";
        CONSTANT_VALUE = "Valore costante";
        FUNCTION_1_ARG = "Funzione unaria";
        FUNCTION_2_ARG = "Funzione binaria";
        FUNCTION_3_ARG = "Funzione ternaria";
        FUNCTION_VARIADIC = "Funzione variadica";
        OPERATOR = "Operatore";
        PARSER_SYMBOL = "Simbolo del parser";
        RANDOM_VARIABLE = "Variabile casuale";
        UNIT = "Unità";
        DIMENSIONLESS_UNIT = "Unità adimensionale";
        ITERATED_OPERATOR = "Operatore iterato";
        // -------------------------------------------------
        RATIO_FRACTION = "Rapporto / Frazione";
        METRIC_PREFIX = "Prefisso metrico";
        UNIT_OF_LENGTH = "Unità di lunghezza";
        UNIT_OF_AREA = "Unità di superficie";
        UNIT_OF_VOLUME = "Unità di volume";
        UNIT_OF_TIME = "Unità di tempo";
        UNIT_OF_MASS = "Unità di massa";
        UNIT_OF_INFORMATION = "Unità di informazione";
        UNIT_OF_ENERGY = "Unità di energia";
        UNIT_OF_SPEED = "Unità di velocità";
        UNIT_OF_ACCELERATION = "Unità di accelerazione";
        UNIT_OF_ANGLE = "Unità di angolo";
        // -------------------------------------------------
        PHYSICAL_CONSTANT = "Costante fisica";
        ASTRONOMICAL_CONSTANT = "Costante astronomica";
        MATHEMATICAL_CONSTANT = "Costante matematica";
        // -------------------------------------------------
        PROBABILITY_DISTRIBUTION_FUNCTION = "Funzione di distribuzione di probabilità";
        CUMULATIVE_DISTRIBUTION_FUNCTION = "Funzione di distribuzione cumulativa";
        QUANTILE_FUNCTION = "Funzione quantile (funzione di distribuzione cumulativa inversa)";
        // -------------------------------------------------
        STUDENTS_T_DISTRIBUTION = "Distribuzione t di Student";
        CHI_SQUARED_DISTRIBUTION = "Distribuzione Chi quadrata";
        SNEDECORS_F_DISTRIBUTION = "Distribuzione F di Snedecor (distribuzione F o rapporto F, nota anche come distribuzione Fisher-Snedecor)";
        UNIFORM_CONTINUOUS_DISTRIBUTION = "Distribuzione continua uniforme";
        UNIFORM_DISCRETE_DISTRIBUTION = "Distribuzione discreta uniforme";
        NORMAL_DISTRIBUTION = "Distribuzione normale";
        // -------------------------------------------------
        RANDOM_INTEGER = "Numero intero casuale";
        RANDOM_NATURAL_NUMBER = "Numero naturale casuale";
        RANDOM_NATURAL_NUMBER_INCLUDING_0 = "Numero naturale casuale incluso lo 0";
        // -------------------------------------------------
        SPECIAL_FUNCTION = "Funzione speciale";
        // -------------------------------------------------
        SEMI_MAJOR_AXIS = "Asse semimaggiore";
        // -------------------------------------------------
        BINARY_RELATION_EQ = "Uguaglianza";
        BINARY_RELATION_NEQ = "Disuguaglianza";
        BINARY_RELATION_LT = "Minore di";
        BINARY_RELATION_GT = "Maggiore di";
        BINARY_RELATION_LEQ = "Minore o uguale a";
        BINARY_RELATION_GEQ = "Maggiore o uguale a";
        // -------------------------------------------------
        BITWISE_OPERATOR_COMPL = "Complemento unario bit a bit (NOT)";
        BITWISE_OPERATOR_AND = "E bit a bit (AND)";
        BITWISE_OPERATOR_XOR = "O esclusivo bit a bit (XOR)";
        BITWISE_OPERATOR_OR = "O inclusivo bit a bit (OR)";
        BITWISE_OPERATOR_LEFT_SHIFT = "Scorrimento a sinistra firmato bit a bit";
        BITWISE_OPERATOR_RIGHT_SHIFT = "Scorrimento a destra firmato bit a bit";
        BITWISE_OPERATOR_NAND = "NOT AND bit a bit (NAND)";
        BITWISE_OPERATOR_NOR = "NOT OR bit a bit (NOR)";
        BITWISE_OPERATOR_XNOR = "NOR esclusivo bit a bit (XNOR)";
        // -------------------------------------------------
        BOOLEAN_OPERATOR_AND = "Congiunzione logica";
        BOOLEAN_OPERATOR_OR = "Disgiunzione logica";
        BOOLEAN_OPERATOR_NEG = "Negazione";
        BOOLEAN_OPERATOR_NAND = "Colpo di Sheffer";
        BOOLEAN_OPERATOR_NOR = "Non o logico (negazione congiunta)";
        BOOLEAN_OPERATOR_XOR = "O esclusivo";
        BOOLEAN_OPERATOR_IMP = "Implicazione";
        BOOLEAN_OPERATOR_CIMP = "Implicazione inversa";
        BOOLEAN_OPERATOR_NIMP = "Non implicazione materiale";
        BOOLEAN_OPERATOR_CNIMP = "Non implicazione inversa";
        BOOLEAN_OPERATOR_EQV = "Bicondizionale logico";
        // -------------------------------------------------
        CALCULUS_OPERATOR_SUM = "Somma SIGMA";
        CALCULUS_OPERATOR_PROD = "Prodotto PI";
        CALCULUS_OPERATOR_INT = "Integrale definito";
        CALCULUS_OPERATOR_DER = "Derivata";
        CALCULUS_OPERATOR_DER_LEFT = "Derivata sinistra";
        CALCULUS_OPERATOR_DER_RIGHT = "Derivata destra";
        CALCULUS_OPERATOR_DERN = "N-esima derivata";
        CALCULUS_OPERATOR_FORW_DIFF = "Differenza in avanti";
        CALCULUS_OPERATOR_BACKW_DIFF = "Differenza all'indietro";
        CALCULUS_OPERATOR_AVG = "Media";
        CALCULUS_OPERATOR_VAR = "Varianza campionaria corretta";
        CALCULUS_OPERATOR_STD = "Deviazione standard campionaria corretta";
        CALCULUS_OPERATOR_MIN = "Valore minimo";
        CALCULUS_OPERATOR_MAX = "Valore massimo";
        CALCULUS_OPERATOR_SOLVE = "Risoluzione di equazioni (ricerca delle radici)";
        // -------------------------------------------------
        CONSTANT_VALUE_PI = "Pi greco, numero di Archimede o Ludolph";
        CONSTANT_VALUE_EULER = "Numero di Napier o Euler (base del logaritmo naturale)";
        CONSTANT_VALUE_EULER_MASCHERONI = "Costante di Euler-Mascheroni";
        CONSTANT_VALUE_GOLDEN_RATIO = "Sezione aurea";
        CONSTANT_VALUE_PLASTIC = "Costante plastica";
        CONSTANT_VALUE_EMBREE_TREFETHEN = "Costante di Embree-Trefethen";
        CONSTANT_VALUE_FEIGENBAUM_DELTA = "Costante delta di Feigenbaum";
        CONSTANT_VALUE_FEIGENBAUM_ALPHA = "Costante alfa di Feigenbaum";
        CONSTANT_VALUE_TWIN_PRIME = "Costante dei primi gemelli";
        CONSTANT_VALUE_MEISSEL_MERTEENS = "Costante di Meissel-Mertens";
        CONSTANT_VALUE_BRAUN_TWIN_PRIME = "Costante di Brun per i primi gemelli";
        CONSTANT_VALUE_BRAUN_PRIME_QUADR = "Costante di Brun per quadrupletti di primi";
        CONSTANT_VALUE_BRUIJN_NEWMAN = "Costante di de Bruijn-Newman";
        CONSTANT_VALUE_CATALAN = "Costante di Catalan";
        CONSTANT_VALUE_LANDAU_RAMANUJAN = "Costante di Landau-Ramanujan";
        CONSTANT_VALUE_VISWANATH = "Costante di Viswanath";
        CONSTANT_VALUE_LEGENDRE = "Costante di Legendre";
        CONSTANT_VALUE_RAMANUJAN_SOLDNER = "Costante di Ramanujan-Soldner";
        CONSTANT_VALUE_ERDOS_BORWEIN = "Costante di Erdos-Borwein";
        CONSTANT_VALUE_BERNSTEIN = "Costante di Bernstein";
        CONSTANT_VALUE_GAUSS_KUZMIN_WIRSING = "Costante di Gauss-Kuzmin-Wirsing";
        CONSTANT_VALUE_HAFNER_SARNAK_MCCURLEY = "Costante di Hafner-Sarnak-McCurley";
        CONSTANT_VALUE_GOLOMB_DICKMAN = "Costante di Golomb-Dickman";
        CONSTANT_VALUE_CAHEN = "Costante di Cahen";
        CONSTANT_VALUE_LAPLACE_LIMIT = "Costante del limite di Laplace";
        CONSTANT_VALUE_ALLADI_GRINSTEAD = "Costante di Alladi-Grinstead";
        CONSTANT_VALUE_LENGYEL = "Costante di Lengyel";
        CONSTANT_VALUE_LEVY = "Costante di Levy";
        CONSTANT_VALUE_APERY = "Costante di Apery";
        CONSTANT_VALUE_MILLS = "Costante di Mills";
        CONSTANT_VALUE_BACKHOUSE = "Costante di Backhouse";
        CONSTANT_VALUE_PORTER = "Costante di Porter";
        CONSTANT_VALUE_LIEB_QUARE_ICE = "Costante del ghiaccio quadrato di Lieb";
        CONSTANT_VALUE_NIVEN = "Costante di Niven";
        CONSTANT_VALUE_SIERPINSKI = "Costante di Sierpinski";
        CONSTANT_VALUE_KHINCHIN = "Costante di Khinchin";
        CONSTANT_VALUE_FRANSEN_ROBINSON = "Costante di Fransen-Robinson";
        CONSTANT_VALUE_LANDAU = "Costante di Landau";
        CONSTANT_VALUE_PARABOLIC = "Costante parabolica";
        CONSTANT_VALUE_OMEGA = "Costante Omega";
        CONSTANT_VALUE_MRB = "Costante MRB";
        CONSTANT_VALUE_LI2 = "Integrale logaritmico al punto 2";
        CONSTANT_VALUE_GOMPERTZ = "Costante di Gompertz";
        CONSTANT_VALUE_LIGHT_SPEED = "Velocità della luce nel vuoto";
        CONSTANT_VALUE_GRAVITATIONAL_CONSTANT = "Costante gravitazionale";
        CONSTANT_VALUE_GRAVIT_ACC_EARTH = "Accelerazione gravitazionale sulla Terra";
        CONSTANT_VALUE_PLANCK_CONSTANT = "Costante di Planck";
        CONSTANT_VALUE_PLANCK_CONSTANT_REDUCED = "Costante di Planck ridotta (Costante di Dirac)";
        CONSTANT_VALUE_PLANCK_LENGTH = "Lunghezza di Planck";
        CONSTANT_VALUE_PLANCK_MASS = "Massa di Planck";
        CONSTANT_VALUE_PLANCK_TIME = "Tempo di Planck";
        CONSTANT_VALUE_LIGHT_YEAR = "Anno luce";
        CONSTANT_VALUE_ASTRONOMICAL_UNIT = "Unità astronomica";
        CONSTANT_VALUE_PARSEC = "Parsec";
        CONSTANT_VALUE_KILOPARSEC = "Kiloparsec";
        CONSTANT_VALUE_EARTH_RADIUS_EQUATORIAL = "Raggio equatoriale della Terra";
        CONSTANT_VALUE_EARTH_RADIUS_POLAR = "Raggio polare della Terra";
        CONSTANT_VALUE_EARTH_RADIUS_MEAN = "Raggio medio della Terra";
        CONSTANT_VALUE_EARTH_MASS = "Massa della Terra";
        CONSTANT_VALUE_EARTH_SEMI_MAJOR_AXIS = "Distanza Terra-Sole";
        CONSTANT_VALUE_MOON_RADIUS_MEAN = "Raggio medio della Luna";
        CONSTANT_VALUE_MOON_MASS = "Massa della Luna";
        CONSTANT_VALUE_MOON_SEMI_MAJOR_AXIS = "Distanza Luna-Terra";
        CONSTANT_VALUE_SOLAR_RADIUS = "Raggio medio del Sole";
        CONSTANT_VALUE_SOLAR_MASS = "Massa solare";
        CONSTANT_VALUE_MERCURY_RADIUS_MEAN = "Raggio medio di Mercurio";
        CONSTANT_VALUE_MERCURY_MASS = "Massa di Mercurio";
        CONSTANT_VALUE_MERCURY_SEMI_MAJOR_AXIS = "Distanza Mercurio-Sole";
        CONSTANT_VALUE_VENUS_RADIUS_MEAN = "Raggio medio di Venere";
        CONSTANT_VALUE_VENUS_MASS = "Massa di Venere";
        CONSTANT_VALUE_VENUS_SEMI_MAJOR_AXIS = "Distanza Venere-Sole";
        CONSTANT_VALUE_MARS_RADIUS_MEAN = "Raggio medio di Marte";
        CONSTANT_VALUE_MARS_MASS = "Massa di Marte";
        CONSTANT_VALUE_MARS_SEMI_MAJOR_AXIS = "Distanza Marte-Sole";
        CONSTANT_VALUE_JUPITER_RADIUS_MEAN = "Raggio medio di Giove";
        CONSTANT_VALUE_JUPITER_MASS = "Massa di Giove";
        CONSTANT_VALUE_JUPITER_SEMI_MAJOR_AXIS = "Distanza Giove-Sole";
        CONSTANT_VALUE_SATURN_RADIUS_MEAN = "Raggio medio di Saturno";
        CONSTANT_VALUE_SATURN_MASS = "Massa di Saturno";
        CONSTANT_VALUE_SATURN_SEMI_MAJOR_AXIS = "Distanza Saturno-Sole";
        CONSTANT_VALUE_URANUS_RADIUS_MEAN = "Raggio medio di Urano";
        CONSTANT_VALUE_URANUS_MASS = "Massa di Urano";
        CONSTANT_VALUE_URANUS_SEMI_MAJOR_AXIS = "Distanza Urano-Sole";
        CONSTANT_VALUE_NEPTUNE_RADIUS_MEAN = "Raggio medio di Nettuno";
        CONSTANT_VALUE_NEPTUNE_MASS = "Massa di Nettuno";
        CONSTANT_VALUE_NEPTUNE_SEMI_MAJOR_AXIS = "Distanza Nettuno-Sole";
        CONSTANT_VALUE_TRUE = "Booleano Vero rappresentato come 1";
        CONSTANT_VALUE_FALSE = "Booleano Falso rappresentato come 0";
        CONSTANT_VALUE_NPAR = "Costante generata automaticamente per le funzioni definite dall'utente, restituisce il numero dei parametri della funzione data";
        CONSTANT_VALUE_NAN = "Non-un-Numero";
        // -------------------------------------------------
        FUNCTION_1_ARG_SIN = "Seno trigonometrico";
        FUNCTION_1_ARG_COS = "Coseno trigonometrico";
        FUNCTION_1_ARG_TAN = "Tangente trigonometrica";
        FUNCTION_1_ARG_CTAN = "Cotangente trigonometrica";
        FUNCTION_1_ARG_SEC = "Secante trigonometrica";
        FUNCTION_1_ARG_COSEC = "Cosecante trigonometrica";
        FUNCTION_1_ARG_ASIN = "Seno inverso trigonometrico (arcoseno)";
        FUNCTION_1_ARG_ACOS = "Coseno inverso trigonometrico (arcocoseno)";
        FUNCTION_1_ARG_ATAN = "Tangente inversa trigonometrica (arcotangente)";
        FUNCTION_1_ARG_ACTAN = "Cotangente inversa trigonometrica";
        FUNCTION_1_ARG_LN = "Logaritmo naturale (base e)";
        FUNCTION_1_ARG_LOG2 = "Logaritmo binario (base 2)";
        FUNCTION_1_ARG_LOG10 = "Logaritmo comune o decadico (base 10)";
        FUNCTION_1_ARG_RAD = "Gradi in radianti";
        FUNCTION_1_ARG_EXP = "Esponenziale";
        FUNCTION_1_ARG_SQRT = "Radice quadrata";
        FUNCTION_1_ARG_SINH = "Seno iperbolico";
        FUNCTION_1_ARG_COSH = "Coseno iperbolico";
        FUNCTION_1_ARG_TANH = "Tangente iperbolica";
        FUNCTION_1_ARG_COTH = "Cotangente iperbolica";
        FUNCTION_1_ARG_SECH = "Secante iperbolica";
        FUNCTION_1_ARG_CSCH = "Cosecante iperbolica";
        FUNCTION_1_ARG_DEG = "Radianti a gradi";
        FUNCTION_1_ARG_ABS = "Valore assoluto";
        FUNCTION_1_ARG_SGN = "Segno";
        FUNCTION_1_ARG_FLOOR = "Arrotondamento all'intero inferiore";
        FUNCTION_1_ARG_CEIL = "Arrotondamento all'intero superiore";
        FUNCTION_1_ARG_NOT = "Negazione";
        FUNCTION_1_ARG_ARSINH = "Seno iperbolico inverso";
        FUNCTION_1_ARG_ARCOSH = "Coseno iperbolico inverso";
        FUNCTION_1_ARG_ARTANH = "Tangente iperbolica inversa";
        FUNCTION_1_ARG_ARCOTH = "Cotangente iperbolica inversa";
        FUNCTION_1_ARG_ARSECH = "Secante iperbolica inversa";
        FUNCTION_1_ARG_ARCSCH = "Cosecante iperbolica inversa";
        FUNCTION_1_ARG_SA = "Sinc (normalizzato)";
        FUNCTION_1_ARG_SINC = "Sinc (non normalizzato)";
        FUNCTION_1_ARG_BELL_NUMBER = "Numero di Bell";
        FUNCTION_1_ARG_LUCAS_NUMBER = "Numero di Lucas";
        FUNCTION_1_ARG_FIBONACCI_NUMBER = "Numero di Fibonacci";
        FUNCTION_1_ARG_HARMONIC_NUMBER = "Numero armonico";
        FUNCTION_1_ARG_IS_PRIME = "Test numeri primi (è un numero primo?)";
        FUNCTION_1_ARG_PRIME_COUNT = "Conteggio dei numeri primi";
        FUNCTION_1_ARG_EXP_INT = "Integrale esponenziale";
        FUNCTION_1_ARG_LOG_INT = "Integrale logaritmico";
        FUNCTION_1_ARG_OFF_LOG_INT = "Integrale logaritmico offset";
        FUNCTION_1_ARG_GAUSS_ERF = "Errore di Gauss";
        FUNCTION_1_ARG_GAUSS_ERFC = "Errore Gauss Complementare";
        FUNCTION_1_ARG_GAUSS_ERF_INV = "Errore Gauss inverso";
        FUNCTION_1_ARG_GAUSS_ERFC_INV = "Errore Gauss complementare inverso";
        FUNCTION_1_ARG_ULP = "Unità nell'ultimo posto";
        FUNCTION_1_ARG_ISNAN = "Restituisce vero se il valore è Non-un-Numero (NaN), falso altrimenti";
        FUNCTION_1_ARG_NDIG10 = "Numero di cifre in sistema numerico con base 10";
        FUNCTION_1_ARG_NFACT = "Scomposizione in numeri primi - numero fattori primi distinti";
        FUNCTION_1_ARG_ARCSEC = "Secante inversa trigonometrica";
        FUNCTION_1_ARG_ARCCSC = "Cosecante inversa trigonometrica";
        FUNCTION_1_ARG_GAMMA = "Gamma";
        FUNCTION_1_ARG_LAMBERT_W0 = "Lambert-W, ramo principale 0, chiamato anche omega o logaritmo prodotto";
        FUNCTION_1_ARG_LAMBERT_W1 = "Lambert-W, ramo -1, chiamato anche omega o logaritmo prodotto";
        FUNCTION_1_ARG_SGN_GAMMA = "Segno Gamma";
        FUNCTION_1_ARG_LOG_GAMMA = "Log Gamma";
        FUNCTION_1_ARG_DI_GAMMA = "Digamma, derivata logaritmica della funzione Gamma";
        FUNCTION_1_ARG_PARAM = "Funzione generata automaticamente per le funzioni definite dall'utente, restituisce il valore del parametro della funzione all'indice 'i'";
        // -------------------------------------------------
        FUNCTION_2_ARG_LOG = "Logaritmo";
        FUNCTION_2_ARG_MOD = "Modulo";
        FUNCTION_2_ARG_BINOM_COEFF = "Coefficiente binomiale, numero di combinazioni k che possono essere estratte da un insieme di n-elementi";
        FUNCTION_2_ARG_BERNOULLI_NUMBER = "Numeri di Bernoulli";
        FUNCTION_2_ARG_STIRLING1_NUMBER = "Numeri di Stirling del primo tipo";
        FUNCTION_2_ARG_STIRLING2_NUMBER = "Numeri di Stirling del secondo tipo";
        FUNCTION_2_ARG_WORPITZKY_NUMBER = "Numero di Worpitzky";
        FUNCTION_2_ARG_EULER_NUMBER = "Numero di Euler";
        FUNCTION_2_ARG_KRONECKER_DELTA = "Delta di Kronecker";
        FUNCTION_2_ARG_EULER_POLYNOMIAL = "Polinomio di Euler";
        FUNCTION_2_ARG_HARMONIC_NUMBER = "Numero armonico";
        FUNCTION_2_ARG_ROUND = "Arrotondamento all'intero più vicino";
        FUNCTION_2_ARG_NDIG = "Numero di cifre che rappresentano il numero in un sistema numerale con base data";
        FUNCTION_2_ARG_DIGIT10 = "Cifra in posizione 1 ... n (da sinistra -> a destra) o 0 ... -(n-1) (da destra -> a sinistra) - sistema numerale in base 10";
        FUNCTION_2_ARG_FACTVAL = "Scomposizione in fattori primi - valore del fattore in posizione tra 1 ... nfact(n) - ordine crescente per valore del fattore";
        FUNCTION_2_ARG_FACTEXP = "Scomposizione in fattori primi - esponente del fattore / molteplicità in posizione tra 1 ... nfact(n) - ordine crescente per valore del fattore";
        FUNCTION_2_ARG_ROOT = "Radice di ordine N di un numero";
        FUNCTION_2_ARG_INC_GAMMA_LOWER = "Gamma incompleta inferiore";
        FUNCTION_2_ARG_INC_GAMMA_UPPER = "Gamma incompleta superiore";
        FUNCTION_2_ARG_REG_GAMMA_LOWER = "P gamma regolarizzata inferiore";
        FUNCTION_2_ARG_REG_GAMMA_UPPER = "Q gamma regolarizzata superiore";
        FUNCTION_2_ARG_PERMUTATIONS = "Numero di permutazioni k che possono essere estratte da un insieme di n-elementi";
        FUNCTION_2_ARG_BETA = "La Beta, anche chiamata integrale di Euler del primo tipo";
        FUNCTION_2_ARG_LOG_BETA = "Il Log Beta, anche chiamato logaritmo dell'integrale di Euler del primo tipo";
        // -------------------------------------------------
        FUNCTION_3_ARG_IF = "Se";
        FUNCTION_3_ARG_CHI = "Funzione caratteristica per x in (a,b)";
        FUNCTION_3_ARG_CHI_LR = "Funzione caratteristica per x in [a,b]";
        FUNCTION_3_ARG_CHI_L = "Funzione caratteristica per x in [a,b)";
        FUNCTION_3_ARG_CHI_R = "Funzione caratteristica per x in (a,b]";
        FUNCTION_3_ARG_DIGIT = "Cifra in posizione 1 ... n (da sinistra -> a destra) o 0 ... -(n-1) (da destra -> a sinistra) - sistema numerale con base data";
        FUNCTION_3_ARG_INC_BETA = "La Beta incompleta, anche chiamata integrale di Euler incompleto del primo tipo";
        FUNCTION_3_ARG_REG_BETA = "La Beta incompleta regolarizzata (o beta regolarizzata), anche chiamata integrale di Euler incompleto regolarizzato del primo tipo";
        // -------------------------------------------------
        FUNCTION_VARIADIC_IFF = "Funzione Se";
        FUNCTION_VARIADIC_MIN = "Minimo";
        FUNCTION_VARIADIC_MAX = "Massimo";
        FUNCTION_VARIADIC_CONT_FRAC = "Frazione continua";
        FUNCTION_VARIADIC_CONT_POL = "Polinomio continuo";
        FUNCTION_VARIADIC_GCD = "Massimo comune divisore";
        FUNCTION_VARIADIC_LCM = "Minimo comune multiplo";
        FUNCTION_VARIADIC_SUM = "Somma";
        FUNCTION_VARIADIC_PROD = "Moltiplicazione";
        FUNCTION_VARIADIC_AVG = "Media / valore medio";
        FUNCTION_VARIADIC_VAR = "Varianza campionaria corretta per il bias";
        FUNCTION_VARIADIC_STD = "Deviazione standard campionaria corretta per il bias";
        FUNCTION_VARIADIC_RND_LIST = "Numero casuale da un elenco di numeri dato";
        FUNCTION_VARIADIC_COALESCE = "Restituisce il primo valore non-NaN";
        FUNCTION_VARIADIC_OR = "Disgiunzione logica (OR) - variabili";
        FUNCTION_VARIADIC_AND = "Congiunzione logica (AND) - variabili";
        FUNCTION_VARIADIC_XOR = "O esclusivo (XOR) - variabili";
        FUNCTION_VARIADIC_ARGMIN = "Argomenti / indici dei minimi";
        FUNCTION_VARIADIC_ARGMAX = "Argomenti / indici dei massimi";
        FUNCTION_VARIADIC_MEDIAN = "La mediana del campione";
        FUNCTION_VARIADIC_MODE = "Moda - il valore che appare più spesso";
        FUNCTION_VARIADIC_BASE = "Restituisce il numero nel sistema numerale con base data rappresentato da una lista di cifre";
        FUNCTION_VARIADIC_NDIST = "Numero di valori distinti";
        // -------------------------------------------------
        OPERATOR_PLUS = "Addizione";
        OPERATOR_MINUS = "Sottrazione";
        OPERATOR_MULTIPLY = "Moltiplicazione";
        OPERATOR_DIVIDE = "Divisione";
        OPERATOR_DIVIDE_QUOTIENT = "Divisione intera (quoziente)";
        OPERATOR_POWER = "Esponenziazione";
        OPERATOR_FACT = "Fattoriale";
        OPERATOR_MOD = "Modulo";
        OPERATOR_PERC = "Percentuale";
        OPERATOR_TETRATION = "Tetrazione (iper-4, torre di potenza, torre esponenziale)";
        OPERATOR_SQUARE_ROOT = "Radice quadrata";
        OPERATOR_CUBE_ROOT = "Radice cubica";
        OPERATOR_FOURTH_ROOT = "Radice quarta";
        // -------------------------------------------------
        PARSER_SYMBOL_LEFT_PARENTHESES = "Parentesi sinistra";
        PARSER_SYMBOL_RIGHT_PARENTHESES = "Parentesi destra";
        PARSER_SYMBOL_COMMA = "Virgola (parametri di funzione)";
        PARSER_SYMBOL_SEMI = "Punto e virgola (parametri di funzione)";
        PARSER_SYMBOL_BLANK = "Carattere bianco (spazio bianco)";
        PARSER_SYMBOL_NUMBER_INTEGER = "Intero";
        PARSER_SYMBOL_NUMBER_DECIMAL = "Decimale";
        PARSER_SYMBOL_NUMBER_LEADING_ZERO = "Zero iniziale";
        PARSER_SYMBOL_NUMBER_SCI_NOTATION = "Notazione scientifica";
        PARSER_SYMBOL_NUMBER_NO_LEADING_ZERO = "Nessuno zero iniziale";
        PARSER_SYMBOL_NUMBER_FRACTIONS = "Frazioni";
        PARSER_SYMBOL_NUMBER_OTHER_NUMERAL_SYSTEMS = "Altri sistemi di numerazione";
        PARSER_SYMBOL_UNICODE_MATH = " - Simbolo matematico Unicode";
        // -------------------------------------------------
        DIMENSIONLESS_UNIT_PERC = "Percentuale";
        DIMENSIONLESS_UNIT_PERM = "Per mille";
        DIMENSIONLESS_UNIT_YOTTA = "Settilione / Yotta";
        DIMENSIONLESS_UNIT_ZETTA = "Sestilione / Zetta";
        DIMENSIONLESS_UNIT_EXA = "Quintilione / Exa";
        DIMENSIONLESS_UNIT_PETA = "Quadrilione / Peta";
        DIMENSIONLESS_UNIT_TERA = "Trilione / Tera";
        DIMENSIONLESS_UNIT_GIGA = "Bilione / Giga";
        DIMENSIONLESS_UNIT_MEGA = "Milione / Mega";
        DIMENSIONLESS_UNIT_KILO = "Mille / Kilo";
        DIMENSIONLESS_UNIT_HECTO = "Cento / Hecto";
        DIMENSIONLESS_UNIT_DECA = "Dieci / Deca";
        DIMENSIONLESS_UNIT_DECI = "Decimo / Deci";
        DIMENSIONLESS_UNIT_CENTI = "Centesimo / Centi";
        DIMENSIONLESS_UNIT_MILLI = "Millesimo / Milli";
        DIMENSIONLESS_UNIT_MICRO = "Milionesimo / Micro";
        DIMENSIONLESS_UNIT_NANO = "Miliardesimo / Nano";
        DIMENSIONLESS_UNIT_PICO = "Trilionesimo / Pico";
        DIMENSIONLESS_UNIT_FEMTO = "Quadrilionesimo / Femto";
        DIMENSIONLESS_UNIT_ATTO = "Quintilionesimo / Atto";
        DIMENSIONLESS_UNIT_ZEPTO = "Sestilionesimo / Zepto";
        DIMENSIONLESS_UNIT_YOCTO = "Settilionesimo / Yocto";
        // -------------------------------------------------
        UNIT_METRE = "Metro";
        UNIT_KILOMETRE = "Chilometro";
        UNIT_CENTIMETRE = "Centimetro";
        UNIT_MILLIMETRE = "Millimetro";
        UNIT_INCH = "Pollice";
        UNIT_YARD = "Iarda";
        UNIT_FEET = "Piede";
        UNIT_MILE = "Miglia";
        UNIT_NAUTICAL_MILE = "Miglia nautica";
        UNIT_METRE2 = "Metro quadrato";
        UNIT_CENTIMETRE2 = "Centimetro quadrato";
        UNIT_MILLIMETRE2 = "Millimetro quadrato";
        UNIT_ARE = "Are";
        UNIT_HECTARE = "Ettaro";
        UNIT_ACRE = "Acro";
        UNIT_KILOMETRE2 = "Chilometro quadrato";
        UNIT_MILLIMETRE3 = "Millimetro cubo";
        UNIT_CENTIMETRE3 = "Centimetro cubo";
        UNIT_METRE3 = "Metro cubo";
        UNIT_KILOMETRE3 = "Chilometro cubo";
        UNIT_MILLILITRE = "Millilitro";
        UNIT_LITRE = "Litro";
        UNIT_GALLON = "Gallone";
        UNIT_PINT = "Pinta";
        UNIT_SECOND = "Secondo";
        UNIT_MILLISECOND = "Millisecondo";
        UNIT_MINUTE = "Minuto";
        UNIT_HOUR = "Ora";
        UNIT_DAY = "Giorno";
        UNIT_WEEK = "Settimana";
        UNIT_JULIAN_YEAR = "Anno giuliano = 365.25 giorni";
        UNIT_KILOGRAM = "Chilogrammo";
        UNIT_GRAM = "Grammo";
        UNIT_MILLIGRAM = "Milligrammo";
        UNIT_DECAGRAM = "Decagrammo";
        UNIT_TONNE = "Tonnellata";
        UNIT_OUNCE = "Oncia";
        UNIT_POUND = "Libbra";
        UNIT_BIT = "Bit";
        UNIT_KILOBIT = "Kilobit";
        UNIT_MEGABIT = "Megabit";
        UNIT_GIGABIT = "Gigabit";
        UNIT_TERABIT = "Terabit";
        UNIT_PETABIT = "Petabit";
        UNIT_EXABIT = "Exabit";
        UNIT_ZETTABIT = "Zettabit";
        UNIT_YOTTABIT = "Yottabit";
        UNIT_BYTE = "Byte";
        UNIT_KILOBYTE = "Kilobyte";
        UNIT_MEGABYTE = "Megabyte";
        UNIT_GIGABYTE = "Gigabyte";
        UNIT_TERABYTE = "Terabyte";
        UNIT_PETABYTE = "Petabyte";
        UNIT_EXABYTE = "Exabyte";
        UNIT_ZETTABYTE = "Zettabyte";
        UNIT_YOTTABYTE = "Yottabyte";
        UNIT_JOULE = "Joule";
        UNIT_ELECTRONO_VOLT = "Elettronvolt";
        UNIT_KILO_ELECTRONO_VOLT = "Kiloelettronvolt";
        UNIT_MEGA_ELECTRONO_VOLT = "Megaelettronvolt";
        UNIT_GIGA_ELECTRONO_VOLT = "Gigaelettronvolt";
        UNIT_TERA_ELECTRONO_VOLT = "Teraelettronvolt";
        UNIT_METRE_PER_SECOND = "Metro al secondo";
        UNIT_KILOMETRE_PER_HOUR = "Chilometro all'ora";
        UNIT_MILE_PER_HOUR = "Miglia all'ora";
        UNIT_KNOT = "Nodo";
        UNIT_METRE_PER_SECOND2 = "Metro al secondo quadrato";
        UNIT_KILOMETRE_PER_HOUR2 = "Chilometro all'ora quadrato";
        UNIT_MILE_PER_HOUR2 = "Miglia all'ora quadrato";
        UNIT_RADIAN_ARC = "Radiante";
        UNIT_DEGREE_ARC = "Grado di arco";
        UNIT_MINUTE_ARC = "Minuto d'arco";
        UNIT_SECOND_ARC = "Secondo d'arco";
    }
}