/*
 * @(#)StringResourcesPortuguese.java        6.1.0    2024-10-06
 *
 * MathParser.org-mXparser DUAL LICENSE AGREEMENT as of date 2024-05-19
 * The most up-to-date license is available at the below link:
 * - https://mathparser.org/mxparser-license
 *
 * AUTHOR: Copyright 2010 - 2024 Mariusz Gromada - All rights reserved
 * PUBLISHER: INFIMA - https://payhip.com/infima
 *
 * SOFTWARE means source code and/or binary form and/or documentation.
 * PRODUCT: MathParser.org-mXparser SOFTWARE
 * LICENSE: DUAL LICENSE AGREEMENT
 *
 * BY INSTALLING, COPYING, OR OTHERWISE USING THE PRODUCT, YOU AGREE TO BE
 * BOUND BY ALL OF THE TERMS AND CONDITIONS OF THE DUAL LICENSE AGREEMENT.
 *
 * The AUTHOR & PUBLISHER provide the PRODUCT under the DUAL LICENSE AGREEMENT
 * model designed to meet the needs of both non-commercial use and commercial
 * use.
 *
 * NON-COMMERCIAL USE means any use or activity where a fee is not charged
 * and the purpose is not the sale of a good or service, and the use or
 * activity is not intended to produce a profit. Examples of NON-COMMERCIAL USE
 * include:
 *
 * 1. Non-commercial open-source software.
 * 2. Non-commercial mobile applications.
 * 3. Non-commercial desktop software.
 * 4. Non-commercial web applications/solutions.
 * 5. Non-commercial use in research, scholarly and educational context.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * COMMERCIAL USE means any use or activity where a fee is charged or the
 * purpose is the sale of a good or service, or the use or activity is
 * intended to produce a profit. COMMERCIAL USE examples:
 *
 * 1. OEMs (Original Equipment Manufacturers).
 * 2. ISVs (Independent Software Vendors).
 * 3. VARs (Value Added Resellers).
 * 4. Other distributors that combine and distribute commercially licensed
 *    software.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * IN CASE YOU WANT TO USE THE PRODUCT COMMERCIALLY, YOU MUST PURCHASE THE
 * APPROPRIATE LICENSE FROM "INFIMA" ONLINE STORE, STORE ADDRESS:
 *
 * 1. https://mathparser.org/order-commercial-license
 * 2. https://payhip.com/infima
 *
 * NON-COMMERCIAL LICENSE
 *
 * Redistribution and use of the PRODUCT in source and/or binary forms,
 * with or without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the unmodified content of
 *    the entire MathParser.org-mXparser DUAL LICENSE AGREEMENT, including
 *    the definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE,
 *    the NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 2. Redistributions in binary form must reproduce the entire content of
 *    MathParser.org-mXparser DUAL LICENSE AGREEMENT in the documentation
 *    and/or other materials provided with the distribution, including the
 *    definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE, the
 *    NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 3. Any form of redistribution requires confirmation and signature of
 *    the NON-COMMERCIAL USE by successfully calling the method:
 *       License.iConfirmNonCommercialUse(...)
 *    The method call is used only internally for logging purposes, and
 *    there is no connection with other external services, and no data is
 *    sent or collected. The lack of a method call (or its successful call)
 *    does not affect the operation of the PRODUCT in any way. Please see
 *    the API documentation.
 *
 * COMMERCIAL LICENSE
 *
 *  1. Before purchasing a commercial license, the AUTHOR & PUBLISHER allow
 *     you to download, install, and use up to three copies of the PRODUCT to
 *     perform integration tests, confirm the quality of the PRODUCT, and
 *     its suitability. The testing period should be limited to fourteen
 *     days. Tests should be performed under the test environments conditions
 *     and not for profit generation.
 *  2. Provided that you purchased a license from "INFIMA" online store
 *     (store address: https://mathparser.org/order-commercial-license or
 *     https://payhip.com/infima), and you comply with all terms and
 *     conditions below, and you have acknowledged and understood the
 *     following DISCLAIMER, the AUTHOR & PUBLISHER grant you a nonexclusive
 *     license with the following rights:
 *  3. The license is granted only to you, the person or entity that made
 *     the purchase, identified and confirmed by the data provided during
 *     the purchase.
 *  4. If you purchased a license in the "ONE-TIME PURCHASE" model, the
 *     license is granted only for the PRODUCT version specified in the
 *     purchase. The upgrade policy gives you additional rights, described
 *     in the dedicated section below.
 *  5. If you purchased a license in the "SUBSCRIPTION" model, you may
 *     install and use any version of the PRODUCT during the subscription
 *     validity period.
 *  6. If you purchased a "SINGLE LICENSE" you may install and use the
 *     PRODUCT on/from one workstation that is located/accessible at/from
 *     any of your premises.
 *  7. Additional copies of the PRODUCT may be installed and used on/from
 *     more than one workstation, limited to the number of workstations
 *     purchased per order.
 *  8. If you purchased a "SITE LICENSE", the PRODUCT may be installed
 *     and used on/from all workstations located/accessible at/from any
 *     of your premises.
 *  9. You may incorporate the unmodified PRODUCT into your own products
 *     and software.
 * 10. If you purchased a license with the "SOURCE CODE" option, you may
 *     modify the PRODUCT's source code and incorporate the modified source
 *     code into your own products and/or software.
 * 11. Provided that the license validity period has not expired, you may
 *     distribute your product and/or software with the incorporated
 *     PRODUCT royalty-free.
 * 12. You may make copies of the PRODUCT for backup and archival purposes.
 * 13. Any form of redistribution requires confirmation and signature of
 *     the COMMERCIAL USE by successfully calling the method:
 *        License.iConfirmCommercialUse(...)
 *     The method call is used only internally for logging purposes, and
 *     there is no connection with other external services, and no data is
 *     sent or collected. The lack of a method call (or its successful call)
 *     does not affect the operation of the PRODUCT in any way. Please see
 *     the API documentation.
 * 14. The AUTHOR & PUBLISHER reserve all rights not expressly granted to
 *     you in this agreement.
 *
 * ADDITIONAL CLARIFICATION ON WORKSTATION
 *
 * A workstation is a device, a remote device, or a virtual device, used by
 * you, your employees, or other entities to whom you have commissioned
 * tasks. For example, the number of workstations may refer to the number
 * of software developers, engineers, architects, scientists, and other
 * professionals who use the PRODUCT on your behalf. The number of
 * workstations is not the number of copies of your end-product that you
 * distribute to your end-users.
 *
 * By purchasing the COMMERCIAL LICENSE, you only pay for the number of
 * workstations, while the number of copies/users of your final product
 * (delivered to your end-users) is not limited.
 *
 * Below are some examples to help you select the right license size:
 *
 * Example 1: Single Workstation License
 * Only one developer works on the development of your application. You do
 * not use separate environments for testing, meaning you design, create,
 * test, and compile your final application on one environment. In this
 * case, you need a license for a single workstation.
 *
 * Example 2: Up to 5 Workstations License
 * Two developers are working on the development of your application.
 * Additionally, one tester conducts tests in a separate environment.
 * You use three workstations in total, so you need a license for up to
 * five workstations.
 *
 * Example 3: Up to 20 Workstations License
 * Ten developers are working on the development of your application.
 * Additionally, five testers conduct tests in separate environments.
 * You use fifteen workstations in total, so you need a license for
 * up to twenty workstations.
 *
 * Example 4: Site License
 * Several dozen developers and testers work on the development of your
 * application using multiple environments. You have a large,
 * multi-disciplinary team involved in creating your solution. As your team
 * is growing and you want to avoid licensing limitations, the best choice
 * would be a site license.
 *
 * UPGRADE POLICY
 *
 * The PRODUCT is versioned according to the following convention:
 *
 *    [MAJOR].[MINOR].[PATCH]
 *
 * 1. COMMERCIAL LICENSE holders can install and use the updated version
 *    for bug fixes free of charge, i.e. if you have purchased a license
 *    for the [MAJOR].[MINOR] version (e.g., 5.0), you can freely install
 *    all releases specified in the [PATCH] version (e.g., 5.0.2).
 *    The license terms remain unchanged after the update.
 * 2. COMMERCIAL LICENSE holders for the [MAJOR].[MINOR] version (e.g., 5.0)
 *    can install and use the updated version [MAJOR].[MINOR + 1] free of
 *    charge, i.e., plus one release in the [MINOR] range (e.g., 5.1). The
 *    license terms remain unchanged after the update.
 * 3. COMMERCIAL LICENSE holders who wish to upgrade their version, but are
 *    not eligible for the free upgrade, can claim a discount when
 *    purchasing the upgrade. For this purpose, please contact us via e-mail.
 *
 * DISCLAIMER
 *
 * THIS PRODUCT IS PROVIDED BY THE AUTHOR & PUBLISHER "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AUTHOR OR PUBLISHER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS PRODUCT, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE VIEWS AND CONCLUSIONS CONTAINED IN THE PRODUCT AND DOCUMENTATION ARE
 * THOSE OF THE AUTHORS AND SHOULD NOT BE INTERPRETED AS REPRESENTING
 * OFFICIAL POLICIES, EITHER EXPRESSED OR IMPLIED, OF THE AUTHOR OR PUBLISHER.
 *
 * CONTACT
 *
 * - e-mail: info@mathparser.org
 * - website: https://mathparser.org
 * - source code: https://github.com/mariuszgromada/MathParser.org-mXparser
 * - online store: https://mathparser.org/order-commercial-license
 * - online store: https://payhip.com/infima
 */
package org.mariuszgromada.math.mxparser;

/**
 * A class containing definition of Portuguese user language
 *
 * @author         <b>Mariusz Gromada</b><br>
 *                 <a href="https://mathparser.org" target="_blank">MathParser.org - mXparser project page</a><br>
 *                 <a href="https://github.com/mariuszgromada/MathParser.org-mXparser" target="_blank">mXparser on GitHub</a><br>
 *                 <a href="https://payhip.com/INFIMA" target="_blank">INFIMA place to purchase a commercial MathParser.org-mXparser software license</a><br>
 *                 <a href="mailto:info@mathparser.org">info@mathparser.org</a><br>
 *                 <a href="https://scalarmath.org/" target="_blank">ScalarMath.org - a powerful math engine and math scripting language</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.lite" target="_blank">Scalar Lite</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.pro" target="_blank">Scalar Pro</a><br>
 *                 <a href="https://mathspace.pl" target="_blank">MathSpace.pl</a><br>
 *
 * @version        6.0.0
 *
 * @see StringResources
 * @see StringModel
 * @see StringModel#setStringResources(StringResources)
 * @see StringModel#getStringResources()
 */
class StringResourcesPortuguese extends StringResources {
    StringResourcesPortuguese() {
        USER_LANGUAGE = "Português";
        // -------------------------------------------------
        STARTING_SYNTAX_CHECK = "Iniciando verificação de sintaxe...";
        NO_ERRORS_DETECTED = "Nenhum erro detectado.";
        NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION = "Nenhum erro detectado na definição do argumento.";
        NO_ERRORS_DETECTED_IN_RECURSIVE_ARGUMENT_DEFINITION = "Nenhum erro detectado na definição recursiva do argumento.";
        NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION = "Nenhum erro detectado na definição da função.";
        NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION = "Nenhum erro detectado na definição da constante.";
        LEXICAL_ERROR_HAS_BEEN_FOUND = "Foi encontrado um erro léxico.";
        ERRORS_HAVE_BEEN_FOUND = "Foram encontrados erros.";
        ALREADY_CHECKED_NO_ERRORS = "A sintaxe já foi verificada - nenhum erro detectado.";
        SYNTAX_STATUS_UNKNOWN = "O status da sintaxe é desconhecido.";
        PROBLEM_WITH_EXPRESSION_SYNTAX = "Há um problema com a sintaxe da expressão.";
        // -------------------------------------------------
        ENCOUNTERED = "Encontrado";
        AT_INDEX = "no índice";
        WAS_EXPECTING = "Esperava-se";
        WAS_EXPECTING_ONE_OF = "Esperava-se um de";
        UNEXPECTED_EXCEPTION_WAS_ENCOUNTERED = "Foi encontrada uma exceção inesperada. Provavelmente um erro de parser - por favor, informe.";
        UNEXPECTED_TOKEN_MANAGER_ERROR_WAS_ENCOUNTERED = "Foi encontrada um erro inesperado no gerenciador de tokens. Provavelmente um erro de parser - por favor, informe.";
        // -------------------------------------------------
        EXPRESSION_STRING_IS_EMPTY = "A string de expressão está vazia.";
        EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS = "A expressão não contém nenhum token.";
        DUPLICATED_KEYWORD = "Foram encontradas palavras-chave duplicadas. Verifique os itens definidos pelo usuário. Considere usar a opção para substituir os tokens incorporados.";
        ELEMENT = "Elemento";
        ERROR = "Erro";
        EXCEPTION = "Exceção";
        TOKEN = "Token";
        INDEX = "índice";
        INVALID_TOKEN = "Token inválido.";
        INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR = "Token inválido. Possivelmente está faltando o operador de multiplicação - tente o modo de multiplicação implícita.";
        EXPRESSION_TOKENS = "Tokens da expressão";
        NULL_TOKENS_LIST = "Lista de tokens nula";
        // -------------------------------------------------
        FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS = "Função definida pelo usuário com corpo estendido - nenhum erro por suposição.";
        ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS = "Argumento definido pelo usuário com corpo estendido - nenhum erro por suposição.";
        PROVIDED_EXTENSION_IS_NULL = "A extensão fornecida é nula.";
        PROVIDED_STRING_IS_NULL = "A string fornecida é nula.";
        PROVIDED_ELEMENTS_ARE_NULL = "Os elementos fornecidos são nulos.";
        MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE = "Operador de multiplicação ausente - tente o modo de multiplicação implícita.";
        // -------------------------------------------------
        STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT = "Iniciando verificação de sintaxe do argumento dependente definido pelo usuário.";
        STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT = "Iniciando verificação de sintaxe do argumento recursivo definido pelo usuário.";
        STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION = "Iniciando verificação de sintaxe da função definida pelo usuário.";
        STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION = "Iniciando verificação de sintaxe da função variádica definida pelo usuário.";
        // -------------------------------------------------
        ARGUMENT_WAS_EXPECTED = "Esperava-se um argumento definido pelo usuário.";
        RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER = "Um argumento recursivo definido pelo usuário requer um parâmetro.";
        // -------------------------------------------------
        INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION = "Número incorreto de parâmetros na função definida pelo usuário.";
        // -------------------------------------------------
        INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS = "Número incorreto de parâmetros de função.";
        EXPECTED = "Esperado";
        PROVIDED = "Fornecido";
        USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT = "Número incorreto de parâmetros na função definida pelo usuário - é esperado pelo menos um argumento.";
        EXPECTED_EVEN_NUMBER_OF_ARGUMENTS = "Era esperado um número par de argumentos.";
        // -------------------------------------------------
        INVALID_FUNCTION_NAME = "Nome de função inválido.";
        INVALID_ARGUMENT_NAME = "Nome de argumento inválido.";
        INVALID_CONSTANT_NAME = "Nome de constante inválido.";
        INVALID_FUNCTION_DEFINITION = "Definição de função inválida.";
        INVALID_ARGUMENT_DEFINITION = "Definição de argumento inválida.";
        INVALID_CONSTANT_DEFINITION = "Definição de constante inválida.";
        PATTERN_DOES_NOT_MATCH = "O padrão não corresponde.";
        PATTERN_EXAMPLES = "Exemplos de padrão";
        // -------------------------------------------------
        CONSTANT_WAS_EXPECTED = "Era esperado um valor constante.";
        USER_CONSTANT_WAS_EXPECTED = "Era esperada uma constante definida pelo usuário.";
        // -------------------------------------------------
        UNARY_FUNCTION_EXPECTS_1_PARAMETER = "Uma função unária espera 1 parâmetro.";
        BINARY_FUNCTION_EXPECTS_2_PARAMETERS = "Uma função binária espera 2 parâmetros.";
        TERNARY_FUNCTION_EXPECTS_3_PARAMETERS = "Uma função ternária espera 3 parâmetros.";
        // -------------------------------------------------
        DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS = "O operador de derivada espera 2, 3, 4 ou 5 parâmetros de cálculo.";
        ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION = "Esperava-se um argumento em uma invocação do operador de derivada.";
        DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Foram encontradas palavras-chave duplicadas na invocação do operador de cálculo. Verifique os parâmetros de cálculo.";
        ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Esperava-se um token (argumento ou desconhecido) na invocação do operador de cálculo.";
        NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS = "O operador de derivada de ordem N espera 3 ou 5 parâmetros de cálculo.";
        INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS = "O operador de integral/solução espera 4 parâmetros de cálculo.";
        ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS = "O operador iterado espera 4 ou 5 parâmetros de cálculo.";
        FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS = "O operador de diferença para frente/para trás espera 2 ou 3 parâmetros de cálculo.";
        FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED = "Esperava-se um argumento na invocação do operador de diferença para frente/para trás.";
        AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED = "Esperava-se pelo menos um argumento.";
        // -------------------------------------------------
        ERROR_WHILE_EXECUTING_THE_CALCULATE = "Erro ao executar o cálculo.";
        RECURSION_CALLS_COUNTER_EXCEEDED = "O contador de chamadas recursivas foi excedido.";
        RECURSION_CALLS_COUNTER = "Contador de chamadas recursivas";
        STARTING_CALCULATION_LOOP = "Iniciando o loop de cálculo.";
        CANCEL_REQUEST_FINISHING = "Solicitação de cancelamento encontrada - finalizando.";
        INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING = "Erro interno/nível de token estranho - finalizando. Provavelmente um erro de parser - por favor, informe.";
        FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN = "Erro fatal, não se sabe o que fazer com o token encontrado. Provavelmente um erro de parser - por favor, informe.";
        MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED = "O comprimento máximo da mensagem de erro foi excedido.";
        // -------------------------------------------------
        STARTING = "Iniciando...";
        PARSING = "Analisando";
        FULLY_COMPILED = "Totalmente compilado";
        CALCULATED_VALUE = "Valor calculado";
        EXITING = "Encerrando.";
        DONE = "concluído.";
        // -------------------------------------------------
        KEYWORD = "Palavra-chave";
        SYNTAX = "Sintaxe";
        NUMBER = "Número";
        NUMBER_LITERAL = "Literal numérico";
        TYPE = "Tipo";
        SINCE = "Desde";
        DESCRIPTION = "Descrição";
        // -------------------------------------------------
        CALC_STEPS_REGISTER_IS_EMPTY = "O registro de etapas de cálculo está vazio.";
        CALC_STEPS_REGISTER_FOR = "Registro de etapas de cálculo para";
        ARGUMENT = "Argumento";
        FUNCTION = "Função";
        EXPRESSION = "Expressão";
        RESULT = "resultado";
        COMPUTING_TIME = "Tempo de cálculo";
        GROUP_SHORT = "grupo";
        NUMBER_SHORT = "nº";
        FIRST = "primeiro";
        LAST = "último";
        DESCRIPTION_SHORT = "descr.";
        STEP = "passo";
        // -------------------------------------------------
        SERIALIZATION_PERFORMED = "Serialização foi realizada:";
        DESERIALIZATION_PERFORMED = "Deserialização foi realizada:";
        NULL_OBJECT_PROVIDED = "Objeto nulo fornecido.";
        NULL_FILE_PATH_PROVIDED = "Caminho do arquivo nulo fornecido.";
        FILE_PATH_ZERO_LENGTH_PROVIDED = "O caminho do arquivo não contém caracteres.";
        FILE_PATH_IS_NOT_A_FILE = "O caminho do arquivo não é um arquivo:";
        FILE_PATH_NOT_EXISTS = "O caminho do arquivo não existe:";
        NULL_DATA_PROVIDED = "Dados nulos fornecidos.";
        BINARY_SERIALIZATION_ENABLED = "A serialização binária está ativada. Use-a apenas conscientemente e com moderação.";
        BINARY_SERIALIZATION_DISABLED = "A serialização binária está desativada. Você pode ativá-la se estiver ciente dos riscos de segurança.";
        // -------------------------------------------------
        USER_DEFINED_EXPRESSION = "Expressão definida pelo usuário";
        USER_DEFINED_ARGUMENT = "Argumento definido pelo usuário";
        USER_DEFINED_CONSTANT = "Constante definida pelo usuário";
        USER_DEFINED_FUNCTION = "Função definida pelo usuário";
        USER_DEFINED_RECURSIVE_ARGUMENT = "Argumento recursivo definido pelo usuário";
        // -------------------------------------------------
        HELP_CONTENT_LIMITED_TO_QUERY = "Conteúdo da ajuda limitado à consulta";
        ALL_HELP_CONTENT = "Todo o conteúdo da ajuda.";
        CAPTION = "Legenda";
        // -------------------------------------------------
        WARNING_BINARY_SERIALIZATION_SECURITY_RISKS = "AVISO DE SEGURANÇA:" + StringInvariant.NEW_LINE
                + "Deserializar dados de uma fonte não confiável pode introduzir vulnerabilidades de segurança" + StringInvariant.NEW_LINE
                + "em sua aplicação. Dependendo das configurações usadas durante a deserialização," + StringInvariant.NEW_LINE
                + "dados não confiáveis podem ser capazes de executar código arbitrário ou causar um ataque de negação de serviço." + StringInvariant.NEW_LINE
                + "Dados não confiáveis podem vir da rede de uma fonte não confiável" + StringInvariant.NEW_LINE
                + "(por exemplo, qualquer cliente de rede), ou podem ser manipulados/alterados por um intermediário enquanto" + StringInvariant.NEW_LINE
                + "estão em trânsito por uma conexão não autenticada, ou do armazenamento local onde podem" + StringInvariant.NEW_LINE
                + "ter sido comprometidos/alterados, ou de muitas outras fontes. MathParser.org-mXparser" + StringInvariant.NEW_LINE
                + "não fornece nenhum meio para autenticar dados ou protegê-los de adulteração. Use um" + StringInvariant.NEW_LINE
                + "método de autenticação de dados apropriado antes de deserializar. Esteja muito atento a esses" + StringInvariant.NEW_LINE
                + "cenários de ataque; muitos projetos e empresas e usuários de bibliotecas de serialização em" + StringInvariant.NEW_LINE
                + "geral foram mordidos pela deserialização não confiável de dados do usuário no passado." + StringInvariant.NEW_LINE
        ;
        // -------------------------------------------------
        BINARY_RELATION = "Relação binária";
        BITWISE_OPERATOR = "Operador bitwise";
        BOOLEAN_OPERATOR = "Operador booleano";
        CALCULUS_OPERATOR = "Operador de cálculo";
        CONSTANT_VALUE = "Valor constante";
        FUNCTION_1_ARG = "Função unária";
        FUNCTION_2_ARG = "Função binária";
        FUNCTION_3_ARG = "Função ternária";
        FUNCTION_VARIADIC = "Função variádica";
        OPERATOR = "Operador";
        PARSER_SYMBOL = "Símbolo do parser";
        RANDOM_VARIABLE = "Variável aleatória";
        UNIT = "Unidade";
        DIMENSIONLESS_UNIT = "Unidade sem dimensão";
        ITERATED_OPERATOR = "Operador iterado";
        // -------------------------------------------------
        RATIO_FRACTION = "Razão / Fração";
        METRIC_PREFIX = "Prefixo métrico";
        UNIT_OF_LENGTH = "Unidade de comprimento";
        UNIT_OF_AREA = "Unidade de área";
        UNIT_OF_VOLUME = "Unidade de volume";
        UNIT_OF_TIME = "Unidade de tempo";
        UNIT_OF_MASS = "Unidade de massa";
        UNIT_OF_INFORMATION = "Unidade de informação";
        UNIT_OF_ENERGY = "Unidade de energia";
        UNIT_OF_SPEED = "Unidade de velocidade";
        UNIT_OF_ACCELERATION = "Unidade de aceleração";
        UNIT_OF_ANGLE = "Unidade de ângulo";
        // -------------------------------------------------
        PHYSICAL_CONSTANT = "Constante física";
        ASTRONOMICAL_CONSTANT = "Constante astronômica";
        MATHEMATICAL_CONSTANT = "Constante matemática";
        // -------------------------------------------------
        PROBABILITY_DISTRIBUTION_FUNCTION = "Função de distribuição de probabilidade";
        CUMULATIVE_DISTRIBUTION_FUNCTION = "Função de distribuição cumulativa";
        QUANTILE_FUNCTION = "Função quantil (função de distribuição cumulativa inversa)";
        // -------------------------------------------------
        STUDENTS_T_DISTRIBUTION = "Distribuição t de Student";
        CHI_SQUARED_DISTRIBUTION = "Distribuição qui-quadrado";
        SNEDECORS_F_DISTRIBUTION = "Distribuição F de Snedecor (distribuição F ou razão F, também conhecida como distribuição Fisher-Snedecor)";
        UNIFORM_CONTINUOUS_DISTRIBUTION = "Distribuição contínua uniforme";
        UNIFORM_DISCRETE_DISTRIBUTION = "Distribuição discreta uniforme";
        NORMAL_DISTRIBUTION = "Distribuição normal";
        // -------------------------------------------------
        RANDOM_INTEGER = "Número inteiro aleatório";
        RANDOM_NATURAL_NUMBER = "Número natural aleatório";
        RANDOM_NATURAL_NUMBER_INCLUDING_0 = "Número natural aleatório incluindo 0";
        // -------------------------------------------------
        SPECIAL_FUNCTION = "Função especial";
        // -------------------------------------------------
        SEMI_MAJOR_AXIS = "Eixo semi-maior";
        // -------------------------------------------------
        BINARY_RELATION_EQ = "Igualdade";
        BINARY_RELATION_NEQ = "Inequação";
        BINARY_RELATION_LT = "Menor que";
        BINARY_RELATION_GT = "Maior que";
        BINARY_RELATION_LEQ = "Menor ou igual";
        BINARY_RELATION_GEQ = "Maior ou igual";
        // -------------------------------------------------
        BITWISE_OPERATOR_COMPL = "Complemento unário bitwise (NOT)";
        BITWISE_OPERATOR_AND = "E bitwise (AND)";
        BITWISE_OPERATOR_XOR = "Ou exclusivo bitwise (XOR)";
        BITWISE_OPERATOR_OR = "Ou inclusivo bitwise (OR)";
        BITWISE_OPERATOR_LEFT_SHIFT = "Deslocamento à esquerda assinado bitwise";
        BITWISE_OPERATOR_RIGHT_SHIFT = "Deslocamento à direita assinado bitwise";
        BITWISE_OPERATOR_NAND = "Bitwise não e (NAND)";
        BITWISE_OPERATOR_NOR = "Bitwise não ou (NOR)";
        BITWISE_OPERATOR_XNOR = "Bitwise NOR exclusivo (XNOR)";
        // -------------------------------------------------
        BOOLEAN_OPERATOR_AND = "Conjunção lógica";
        BOOLEAN_OPERATOR_OR = "Disjunção lógica";
        BOOLEAN_OPERATOR_NEG = "Negação";
        BOOLEAN_OPERATOR_NAND = "Traço de Sheffer";
        BOOLEAN_OPERATOR_NOR = "Não ou lógico (negação conjunta)";
        BOOLEAN_OPERATOR_XOR = "Ou exclusivo";
        BOOLEAN_OPERATOR_IMP = "Implicação";
        BOOLEAN_OPERATOR_CIMP = "Implicação inversa";
        BOOLEAN_OPERATOR_NIMP = "Não implicação material";
        BOOLEAN_OPERATOR_CNIMP = "Não implicação inversa";
        BOOLEAN_OPERATOR_EQV = "Bicondicional lógico";
        // -------------------------------------------------
        CALCULUS_OPERATOR_SUM = "Somatório SIGMA";
        CALCULUS_OPERATOR_PROD = "Produto PI";
        CALCULUS_OPERATOR_INT = "Integral definida";
        CALCULUS_OPERATOR_DER = "Derivada";
        CALCULUS_OPERATOR_DER_LEFT = "Derivada à esquerda";
        CALCULUS_OPERATOR_DER_RIGHT = "Derivada à direita";
        CALCULUS_OPERATOR_DERN = "Derivada n-ésima";
        CALCULUS_OPERATOR_FORW_DIFF = "Diferença para a frente";
        CALCULUS_OPERATOR_BACKW_DIFF = "Diferença para trás";
        CALCULUS_OPERATOR_AVG = "Média";
        CALCULUS_OPERATOR_VAR = "Variância amostral corrigida";
        CALCULUS_OPERATOR_STD = "Desvio padrão amostral corrigido";
        CALCULUS_OPERATOR_MIN = "Valor mínimo";
        CALCULUS_OPERATOR_MAX = "Valor máximo";
        CALCULUS_OPERATOR_SOLVE = "Resolução de equação (encontrar raízes)";
        // -------------------------------------------------
        CONSTANT_VALUE_PI = "Pi, número de Arquimedes ou Ludolph";
        CONSTANT_VALUE_EULER = "Número de Napier ou Euler (base do logaritmo natural)";
        CONSTANT_VALUE_EULER_MASCHERONI = "Constante de Euler-Mascheroni";
        CONSTANT_VALUE_GOLDEN_RATIO = "Proporção áurea";
        CONSTANT_VALUE_PLASTIC = "Constante plástica";
        CONSTANT_VALUE_EMBREE_TREFETHEN = "Constante de Embree-Trefethen";
        CONSTANT_VALUE_FEIGENBAUM_DELTA = "Constante delta de Feigenbaum";
        CONSTANT_VALUE_FEIGENBAUM_ALPHA = "Constante alfa de Feigenbaum";
        CONSTANT_VALUE_TWIN_PRIME = "Constante do primo gêmeo";
        CONSTANT_VALUE_MEISSEL_MERTEENS = "Constante de Meissel-Mertens";
        CONSTANT_VALUE_BRAUN_TWIN_PRIME = "Constante de Brun para primos gêmeos";
        CONSTANT_VALUE_BRAUN_PRIME_QUADR = "Constante de Brun para quartetos primos";
        CONSTANT_VALUE_BRUIJN_NEWMAN = "Constante de de Bruijn-Newman";
        CONSTANT_VALUE_CATALAN = "Constante de Catalan";
        CONSTANT_VALUE_LANDAU_RAMANUJAN = "Constante de Landau-Ramanujan";
        CONSTANT_VALUE_VISWANATH = "Constante de Viswanath";
        CONSTANT_VALUE_LEGENDRE = "Constante de Legendre";
        CONSTANT_VALUE_RAMANUJAN_SOLDNER = "Constante de Ramanujan-Soldner";
        CONSTANT_VALUE_ERDOS_BORWEIN = "Constante de Erdos-Borwein";
        CONSTANT_VALUE_BERNSTEIN = "Constante de Bernstein";
        CONSTANT_VALUE_GAUSS_KUZMIN_WIRSING = "Constante de Gauss-Kuzmin-Wirsing";
        CONSTANT_VALUE_HAFNER_SARNAK_MCCURLEY = "Constante de Hafner-Sarnak-McCurley";
        CONSTANT_VALUE_GOLOMB_DICKMAN = "Constante de Golomb-Dickman";
        CONSTANT_VALUE_CAHEN = "Constante de Cahen";
        CONSTANT_VALUE_LAPLACE_LIMIT = "Constante do limite de Laplace";
        CONSTANT_VALUE_ALLADI_GRINSTEAD = "Constante de Alladi-Grinstead";
        CONSTANT_VALUE_LENGYEL = "Constante de Lengyel";
        CONSTANT_VALUE_LEVY = "Constante de Levy";
        CONSTANT_VALUE_APERY = "Constante de Apery";
        CONSTANT_VALUE_MILLS = "Constante de Mills";
        CONSTANT_VALUE_BACKHOUSE = "Constante de Backhouse";
        CONSTANT_VALUE_PORTER = "Constante de Porter";
        CONSTANT_VALUE_LIEB_QUARE_ICE = "Constante do gelo quadrado de Lieb";
        CONSTANT_VALUE_NIVEN = "Constante de Niven";
        CONSTANT_VALUE_SIERPINSKI = "Constante de Sierpinski";
        CONSTANT_VALUE_KHINCHIN = "Constante de Khinchin";
        CONSTANT_VALUE_FRANSEN_ROBINSON = "Constante de Fransen-Robinson";
        CONSTANT_VALUE_LANDAU = "Constante de Landau";
        CONSTANT_VALUE_PARABOLIC = "Constante parabólica";
        CONSTANT_VALUE_OMEGA = "Constante Omega";
        CONSTANT_VALUE_MRB = "Constante MRB";
        CONSTANT_VALUE_LI2 = "Integral logarítmica no ponto 2";
        CONSTANT_VALUE_GOMPERTZ = "Constante de Gompertz";
        CONSTANT_VALUE_LIGHT_SPEED = "Velocidade da luz no vácuo";
        CONSTANT_VALUE_GRAVITATIONAL_CONSTANT = "Constante gravitacional";
        CONSTANT_VALUE_GRAVIT_ACC_EARTH = "Aceleração da gravidade na Terra";
        CONSTANT_VALUE_PLANCK_CONSTANT = "Constante de Planck";
        CONSTANT_VALUE_PLANCK_CONSTANT_REDUCED = "Constante de Planck reduzida (constante de Dirac)";
        CONSTANT_VALUE_PLANCK_LENGTH = "Comprimento de Planck";
        CONSTANT_VALUE_PLANCK_MASS = "Massa de Planck";
        CONSTANT_VALUE_PLANCK_TIME = "Tempo de Planck";
        CONSTANT_VALUE_LIGHT_YEAR = "Ano-luz";
        CONSTANT_VALUE_ASTRONOMICAL_UNIT = "Unidade astronômica";
        CONSTANT_VALUE_PARSEC = "Parsec";
        CONSTANT_VALUE_KILOPARSEC = "Kiloparsec";
        CONSTANT_VALUE_EARTH_RADIUS_EQUATORIAL = "Raio equatorial da Terra";
        CONSTANT_VALUE_EARTH_RADIUS_POLAR = "Raio polar da Terra";
        CONSTANT_VALUE_EARTH_RADIUS_MEAN = "Raio médio da Terra";
        CONSTANT_VALUE_EARTH_MASS = "Massa da Terra";
        CONSTANT_VALUE_EARTH_SEMI_MAJOR_AXIS = "Distância Terra-Sol";
        CONSTANT_VALUE_MOON_RADIUS_MEAN = "Raio médio da Lua";
        CONSTANT_VALUE_MOON_MASS = "Massa da Lua";
        CONSTANT_VALUE_MOON_SEMI_MAJOR_AXIS = "Distância Lua-Terra";
        CONSTANT_VALUE_SOLAR_RADIUS = "Raio médio do Sol";
        CONSTANT_VALUE_SOLAR_MASS = "Massa do Sol";
        CONSTANT_VALUE_MERCURY_RADIUS_MEAN = "Raio médio de Mercúrio";
        CONSTANT_VALUE_MERCURY_MASS = "Massa de Mercúrio";
        CONSTANT_VALUE_MERCURY_SEMI_MAJOR_AXIS = "Distância Mercúrio-Sol";
        CONSTANT_VALUE_VENUS_RADIUS_MEAN = "Raio médio de Vênus";
        CONSTANT_VALUE_VENUS_MASS = "Massa de Vênus";
        CONSTANT_VALUE_VENUS_SEMI_MAJOR_AXIS = "Distância Vênus-Sol";
        CONSTANT_VALUE_MARS_RADIUS_MEAN = "Raio médio de Marte";
        CONSTANT_VALUE_MARS_MASS = "Massa de Marte";
        CONSTANT_VALUE_MARS_SEMI_MAJOR_AXIS = "Distância Marte-Sol";
        CONSTANT_VALUE_JUPITER_RADIUS_MEAN = "Raio médio de Júpiter";
        CONSTANT_VALUE_JUPITER_MASS = "Massa de Júpiter";
        CONSTANT_VALUE_JUPITER_SEMI_MAJOR_AXIS = "Distância Júpiter-Sol";
        CONSTANT_VALUE_SATURN_RADIUS_MEAN = "Raio médio de Saturno";
        CONSTANT_VALUE_SATURN_MASS = "Massa de Saturno";
        CONSTANT_VALUE_SATURN_SEMI_MAJOR_AXIS = "Distância Saturno-Sol";
        CONSTANT_VALUE_URANUS_RADIUS_MEAN = "Raio médio de Urano";
        CONSTANT_VALUE_URANUS_MASS = "Massa de Urano";
        CONSTANT_VALUE_URANUS_SEMI_MAJOR_AXIS = "Distância Urano-Sol";
        CONSTANT_VALUE_NEPTUNE_RADIUS_MEAN = "Raio médio de Netuno";
        CONSTANT_VALUE_NEPTUNE_MASS = "Massa de Netuno";
        CONSTANT_VALUE_NEPTUNE_SEMI_MAJOR_AXIS = "Distância Netuno-Sol";
        CONSTANT_VALUE_TRUE = "Booleano Verdadeiro representado como 1";
        CONSTANT_VALUE_FALSE = "Booleano Falso representado como 0";
        CONSTANT_VALUE_NPAR = "Constante gerada automaticamente para funções definidas pelo usuário, retorna o número de parâmetros da função dada";
        CONSTANT_VALUE_NAN = "Não é um número";
        // -------------------------------------------------
        FUNCTION_1_ARG_SIN = "Seno trigonométrico";
        FUNCTION_1_ARG_COS = "Cosseno trigonométrico";
        FUNCTION_1_ARG_TAN = "Tangente trigonométrica";
        FUNCTION_1_ARG_CTAN = "Cotangente trigonométrica";
        FUNCTION_1_ARG_SEC = "Secante trigonométrica";
        FUNCTION_1_ARG_COSEC = "Cosecante trigonométrica";
        FUNCTION_1_ARG_ASIN = "Seno inverso trigonométrico";
        FUNCTION_1_ARG_ACOS = "Cosseno inverso trigonométrico";
        FUNCTION_1_ARG_ATAN = "Tangente inversa trigonométrica";
        FUNCTION_1_ARG_ACTAN = "Cotangente inversa trigonométrica";
        FUNCTION_1_ARG_LN = "Logaritmo natural (base e)";
        FUNCTION_1_ARG_LOG2 = "Logaritmo binário (base 2)";
        FUNCTION_1_ARG_LOG10 = "Logaritmo comum (base 10)";
        FUNCTION_1_ARG_RAD = "Graus para radianos";
        FUNCTION_1_ARG_EXP = "Exponencial";
        FUNCTION_1_ARG_SQRT = "Raiz quadrada";
        FUNCTION_1_ARG_SINH = "Seno hiperbólico";
        FUNCTION_1_ARG_COSH = "Cosseno hiperbólico";
        FUNCTION_1_ARG_TANH = "Tangente hiperbólica";
        FUNCTION_1_ARG_COTH = "Cotangente hiperbólica";
        FUNCTION_1_ARG_SECH = "Secante hiperbólica";
        FUNCTION_1_ARG_CSCH = "Cosecante hiperbólica";
        FUNCTION_1_ARG_DEG = "Radianos para graus";
        FUNCTION_1_ARG_ABS = "Valor absoluto";
        FUNCTION_1_ARG_SGN = "Signum";
        FUNCTION_1_ARG_FLOOR = "Chão";
        FUNCTION_1_ARG_CEIL = "Teto";
        FUNCTION_1_ARG_NOT = "Negação";
        FUNCTION_1_ARG_ARSINH = "Seno hiperbólico inverso";
        FUNCTION_1_ARG_ARCOSH = "Cosseno hiperbólico inverso";
        FUNCTION_1_ARG_ARTANH = "Tangente hiperbólica inversa";
        FUNCTION_1_ARG_ARCOTH = "Cotangente hiperbólica inversa";
        FUNCTION_1_ARG_ARSECH = "Secante hiperbólica inversa";
        FUNCTION_1_ARG_ARCSCH = "Cosecante hiperbólica inversa";
        FUNCTION_1_ARG_SA = "Sinc (normalizado)";
        FUNCTION_1_ARG_SINC = "Sinc (não normalizado)";
        FUNCTION_1_ARG_BELL_NUMBER = "Número de Bell";
        FUNCTION_1_ARG_LUCAS_NUMBER = "Número de Lucas";
        FUNCTION_1_ARG_FIBONACCI_NUMBER = "Número de Fibonacci";
        FUNCTION_1_ARG_HARMONIC_NUMBER = "Número Harmônico";
        FUNCTION_1_ARG_IS_PRIME = "Teste de número primo (o número é primo?)";
        FUNCTION_1_ARG_PRIME_COUNT = "Contagem de primos";
        FUNCTION_1_ARG_EXP_INT = "Integral exponencial";
        FUNCTION_1_ARG_LOG_INT = "Integral logarítmica";
        FUNCTION_1_ARG_OFF_LOG_INT = "Integral logarítmica deslocada";
        FUNCTION_1_ARG_GAUSS_ERF = "Erro de Gauss";
        FUNCTION_1_ARG_GAUSS_ERFC = "Erro complementar de Gauss";
        FUNCTION_1_ARG_GAUSS_ERF_INV = "Erro inverso de Gauss";
        FUNCTION_1_ARG_GAUSS_ERFC_INV = "Erro complementar inverso de Gauss";
        FUNCTION_1_ARG_ULP = "Unidade no Último Lugar";
        FUNCTION_1_ARG_ISNAN = "Retorna verdadeiro se o valor for Not-a-Number (NaN), falso caso contrário";
        FUNCTION_1_ARG_NDIG10 = "Número de dígitos no sistema numeral de base 10";
        FUNCTION_1_ARG_NFACT = "Decomposição prima - número de fatores primos distintos";
        FUNCTION_1_ARG_ARCSEC = "Secante inversa trigonométrica";
        FUNCTION_1_ARG_ARCCSC = "Cosecante inversa trigonométrica";
        FUNCTION_1_ARG_GAMMA = "Gama";
        FUNCTION_1_ARG_LAMBERT_W0 = "Lambert-W, ramo principal 0, também chamado de logaritmo do produto ou ômega";
        FUNCTION_1_ARG_LAMBERT_W1 = "Lambert-W, ramo -1, também chamado de logaritmo do produto ou ômega";
        FUNCTION_1_ARG_SGN_GAMMA = "Signum de Gamma";
        FUNCTION_1_ARG_LOG_GAMMA = "Log Gamma";
        FUNCTION_1_ARG_DI_GAMMA = "Digamma como a derivada logarítmica do Gamma";
        FUNCTION_1_ARG_PARAM = "Função gerada automaticamente para funções definidas pelo usuário, retorna o valor do parâmetro da função no índice 'i'";
        // -------------------------------------------------
        FUNCTION_2_ARG_LOG = "Logaritmo";
        FUNCTION_2_ARG_MOD = "Módulo";
        FUNCTION_2_ARG_BINOM_COEFF = "Coeficiente binomial, número de combinações de k que podem ser tiradas de um conjunto de n elementos";
        FUNCTION_2_ARG_BERNOULLI_NUMBER = "Números de Bernoulli";
        FUNCTION_2_ARG_STIRLING1_NUMBER = "Números de Stirling do primeiro tipo";
        FUNCTION_2_ARG_STIRLING2_NUMBER = "Números de Stirling do segundo tipo";
        FUNCTION_2_ARG_WORPITZKY_NUMBER = "Número de Worpitzky";
        FUNCTION_2_ARG_EULER_NUMBER = "Número de Euler";
        FUNCTION_2_ARG_KRONECKER_DELTA = "Delta de Kronecker";
        FUNCTION_2_ARG_EULER_POLYNOMIAL = "Polinómio de Euler";
        FUNCTION_2_ARG_HARMONIC_NUMBER = "Número harmónico";
        FUNCTION_2_ARG_ROUND = "Arredondamento para cima";
        FUNCTION_2_ARG_NDIG = "Número de dígitos que representam o número no sistema numérico com base fornecida";
        FUNCTION_2_ARG_DIGIT10 = "Dígito na posição 1 ... n (esquerda -> direita) ou 0 ... -(n-1) (direita -> esquerda) - sistema numérico base 10";
        FUNCTION_2_ARG_FACTVAL = "Decomposição em fatores primos - valor do fator na posição entre 1 ... nfact(n) - ordem crescente pelo valor do fator";
        FUNCTION_2_ARG_FACTEXP = "Decomposição em fatores primos - expoente/multiplicidade do fator na posição entre 1 ... nfact(n) - ordem crescente pelo valor do fator";
        FUNCTION_2_ARG_ROOT = "Raiz de ordem N de um número";
        FUNCTION_2_ARG_INC_GAMMA_LOWER = "Gama incompleto inferior";
        FUNCTION_2_ARG_INC_GAMMA_UPPER = "Gama incompleto superior";
        FUNCTION_2_ARG_REG_GAMMA_LOWER = "Gama regularizado P inferior";
        FUNCTION_2_ARG_REG_GAMMA_UPPER = "Gama regularizado Q superior";
        FUNCTION_2_ARG_PERMUTATIONS = "Número de permutações de k que podem ser tiradas de um conjunto de n elementos";
        FUNCTION_2_ARG_BETA = "O Beta, também chamado de integral de Euler do primeiro tipo";
        FUNCTION_2_ARG_LOG_BETA = "O Log Beta, também chamado de integral logarítmica de Euler do primeiro tipo";
        // -------------------------------------------------
        FUNCTION_3_ARG_IF = "Se";
        FUNCTION_3_ARG_CHI = "Função característica para x em (a,b)";
        FUNCTION_3_ARG_CHI_LR = "Função característica para x em [a,b]";
        FUNCTION_3_ARG_CHI_L = "Função característica para x em [a,b)";
        FUNCTION_3_ARG_CHI_R = "Função característica para x em (a,b]";
        FUNCTION_3_ARG_DIGIT = "Dígito na posição 1 ... n (esquerda -> direita) ou 0 ... -(n-1) (direita -> esquerda) - sistema numérico com base fornecida";
        FUNCTION_3_ARG_INC_BETA = "O Beta incompleto, também chamado de integral de Euler incompleto do primeiro tipo";
        FUNCTION_3_ARG_REG_BETA = "O Beta incompleto regularizado (ou beta regularizado), também chamado de integral de Euler incompleto regularizado do primeiro tipo";
        // -------------------------------------------------
        FUNCTION_VARIADIC_IFF = "Função Se";
        FUNCTION_VARIADIC_MIN = "Mínimo";
        FUNCTION_VARIADIC_MAX = "Máximo";
        FUNCTION_VARIADIC_CONT_FRAC = "Fração contínua";
        FUNCTION_VARIADIC_CONT_POL = "Polinómio contínuo";
        FUNCTION_VARIADIC_GCD = "Maior divisor comum";
        FUNCTION_VARIADIC_LCM = "Mínimo múltiplo comum";
        FUNCTION_VARIADIC_SUM = "Soma";
        FUNCTION_VARIADIC_PROD = "Multiplicação";
        FUNCTION_VARIADIC_AVG = "Média";
        FUNCTION_VARIADIC_VAR = "Variância amostral corrigida";
        FUNCTION_VARIADIC_STD = "Desvio padrão amostral corrigido";
        FUNCTION_VARIADIC_RND_LIST = "Número aleatório de uma lista de números fornecida";
        FUNCTION_VARIADIC_COALESCE = "Retorna o primeiro valor não-NaN";
        FUNCTION_VARIADIC_OR = "Disjunção lógica (OR) - variadic";
        FUNCTION_VARIADIC_AND = "Conjunção lógica (AND) - variadic";
        FUNCTION_VARIADIC_XOR = "Ou exclusivo (XOR) - variadic";
        FUNCTION_VARIADIC_ARGMIN = "Argumentos / índices dos mínimos";
        FUNCTION_VARIADIC_ARGMAX = "Argumentos / índices dos máximos";
        FUNCTION_VARIADIC_MEDIAN = "A mediana da amostra";
        FUNCTION_VARIADIC_MODE = "Moda - o valor que aparece com mais frequência";
        FUNCTION_VARIADIC_BASE = "Retorna número no sistema numérico de base fornecida representado por lista de dígitos";
        FUNCTION_VARIADIC_NDIST = "Número de valores distintos";
        // -------------------------------------------------
        OPERATOR_PLUS = "Adição";
        OPERATOR_MINUS = "Subtração";
        OPERATOR_MULTIPLY = "Multiplicação";
        OPERATOR_DIVIDE = "Divisão";
        OPERATOR_DIVIDE_QUOTIENT = "Divisão inteira (quociente)";
        OPERATOR_POWER = "Exponenciação";
        OPERATOR_FACT = "Fatorial";
        OPERATOR_MOD = "Módulo";
        OPERATOR_PERC = "Percentagem";
        OPERATOR_TETRATION = "Tetração (hiper-4, torre de potência, torre exponencial)";
        OPERATOR_SQUARE_ROOT = "Raiz quadrada";
        OPERATOR_CUBE_ROOT = "Raiz cúbica";
        OPERATOR_FOURTH_ROOT = "Raiz quarta";
        // -------------------------------------------------
        PARSER_SYMBOL_LEFT_PARENTHESES = "Parênteses esquerdo";
        PARSER_SYMBOL_RIGHT_PARENTHESES = "Parênteses direito";
        PARSER_SYMBOL_COMMA = "Vírgula (parâmetros de função)";
        PARSER_SYMBOL_SEMI = "Ponto e vírgula (parâmetros de função)";
        PARSER_SYMBOL_BLANK = "Caractere em branco (espaço em branco)";
        PARSER_SYMBOL_NUMBER_INTEGER = "Inteiro";
        PARSER_SYMBOL_NUMBER_DECIMAL = "Decimal";
        PARSER_SYMBOL_NUMBER_LEADING_ZERO = "Zero à esquerda";
        PARSER_SYMBOL_NUMBER_SCI_NOTATION = "Notação científica";
        PARSER_SYMBOL_NUMBER_NO_LEADING_ZERO = "Sem zero à esquerda";
        PARSER_SYMBOL_NUMBER_FRACTIONS = "Frações";
        PARSER_SYMBOL_NUMBER_OTHER_NUMERAL_SYSTEMS = "Outros sistemas numéricos";
        PARSER_SYMBOL_UNICODE_MATH = " - Símbolo matemático Unicode";
        // -------------------------------------------------
        DIMENSIONLESS_UNIT_PERC = "Percentagem";
        DIMENSIONLESS_UNIT_PERM = "Por milha";
        DIMENSIONLESS_UNIT_YOTTA = "Septilião / Yotta";
        DIMENSIONLESS_UNIT_ZETTA = "Sextilião / Zetta";
        DIMENSIONLESS_UNIT_EXA = "Quintilião / Exa";
        DIMENSIONLESS_UNIT_PETA = "Quadrilião / Peta";
        DIMENSIONLESS_UNIT_TERA = "Trilião / Tera";
        DIMENSIONLESS_UNIT_GIGA = "Bilião / Giga";
        DIMENSIONLESS_UNIT_MEGA = "Milhão / Mega";
        DIMENSIONLESS_UNIT_KILO = "Mil / Kilo";
        DIMENSIONLESS_UNIT_HECTO = "Cem / Hecto";
        DIMENSIONLESS_UNIT_DECA = "Dez / Deca";
        DIMENSIONLESS_UNIT_DECI = "Décimo / Deci";
        DIMENSIONLESS_UNIT_CENTI = "Centésimo / Centi";
        DIMENSIONLESS_UNIT_MILLI = "Milésimo / Milli";
        DIMENSIONLESS_UNIT_MICRO = "Milionésimo / Micro";
        DIMENSIONLESS_UNIT_NANO = "Bilionésimo / Nano";
        DIMENSIONLESS_UNIT_PICO = "Trilionésimo / Pico";
        DIMENSIONLESS_UNIT_FEMTO = "Quadrilionésimo / Femto";
        DIMENSIONLESS_UNIT_ATTO = "Quintilionésimo / Atto";
        DIMENSIONLESS_UNIT_ZEPTO = "Sextilionésimo / Zepto";
        DIMENSIONLESS_UNIT_YOCTO = "Septilionésimo / Yocto";
        // -------------------------------------------------
        UNIT_METRE = "Metro";
        UNIT_KILOMETRE = "Quilômetro";
        UNIT_CENTIMETRE = "Centímetro";
        UNIT_MILLIMETRE = "Milímetro";
        UNIT_INCH = "Polegada";
        UNIT_YARD = "Jarda";
        UNIT_FEET = "Pé";
        UNIT_MILE = "Milha";
        UNIT_NAUTICAL_MILE = "Milha náutica";
        UNIT_METRE2 = "Metro quadrado";
        UNIT_CENTIMETRE2 = "Centímetro quadrado";
        UNIT_MILLIMETRE2 = "Milímetro quadrado";
        UNIT_ARE = "Are";
        UNIT_HECTARE = "Hectare";
        UNIT_ACRE = "Acre";
        UNIT_KILOMETRE2 = "Quilômetro quadrado";
        UNIT_MILLIMETRE3 = "Milímetro cúbico";
        UNIT_CENTIMETRE3 = "Centímetro cúbico";
        UNIT_METRE3 = "Metro cúbico";
        UNIT_KILOMETRE3 = "Quilômetro cúbico";
        UNIT_MILLILITRE = "Mililitro";
        UNIT_LITRE = "Litro";
        UNIT_GALLON = "Galão";
        UNIT_PINT = "Pinta";
        UNIT_SECOND = "Segundo";
        UNIT_MILLISECOND = "Milissegundo";
        UNIT_MINUTE = "Minuto";
        UNIT_HOUR = "Hora";
        UNIT_DAY = "Dia";
        UNIT_WEEK = "Semana";
        UNIT_JULIAN_YEAR = "Ano juliano = 365,25 dias";
        UNIT_KILOGRAM = "Quilograma";
        UNIT_GRAM = "Grama";
        UNIT_MILLIGRAM = "Miligrama";
        UNIT_DECAGRAM = "Decagrama";
        UNIT_TONNE = "Tonelada";
        UNIT_OUNCE = "Onça";
        UNIT_POUND = "Libra";
        UNIT_BIT = "Bit";
        UNIT_KILOBIT = "Quilobit";
        UNIT_MEGABIT = "Megabit";
        UNIT_GIGABIT = "Gigabit";
        UNIT_TERABIT = "Terabit";
        UNIT_PETABIT = "Petabit";
        UNIT_EXABIT = "Exabit";
        UNIT_ZETTABIT = "Zettabit";
        UNIT_YOTTABIT = "Yottabit";
        UNIT_BYTE = "Byte";
        UNIT_KILOBYTE = "Quilobyte";
        UNIT_MEGABYTE = "Megabyte";
        UNIT_GIGABYTE = "Gigabyte";
        UNIT_TERABYTE = "Terabyte";
        UNIT_PETABYTE = "Petabyte";
        UNIT_EXABYTE = "Exabyte";
        UNIT_ZETTABYTE = "Zettabyte";
        UNIT_YOTTABYTE = "Yottabyte";
        UNIT_JOULE = "Joule";
        UNIT_ELECTRONO_VOLT = "Eletronovolt";
        UNIT_KILO_ELECTRONO_VOLT = "Quiloeletronovolt";
        UNIT_MEGA_ELECTRONO_VOLT = "Megaeletronovolt";
        UNIT_GIGA_ELECTRONO_VOLT = "Gigaeletronovolt";
        UNIT_TERA_ELECTRONO_VOLT = "Teraeletronovolt";
        UNIT_METRE_PER_SECOND = "Metro por segundo";
        UNIT_KILOMETRE_PER_HOUR = "Quilômetro por hora";
        UNIT_MILE_PER_HOUR = "Milha por hora";
        UNIT_KNOT = "Nó";
        UNIT_METRE_PER_SECOND2 = "Metro por segundo quadrado";
        UNIT_KILOMETRE_PER_HOUR2 = "Quilômetro por hora quadrada";
        UNIT_MILE_PER_HOUR2 = "Milha por hora quadrada";
        UNIT_RADIAN_ARC = "Radiano";
        UNIT_DEGREE_ARC = "Grau de arco";
        UNIT_MINUTE_ARC = "Minuto de arco";
        UNIT_SECOND_ARC = "Segundo de arco";
    }
}