/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.exsim;

import javax.annotation.PostConstruct;
import org.marketcetera.marketdata.FeedStatus;
import org.marketcetera.marketdata.MarketDataStatus;
import org.marketcetera.marketdata.exsim.ExsimFeedModule;
import org.marketcetera.marketdata.exsim.Messages;
import org.marketcetera.marketdata.service.MarketDataService;
import org.marketcetera.module.Module;
import org.marketcetera.module.ModuleCreationException;
import org.marketcetera.module.ModuleFactory;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.util.log.I18NBoundMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExsimFeedModuleFactory
extends ModuleFactory {
    @Autowired
    private MarketDataService marketDataService;
    public static final String IDENTIFIER = "exsim";
    public static final ModuleURN PROVIDER_URN = new ModuleURN("metc:mdata:exsim");
    public static final ModuleURN INSTANCE_URN = new ModuleURN(PROVIDER_URN, "single");

    public ExsimFeedModuleFactory() {
        super(PROVIDER_URN, (I18NBoundMessage)Messages.PROVIDER_DESCRIPTION, false, false, new Class[0]);
    }

    public Module create(Object ... inParameters) throws ModuleCreationException {
        return new ExsimFeedModule(INSTANCE_URN);
    }

    @PostConstruct
    public void start() {
        this.marketDataService.reportMarketDataStatus(new MarketDataStatus(){

            public FeedStatus getFeedStatus() {
                return FeedStatus.OFFLINE;
            }

            public String getProvider() {
                return ExsimFeedModuleFactory.IDENTIFIER;
            }
        });
    }
}

