/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.rpc.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.marketcetera.admin.service.AuthorizationService;
import org.marketcetera.event.Event;
import org.marketcetera.marketdata.Capability;
import org.marketcetera.marketdata.Content;
import org.marketcetera.marketdata.MarketDataListener;
import org.marketcetera.marketdata.MarketDataPermissions;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.marketdata.MarketDataRequestBuilder;
import org.marketcetera.marketdata.MarketDataStatus;
import org.marketcetera.marketdata.MarketDataStatusListener;
import org.marketcetera.marketdata.core.rpc.MarketDataRpc;
import org.marketcetera.marketdata.core.rpc.MarketDataRpcServiceGrpc;
import org.marketcetera.marketdata.core.rpc.MarketDataTypesRpc;
import org.marketcetera.marketdata.rpc.MarketDataRpcUtil;
import org.marketcetera.marketdata.service.MarketDataService;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.persist.PageResponse;
import org.marketcetera.rpc.base.BaseRpc;
import org.marketcetera.rpc.base.BaseRpcUtil;
import org.marketcetera.rpc.paging.PagingRpc;
import org.marketcetera.rpc.paging.PagingRpcUtil;
import org.marketcetera.rpc.server.AbstractRpcService;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.rpc.TradeTypesRpc;
import org.marketcetera.trading.rpc.TradeRpcUtil;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.springframework.beans.factory.annotation.Autowired;

public class MarketDataRpcService<SessionClazz>
extends AbstractRpcService<SessionClazz, MarketDataRpcServiceGrpc.MarketDataRpcServiceImplBase> {
    @Autowired
    private MarketDataService marketDataService;
    @Autowired
    private AuthorizationService authzService;
    private Service service;
    private static final String description = "Marketdata RPC Service";
    private final Cache<String, BaseRpcUtil.AbstractServerListenerProxy<?>> listenerProxiesById = CacheBuilder.newBuilder().build();

    public void start() throws Exception {
        Validate.notNull((Object)this.marketDataService, (String)"Market data service required");
        this.service = new Service();
        super.start();
    }

    public MarketDataService getServiceAdapter() {
        return this.marketDataService;
    }

    public void setServiceAdapter(MarketDataService inMarketDataService) {
        this.marketDataService = inMarketDataService;
    }

    protected String getServiceDescription() {
        return description;
    }

    protected MarketDataRpcServiceGrpc.MarketDataRpcServiceImplBase getService() {
        return this.service;
    }

    private class MarketDataListenerProxy
    extends BaseRpcUtil.AbstractServerListenerProxy<MarketDataRpc.EventsResponse>
    implements MarketDataListener {
        private final String clientRequestId;
        private final MarketDataRpc.EventsResponse.Builder responseBuilder;

        public void receiveMarketData(Event inEvent) {
            try {
                MarketDataRpcUtil.getRpcEventHolder((Event)inEvent).ifPresent(value -> this.responseBuilder.setEvent(value));
                this.responseBuilder.setRequestId(this.clientRequestId);
                MarketDataRpc.EventsResponse response = this.responseBuilder.build();
                SLF4JLoggerProxy.trace(MarketDataRpcService.class, (String)"{} received event {}, sending {}", (Object[])new Object[]{this.getId(), inEvent, response});
                this.getObserver().onNext((Object)response);
                this.responseBuilder.clear();
            }
            catch (StatusRuntimeException e) {
                SLF4JLoggerProxy.info(MarketDataRpcService.class, (String)"Client disconnected, canceling market data listener: {}", (Object[])new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e)});
                MarketDataRpcService.this.marketDataService.cancel(this.getId());
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn(MarketDataRpcService.class, (Throwable)e, (String)"Unable to transmit market data to listener, closing client", (Object[])new Object[0]);
                MarketDataRpcService.this.marketDataService.cancel(this.getId());
            }
        }

        public void onError(String inMessage) {
            MarketDataTypesRpc.LogEvent.Builder logEventBuilder = MarketDataTypesRpc.LogEvent.newBuilder();
            logEventBuilder.setMessage(inMessage);
            logEventBuilder.setLogEventLevel(MarketDataTypesRpc.LogEventLevel.ERROR_LOG_EVENT_LEVEL);
            BaseRpcUtil.getRpcObject((Serializable)new RuntimeException(inMessage)).ifPresent(rpcObject -> logEventBuilder.setException(rpcObject));
            MarketDataTypesRpc.LogEvent rpcLogEvent = logEventBuilder.build();
            MarketDataTypesRpc.EventHolder.Builder eventHolderBuilder = MarketDataTypesRpc.EventHolder.newBuilder();
            eventHolderBuilder.setLogEvent(rpcLogEvent);
            MarketDataTypesRpc.EventHolder rpcEventHolder = eventHolderBuilder.build();
            this.responseBuilder.setEvent(rpcEventHolder);
            this.responseBuilder.setRequestId(this.clientRequestId);
            MarketDataRpc.EventsResponse response = this.responseBuilder.build();
            SLF4JLoggerProxy.trace(MarketDataRpcService.class, (String)"{} received error {}, sending {}", (Object[])new Object[]{this.getId(), inMessage, response});
            this.getObserver().onNext((Object)response);
            this.responseBuilder.clear();
        }

        private MarketDataListenerProxy(String inServerRequestId, String inClientRequestId, StreamObserver<MarketDataRpc.EventsResponse> inObserver) {
            super(inServerRequestId, inObserver);
            this.responseBuilder = MarketDataRpc.EventsResponse.newBuilder();
            this.clientRequestId = inClientRequestId;
        }
    }

    private class MarketDataStatusListenerProxy
    extends BaseRpcUtil.AbstractServerListenerProxy<MarketDataRpc.MarketDataStatusListenerResponse>
    implements MarketDataStatusListener {
        private final MarketDataRpc.MarketDataStatusListenerResponse.Builder responseBuilder;

        public void receiveMarketDataStatus(MarketDataStatus inMarketDataStatus) {
            try {
                MarketDataRpcUtil.getRpcMarketDataStatus((MarketDataStatus)inMarketDataStatus).ifPresent(value -> this.responseBuilder.setMarketDataStatus(value));
                MarketDataRpc.MarketDataStatusListenerResponse response = this.responseBuilder.build();
                SLF4JLoggerProxy.trace(MarketDataRpcService.class, (String)"{} received market data status {}, sending {}", (Object[])new Object[]{this.getId(), inMarketDataStatus, response});
                this.getObserver().onNext((Object)response);
                this.responseBuilder.clear();
            }
            catch (StatusRuntimeException e) {
                SLF4JLoggerProxy.info(MarketDataRpcService.class, (String)"Client disconnected, canceling market data listener: {}", (Object[])new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e)});
                MarketDataRpcService.this.marketDataService.removeMarketDataStatusListener((MarketDataStatusListener)this);
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn(MarketDataRpcService.class, (Throwable)e, (String)"Unable to transmit market data to listener, closing client", (Object[])new Object[0]);
                MarketDataRpcService.this.marketDataService.removeMarketDataStatusListener((MarketDataStatusListener)this);
            }
        }

        private MarketDataStatusListenerProxy(String inId, StreamObserver<MarketDataRpc.MarketDataStatusListenerResponse> inObserver) {
            super(inId, inObserver);
            this.responseBuilder = MarketDataRpc.MarketDataStatusListenerResponse.newBuilder();
        }
    }

    private class Service
    extends MarketDataRpcServiceGrpc.MarketDataRpcServiceImplBase {
        private Service() {
        }

        public void login(BaseRpc.LoginRequest inRequest, StreamObserver<BaseRpc.LoginResponse> inResponseObserver) {
            MarketDataRpcService.this.doLogin(inRequest, inResponseObserver);
        }

        public void logout(BaseRpc.LogoutRequest inRequest, StreamObserver<BaseRpc.LogoutResponse> inResponseObserver) {
            MarketDataRpcService.this.doLogout(inRequest, inResponseObserver);
        }

        public void heartbeat(BaseRpc.HeartbeatRequest inRequest, StreamObserver<BaseRpc.HeartbeatResponse> inResponseObserver) {
            MarketDataRpcService.this.doHeartbeat(inRequest, inResponseObserver);
        }

        public void request(MarketDataRpc.MarketDataRequest inRequest, StreamObserver<MarketDataRpc.EventsResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = MarketDataRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)MarketDataRpcService.this), (String)"Received market data request {}", (Object[])new Object[]{inRequest});
                MarketDataRpcService.this.authzService.authorize(sessionHolder.getUser(), MarketDataPermissions.RequestMarketDataAction.name());
                MarketDataRequest request = MarketDataRequestBuilder.newRequestFromString((String)inRequest.getRequest());
                String clientRequestId = request.getRequestId();
                String serverRequestId = this.buildRequestId(inRequest.getSessionId(), clientRequestId);
                BaseRpcUtil.AbstractServerListenerProxy marketDataListenerProxy = (BaseRpcUtil.AbstractServerListenerProxy)MarketDataRpcService.this.listenerProxiesById.getIfPresent((Object)serverRequestId);
                if (marketDataListenerProxy != null) {
                    throw new IllegalArgumentException("Duplicate market data request id: " + clientRequestId);
                }
                marketDataListenerProxy = new MarketDataListenerProxy(serverRequestId, clientRequestId, inResponseObserver);
                MarketDataRpcService.this.listenerProxiesById.put((Object)serverRequestId, (Object)marketDataListenerProxy);
                MarketDataListener listenerProxy = (MarketDataListener)marketDataListenerProxy;
                MarketDataRpcUtil.getMarketDataRequest((String)inRequest.getRequest(), (String)serverRequestId, (String)clientRequestId).ifPresent(value -> MarketDataRpcService.this.marketDataService.request(value, listenerProxy));
            }
            catch (Exception e) {
                MarketDataRpcService.this.handleError(e, inResponseObserver);
                inResponseObserver.onCompleted();
            }
        }

        public void cancel(MarketDataRpc.CancelRequest inRequest, StreamObserver<MarketDataRpc.CancelResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = MarketDataRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)MarketDataRpcService.this), (String)"Received market data cancel request {}", (Object[])new Object[]{inRequest});
                MarketDataRpcService.this.authzService.authorize(sessionHolder.getUser(), MarketDataPermissions.RequestMarketDataAction.name());
                MarketDataRpc.CancelResponse.Builder responseBuilder = MarketDataRpc.CancelResponse.newBuilder();
                String clientRequestId = inRequest.getRequestId();
                String serverRequestId = this.buildRequestId(inRequest.getSessionId(), clientRequestId);
                BaseRpcUtil.AbstractServerListenerProxy marketDataListenerProxy = (BaseRpcUtil.AbstractServerListenerProxy)MarketDataRpcService.this.listenerProxiesById.getIfPresent((Object)serverRequestId);
                if (marketDataListenerProxy == null) {
                    throw new IllegalArgumentException("Unknown market data request id: " + clientRequestId);
                }
                MarketDataRpcService.this.listenerProxiesById.invalidate((Object)serverRequestId);
                MarketDataRpcService.this.marketDataService.cancel(serverRequestId);
                if (marketDataListenerProxy != null) {
                    marketDataListenerProxy.close();
                }
                MarketDataRpc.CancelResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)MarketDataRpcService.this), (String)"Sending response: {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                MarketDataRpcService.this.handleError(e, inResponseObserver);
                inResponseObserver.onCompleted();
            }
        }

        public void getSnapshot(MarketDataRpc.SnapshotRequest inRequest, StreamObserver<MarketDataRpc.SnapshotResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = MarketDataRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)MarketDataRpcService.this), (String)"Received snapshot request {}", (Object[])new Object[]{inRequest});
                MarketDataRpcService.this.authzService.authorize(sessionHolder.getUser(), MarketDataPermissions.RequestMarketDataSnapshotAction.name());
                MarketDataRpc.SnapshotResponse.Builder responseBuilder = MarketDataRpc.SnapshotResponse.newBuilder();
                Instrument instrument = TradeRpcUtil.getInstrument((TradeTypesRpc.Instrument)inRequest.getInstrument()).orElse(null);
                Content content = MarketDataRpcUtil.getContent((MarketDataTypesRpc.ContentAndCapability)inRequest.getContent());
                PageRequest pageRequest = inRequest.hasPage() ? PagingRpcUtil.getPageRequest((PagingRpc.PageRequest)inRequest.getPage()) : PageRequest.ALL;
                CollectionPageResponse eventPage = MarketDataRpcService.this.marketDataService.getSnapshot(instrument, content, pageRequest);
                eventPage.getElements().forEach(value -> MarketDataRpcUtil.getRpcEventHolder((Event)value).ifPresent(innerValue -> responseBuilder.addEvent(innerValue)));
                responseBuilder.setPageResponse(PagingRpcUtil.getPageResponse((PageRequest)pageRequest, (PageResponse)eventPage));
                MarketDataRpc.SnapshotResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)MarketDataRpcService.this), (String)"Sending response: {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                MarketDataRpcService.this.handleError(e, inResponseObserver);
                inResponseObserver.onCompleted();
            }
        }

        public void getAvailableCapability(MarketDataRpc.AvailableCapabilityRequest inRequest, StreamObserver<MarketDataRpc.AvailableCapabilityResponse> inResponseObserver) {
            try {
                MarketDataRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)MarketDataRpcService.this), (String)"Received available capability request {}", (Object[])new Object[]{inRequest});
                MarketDataRpc.AvailableCapabilityResponse.Builder responseBuilder = MarketDataRpc.AvailableCapabilityResponse.newBuilder();
                Set capabilities = MarketDataRpcService.this.marketDataService.getAvailableCapability();
                for (Capability capability : capabilities) {
                    responseBuilder.addCapability(MarketDataTypesRpc.ContentAndCapability.valueOf((String)capability.name()));
                }
                MarketDataRpc.AvailableCapabilityResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)MarketDataRpcService.this), (String)"Sending response: {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                MarketDataRpcService.this.handleError(e, inResponseObserver);
                inResponseObserver.onCompleted();
            }
        }

        public void getMarketDataProviders(MarketDataRpc.GetMarketDataProvidersRequest inRequest, StreamObserver<MarketDataRpc.GetMarketDataProvidersResponse> inResponseObserver) {
            try {
                MarketDataRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)MarketDataRpcService.this), (String)"Received market data providers request {}", (Object[])new Object[]{inRequest});
                MarketDataRpc.GetMarketDataProvidersResponse.Builder responseBuilder = MarketDataRpc.GetMarketDataProvidersResponse.newBuilder();
                Set providers = MarketDataRpcService.this.marketDataService.getProviders();
                providers.forEach(provider -> responseBuilder.addProvider(provider));
                MarketDataRpc.GetMarketDataProvidersResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)MarketDataRpcService.this), (String)"Sending response: {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                MarketDataRpcService.this.handleError(e, inResponseObserver);
                inResponseObserver.onCompleted();
            }
        }

        public void addMarketDataStatusListener(MarketDataRpc.AddMarketDataStatusListenerRequest inRequest, StreamObserver<MarketDataRpc.MarketDataStatusListenerResponse> inResponseObserver) {
            try {
                MarketDataRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)MarketDataRpcService.this), (String)"Received add market data status listener request {}", (Object[])new Object[]{inRequest});
                String listenerId = inRequest.getListenerId();
                BaseRpcUtil.AbstractServerListenerProxy marketDataStatusListenerProxy = (BaseRpcUtil.AbstractServerListenerProxy)MarketDataRpcService.this.listenerProxiesById.getIfPresent((Object)listenerId);
                if (marketDataStatusListenerProxy == null) {
                    marketDataStatusListenerProxy = new MarketDataStatusListenerProxy(listenerId, inResponseObserver);
                    MarketDataRpcService.this.listenerProxiesById.put((Object)marketDataStatusListenerProxy.getId(), (Object)marketDataStatusListenerProxy);
                    MarketDataRpcService.this.marketDataService.addMarketDataStatusListener((MarketDataStatusListener)marketDataStatusListenerProxy);
                }
            }
            catch (Exception e) {
                MarketDataRpcService.this.handleError(e, inResponseObserver);
                inResponseObserver.onCompleted();
            }
        }

        public void removeMarketDataStatusListener(MarketDataRpc.RemoveMarketDataStatusListenerRequest inRequest, StreamObserver<MarketDataRpc.RemoveMarketDataStatusListenerResponse> inResponseObserver) {
            try {
                MarketDataRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)MarketDataRpcService.this), (String)"Received market data status listener request {}", (Object[])new Object[]{inRequest});
                String listenerId = inRequest.getListenerId();
                BaseRpcUtil.AbstractServerListenerProxy marketDataStatusListenerProxy = (BaseRpcUtil.AbstractServerListenerProxy)MarketDataRpcService.this.listenerProxiesById.getIfPresent((Object)listenerId);
                MarketDataRpcService.this.listenerProxiesById.invalidate((Object)listenerId);
                if (marketDataStatusListenerProxy != null) {
                    MarketDataRpcService.this.marketDataService.removeMarketDataStatusListener((MarketDataStatusListener)marketDataStatusListenerProxy);
                    marketDataStatusListenerProxy.close();
                }
                MarketDataRpc.RemoveMarketDataStatusListenerResponse.Builder responseBuilder = MarketDataRpc.RemoveMarketDataStatusListenerResponse.newBuilder();
                MarketDataRpc.RemoveMarketDataStatusListenerResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)MarketDataRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                MarketDataRpcService.this.handleError(e, inResponseObserver);
                inResponseObserver.onCompleted();
            }
        }

        private String buildRequestId(String inSessionId, String inRequestId) {
            return "sessionId->" + inSessionId + "/requestId->" + inRequestId;
        }
    }
}

