/*
 * Decompiled with CFR 0.152.
 */
package org.mayanjun.util;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mayanjun.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AES {
    private static final Logger LOG = LoggerFactory.getLogger(AES.class);

    private AES() {
    }

    public static byte[] encrypt(byte[] content, byte[] iv, byte[] key) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(1, (Key)keySpec, ivSpec);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            LOG.error("AES encrypt error:", (Throwable)e);
            return null;
        }
    }

    public static byte[] decrypt(byte[] content, byte[] iv, byte[] key) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(2, (Key)keySpec, ivSpec);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            LOG.error("AES decrypt error:", (Throwable)e);
            return null;
        }
    }

    public static String encrypt(String content, String iv, String key) {
        return Base64.encodeBase64String((byte[])AES.encrypt(Base64.decodeBase64((String)content), Base64.decodeBase64((String)iv), Base64.decodeBase64((String)key)));
    }

    public static byte[] decrypt(String content, String iv, String key) {
        return AES.decrypt(Base64.decodeBase64((String)content), Base64.decodeBase64((String)iv), Base64.decodeBase64((String)key));
    }

    public static String encrypt(String content, String iv, SecretKey key) {
        return Base64.encodeBase64String((byte[])AES.encrypt(Base64.decodeBase64((String)content), Base64.decodeBase64((String)iv), key.getEncoded()));
    }

    public static byte[] decrypt(String content, String iv, SecretKey key) {
        return AES.decrypt(Base64.decodeBase64((String)content), Base64.decodeBase64((String)iv), key.getEncoded());
    }

    public static String encryptString(String content, byte[] iv, SecretKey key) {
        try {
            return Base64.encodeBase64String((byte[])AES.encrypt(content.getBytes("UTF-8"), iv, key.getEncoded()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String decryptString(String content, byte[] iv, SecretKey key) {
        try {
            byte[] bs = AES.decrypt(Base64.decodeBase64((String)content), iv, key.getEncoded());
            return new String(bs, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String encryptString(String content, byte[] iv, byte[] key) {
        try {
            return Base64.encodeBase64String((byte[])AES.encrypt(content.getBytes("UTF-8"), iv, key));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String decryptString(String content, byte[] iv, byte[] key) {
        try {
            byte[] bs = AES.decrypt(Base64.decodeBase64((String)content), iv, key);
            return new String(bs, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static SecretKey generateKey(String secretKey) throws Exception {
        Provider p = Security.getProvider("SUN");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", p);
        secureRandom.setSeed(secretKey.getBytes());
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(256, secureRandom);
        return kg.generateKey();
    }

    public static byte[] generateIV() {
        return Strings.random(16).getBytes();
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

