/*
 * Decompiled with CFR 0.152.
 */
package org.mayanjun.util;

import org.mayanjun.core.Assert;
import org.mayanjun.core.Parser;
import org.mayanjun.core.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParser<I, O>
implements Parser<I, O> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractParser.class);

    public O parse(I input) throws ServiceException {
        try {
            this.validate(input);
            return this.doParse(input);
        }
        catch (ServiceException e) {
            LOG.error("{} parse error: input={}, code={}, message={}", new Object[]{this.getClass().getCanonicalName(), input, e.getStatus().getCode(), e.getStatus().getMessage()});
            throw e;
        }
        catch (Exception e) {
            LOG.error(this.getClass().getCanonicalName() + " parse error, input=" + input, (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    protected void validate(I input) {
        Assert.notNull(input, (String)"input can not be null");
    }

    protected abstract O doParse(I var1);
}

