/*
 * Decompiled with CFR 0.152.
 */
package org.mayanjun.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.mayanjun.core.Assert;
import org.mayanjun.core.Message;
import org.mayanjun.core.ServiceException;
import org.mayanjun.core.Status;
import org.mayanjun.util.AbstractParser;
import org.mayanjun.util.Strings;

public class ChineseIDCardParser
extends AbstractParser<String, IDCard> {
    public static Status CODE_NUMBER_EMPTY = new Status(2018001, "\u8eab\u4efd\u8bc1\u53f7\u4e3a\u7a7a");
    public static Status CODE_NUMBER_ERROR = new Status(2018002, "\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef");
    public static Status CODE_BIRTHDATE_ERROR = new Status(2018003, "\u51fa\u751f\u65e5\u671f\u9519\u8bef");
    public static Status CODE_PROVINCE_ERROR = new Status(2018004, "\u5730\u533a\u7f16\u7801\u9519\u8bef");
    public static Status CODE_CHECKSUM_ERROR = new Status(2018005, "\u8eab\u4efd\u8bc1\u65e0\u6548\uff0c\u6700\u540e\u4e00\u4f4d\u9519\u8bef");
    private static Map<String, String> PROVINCE_CODES = new HashMap<String, String>();
    private static String[] VAL_CODES = new String[]{"1", "0", "x", "9", "8", "7", "6", "5", "4", "3", "2"};
    private static int[] CHECK_SUM_CODE = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static String[] PROVINCE_CODES_ARR = new String[]{"11", "\u5317\u4eac", "12", "\u5929\u6d25", "13", "\u6cb3\u5317", "14", "\u5c71\u897f", "15", "\u5185\u8499\u53e4", "21", "\u8fbd\u5b81", "22", "\u5409\u6797", "23", "\u9ed1\u9f99\u6c5f", "31", "\u4e0a\u6d77", "32", "\u6c5f\u82cf", "33", "\u6d59\u6c5f", "34", "\u5b89\u5fbd", "35", "\u798f\u5efa", "36", "\u6c5f\u897f", "37", "\u5c71\u4e1c", "41", "\u6cb3\u5357", "42", "\u6e56\u5317", "43", "\u6e56\u5357", "44", "\u5e7f\u4e1c", "45", "\u5e7f\u897f", "46", "\u6d77\u5357", "50", "\u91cd\u5e86", "51", "\u56db\u5ddd", "52", "\u8d35\u5dde", "53", "\u4e91\u5357", "54", "\u897f\u85cf", "61", "\u9655\u897f", "62", "\u7518\u8083", "63", "\u9752\u6d77", "64", "\u5b81\u590f", "65", "\u65b0\u7586", "71", "\u53f0\u6e7e", "81", "\u9999\u6e2f", "82", "\u6fb3\u95e8", "91", "\u56fd\u5916"};

    @Override
    protected IDCard doParse(String input) {
        DateTime birthdate;
        int generation;
        String ai;
        String id = input;
        Assert.notBlank((CharSequence)id, (Status)CODE_NUMBER_EMPTY);
        id = id.replaceAll(" ", "").toLowerCase();
        if (id.length() == 18) {
            ai = id.substring(0, 17);
            generation = 2;
        } else if (id.length() == 15) {
            ai = id.substring(0, 6) + "19" + id.substring(6, 15);
            generation = 1;
        } else {
            throw new ServiceException(CODE_NUMBER_ERROR, "\u53f7\u7801\u957f\u5ea6\u5e94\u8be5\u4e3a15\u4f4d\u621618\u4f4d,\u60a8\u7684\u8eab\u4efd\u8bc1\u53f7\u7801\u4e3a" + id.length() + "\u4f4d");
        }
        Assert.isTrue((boolean)Strings.isNumeric(ai), (Status)CODE_NUMBER_ERROR, (String)"15\u4f4d\u53f7\u7801\u90fd\u5e94\u4e3a\u6570\u5b57; 18\u4f4d\u53f7\u7801\u9664\u6700\u540e\u4e00\u4f4d\u5916\uff0c\u90fd\u5e94\u4e3a\u6570\u5b57");
        String birthdateString = ai.substring(6, 14);
        try {
            birthdate = DateTime.parse((String)birthdateString, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyyMMdd").withZone(DateTimeZone.forOffsetHours((int)8)));
        }
        catch (Exception e) {
            throw new ServiceException(CODE_BIRTHDATE_ERROR);
        }
        Assert.notNull((Object)PROVINCE_CODES.get(ai.substring(0, 2)), (Status)CODE_PROVINCE_ERROR);
        int checkSum = 0;
        for (int i = 0; i < 17; ++i) {
            checkSum += Integer.parseInt(String.valueOf(ai.charAt(i))) * CHECK_SUM_CODE[i];
        }
        String strVerifyCode = VAL_CODES[checkSum % 11];
        ai = ai + strVerifyCode;
        Assert.isTrue((boolean)ai.equals(id), (Status)CODE_CHECKSUM_ERROR);
        String provinceCode = ai.substring(0, 2).toString();
        String province = PROVINCE_CODES.get(provinceCode);
        Character sexInfo = Character.valueOf(id.charAt(id.length() - 2));
        int sexInt = Integer.parseInt(sexInfo.toString());
        Gender gender = sexInt % 2 == 0 ? Gender.FEMALE : Gender.MALE;
        return new IDCard(id, gender, province, provinceCode, generation, birthdate.toDate(), ai);
    }

    static {
        for (int i = 0; i < PROVINCE_CODES_ARR.length; i += 2) {
            PROVINCE_CODES.put(PROVINCE_CODES_ARR[i], PROVINCE_CODES_ARR[i + 1]);
        }
    }

    public static enum Gender {
        UNKNOWN,
        MALE,
        FEMALE;

    }

    public static class IDCard
    extends Message {
        private String number;
        private Gender gender;
        private String province;
        private String provinceCode;
        private int generation;
        private Date birthdate;
        private String number2;

        public IDCard() {
            super(Status.OK.getCode(), "OK");
        }

        public IDCard(int code) {
            super(code, "");
        }

        public IDCard(String number, Gender gender, String province, String provinceCode, int generation, Date birthdate, String number2) {
            super(Status.OK.getCode(), "OK");
            this.number = number;
            this.gender = gender;
            this.province = province;
            this.provinceCode = provinceCode;
            this.generation = generation;
            this.birthdate = birthdate;
            this.number2 = number2;
        }

        public String getIDCardNumber() {
            return this.number;
        }

        public String getProvince() {
            return this.province;
        }

        public String getProvinceCode() {
            return this.provinceCode;
        }

        public int getGeneration() {
            return this.generation;
        }

        public Date getBirthdate() {
            return this.birthdate;
        }

        public String getNumber2() {
            return this.number2;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public void setProvinceCode(String provinceCode) {
            this.provinceCode = provinceCode;
        }

        public void setGeneration(int generation) {
            this.generation = generation;
        }

        public void setBirthdate(Date birthdate) {
            this.birthdate = birthdate;
        }

        public void setNumber2(String number2) {
            this.number2 = number2;
        }

        public Gender getGender() {
            return this.gender;
        }

        public void setGender(Gender gender) {
            this.gender = gender;
        }

        public String toString() {
            return "IDCard{number='" + this.number + '\'' + ", gender=" + (Object)((Object)this.gender) + ", province='" + this.province + '\'' + ", provinceCode='" + this.provinceCode + '\'' + ", generation=" + this.generation + ", birthdate=" + this.birthdate + ", number2='" + this.number2 + '\'' + '}';
        }
    }
}

