/*
 * Decompiled with CFR 0.152.
 */
package org.mayanjun.util;

import java.util.HashMap;
import java.util.Map;
import org.mayanjun.core.Assert;
import org.mayanjun.core.Message;
import org.mayanjun.core.ServiceException;
import org.mayanjun.util.AbstractParser;

public class ChinesePhoneNumberParser
extends AbstractParser<String, PhoneNumber> {
    private int mobileNumberLength = 11;

    @Override
    protected PhoneNumber doParse(String input) {
        char[] cs = input.toCharArray();
        PhoneNumber number = new PhoneNumber(input);
        char cs0 = cs[0];
        switch (cs0) {
            case '0': {
                number.setOperator(MobileOperator.CHINA_TELECOM);
                this.parseRegionNumber(number, cs);
                break;
            }
            case '1': {
                this.validateMobileNumber(cs);
                number.setOperator(MobileOperator.getMobileOperator(String.valueOf(cs, 0, 3)));
            }
        }
        return number;
    }

    private void validateMobileNumber(char[] cs) {
        Assert.isTrue((cs.length == this.mobileNumberLength ? 1 : 0) != 0, (String)("\u624b\u673a\u53f7\u7801\u957f\u5ea6\u5fc5\u987b\u662f" + this.mobileNumberLength + "\u4f4d"));
        for (char c : cs) {
            if (Character.isWhitespace(c) || Character.isDigit(c)) continue;
            throw new ServiceException("\u53f7\u7801\u4e2d\u542b\u6709\u975e\u6570\u5b57\u5b57\u7b26");
        }
    }

    private void parseRegionNumber(PhoneNumber number, char[] cs) {
        StringBuffer rn = new StringBuffer();
        StringBuffer pn = new StringBuffer();
        boolean numberBegin = false;
        for (char c : cs) {
            if (Character.isDigit(c)) {
                if (numberBegin) {
                    pn.append(c);
                    continue;
                }
                rn.append(c);
                continue;
            }
            numberBegin = true;
        }
        number.setRegionNumber(rn.toString());
        number.setPhoneNumber(pn.toString());
    }

    public int getMobileNumberLength() {
        return this.mobileNumberLength;
    }

    public void setMobileNumberLength(int mobileNumberLength) {
        this.mobileNumberLength = mobileNumberLength;
    }

    public static final class MobileOperator
    extends Enum<MobileOperator> {
        public static final /* enum */ MobileOperator UNKNOWN;
        public static final /* enum */ MobileOperator CHINA_UNICOME;
        public static final /* enum */ MobileOperator CHINA_TELECOM;
        public static final /* enum */ MobileOperator CMCC;
        private static Map<String, MobileOperator> OPERATORS_INDEX;
        private String[] numberPrefixes;
        private static final /* synthetic */ MobileOperator[] $VALUES;

        public static MobileOperator[] values() {
            return (MobileOperator[])$VALUES.clone();
        }

        public static MobileOperator valueOf(String name) {
            return Enum.valueOf(MobileOperator.class, name);
        }

        public static MobileOperator getMobileOperator(String number) {
            MobileOperator operator;
            String num = number;
            if (num.length() > 3) {
                num = num.substring(0, 3);
            }
            if ((operator = OPERATORS_INDEX.get(num)) != null) {
                return operator;
            }
            return UNKNOWN;
        }

        private MobileOperator(String ... numberPrefixes) {
            this.numberPrefixes = numberPrefixes;
        }

        public String[] getNumberPrefixes() {
            return this.numberPrefixes;
        }

        static {
            MobileOperator[] operators;
            UNKNOWN = new MobileOperator(new String[0]);
            CHINA_UNICOME = new MobileOperator("130", "131", "132", "155", "156", "185", "186");
            CHINA_TELECOM = new MobileOperator("133", "153", "180", "189");
            CMCC = new MobileOperator("134", "135", "136", "137", "138", "139", "147", "150", "151", "152", "157", "158", "159", "187", "188");
            $VALUES = new MobileOperator[]{UNKNOWN, CHINA_UNICOME, CHINA_TELECOM, CMCC};
            OPERATORS_INDEX = new HashMap<String, MobileOperator>();
            for (MobileOperator mo : operators = MobileOperator.values()) {
                for (String p : mo.numberPrefixes) {
                    OPERATORS_INDEX.put(p, mo);
                }
            }
        }
    }

    public static class PhoneNumber
    extends Message {
        private String number;
        private MobileOperator operator;
        private String regionNumber;
        private String phoneNumber;

        public PhoneNumber(String number) {
            this.number = number;
        }

        public PhoneNumber(int code, String description, Throwable exception) {
            super(code, description, exception);
        }

        public PhoneNumber(int code, String description) {
            super(code, description);
        }

        public PhoneNumber() {
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public MobileOperator getOperator() {
            return this.operator;
        }

        public void setOperator(MobileOperator operator) {
            this.operator = operator;
        }

        public String getRegionNumber() {
            return this.regionNumber;
        }

        public void setRegionNumber(String regionNumber) {
            this.regionNumber = regionNumber;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public String toString() {
            return "PhoneNumber{number='" + this.number + '\'' + ", operator=" + (Object)((Object)this.operator) + ", regionNumber='" + this.regionNumber + '\'' + ", phoneNumber='" + this.phoneNumber + '\'' + '}';
        }
    }
}

