/*
 * Decompiled with CFR 0.152.
 */
package org.mayanjun.util;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.mayanjun.core.Assert;
import org.mayanjun.core.ServiceException;
import org.mayanjun.util.KeyPairStore;

public class Encryptions {
    public static String SIGN_ALGORITHMS = "SHA512withRSA";

    private Encryptions() {
    }

    public static String sign(String source, KeyPairStore store) {
        return Encryptions.sign(source, store, SIGN_ALGORITHMS);
    }

    public static String sign(String source, KeyPairStore store, String signAlg) {
        Assert.notNull((Object)source, (String)"\u7b7e\u540d\u5931\u8d25:\u65e0\u6cd5\u5bf9\u7a7a\u5185\u5bb9\u8fdb\u884c\u7b7e\u540d");
        try {
            Signature signature = Signature.getInstance(signAlg);
            signature.initSign(store.getPrivateKey());
            byte[] bytes = source.getBytes();
            signature.update(bytes);
            byte[] result = signature.sign();
            return Base64.encodeBase64String((byte[])result);
        }
        catch (Exception e) {
            throw new ServiceException("\u7b7e\u540d\u5931\u8d25");
        }
    }

    public static boolean verify(String signature, String plain, KeyPairStore store) {
        return Encryptions.verify(signature, plain, store.getPublicKey());
    }

    public static boolean verify(String signature, String plain, PublicKey key) {
        return Encryptions.verify(signature, plain, key, SIGN_ALGORITHMS);
    }

    public static boolean verify(String signature, String plain, PublicKey key, String alg) {
        Assert.notNull((Object)signature, (String)"\u9a8c\u8bc1\u5931\u8d25:\u7b7e\u540d\u9519\u8bef");
        Assert.notNull((Object)plain, (String)"\u9a8c\u8bc1\u5931\u8d25:\u7b7e\u540d\u9519\u8bef");
        try {
            Signature s = Signature.getInstance(alg);
            s.initVerify(key);
            s.update(plain.getBytes());
            byte[] bytes = Base64.decodeBase64((String)signature);
            return s.verify(bytes);
        }
        catch (Exception e) {
            throw new ServiceException("\u9a8c\u8bc1\u5931\u8d25:\u7b7e\u540d\u9519\u8bef");
        }
    }

    public static String encrypt(String plain, Key key) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, key);
            byte[] ret = cipher.doFinal(plain.getBytes());
            return Base64.encodeBase64String((byte[])ret);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String decrypt(String signature, Key key) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, key);
            byte[] bytes = Base64.decodeBase64((String)signature);
            byte[] ret = cipher.doFinal(bytes);
            return new String(ret);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encrypt(String plain, KeyPairStore store) {
        return Encryptions.encrypt(plain, store.getPublicKey());
    }

    public static String decrypt(String signature, KeyPairStore store) {
        return Encryptions.decrypt(signature, store.getPrivateKey());
    }

    public static KeyPairStore generateKeys() {
        KeyPairGenerator keygen = null;
        try {
            keygen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        SecureRandom random = new SecureRandom();
        keygen.initialize(1024, random);
        KeyPair kp = keygen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)kp.getPrivate();
        String privateKeyString = Base64.encodeBase64String((byte[])privateKey.getEncoded());
        RSAPublicKey publicKey = (RSAPublicKey)kp.getPublic();
        String publicKeyString = Base64.encodeBase64String((byte[])publicKey.getEncoded());
        System.out.println("PrivateKey:" + privateKeyString);
        System.out.println("PublicKey:" + publicKeyString);
        return new KeyPairStore(privateKeyString, publicKeyString);
    }
}

