/*
 * Decompiled with CFR 0.152.
 */
package org.mayanjun.util;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class KeyPairStore {
    private String privateKeyString;
    private String publicKeyString;
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public KeyPairStore(String privateKeyString, String publicKeyString) {
        this.privateKeyString = privateKeyString;
        this.publicKeyString = publicKeyString;
        this.init();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public KeyPairStore(PrivateKey privateKey, PublicKey publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    private void init() {
        this.privateKey = KeyPairStore.createPrivateKey(this.privateKeyString);
        this.publicKey = KeyPairStore.createPublicKey(this.publicKeyString);
    }

    public PrivateKey createPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKeyString() {
        return this.privateKeyString;
    }

    public void setPrivateKeyString(String privateKeyString) {
        this.privateKeyString = privateKeyString;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public String getPublicKeyString() {
        return this.publicKeyString;
    }

    public void setPublicKeyString(String publicKeyString) {
        this.publicKeyString = publicKeyString;
    }

    public static PrivateKey createPrivateKey(String privateKeyString) {
        try {
            byte[] encodedKey = Base64.decodeBase64((String)privateKeyString);
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(encodedKey);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(spec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PublicKey createPublicKey(String publicKeyString) {
        try {
            byte[] encodedKey = Base64.decodeBase64((String)publicKeyString);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedKey);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(spec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

