/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.util;

import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceBundleRegistry {
    private static volatile ResourceBundleRegistry singleton = null;
    private Locale locale;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ResourceBundleRegistry getInstance() {
        ResourceBundleRegistry avoidAcess = singleton;
        if (avoidAcess != null) return avoidAcess;
        Class<ResourceBundleRegistry> clazz = ResourceBundleRegistry.class;
        synchronized (ResourceBundleRegistry.class) {
            avoidAcess = singleton;
            if (avoidAcess != null) return avoidAcess;
            singleton = new ResourceBundleRegistry();
            return singleton;
        }
    }

    public static String getString(String resourceBundle, String key) {
        ResourceBundleRegistry registry = ResourceBundleRegistry.getInstance();
        ResourceBundle bundle = registry.getResourceBundle(resourceBundle);
        return bundle.getString(key);
    }

    private ResourceBundleRegistry() {
        this(null);
    }

    private ResourceBundleRegistry(Locale locale) {
        this.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        if (this.locale.equals(locale)) {
            return;
        }
        ResourceBundleRegistry resourceBundleRegistry = this;
        synchronized (resourceBundleRegistry) {
            this.locale = locale;
        }
    }

    public ResourceBundle getResourceBundle(String name) {
        return this.locale == null ? ResourceBundle.getBundle(name) : ResourceBundle.getBundle(name, this.locale);
    }
}

