/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.util;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlUtil {
    public static String getVersion() {
        String output = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        output = output + System.getProperty("line.separator");
        return output;
    }

    public static String getStylesheet(String file) {
        String output = String.format("<?xml-stylesheet type=\"text/xsl\" href=\"%s\"?>", file);
        output = output + System.getProperty("line.separator");
        return output;
    }

    public static String convertToPrettyFormat(String input) throws TransformerException {
        return XmlUtil.convertToPrettyFormat(input, 2);
    }

    public static String convertToPrettyFormat(String input, int indent) throws TransformerException {
        try {
            return XmlUtil.convertToPrettyFormat(input, indent, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String convertToPrettyFormat(String input, int indent, String charsetName) throws TransformerException, UnsupportedEncodingException {
        StreamSource source = new StreamSource(new StringReader(input));
        int n = input.length();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(n);
        StreamResult result = new StreamResult(buffer);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "" + indent);
        transformer.transform(source, result);
        return buffer.toString(charsetName);
    }
}

