/*
 * Decompiled with CFR 0.152.
 */
package org.mcavallo.opencloud;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mcavallo.opencloud.Tag;
import org.mcavallo.opencloud.filters.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cloud
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Tag> cloud = new HashMap<String, Tag>();
    private String defaultLink = null;
    private double minWeight = 0.0;
    private double maxWeight = 4.0;
    private int maxTagsToDisplay = 50;
    private double threshold = 0.0;
    private double normThreshold = 0.0;
    private long tagLifetime = -1L;
    private String wordPattern = "[\\p{N}\\p{L}]+[\\p{Pd}]?[\\p{N}\\p{L}]+";
    private Case tagCase = Case.LOWER;
    private Rounding rounding = Rounding.CEIL;
    private Locale locale = Locale.getDefault();
    private Set<Filter<Tag>> inputFilters = new HashSet<Filter<Tag>>();
    private Set<Filter<Tag>> outputFilters = new HashSet<Filter<Tag>>();

    public Cloud() {
    }

    public Cloud(Case case_) {
        this.setTagCase(case_);
    }

    public Cloud(Locale locale) {
        this.setLocale(locale);
    }

    public Cloud(Case case_, Locale locale) {
        this.setTagCase(case_);
        this.setLocale(locale);
    }

    public Cloud(Cloud cloud) {
        this.setCloud(new HashMap<String, Tag>(cloud.getCloud()));
        this.setMinWeight(cloud.getMinWeight());
        this.setMaxWeight(cloud.getMaxWeight());
        this.setMaxTagsToDisplay(cloud.getMaxTagsToDisplay());
        this.setThreshold(cloud.getThreshold());
        this.setNormThreshold(cloud.getNormThreshold());
        this.setWordPattern(cloud.getWordPattern());
        this.setTagLifetime(cloud.getTagLifetime());
        this.setTagCase(cloud.getTagCase());
        this.setLocale(cloud.getLocale());
        this.setDefaultLink(cloud.getDefaultLink());
        this.setRounding(cloud.getRounding());
        this.setInputFilters(new HashSet<Filter<Tag>>(cloud.getInputFilters()));
        this.setOutputFilters(new HashSet<Filter<Tag>>(cloud.getOutputFilters()));
    }

    public void addTag(Tag tag) {
        if (!Cloud.isValid(tag)) {
            return;
        }
        String string = this.extractKey(tag.getName());
        Object object = this.inputFilters.iterator();
        while (object.hasNext()) {
            Filter<Tag> filter = object.next();
            if (filter.accept(tag)) continue;
            return;
        }
        if (tag.getLink() == null && this.getDefaultLink() != null) {
            tag.setLink(String.format(this.getDefaultLink(), tag.getName()));
        }
        if ((object = this.cloud.get(string)) != null) {
            tag.add(((Tag)object).getScore());
            if (tag.getLink() == null) {
                tag.setLink(((Tag)object).getLink());
            }
            if (tag.getDate() == null || tag.getDate().before(((Tag)object).getDate())) {
                tag.setDate(((Tag)object).getDate());
            }
        }
        this.cloud.put(string, tag);
    }

    public void addTag(String string) {
        this.addTag(new Tag(string));
    }

    public void addTag(String string, String string2) {
        this.addTag(new Tag(string, string2));
    }

    public void addTags(Collection<Tag> collection) {
        if (collection == null) {
            return;
        }
        Iterator<Tag> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addTag(iterator.next());
        }
    }

    public void addText(String string, String string2) {
        if (this.getWordPattern() == null || string == null) {
            return;
        }
        Pattern pattern = Pattern.compile(this.getWordPattern());
        Matcher matcher = pattern.matcher(string);
        if (string2 != null) {
            while (matcher.find()) {
                String string3 = matcher.group(0);
                this.addTag(new Tag(string3, String.format(string2, string3)));
            }
        } else {
            while (matcher.find()) {
                String string4 = matcher.group(0);
                this.addTag(new Tag(string4, null));
            }
        }
    }

    public void addText(String string) {
        this.addText(string, this.getDefaultLink());
    }

    public Tag getTag(String string) {
        Tag tag = this.cloud.get(this.extractKey(string));
        if (tag != null) {
            this.adjustTagCase(tag);
        }
        return tag;
    }

    public Tag getTag(Tag tag) {
        if (tag == null) {
            return null;
        }
        return this.getTag(tag.getName());
    }

    public void removeTag(String string) {
        if (string == null) {
            return;
        }
        this.cloud.remove(this.extractKey(string));
    }

    public void removeTag(Tag tag) {
        if (tag == null) {
            return;
        }
        this.removeTag(tag.getName());
    }

    public static boolean isValid(Tag tag) {
        return tag != null && tag.getName() != null && tag.getName().length() != 0 && !Double.isInfinite(tag.getScore()) && tag.getScore() > 0.0;
    }

    public List<Tag> tags() {
        return this.tags(new Tag.NameComparatorAsc());
    }

    public List<Tag> tags(Comparator<? super Tag> comparator) {
        List<Tag> list = this.getOutputTags();
        Collections.sort(list, comparator);
        return list;
    }

    protected List<Tag> getOutputTags() {
        Tag tag;
        LinkedList<Tag> linkedList = new LinkedList<Tag>();
        if (this.getCloud() == null) {
            return linkedList;
        }
        double d = 0.0;
        Date date = new Date();
        List<Tag> list = new LinkedList<Tag>();
        Iterator<Tag> iterator = this.getCloud().values().iterator();
        while (iterator.hasNext()) {
            tag = iterator.next();
            if (!Cloud.isValid(tag)) {
                iterator.remove();
                continue;
            }
            if (tag.getScore() < this.getThreshold() || this.getTagLifetime() > 0L && tag.getDate() != null && date.getTime() - tag.getDate().getTime() > this.getTagLifetime() || this.isOutputTagFiltered(tag)) continue;
            list.add(tag);
            if (!(tag.getScore() > d)) continue;
            d = tag.getScore();
        }
        if (Double.isInfinite(d) || Double.isNaN(d) || d <= 0.0) {
            return linkedList;
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            tag = iterator.next();
            tag.normalize(d);
            if (tag.getNormScore() < this.getNormThreshold()) {
                iterator.remove();
                continue;
            }
            tag.setWeight(this.getMinWeight() + tag.getNormScore() * (this.getMaxWeight() - this.getMinWeight()));
        }
        list = this.removeExceedingTags(list);
        return list;
    }

    public List<Tag> allTags(Comparator<? super Tag> comparator) {
        List<Tag> list = this.allTags();
        Collections.sort(list, comparator);
        return list;
    }

    public List<Tag> allTags() {
        return new ArrayList<Tag>(this.getCloud().values());
    }

    public int size() {
        if (this.getCloud() == null) {
            return 0;
        }
        return this.getCloud().values().size();
    }

    public void clear() {
        if (this.getCloud() != null) {
            this.getCloud().clear();
        }
    }

    protected String extractKey(String string) {
        if (this.tagCase == Case.CASE_SENSITIVE) {
            return string;
        }
        return string.toLowerCase(this.locale);
    }

    protected void adjustTagCase(Tag tag) {
        if (this.tagCase == Case.LOWER) {
            tag.setName(tag.getName().toLowerCase(this.locale));
        } else if (this.tagCase == Case.UPPER) {
            tag.setName(tag.getName().toUpperCase(this.locale));
        } else if (this.tagCase == Case.CAPITALIZATION) {
            tag.setName(this.capitalize(tag.getName()));
        }
    }

    protected String capitalize(String string) {
        if (string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase(this.locale) + string.substring(1).toLowerCase(this.locale);
    }

    protected List<Tag> removeExceedingTags(List<Tag> list) {
        if (this.getMaxTagsToDisplay() < 0 || this.size() <= this.getMaxTagsToDisplay()) {
            Iterator<Tag> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.adjustTagCase(iterator.next());
            }
            return list;
        }
        LinkedList<Tag> linkedList = new LinkedList<Tag>();
        Collections.sort(list, new Tag.ScoreComparatorDesc());
        int n = 1;
        for (Tag tag : list) {
            if (n > this.getMaxTagsToDisplay()) break;
            this.adjustTagCase(tag);
            linkedList.add(tag);
            ++n;
        }
        return linkedList;
    }

    protected boolean isOutputTagFiltered(Tag tag) {
        if (this.getOutputFilters() == null) {
            return false;
        }
        for (Filter<Tag> filter : this.getOutputFilters()) {
            if (filter.accept(tag)) continue;
            return true;
        }
        return false;
    }

    public int getMaxTagsToDisplay() {
        return this.maxTagsToDisplay;
    }

    public void setMaxTagsToDisplay(int n) {
        this.maxTagsToDisplay = n;
    }

    public double getNormThreshold() {
        return this.normThreshold;
    }

    public void setNormThreshold(double d) {
        this.normThreshold = d;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    public String getWordPattern() {
        return this.wordPattern;
    }

    public void setWordPattern(String string) {
        this.wordPattern = string;
    }

    public void addInputFilter(Filter<Tag> filter) {
        this.inputFilters.add(filter);
    }

    public void removeInputFilter(Filter<Tag> filter) {
        this.inputFilters.remove(filter);
    }

    public void removeInputFilters(Class<?> clazz) {
        if (this.getInputFilters() == null) {
            return;
        }
        Iterator<Filter<Tag>> iterator = this.getInputFilters().iterator();
        while (iterator.hasNext()) {
            if (!clazz.isInstance(iterator.next())) continue;
            iterator.remove();
        }
    }

    public void clearInputFilters() {
        this.inputFilters.clear();
    }

    public void addOutputFilter(Filter<Tag> filter) {
        this.outputFilters.add(filter);
    }

    public void removeOutputFilter(Filter<Tag> filter) {
        this.outputFilters.remove(filter);
    }

    public void removeOutputFilters(Class<?> clazz) {
        if (this.getOutputFilters() == null) {
            return;
        }
        Iterator<Filter<Tag>> iterator = this.getOutputFilters().iterator();
        while (iterator.hasNext()) {
            if (!clazz.isInstance(iterator.next())) continue;
            iterator.remove();
        }
    }

    public void clearOutputFilters() {
        this.outputFilters.clear();
    }

    protected Map<String, Tag> getCloud() {
        return this.cloud;
    }

    protected void setCloud(Map<String, Tag> map) {
        this.cloud = map;
    }

    public Set<Filter<Tag>> getInputFilters() {
        return this.inputFilters;
    }

    protected void setInputFilters(Set<Filter<Tag>> set) {
        this.inputFilters = set;
    }

    public Set<Filter<Tag>> getOutputFilters() {
        return this.outputFilters;
    }

    public void setOutputFilters(Set<Filter<Tag>> set) {
        this.outputFilters = set;
    }

    public long getTagLifetime() {
        return this.tagLifetime;
    }

    public void setTagLifetime(long l) {
        this.tagLifetime = l;
    }

    public Case getTagCase() {
        return this.tagCase;
    }

    public void setTagCase(Case case_) {
        this.tagCase = case_;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getDefaultLink() {
        return this.defaultLink;
    }

    public void setDefaultLink(String string) {
        this.defaultLink = string;
    }

    public double getMinWeight() {
        return this.minWeight;
    }

    public void setMinWeight(double d) {
        this.minWeight = d;
    }

    public double getMaxWeight() {
        return this.maxWeight;
    }

    public void setMaxWeight(double d) {
        this.maxWeight = d;
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public void setRounding(Rounding rounding) {
        this.rounding = rounding;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.cloud == null ? 0 : ((Object)this.cloud).hashCode());
        n = 31 * n + (this.defaultLink == null ? 0 : this.defaultLink.hashCode());
        n = 31 * n + (this.inputFilters == null ? 0 : ((Object)this.inputFilters).hashCode());
        n = 31 * n + (this.locale == null ? 0 : this.locale.hashCode());
        n = 31 * n + this.maxTagsToDisplay;
        long l = Double.doubleToLongBits(this.maxWeight);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.minWeight);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.normThreshold);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.outputFilters == null ? 0 : ((Object)this.outputFilters).hashCode());
        n = 31 * n + (this.rounding == null ? 0 : this.rounding.hashCode());
        n = 31 * n + (this.tagCase == null ? 0 : this.tagCase.hashCode());
        n = 31 * n + (int)(this.tagLifetime ^ this.tagLifetime >>> 32);
        l = Double.doubleToLongBits(this.threshold);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.wordPattern == null ? 0 : this.wordPattern.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Cloud cloud = (Cloud)object;
        if (this.cloud == null ? cloud.cloud != null : !((Object)this.cloud).equals(cloud.cloud)) {
            return false;
        }
        if (this.defaultLink == null ? cloud.defaultLink != null : !this.defaultLink.equals(cloud.defaultLink)) {
            return false;
        }
        if (this.inputFilters == null ? cloud.inputFilters != null : !((Object)this.inputFilters).equals(cloud.inputFilters)) {
            return false;
        }
        if (this.locale == null ? cloud.locale != null : !this.locale.equals(cloud.locale)) {
            return false;
        }
        if (this.maxTagsToDisplay != cloud.maxTagsToDisplay) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxWeight) != Double.doubleToLongBits(cloud.maxWeight)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minWeight) != Double.doubleToLongBits(cloud.minWeight)) {
            return false;
        }
        if (Double.doubleToLongBits(this.normThreshold) != Double.doubleToLongBits(cloud.normThreshold)) {
            return false;
        }
        if (this.outputFilters == null ? cloud.outputFilters != null : !((Object)this.outputFilters).equals(cloud.outputFilters)) {
            return false;
        }
        if (this.rounding == null ? cloud.rounding != null : !this.rounding.equals((Object)cloud.rounding)) {
            return false;
        }
        if (this.tagCase == null ? cloud.tagCase != null : !this.tagCase.equals((Object)cloud.tagCase)) {
            return false;
        }
        if (this.tagLifetime != cloud.tagLifetime) {
            return false;
        }
        if (Double.doubleToLongBits(this.threshold) != Double.doubleToLongBits(cloud.threshold)) {
            return false;
        }
        return !(this.wordPattern == null ? cloud.wordPattern != null : !this.wordPattern.equals(cloud.wordPattern));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Rounding {
        CEIL,
        FLOOR,
        ROUND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Case {
        LOWER,
        UPPER,
        CAPITALIZATION,
        PRESERVE_CASE,
        CASE_SENSITIVE;

    }
}

